/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.parser.functions;

import de.focus_shift.jollyday.core.spi.FixedWeekdayBetweenFixed;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;
import java.util.stream.Stream;

public class FindWeekDayBetween
implements Function<FixedWeekdayBetweenFixed, LocalDate> {
    private final LocalDate from;
    private final LocalDate to;

    public FindWeekDayBetween(LocalDate from, LocalDate to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public LocalDate apply(FixedWeekdayBetweenFixed fwm) {
        return Stream.iterate(this.from, date -> date.plusDays(1L)).limit(ChronoUnit.DAYS.between(this.from, this.to) + 1L).filter(date -> date.getDayOfWeek() == fwm.weekday()).findFirst().orElse(null);
    }
}

