? my $ctx = $main::context;
? $_mt->wrapper_file("wrapper.mt", "Configure", "Using Basic Authentication")->(sub {

<p>
Starting from version 1.7, H2O comes with a mruby script named <a href="https://github.com/h2o/h2o/blob/master/share/h2o/mruby/htpasswd.rb">htpasswd.rb</a> that implements <a href="https://tools.ietf.org/html/rfc2617" target="_blank">Basic Authentication</a>.
The script provides a Rack handler that implements Basic Authentication using password files generated by the <a href="https://httpd.apache.org/docs/2.4/programs/htpasswd.html">htpasswd</a> command.
</p>

<p>
Below example uses the mruby script to restrict access to the path.
If authentication fails, the mruby handler returns a <code>401 Unauthorized</code> response.
If authentication succeeds, the handler returns a <code>399</code> response, and the request is <a href="configure/mruby.html#delegating-request">delegated</a> internally to the next handler (i.e. <code>file.dir</code>).
</p>

<?= $ctx->{example}->('Configuring HTTP authentication using htpasswd.rb', <<'EOT');
paths:
  "/":
    mruby.handler: |
      require "htpasswd.rb"
      Htpasswd.new("/path/to/.htpasswd", "realm-name")
    file.dir: /path/to/doc_root
EOT
?>

<p>
In H2O versions prior to 2.0, you should specify <code>"#{$H2O_ROOT}/share/h2o/mruby/htpasswd.rb"</code> as the argument to <code>require</code>, since the directory is not registered as part of <code>$LOAD_PATH</code>.
</p>

For convenience, the mruby script also forbids access to files or directories that start with <code>.ht</code>.

? })
