/*
 * Decompiled with CFR 0.152.
 */
package pl.com.salsoft.sqlitestudioremote;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import pl.com.salsoft.sqlitestudioremote.internal.SQLiteStudioListener;
import pl.com.salsoft.sqlitestudioremote.internal.Utils;

public class SQLiteStudioService
extends Service {
    public static final int DEFAULT_PORT = 12121;
    private static SQLiteStudioService staticInstance;
    private SQLiteStudioListener listener;
    private Thread listenerThread;
    private boolean running = false;
    private int port = 12121;
    private String password;
    private List<String> ipBlackList = new ArrayList<String>();
    private List<String> ipWhiteList = new ArrayList<String>();

    public void start(Context context) {
        if (this.running) {
            return;
        }
        this.listener = new SQLiteStudioListener(context);
        this.listener.setPort(this.port);
        this.listener.setPassword(this.password);
        this.listener.setIpBlackList(this.ipBlackList);
        this.listener.setIpWhiteList(this.ipWhiteList);
        this.listenerThread = new Thread(this.listener);
        this.listenerThread.start();
        this.running = true;
        Log.d((String)Utils.LOG_TAG, (String)("Started instance on port " + this.port));
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        Log.d((String)Utils.LOG_TAG, (String)"Shutting down SQLiteStudioService instance.");
        this.listener.close();
        try {
            this.listenerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.running = false;
    }

    public static SQLiteStudioService instance() {
        if (staticInstance == null) {
            staticInstance = new SQLiteStudioService();
        }
        return staticInstance;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void addIpToBlackList(String ip) {
        this.ipBlackList.add(ip);
    }

    public void addIpToWhiteList(String ip) {
        this.ipWhiteList.add(ip);
    }

    public void setIpBlackList(String ... ip) {
        this.ipBlackList.clear();
        for (String singleIp : ip) {
            this.ipBlackList.add(singleIp);
        }
    }

    public void setIpWhiteList(String ... ip) {
        this.ipBlackList.clear();
        for (String singleIp : ip) {
            this.ipWhiteList.add(singleIp);
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isRunning() {
        return this.running;
    }
}

