/*
 * Decompiled with CFR 0.152.
 */
package pl.com.salsoft.sqlitestudioremote.internal;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pl.com.salsoft.sqlitestudioremote.internal.QueryResults;
import pl.com.salsoft.sqlitestudioremote.internal.SQLiteStudioDbOpenHelper;

public class SQLiteStudioDbService {
    private static final Pattern DOWNGRADE_PATT = Pattern.compile(".*downgrade\\s+database\\s+from\\s+version\\s+(\\d+)\\s+to\\s+(\\d+)");
    private HashMap<String, SQLiteDatabase> managedDatabases = new HashMap();
    private Context context;

    public SQLiteStudioDbService(Context context) {
        this.context = context.getApplicationContext();
    }

    public List<String> getDbList() {
        ArrayList<String> filteredList = new ArrayList<String>();
        for (String dbFile : this.context.databaseList()) {
            if (dbFile.endsWith("-journal")) continue;
            filteredList.add(dbFile);
        }
        return filteredList;
    }

    public boolean deleteDb(String dbName) {
        return this.context.deleteDatabase(dbName);
    }

    public void releaseAll() {
        for (SQLiteDatabase db : this.managedDatabases.values()) {
            db.close();
        }
        this.managedDatabases.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResults exec(String dbName, String query) {
        QueryResults results;
        SQLiteDatabase db = this.getDb(dbName);
        try (Cursor cursor = null;){
            cursor = db.rawQuery(query, null);
            results = new QueryResults();
            results.readResults(cursor);
        }
        return results;
    }

    private SQLiteDatabase getDb(String name) {
        if (this.managedDatabases.containsKey(name)) {
            return this.managedDatabases.get(name);
        }
        SQLiteDatabase db = null;
        try {
            db = this.tryToGetDb(name, 1);
        }
        catch (SQLiteException e) {
            String msg = e.getMessage();
            Matcher m = DOWNGRADE_PATT.matcher(msg);
            if (m.find()) {
                db = this.tryToGetDb(name, Integer.parseInt(m.group(1)));
            }
            throw e;
        }
        this.managedDatabases.put(name, db);
        return db;
    }

    private SQLiteDatabase tryToGetDb(String name, int version) {
        SQLiteStudioDbOpenHelper helper = new SQLiteStudioDbOpenHelper(this.context, name, version);
        return helper.getWritableDatabase();
    }
}

