/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'revert_creds' function
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process calls 'rever_creds', we need to correctly handle this situation
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 10.X.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_REVERT_CREDS_H
#define P_LKRG_EXPLOIT_DETECTION_REVERT_CREDS_H

/* per-instance private data */
struct p_revert_creds_data {
    ktime_t entry_stamp;
};

int p_revert_creds_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs);
int p_revert_creds_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_revert_creds_hook(int p_isra);
void p_uninstall_revert_creds_hook(void);

#endif
