// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 6
// RUN: %clang_cc1 -triple riscv64-none-linux-gnu -target-feature +f -target-feature +d -target-feature +zve64d -mvscale-min=4 -mvscale-max=4 -O1 -emit-llvm -o - %s | FileCheck %s

// REQUIRES: riscv-registered-target

#include <stdint.h>

typedef __rvv_int8m1_t vint8m1_t;
typedef __rvv_uint8m1_t vuint8m1_t;
typedef __rvv_int16m1_t vint16m1_t;
typedef __rvv_uint16m1_t vuint16m1_t;
typedef __rvv_int32m1_t vint32m1_t;
typedef __rvv_uint32m1_t vuint32m1_t;
typedef __rvv_int64m1_t vint64m1_t;
typedef __rvv_uint64m1_t vuint64m1_t;
typedef __rvv_float32m1_t vfloat32m1_t;
typedef __rvv_float64m1_t vfloat64m1_t;

typedef __rvv_bool1_t vbool1_t;
typedef __rvv_bool4_t vbool4_t;
typedef __rvv_bool32_t vbool32_t;

typedef vint64m1_t fixed_int64m1_t __attribute__((riscv_rvv_vector_bits(__riscv_v_fixed_vlen)));
typedef vfloat64m1_t fixed_float64m1_t __attribute__((riscv_rvv_vector_bits(__riscv_v_fixed_vlen)));

typedef vint32m1_t fixed_int32m1_t __attribute__((riscv_rvv_vector_bits(__riscv_v_fixed_vlen)));
typedef vfloat64m1_t fixed_float64m1_t __attribute__((riscv_rvv_vector_bits(__riscv_v_fixed_vlen)));
typedef int32_t gnu_int32m1_t __attribute__((vector_size(__riscv_v_fixed_vlen / 8)));

typedef vbool1_t fixed_bool1_t __attribute__((riscv_rvv_vector_bits(__riscv_v_fixed_vlen)));
typedef vbool4_t fixed_bool4_t __attribute__((riscv_rvv_vector_bits(__riscv_v_fixed_vlen/4)));
typedef vbool32_t fixed_bool32_t __attribute__((riscv_rvv_vector_bits(__riscv_v_fixed_vlen/32)));

// CHECK-LABEL: define dso_local noundef <vscale x 2 x i32> @to_vint32m1_t(
// CHECK-SAME: <vscale x 2 x i32> noundef returned [[TYPE_COERCE:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <vscale x 2 x i32> [[TYPE_COERCE]]
//
vint32m1_t to_vint32m1_t(fixed_int32m1_t type) {
  return type;
}

// CHECK-LABEL: define dso_local <vscale x 2 x i32> @from_vint32m1_t(
// CHECK-SAME: <vscale x 2 x i32> returned [[TYPE:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <vscale x 2 x i32> [[TYPE]]
//
fixed_int32m1_t from_vint32m1_t(vint32m1_t type) {
  return type;
}

// CHECK-LABEL: define dso_local noundef <vscale x 1 x double> @to_vfloat64m1_t(
// CHECK-SAME: <vscale x 1 x double> noundef returned [[TYPE_COERCE:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <vscale x 1 x double> [[TYPE_COERCE]]
//
vfloat64m1_t to_vfloat64m1_t(fixed_float64m1_t type) {
  return type;
}

// CHECK-LABEL: define dso_local <vscale x 1 x double> @from_vfloat64m1_t(
// CHECK-SAME: <vscale x 1 x double> returned [[TYPE:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <vscale x 1 x double> [[TYPE]]
//
fixed_float64m1_t from_vfloat64m1_t(vfloat64m1_t type) {
  return type;
}

// CHECK-LABEL: define dso_local <vscale x 64 x i1> @from_vbool1_t(
// CHECK-SAME: <vscale x 64 x i1> returned [[TYPE:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <vscale x 64 x i1> [[TYPE]]
//
fixed_bool1_t from_vbool1_t(vbool1_t type) {
  return type;
}

// CHECK-LABEL: define dso_local noundef <vscale x 64 x i1> @to_vbool1_t(
// CHECK-SAME: <vscale x 64 x i1> noundef returned [[TMP0:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <vscale x 64 x i1> [[TMP0]]
//
vbool1_t to_vbool1_t(fixed_bool1_t type) {
  return type;
}

// CHECK-LABEL: define dso_local <vscale x 16 x i1> @from_vbool4_t(
// CHECK-SAME: <vscale x 16 x i1> returned [[TYPE:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <vscale x 16 x i1> [[TYPE]]
//
fixed_bool4_t from_vbool4_t(vbool4_t type) {
  return type;
}

// CHECK-LABEL: define dso_local noundef <vscale x 16 x i1> @to_vbool4_t(
// CHECK-SAME: <vscale x 16 x i1> noundef returned [[TMP0:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <vscale x 16 x i1> [[TMP0]]
//
vbool4_t to_vbool4_t(fixed_bool4_t type) {
  return type;
}

// CHECK-LABEL: define dso_local <vscale x 2 x i1> @from_vbool32_t(
// CHECK-SAME: <vscale x 2 x i1> returned [[TYPE:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <vscale x 2 x i1> [[TYPE]]
//
fixed_bool32_t from_vbool32_t(vbool32_t type) {
  return type;
}

// CHECK-LABEL: define dso_local noundef <vscale x 2 x i1> @to_vbool32_t(
// CHECK-SAME: <vscale x 2 x i1> noundef returned [[TMP0:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <vscale x 2 x i1> [[TMP0]]
//
vbool32_t to_vbool32_t(fixed_bool32_t type) {
  return type;
}

// CHECK-LABEL: define dso_local <vscale x 2 x i32> @to_vint32m1_t__from_gnu_int32m1_t(
// CHECK-SAME: ptr dead_on_return noundef readonly captures(none) [[TMP0:%.*]]) local_unnamed_addr #[[ATTR2:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TYPE:%.*]] = load <8 x i32>, ptr [[TMP0]], align 32, !tbaa [[CHAR_TBAA10:![0-9]+]]
// CHECK-NEXT:    [[CAST_SCALABLE:%.*]] = tail call <vscale x 2 x i32> @llvm.vector.insert.nxv2i32.v8i32(<vscale x 2 x i32> poison, <8 x i32> [[TYPE]], i64 0)
// CHECK-NEXT:    ret <vscale x 2 x i32> [[CAST_SCALABLE]]
//
vint32m1_t to_vint32m1_t__from_gnu_int32m1_t(gnu_int32m1_t type) {
  return type;
}

// CHECK-LABEL: define dso_local void @from_vint32m1_t__to_gnu_int32m1_t(
// CHECK-SAME: ptr dead_on_unwind noalias writable writeonly sret(<8 x i32>) align 32 captures(none) initializes((0, 32)) [[AGG_RESULT:%.*]], <vscale x 2 x i32> [[TYPE:%.*]]) local_unnamed_addr #[[ATTR3:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[CAST_FIXED:%.*]] = tail call <8 x i32> @llvm.vector.extract.v8i32.nxv2i32(<vscale x 2 x i32> [[TYPE]], i64 0)
// CHECK-NEXT:    store <8 x i32> [[CAST_FIXED]], ptr [[AGG_RESULT]], align 32, !tbaa [[CHAR_TBAA10]]
// CHECK-NEXT:    ret void
//
gnu_int32m1_t from_vint32m1_t__to_gnu_int32m1_t(vint32m1_t type) {
  return type;
}

// CHECK-LABEL: define dso_local <vscale x 2 x i32> @to_fixed_int32m1_t__from_gnu_int32m1_t(
// CHECK-SAME: ptr dead_on_return noundef readonly captures(none) [[TMP0:%.*]]) local_unnamed_addr #[[ATTR2]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TYPE:%.*]] = load <8 x i32>, ptr [[TMP0]], align 32, !tbaa [[CHAR_TBAA10]]
// CHECK-NEXT:    [[CAST_SCALABLE:%.*]] = tail call <vscale x 2 x i32> @llvm.vector.insert.nxv2i32.v8i32(<vscale x 2 x i32> poison, <8 x i32> [[TYPE]], i64 0)
// CHECK-NEXT:    ret <vscale x 2 x i32> [[CAST_SCALABLE]]
//
fixed_int32m1_t to_fixed_int32m1_t__from_gnu_int32m1_t(gnu_int32m1_t type) {
  return type;
}

// CHECK-LABEL: define dso_local void @from_fixed_int32m1_t__to_gnu_int32m1_t(
// CHECK-SAME: ptr dead_on_unwind noalias writable writeonly sret(<8 x i32>) align 32 captures(none) initializes((0, 32)) [[AGG_RESULT:%.*]], <vscale x 2 x i32> noundef [[TYPE_COERCE:%.*]]) local_unnamed_addr #[[ATTR3]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TYPE:%.*]] = tail call <8 x i32> @llvm.vector.extract.v8i32.nxv2i32(<vscale x 2 x i32> [[TYPE_COERCE]], i64 0)
// CHECK-NEXT:    store <8 x i32> [[TYPE]], ptr [[AGG_RESULT]], align 32, !tbaa [[CHAR_TBAA10]]
// CHECK-NEXT:    ret void
//
gnu_int32m1_t from_fixed_int32m1_t__to_gnu_int32m1_t(fixed_int32m1_t type) {
  return type;
}
//.
// CHECK: [[META8:![0-9]+]] = !{!"omnipotent char", [[META9:![0-9]+]], i64 0}
// CHECK: [[META9]] = !{!"Simple C/C++ TBAA"}
// CHECK: [[CHAR_TBAA10]] = !{[[META8]], [[META8]], i64 0}
//.
