// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --check-globals all --include-generated-funcs --version 5
// RUN: %clang_cc1 -finclude-default-header -x hlsl -triple \
// RUN:   spirv-unknown-vulkan-compute %s -fnative-int16-type -emit-llvm -disable-llvm-passes \
// RUN:   -o - | FileCheck %s

[[vk::constant_id(1)]]
const bool bool_const = true;

[[vk::constant_id(1)]]
const short short_const = 4;

[[vk::constant_id(3)]]
const int int_const = 5;

[[vk::constant_id(4)]]
const long long long_const = 8;

[[vk::constant_id(5)]]
const unsigned short ushort_const = 10;

[[vk::constant_id(6)]]
const unsigned int uint_const = 12;

[[vk::constant_id(6)]]
const uint uint_const_2 = 12;

[[vk::constant_id(7)]]
const unsigned long long ulong_const = 25;

[[vk::constant_id(8)]]
const half half_const = 40.4;

[[vk::constant_id(8)]]
const float float_const = 50.5;

[[vk::constant_id(9)]]
const double double_const = 100.2;

enum E {
    e0 = 10,
    e1 = 20,
    e2 = 30
};

[[vk::constant_id(10)]]
const E enum_const = e2;

[numthreads(1,1,1)]
void main() {
    bool b = bool_const;
    short s = short_const;
    int i = int_const;
    long long l = long_const;
    unsigned short us = ushort_const;
    unsigned int ui = uint_const;
    uint ui2 = uint_const_2;
    unsigned long long ul = ulong_const;
    half h = half_const;
    float f = float_const;
    double d = double_const;
    E e = enum_const;
}
//.
// CHECK: @_ZL10bool_const = internal addrspace(10) global i32 0, align 4
// CHECK: @_ZL11short_const = internal addrspace(10) global i16 0, align 2
// CHECK: @_ZL9int_const = internal addrspace(10) global i32 0, align 4
// CHECK: @_ZL10long_const = internal addrspace(10) global i64 0, align 8
// CHECK: @_ZL12ushort_const = internal addrspace(10) global i16 0, align 2
// CHECK: @_ZL10uint_const = internal addrspace(10) global i32 0, align 4
// CHECK: @_ZL12uint_const_2 = internal addrspace(10) global i32 0, align 4
// CHECK: @_ZL11ulong_const = internal addrspace(10) global i64 0, align 8
// CHECK: @_ZL10half_const = internal addrspace(10) global float 0.000000e+00, align 4
// CHECK: @_ZL11float_const = internal addrspace(10) global float 0.000000e+00, align 4
// CHECK: @_ZL12double_const = internal addrspace(10) global double 0.000000e+00, align 8
// CHECK: @_ZL10enum_const = internal addrspace(10) global i32 0, align 4
//.
// CHECK-LABEL: define internal spir_func void @_Z4mainv(
// CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = call token @llvm.experimental.convergence.entry()
// CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[S:%.*]] = alloca i16, align 2
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[L:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[US:%.*]] = alloca i16, align 2
// CHECK-NEXT:    [[UI:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[UI2:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[UL:%.*]] = alloca i64, align 8
// CHECK-NEXT:    [[H:%.*]] = alloca float, align 4
// CHECK-NEXT:    [[F:%.*]] = alloca float, align 4
// CHECK-NEXT:    [[D:%.*]] = alloca double, align 8
// CHECK-NEXT:    [[E:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr addrspace(10) @_ZL10bool_const, align 4
// CHECK-NEXT:    [[LOADEDV:%.*]] = trunc i32 [[TMP1]] to i1
// CHECK-NEXT:    [[STOREDV:%.*]] = zext i1 [[LOADEDV]] to i32
// CHECK-NEXT:    store i32 [[STOREDV]], ptr [[B]], align 4
// CHECK-NEXT:    [[TMP2:%.*]] = load i16, ptr addrspace(10) @_ZL11short_const, align 2
// CHECK-NEXT:    store i16 [[TMP2]], ptr [[S]], align 2
// CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr addrspace(10) @_ZL9int_const, align 4
// CHECK-NEXT:    store i32 [[TMP3]], ptr [[I]], align 4
// CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr addrspace(10) @_ZL10long_const, align 8
// CHECK-NEXT:    store i64 [[TMP4]], ptr [[L]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i16, ptr addrspace(10) @_ZL12ushort_const, align 2
// CHECK-NEXT:    store i16 [[TMP5]], ptr [[US]], align 2
// CHECK-NEXT:    [[TMP6:%.*]] = load i32, ptr addrspace(10) @_ZL10uint_const, align 4
// CHECK-NEXT:    store i32 [[TMP6]], ptr [[UI]], align 4
// CHECK-NEXT:    [[TMP7:%.*]] = load i32, ptr addrspace(10) @_ZL12uint_const_2, align 4
// CHECK-NEXT:    store i32 [[TMP7]], ptr [[UI2]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i64, ptr addrspace(10) @_ZL11ulong_const, align 8
// CHECK-NEXT:    store i64 [[TMP8]], ptr [[UL]], align 8
// CHECK-NEXT:    [[TMP9:%.*]] = load float, ptr addrspace(10) @_ZL10half_const, align 4
// CHECK-NEXT:    store float [[TMP9]], ptr [[H]], align 4
// CHECK-NEXT:    [[TMP10:%.*]] = load float, ptr addrspace(10) @_ZL11float_const, align 4
// CHECK-NEXT:    store float [[TMP10]], ptr [[F]], align 4
// CHECK-NEXT:    [[TMP11:%.*]] = load double, ptr addrspace(10) @_ZL12double_const, align 8
// CHECK-NEXT:    store double [[TMP11]], ptr [[D]], align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load i32, ptr addrspace(10) @_ZL10enum_const, align 4
// CHECK-NEXT:    store i32 [[TMP12]], ptr [[E]], align 4
// CHECK-NEXT:    ret void
//
// CHECK-LABEL: define internal spir_func void @__cxx_global_var_init(
// CHECK-SAME: ) #[[ATTR3:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = call token @llvm.experimental.convergence.entry()
// CHECK-NEXT:    [[TMP1:%.*]] = call i1 @_Z20__spirv_SpecConstantib(i32 1, i1 true)
// CHECK-NEXT:    [[STOREDV:%.*]] = zext i1 [[TMP1]] to i32
// CHECK-NEXT:    store i32 [[STOREDV]], ptr addrspace(10) @_ZL10bool_const, align 4
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define internal spir_func void @__cxx_global_var_init.1(
// CHECK-SAME: ) #[[ATTR3]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = call token @llvm.experimental.convergence.entry()
// CHECK-NEXT:    [[TMP1:%.*]] = call i16 @_Z20__spirv_SpecConstantis(i32 1, i16 4)
// CHECK-NEXT:    store i16 [[TMP1]], ptr addrspace(10) @_ZL11short_const, align 2
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define internal spir_func void @__cxx_global_var_init.2(
// CHECK-SAME: ) #[[ATTR3]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = call token @llvm.experimental.convergence.entry()
// CHECK-NEXT:    [[TMP1:%.*]] = call i32 @_Z20__spirv_SpecConstantii(i32 3, i32 5)
// CHECK-NEXT:    store i32 [[TMP1]], ptr addrspace(10) @_ZL9int_const, align 4
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define internal spir_func void @__cxx_global_var_init.3(
// CHECK-SAME: ) #[[ATTR3]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = call token @llvm.experimental.convergence.entry()
// CHECK-NEXT:    [[TMP1:%.*]] = call i64 @_Z20__spirv_SpecConstantix(i32 4, i64 8)
// CHECK-NEXT:    store i64 [[TMP1]], ptr addrspace(10) @_ZL10long_const, align 8
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define internal spir_func void @__cxx_global_var_init.4(
// CHECK-SAME: ) #[[ATTR3]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = call token @llvm.experimental.convergence.entry()
// CHECK-NEXT:    [[TMP1:%.*]] = call i16 @_Z20__spirv_SpecConstantit(i32 5, i16 10)
// CHECK-NEXT:    store i16 [[TMP1]], ptr addrspace(10) @_ZL12ushort_const, align 2
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define internal spir_func void @__cxx_global_var_init.5(
// CHECK-SAME: ) #[[ATTR3]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = call token @llvm.experimental.convergence.entry()
// CHECK-NEXT:    [[TMP1:%.*]] = call i32 @_Z20__spirv_SpecConstantij(i32 6, i32 12)
// CHECK-NEXT:    store i32 [[TMP1]], ptr addrspace(10) @_ZL10uint_const, align 4
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define internal spir_func void @__cxx_global_var_init.6(
// CHECK-SAME: ) #[[ATTR3]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = call token @llvm.experimental.convergence.entry()
// CHECK-NEXT:    [[TMP1:%.*]] = call i32 @_Z20__spirv_SpecConstantij(i32 6, i32 12)
// CHECK-NEXT:    store i32 [[TMP1]], ptr addrspace(10) @_ZL12uint_const_2, align 4
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define internal spir_func void @__cxx_global_var_init.7(
// CHECK-SAME: ) #[[ATTR3]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = call token @llvm.experimental.convergence.entry()
// CHECK-NEXT:    [[TMP1:%.*]] = call i64 @_Z20__spirv_SpecConstantiy(i32 7, i64 25)
// CHECK-NEXT:    store i64 [[TMP1]], ptr addrspace(10) @_ZL11ulong_const, align 8
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define internal spir_func void @__cxx_global_var_init.8(
// CHECK-SAME: ) #[[ATTR3]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = call token @llvm.experimental.convergence.entry()
// CHECK-NEXT:    [[TMP1:%.*]] = call reassoc nnan ninf nsz arcp afn float @_Z20__spirv_SpecConstantiDh(i32 8, float 0x4044333340000000)
// CHECK-NEXT:    store float [[TMP1]], ptr addrspace(10) @_ZL10half_const, align 4
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define internal spir_func void @__cxx_global_var_init.9(
// CHECK-SAME: ) #[[ATTR3]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = call token @llvm.experimental.convergence.entry()
// CHECK-NEXT:    [[TMP1:%.*]] = call reassoc nnan ninf nsz arcp afn float @_Z20__spirv_SpecConstantif(i32 8, float 5.050000e+01)
// CHECK-NEXT:    store float [[TMP1]], ptr addrspace(10) @_ZL11float_const, align 4
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define internal spir_func void @__cxx_global_var_init.10(
// CHECK-SAME: ) #[[ATTR3]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = call token @llvm.experimental.convergence.entry()
// CHECK-NEXT:    [[TMP1:%.*]] = call reassoc nnan ninf nsz arcp afn double @_Z20__spirv_SpecConstantid(i32 9, double 0x40590CCCC0000000)
// CHECK-NEXT:    store double [[TMP1]], ptr addrspace(10) @_ZL12double_const, align 8
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define internal spir_func void @__cxx_global_var_init.11(
// CHECK-SAME: ) #[[ATTR3]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = call token @llvm.experimental.convergence.entry()
// CHECK-NEXT:    [[TMP1:%.*]] = call i32 @_Z20__spirv_SpecConstantii(i32 10, i32 30)
// CHECK-NEXT:    store i32 [[TMP1]], ptr addrspace(10) @_ZL10enum_const, align 4
// CHECK-NEXT:    ret void
