/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.text;

import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;

class ICUCompatIcs {
    private static final String TAG = "ICUCompatIcs";
    private static Method sGetScriptMethod;
    private static Method sAddLikelySubtagsMethod;

    ICUCompatIcs() {
    }

    public static String maximizeAndGetScript(Locale locale) {
        String localeWithSubtags = ICUCompatIcs.addLikelySubtags(locale);
        if (localeWithSubtags != null) {
            return ICUCompatIcs.getScript(localeWithSubtags);
        }
        return null;
    }

    private static String getScript(String localeStr) {
        try {
            if (sGetScriptMethod != null) {
                Object[] args = new Object[]{localeStr};
                return (String)sGetScriptMethod.invoke(null, args);
            }
        }
        catch (IllegalAccessException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return null;
    }

    private static String addLikelySubtags(Locale locale) {
        String localeStr = locale.toString();
        try {
            if (sAddLikelySubtagsMethod != null) {
                Object[] args = new Object[]{localeStr};
                return (String)sAddLikelySubtagsMethod.invoke(null, args);
            }
        }
        catch (IllegalAccessException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return localeStr;
    }

    static {
        try {
            Class<?> clazz = Class.forName("libcore.icu.ICU");
            if (clazz != null) {
                sGetScriptMethod = clazz.getMethod("getScript", String.class);
                sAddLikelySubtagsMethod = clazz.getMethod("addLikelySubtags", String.class);
            }
        }
        catch (Exception e) {
            sGetScriptMethod = null;
            sAddLikelySubtagsMethod = null;
            Log.w((String)TAG, (Throwable)e);
        }
    }
}

