/*
** Copyright (c) 2021 Samsung
** Copyright (c) 2023 Google
** Copyright (c) 2023 LunarG, Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and associated documentation files (the "Software"),
** to deal in the Software without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Software, and to permit persons to whom the
** Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
** AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
** FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
*/

/*
** This file is generated from the Khronos Vulkan XML API Registry.
**
*/

#include "decode/vulkan_cpp_structs.h"
#include "generated/generated_vulkan_cpp_structs.h"
#include "generated/generated_vulkan_cpp_consumer.h"
#include "generated/generated_vulkan_cpp_consumer_extension.h"
#include "generated/generated_vulkan_enum_to_string.h"

GFXRECON_BEGIN_NAMESPACE(gfxrecon)
GFXRECON_BEGIN_NAMESPACE(decode)

std::string GenerateStruct_StdVideoAV1CDEF(std::ostream &out, const StdVideoAV1CDEF* structInfo, Decoded_StdVideoAV1CDEF* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << std::to_string(structInfo->cdef_damping_minus_3) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->cdef_bits) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->cdef_y_pri_strength[0]), STD_VIDEO_AV1_MAX_CDEF_FILTER_STRENGTHS) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->cdef_y_sec_strength[0]), STD_VIDEO_AV1_MAX_CDEF_FILTER_STRENGTHS) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->cdef_uv_pri_strength[0]), STD_VIDEO_AV1_MAX_CDEF_FILTER_STRENGTHS) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->cdef_uv_sec_strength[0]), STD_VIDEO_AV1_MAX_CDEF_FILTER_STRENGTHS) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1CDEF");
    out << "\t\t" << "StdVideoAV1CDEF " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1ColorConfig(std::ostream &out, const StdVideoAV1ColorConfig* structInfo, Decoded_StdVideoAV1ColorConfig* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoAV1ColorConfigFlags(out,
                                                                            &structInfo->flags,
                                                                            metaInfo->flags,
                                                                            consumer);
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->BitDepth) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->subsampling_x) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->subsampling_y) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->reserved1) << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1ColorPrimaries(" << structInfo->color_primaries << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1TransferCharacteristics(" << structInfo->transfer_characteristics << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1MatrixCoefficients(" << structInfo->matrix_coefficients << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1ChromaSamplePosition(" << structInfo->chroma_sample_position << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1ColorConfig");
    out << "\t\t" << "StdVideoAV1ColorConfig " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1ColorConfigFlags(std::ostream &out, const StdVideoAV1ColorConfigFlags* structInfo, Decoded_StdVideoAV1ColorConfigFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->mono_chrome << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->color_range << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->separate_uv_delta_q << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->color_description_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1ColorConfigFlags");
    out << "\t\t" << "StdVideoAV1ColorConfigFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1FilmGrain(std::ostream &out, const StdVideoAV1FilmGrain* structInfo, Decoded_StdVideoAV1FilmGrain* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoAV1FilmGrainFlags(out,
                                                                          &structInfo->flags,
                                                                          metaInfo->flags,
                                                                          consumer);
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->grain_scaling_minus_8) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->ar_coeff_lag) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->ar_coeff_shift_minus_6) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->grain_scale_shift) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->grain_seed << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->film_grain_params_ref_idx) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->num_y_points) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->point_y_value[0]), STD_VIDEO_AV1_MAX_NUM_Y_POINTS) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->point_y_scaling[0]), STD_VIDEO_AV1_MAX_NUM_Y_POINTS) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->num_cb_points) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->point_cb_value[0]), STD_VIDEO_AV1_MAX_NUM_CB_POINTS) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->point_cb_scaling[0]), STD_VIDEO_AV1_MAX_NUM_CB_POINTS) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->num_cr_points) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->point_cr_value[0]), STD_VIDEO_AV1_MAX_NUM_CR_POINTS) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->point_cr_scaling[0]), STD_VIDEO_AV1_MAX_NUM_CR_POINTS) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->ar_coeffs_y_plus_128[0]), STD_VIDEO_AV1_MAX_NUM_POS_LUMA) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->ar_coeffs_cb_plus_128[0]), STD_VIDEO_AV1_MAX_NUM_POS_CHROMA) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->ar_coeffs_cr_plus_128[0]), STD_VIDEO_AV1_MAX_NUM_POS_CHROMA) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->cb_mult) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->cb_luma_mult) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->cb_offset << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->cr_mult) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->cr_luma_mult) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->cr_offset << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1FilmGrain");
    out << "\t\t" << "StdVideoAV1FilmGrain " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1FilmGrainFlags(std::ostream &out, const StdVideoAV1FilmGrainFlags* structInfo, Decoded_StdVideoAV1FilmGrainFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->chroma_scaling_from_luma << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->overlap_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->clip_to_restricted_range << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->update_grain << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1FilmGrainFlags");
    out << "\t\t" << "StdVideoAV1FilmGrainFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1GlobalMotion(std::ostream &out, const StdVideoAV1GlobalMotion* structInfo, Decoded_StdVideoAV1GlobalMotion* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->GmType[0]), STD_VIDEO_AV1_NUM_REF_FRAMES) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int32_t*>(&structInfo->gm_params[0][0]), STD_VIDEO_AV1_NUM_REF_FRAMES) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1GlobalMotion");
    out << "\t\t" << "StdVideoAV1GlobalMotion " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1LoopFilter(std::ostream &out, const StdVideoAV1LoopFilter* structInfo, Decoded_StdVideoAV1LoopFilter* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoAV1LoopFilterFlags(out,
                                                                           &structInfo->flags,
                                                                           metaInfo->flags,
                                                                           consumer);
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->loop_filter_level[0]), STD_VIDEO_AV1_MAX_LOOP_FILTER_STRENGTHS) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->loop_filter_sharpness) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->update_ref_delta) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->loop_filter_ref_deltas[0]), STD_VIDEO_AV1_TOTAL_REFS_PER_FRAME) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->update_mode_delta) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->loop_filter_mode_deltas[0]), STD_VIDEO_AV1_LOOP_FILTER_ADJUSTMENTS) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1LoopFilter");
    out << "\t\t" << "StdVideoAV1LoopFilter " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1LoopFilterFlags(std::ostream &out, const StdVideoAV1LoopFilterFlags* structInfo, Decoded_StdVideoAV1LoopFilterFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->loop_filter_delta_enabled << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->loop_filter_delta_update << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1LoopFilterFlags");
    out << "\t\t" << "StdVideoAV1LoopFilterFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1LoopRestoration(std::ostream &out, const StdVideoAV1LoopRestoration* structInfo, Decoded_StdVideoAV1LoopRestoration* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const StdVideoAV1FrameRestorationType*>(&structInfo->FrameRestorationType[0]), STD_VIDEO_AV1_MAX_NUM_PLANES) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint16_t*>(&structInfo->LoopRestorationSize[0]), STD_VIDEO_AV1_MAX_NUM_PLANES) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1LoopRestoration");
    out << "\t\t" << "StdVideoAV1LoopRestoration " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1Quantization(std::ostream &out, const StdVideoAV1Quantization* structInfo, Decoded_StdVideoAV1Quantization* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoAV1QuantizationFlags(out,
                                                                             &structInfo->flags,
                                                                             metaInfo->flags,
                                                                             consumer);
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->base_q_idx) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->DeltaQYDc) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->DeltaQUDc) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->DeltaQUAc) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->DeltaQVDc) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->DeltaQVAc) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->qm_y) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->qm_u) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->qm_v) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1Quantization");
    out << "\t\t" << "StdVideoAV1Quantization " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1QuantizationFlags(std::ostream &out, const StdVideoAV1QuantizationFlags* structInfo, Decoded_StdVideoAV1QuantizationFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->using_qmatrix << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->diff_uv_delta << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1QuantizationFlags");
    out << "\t\t" << "StdVideoAV1QuantizationFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1Segmentation(std::ostream &out, const StdVideoAV1Segmentation* structInfo, Decoded_StdVideoAV1Segmentation* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->FeatureEnabled[0]), STD_VIDEO_AV1_MAX_SEGMENTS) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int16_t*>(&structInfo->FeatureData[0][0]), STD_VIDEO_AV1_MAX_SEGMENTS) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1Segmentation");
    out << "\t\t" << "StdVideoAV1Segmentation " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1SequenceHeader(std::ostream &out, const StdVideoAV1SequenceHeader* structInfo, Decoded_StdVideoAV1SequenceHeader* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoAV1SequenceHeaderFlags(out,
                                                                               &structInfo->flags,
                                                                               metaInfo->flags,
                                                                               consumer);
    std::string pcolor_config_struct = "NULL";
    if (structInfo->pColorConfig != NULL) {
        pcolor_config_struct = GenerateStruct_StdVideoAV1ColorConfig(out,
                                                                     structInfo->pColorConfig,
                                                                     metaInfo->pColorConfig->GetMetaStructPointer(),
                                                                     consumer);
        pcolor_config_struct.insert(0, "&");
    }
    std::string ptiming_info_struct = "NULL";
    if (structInfo->pTimingInfo != NULL) {
        ptiming_info_struct = GenerateStruct_StdVideoAV1TimingInfo(out,
                                                                   structInfo->pTimingInfo,
                                                                   metaInfo->pTimingInfo->GetMetaStructPointer(),
                                                                   consumer);
        ptiming_info_struct.insert(0, "&");
    }
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1Profile(" << structInfo->seq_profile << ")" << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->frame_width_bits_minus_1) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->frame_height_bits_minus_1) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->max_frame_width_minus_1 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->max_frame_height_minus_1 << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->delta_frame_id_length_minus_2) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->additional_frame_id_length_minus_1) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->order_hint_bits_minus_1) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->seq_force_integer_mv) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->seq_force_screen_content_tools) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->reserved1[0]), 5) << "," << std::endl;
    struct_body << "\t\t\t" << pcolor_config_struct << "," << std::endl;
    struct_body << "\t\t\t" << ptiming_info_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1SequenceHeader");
    out << "\t\t" << "StdVideoAV1SequenceHeader " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1SequenceHeaderFlags(std::ostream &out, const StdVideoAV1SequenceHeaderFlags* structInfo, Decoded_StdVideoAV1SequenceHeaderFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->still_picture << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reduced_still_picture_header << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->use_128x128_superblock << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->enable_filter_intra << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->enable_intra_edge_filter << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->enable_interintra_compound << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->enable_masked_compound << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->enable_warped_motion << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->enable_dual_filter << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->enable_order_hint << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->enable_jnt_comp << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->enable_ref_frame_mvs << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_id_numbers_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->enable_superres << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->enable_cdef << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->enable_restoration << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->film_grain_params_present << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->timing_info_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->initial_display_delay_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1SequenceHeaderFlags");
    out << "\t\t" << "StdVideoAV1SequenceHeaderFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1TileInfo(std::ostream &out, const StdVideoAV1TileInfo* structInfo, Decoded_StdVideoAV1TileInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoAV1TileInfoFlags(out,
                                                                         &structInfo->flags,
                                                                         metaInfo->flags,
                                                                         consumer);
    std::string pmi_col_starts_array = "NULL";
    if (structInfo->pMiColStarts != NULL) {
        std::string pmi_col_starts_values;
        for (uint32_t idx0 = 0; idx0 < structInfo->TileCols; ++idx0) {
            pmi_col_starts_values += std::to_string(structInfo->pMiColStarts[idx0]) + ", ";
        }
        pmi_col_starts_array = "pMiColStarts_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint16_t " << pmi_col_starts_array << "[] = {" << pmi_col_starts_values << "};" << std::endl;
    }
    std::string pmi_row_starts_array = "NULL";
    if (structInfo->pMiRowStarts != NULL) {
        std::string pmi_row_starts_values;
        for (uint32_t idx0 = 0; idx0 < structInfo->TileRows; ++idx0) {
            pmi_row_starts_values += std::to_string(structInfo->pMiRowStarts[idx0]) + ", ";
        }
        pmi_row_starts_array = "pMiRowStarts_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint16_t " << pmi_row_starts_array << "[] = {" << pmi_row_starts_values << "};" << std::endl;
    }
    std::string pwidth_in_sbs_minus1_array = "NULL";
    if (structInfo->pWidthInSbsMinus1 != NULL) {
        std::string pwidth_in_sbs_minus1_values;
        for (uint32_t idx0 = 0; idx0 < structInfo->TileCols; ++idx0) {
            pwidth_in_sbs_minus1_values += std::to_string(structInfo->pWidthInSbsMinus1[idx0]) + ", ";
        }
        pwidth_in_sbs_minus1_array = "pWidthInSbsMinus1_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint16_t " << pwidth_in_sbs_minus1_array << "[] = {" << pwidth_in_sbs_minus1_values << "};" << std::endl;
    }
    std::string pheight_in_sbs_minus1_array = "NULL";
    if (structInfo->pHeightInSbsMinus1 != NULL) {
        std::string pheight_in_sbs_minus1_values;
        for (uint32_t idx0 = 0; idx0 < structInfo->TileRows; ++idx0) {
            pheight_in_sbs_minus1_values += std::to_string(structInfo->pHeightInSbsMinus1[idx0]) + ", ";
        }
        pheight_in_sbs_minus1_array = "pHeightInSbsMinus1_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint16_t " << pheight_in_sbs_minus1_array << "[] = {" << pheight_in_sbs_minus1_values << "};" << std::endl;
    }
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->TileCols) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->TileRows) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->context_update_tile_id << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->tile_size_bytes_minus_1) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->reserved1[0]), 7) << "," << std::endl;
    struct_body << "\t\t\t" << pmi_col_starts_array << "," << std::endl;
    struct_body << "\t\t\t" << pmi_row_starts_array << "," << std::endl;
    struct_body << "\t\t\t" << pwidth_in_sbs_minus1_array << "," << std::endl;
    struct_body << "\t\t\t" << pheight_in_sbs_minus1_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1TileInfo");
    out << "\t\t" << "StdVideoAV1TileInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1TileInfoFlags(std::ostream &out, const StdVideoAV1TileInfoFlags* structInfo, Decoded_StdVideoAV1TileInfoFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->uniform_tile_spacing_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1TileInfoFlags");
    out << "\t\t" << "StdVideoAV1TileInfoFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1TimingInfo(std::ostream &out, const StdVideoAV1TimingInfo* structInfo, Decoded_StdVideoAV1TimingInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoAV1TimingInfoFlags(out,
                                                                           &structInfo->flags,
                                                                           metaInfo->flags,
                                                                           consumer);
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->num_units_in_display_tick << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->time_scale << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->num_ticks_per_picture_minus_1 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1TimingInfo");
    out << "\t\t" << "StdVideoAV1TimingInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoAV1TimingInfoFlags(std::ostream &out, const StdVideoAV1TimingInfoFlags* structInfo, Decoded_StdVideoAV1TimingInfoFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->equal_picture_interval << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoAV1TimingInfoFlags");
    out << "\t\t" << "StdVideoAV1TimingInfoFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoDecodeAV1PictureInfo(std::ostream &out, const StdVideoDecodeAV1PictureInfo* structInfo, Decoded_StdVideoDecodeAV1PictureInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoDecodeAV1PictureInfoFlags(out,
                                                                                  &structInfo->flags,
                                                                                  metaInfo->flags,
                                                                                  consumer);
    std::string ptile_info_struct = "NULL";
    if (structInfo->pTileInfo != NULL) {
        ptile_info_struct = GenerateStruct_StdVideoAV1TileInfo(out,
                                                               structInfo->pTileInfo,
                                                               metaInfo->pTileInfo->GetMetaStructPointer(),
                                                               consumer);
        ptile_info_struct.insert(0, "&");
    }
    std::string pquantization_struct = "NULL";
    if (structInfo->pQuantization != NULL) {
        pquantization_struct = GenerateStruct_StdVideoAV1Quantization(out,
                                                                      structInfo->pQuantization,
                                                                      metaInfo->pQuantization->GetMetaStructPointer(),
                                                                      consumer);
        pquantization_struct.insert(0, "&");
    }
    std::string psegmentation_struct = "NULL";
    if (structInfo->pSegmentation != NULL) {
        psegmentation_struct = GenerateStruct_StdVideoAV1Segmentation(out,
                                                                      structInfo->pSegmentation,
                                                                      metaInfo->pSegmentation->GetMetaStructPointer(),
                                                                      consumer);
        psegmentation_struct.insert(0, "&");
    }
    std::string ploop_filter_struct = "NULL";
    if (structInfo->pLoopFilter != NULL) {
        ploop_filter_struct = GenerateStruct_StdVideoAV1LoopFilter(out,
                                                                   structInfo->pLoopFilter,
                                                                   metaInfo->pLoopFilter->GetMetaStructPointer(),
                                                                   consumer);
        ploop_filter_struct.insert(0, "&");
    }
    std::string pc_d_e_f_struct = "NULL";
    if (structInfo->pCDEF != NULL) {
        pc_d_e_f_struct = GenerateStruct_StdVideoAV1CDEF(out,
                                                         structInfo->pCDEF,
                                                         metaInfo->pCDEF->GetMetaStructPointer(),
                                                         consumer);
        pc_d_e_f_struct.insert(0, "&");
    }
    std::string ploop_restoration_struct = "NULL";
    if (structInfo->pLoopRestoration != NULL) {
        ploop_restoration_struct = GenerateStruct_StdVideoAV1LoopRestoration(out,
                                                                             structInfo->pLoopRestoration,
                                                                             metaInfo->pLoopRestoration->GetMetaStructPointer(),
                                                                             consumer);
        ploop_restoration_struct.insert(0, "&");
    }
    std::string pglobal_motion_struct = "NULL";
    if (structInfo->pGlobalMotion != NULL) {
        pglobal_motion_struct = GenerateStruct_StdVideoAV1GlobalMotion(out,
                                                                       structInfo->pGlobalMotion,
                                                                       metaInfo->pGlobalMotion->GetMetaStructPointer(),
                                                                       consumer);
        pglobal_motion_struct.insert(0, "&");
    }
    std::string pfilm_grain_struct = "NULL";
    if (structInfo->pFilmGrain != NULL) {
        pfilm_grain_struct = GenerateStruct_StdVideoAV1FilmGrain(out,
                                                                 structInfo->pFilmGrain,
                                                                 metaInfo->pFilmGrain->GetMetaStructPointer(),
                                                                 consumer);
        pfilm_grain_struct.insert(0, "&");
    }
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1FrameType(" << structInfo->frame_type << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->current_frame_id << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->OrderHint) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->primary_ref_frame) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->refresh_frame_flags) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->reserved1) << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1InterpolationFilter(" << structInfo->interpolation_filter << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1TxMode(" << structInfo->TxMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->delta_q_res) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->delta_lf_res) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->SkipModeFrame[0]), STD_VIDEO_AV1_SKIP_MODE_FRAMES) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->coded_denom) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->reserved2[0]), 3) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->OrderHints[0]), STD_VIDEO_AV1_NUM_REF_FRAMES) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint32_t*>(&structInfo->expectedFrameId[0]), STD_VIDEO_AV1_NUM_REF_FRAMES) << "," << std::endl;
    struct_body << "\t\t\t" << ptile_info_struct << "," << std::endl;
    struct_body << "\t\t\t" << pquantization_struct << "," << std::endl;
    struct_body << "\t\t\t" << psegmentation_struct << "," << std::endl;
    struct_body << "\t\t\t" << ploop_filter_struct << "," << std::endl;
    struct_body << "\t\t\t" << pc_d_e_f_struct << "," << std::endl;
    struct_body << "\t\t\t" << ploop_restoration_struct << "," << std::endl;
    struct_body << "\t\t\t" << pglobal_motion_struct << "," << std::endl;
    struct_body << "\t\t\t" << pfilm_grain_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoDecodeAV1PictureInfo");
    out << "\t\t" << "StdVideoDecodeAV1PictureInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoDecodeAV1PictureInfoFlags(std::ostream &out, const StdVideoDecodeAV1PictureInfoFlags* structInfo, Decoded_StdVideoDecodeAV1PictureInfoFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->error_resilient_mode << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->disable_cdf_update << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->use_superres << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->render_and_frame_size_different << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->allow_screen_content_tools << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->is_filter_switchable << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->force_integer_mv << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_size_override_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->buffer_removal_time_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->allow_intrabc << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_refs_short_signaling << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->allow_high_precision_mv << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->is_motion_mode_switchable << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->use_ref_frame_mvs << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->disable_frame_end_update_cdf << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->allow_warped_motion << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reduced_tx_set << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reference_select << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->skip_mode_present << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->delta_q_present << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->delta_lf_present << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->delta_lf_multi << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->segmentation_enabled << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->segmentation_update_map << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->segmentation_temporal_update << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->segmentation_update_data << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->UsesLr << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->usesChromaLr << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->apply_grain << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoDecodeAV1PictureInfoFlags");
    out << "\t\t" << "StdVideoDecodeAV1PictureInfoFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoDecodeAV1ReferenceInfo(std::ostream &out, const StdVideoDecodeAV1ReferenceInfo* structInfo, Decoded_StdVideoDecodeAV1ReferenceInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoDecodeAV1ReferenceInfoFlags(out,
                                                                                    &structInfo->flags,
                                                                                    metaInfo->flags,
                                                                                    consumer);
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->frame_type) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->RefFrameSignBias) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->OrderHint) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->SavedOrderHints[0]), STD_VIDEO_AV1_NUM_REF_FRAMES) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoDecodeAV1ReferenceInfo");
    out << "\t\t" << "StdVideoDecodeAV1ReferenceInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoDecodeAV1ReferenceInfoFlags(std::ostream &out, const StdVideoDecodeAV1ReferenceInfoFlags* structInfo, Decoded_StdVideoDecodeAV1ReferenceInfoFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->disable_frame_end_update_cdf << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->segmentation_enabled << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoDecodeAV1ReferenceInfoFlags");
    out << "\t\t" << "StdVideoDecodeAV1ReferenceInfoFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoDecodeH264PictureInfo(std::ostream &out, const StdVideoDecodeH264PictureInfo* structInfo, Decoded_StdVideoDecodeH264PictureInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoDecodeH264PictureInfoFlags(out,
                                                                                   &structInfo->flags,
                                                                                   metaInfo->flags,
                                                                                   consumer);
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->seq_parameter_set_id) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->pic_parameter_set_id) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->reserved1) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->reserved2) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_num << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->idr_pic_id << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int32_t*>(&structInfo->PicOrderCnt[0]), STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoDecodeH264PictureInfo");
    out << "\t\t" << "StdVideoDecodeH264PictureInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoDecodeH264PictureInfoFlags(std::ostream &out, const StdVideoDecodeH264PictureInfoFlags* structInfo, Decoded_StdVideoDecodeH264PictureInfoFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->field_pic_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->is_intra << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->IdrPicFlag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bottom_field_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->is_reference << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->complementary_field_pair << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoDecodeH264PictureInfoFlags");
    out << "\t\t" << "StdVideoDecodeH264PictureInfoFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoDecodeH264ReferenceInfo(std::ostream &out, const StdVideoDecodeH264ReferenceInfo* structInfo, Decoded_StdVideoDecodeH264ReferenceInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoDecodeH264ReferenceInfoFlags(out,
                                                                                     &structInfo->flags,
                                                                                     metaInfo->flags,
                                                                                     consumer);
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->FrameNum << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int32_t*>(&structInfo->PicOrderCnt[0]), STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoDecodeH264ReferenceInfo");
    out << "\t\t" << "StdVideoDecodeH264ReferenceInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoDecodeH264ReferenceInfoFlags(std::ostream &out, const StdVideoDecodeH264ReferenceInfoFlags* structInfo, Decoded_StdVideoDecodeH264ReferenceInfoFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->top_field_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bottom_field_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->used_for_long_term_reference << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->is_non_existing << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoDecodeH264ReferenceInfoFlags");
    out << "\t\t" << "StdVideoDecodeH264ReferenceInfoFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoDecodeVP9PictureInfo(std::ostream &out, const StdVideoDecodeVP9PictureInfo* structInfo, Decoded_StdVideoDecodeVP9PictureInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoDecodeVP9PictureInfoFlags(out,
                                                                                  &structInfo->flags,
                                                                                  metaInfo->flags,
                                                                                  consumer);
    std::string pcolor_config_struct = "NULL";
    if (structInfo->pColorConfig != NULL) {
        pcolor_config_struct = GenerateStruct_StdVideoVP9ColorConfig(out,
                                                                     structInfo->pColorConfig,
                                                                     metaInfo->pColorConfig->GetMetaStructPointer(),
                                                                     consumer);
        pcolor_config_struct.insert(0, "&");
    }
    std::string ploop_filter_struct = "NULL";
    if (structInfo->pLoopFilter != NULL) {
        ploop_filter_struct = GenerateStruct_StdVideoVP9LoopFilter(out,
                                                                   structInfo->pLoopFilter,
                                                                   metaInfo->pLoopFilter->GetMetaStructPointer(),
                                                                   consumer);
        ploop_filter_struct.insert(0, "&");
    }
    std::string psegmentation_struct = "NULL";
    if (structInfo->pSegmentation != NULL) {
        psegmentation_struct = GenerateStruct_StdVideoVP9Segmentation(out,
                                                                      structInfo->pSegmentation,
                                                                      metaInfo->pSegmentation->GetMetaStructPointer(),
                                                                      consumer);
        psegmentation_struct.insert(0, "&");
    }
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoVP9Profile(" << structInfo->profile << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoVP9FrameType(" << structInfo->frame_type << ")" << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->frame_context_idx) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->reset_frame_context) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->refresh_frame_flags) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->ref_frame_sign_bias_mask) << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoVP9InterpolationFilter(" << structInfo->interpolation_filter << ")" << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->base_q_idx) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->delta_q_y_dc) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->delta_q_uv_dc) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->delta_q_uv_ac) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->tile_cols_log2) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->tile_rows_log2) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint16_t*>(&structInfo->reserved1[0]), 3) << "," << std::endl;
    struct_body << "\t\t\t" << pcolor_config_struct << "," << std::endl;
    struct_body << "\t\t\t" << ploop_filter_struct << "," << std::endl;
    struct_body << "\t\t\t" << psegmentation_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoDecodeVP9PictureInfo");
    out << "\t\t" << "StdVideoDecodeVP9PictureInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoDecodeVP9PictureInfoFlags(std::ostream &out, const StdVideoDecodeVP9PictureInfoFlags* structInfo, Decoded_StdVideoDecodeVP9PictureInfoFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->error_resilient_mode << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->intra_only << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->allow_high_precision_mv << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->refresh_frame_context << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_parallel_decoding_mode << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->segmentation_enabled << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->show_frame << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->UsePrevFrameMvs << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoDecodeVP9PictureInfoFlags");
    out << "\t\t" << "StdVideoDecodeVP9PictureInfoFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeAV1DecoderModelInfo(std::ostream &out, const StdVideoEncodeAV1DecoderModelInfo* structInfo, Decoded_StdVideoEncodeAV1DecoderModelInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << std::to_string(structInfo->buffer_delay_length_minus_1) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->buffer_removal_time_length_minus_1) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->frame_presentation_time_length_minus_1) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->reserved1) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->num_units_in_decoding_tick << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeAV1DecoderModelInfo");
    out << "\t\t" << "StdVideoEncodeAV1DecoderModelInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeAV1ExtensionHeader(std::ostream &out, const StdVideoEncodeAV1ExtensionHeader* structInfo, Decoded_StdVideoEncodeAV1ExtensionHeader* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << std::to_string(structInfo->temporal_id) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->spatial_id) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeAV1ExtensionHeader");
    out << "\t\t" << "StdVideoEncodeAV1ExtensionHeader " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeAV1OperatingPointInfo(std::ostream &out, const StdVideoEncodeAV1OperatingPointInfo* structInfo, Decoded_StdVideoEncodeAV1OperatingPointInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoEncodeAV1OperatingPointInfoFlags(out,
                                                                                         &structInfo->flags,
                                                                                         metaInfo->flags,
                                                                                         consumer);
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->operating_point_idc << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->seq_level_idx) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->seq_tier) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->decoder_buffer_delay << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->encoder_buffer_delay << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->initial_display_delay_minus_1) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeAV1OperatingPointInfo");
    out << "\t\t" << "StdVideoEncodeAV1OperatingPointInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeAV1OperatingPointInfoFlags(std::ostream &out, const StdVideoEncodeAV1OperatingPointInfoFlags* structInfo, Decoded_StdVideoEncodeAV1OperatingPointInfoFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->decoder_model_present_for_this_op << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->low_delay_mode_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->initial_display_delay_present_for_this_op << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeAV1OperatingPointInfoFlags");
    out << "\t\t" << "StdVideoEncodeAV1OperatingPointInfoFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeAV1PictureInfo(std::ostream &out, const StdVideoEncodeAV1PictureInfo* structInfo, Decoded_StdVideoEncodeAV1PictureInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoEncodeAV1PictureInfoFlags(out,
                                                                                  &structInfo->flags,
                                                                                  metaInfo->flags,
                                                                                  consumer);
    std::string ptile_info_struct = "NULL";
    if (structInfo->pTileInfo != NULL) {
        ptile_info_struct = GenerateStruct_StdVideoAV1TileInfo(out,
                                                               structInfo->pTileInfo,
                                                               metaInfo->pTileInfo->GetMetaStructPointer(),
                                                               consumer);
        ptile_info_struct.insert(0, "&");
    }
    std::string pquantization_struct = "NULL";
    if (structInfo->pQuantization != NULL) {
        pquantization_struct = GenerateStruct_StdVideoAV1Quantization(out,
                                                                      structInfo->pQuantization,
                                                                      metaInfo->pQuantization->GetMetaStructPointer(),
                                                                      consumer);
        pquantization_struct.insert(0, "&");
    }
    std::string psegmentation_struct = "NULL";
    if (structInfo->pSegmentation != NULL) {
        psegmentation_struct = GenerateStruct_StdVideoAV1Segmentation(out,
                                                                      structInfo->pSegmentation,
                                                                      metaInfo->pSegmentation->GetMetaStructPointer(),
                                                                      consumer);
        psegmentation_struct.insert(0, "&");
    }
    std::string ploop_filter_struct = "NULL";
    if (structInfo->pLoopFilter != NULL) {
        ploop_filter_struct = GenerateStruct_StdVideoAV1LoopFilter(out,
                                                                   structInfo->pLoopFilter,
                                                                   metaInfo->pLoopFilter->GetMetaStructPointer(),
                                                                   consumer);
        ploop_filter_struct.insert(0, "&");
    }
    std::string pc_d_e_f_struct = "NULL";
    if (structInfo->pCDEF != NULL) {
        pc_d_e_f_struct = GenerateStruct_StdVideoAV1CDEF(out,
                                                         structInfo->pCDEF,
                                                         metaInfo->pCDEF->GetMetaStructPointer(),
                                                         consumer);
        pc_d_e_f_struct.insert(0, "&");
    }
    std::string ploop_restoration_struct = "NULL";
    if (structInfo->pLoopRestoration != NULL) {
        ploop_restoration_struct = GenerateStruct_StdVideoAV1LoopRestoration(out,
                                                                             structInfo->pLoopRestoration,
                                                                             metaInfo->pLoopRestoration->GetMetaStructPointer(),
                                                                             consumer);
        ploop_restoration_struct.insert(0, "&");
    }
    std::string pglobal_motion_struct = "NULL";
    if (structInfo->pGlobalMotion != NULL) {
        pglobal_motion_struct = GenerateStruct_StdVideoAV1GlobalMotion(out,
                                                                       structInfo->pGlobalMotion,
                                                                       metaInfo->pGlobalMotion->GetMetaStructPointer(),
                                                                       consumer);
        pglobal_motion_struct.insert(0, "&");
    }
    std::string pextension_header_struct = "NULL";
    if (structInfo->pExtensionHeader != NULL) {
        pextension_header_struct = GenerateStruct_StdVideoEncodeAV1ExtensionHeader(out,
                                                                                   structInfo->pExtensionHeader,
                                                                                   metaInfo->pExtensionHeader->GetMetaStructPointer(),
                                                                                   consumer);
        pextension_header_struct.insert(0, "&");
    }
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1FrameType(" << structInfo->frame_type << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_presentation_time << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->current_frame_id << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->order_hint) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->primary_ref_frame) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->refresh_frame_flags) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->coded_denom) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->render_width_minus_1 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->render_height_minus_1 << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1InterpolationFilter(" << structInfo->interpolation_filter << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1TxMode(" << structInfo->TxMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->delta_q_res) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->delta_lf_res) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->ref_order_hint[0]), STD_VIDEO_AV1_NUM_REF_FRAMES) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->ref_frame_idx[0]), STD_VIDEO_AV1_REFS_PER_FRAME) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->reserved1[0]), 3) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint32_t*>(&structInfo->delta_frame_id_minus_1[0]), STD_VIDEO_AV1_REFS_PER_FRAME) << "," << std::endl;
    struct_body << "\t\t\t" << ptile_info_struct << "," << std::endl;
    struct_body << "\t\t\t" << pquantization_struct << "," << std::endl;
    struct_body << "\t\t\t" << psegmentation_struct << "," << std::endl;
    struct_body << "\t\t\t" << ploop_filter_struct << "," << std::endl;
    struct_body << "\t\t\t" << pc_d_e_f_struct << "," << std::endl;
    struct_body << "\t\t\t" << ploop_restoration_struct << "," << std::endl;
    struct_body << "\t\t\t" << pglobal_motion_struct << "," << std::endl;
    struct_body << "\t\t\t" << pextension_header_struct << "," << std::endl;
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeAV1PictureInfo");
    out << "\t\t" << "StdVideoEncodeAV1PictureInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeAV1PictureInfoFlags(std::ostream &out, const StdVideoEncodeAV1PictureInfoFlags* structInfo, Decoded_StdVideoEncodeAV1PictureInfoFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->error_resilient_mode << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->disable_cdf_update << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->use_superres << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->render_and_frame_size_different << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->allow_screen_content_tools << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->is_filter_switchable << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->force_integer_mv << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_size_override_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->buffer_removal_time_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->allow_intrabc << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_refs_short_signaling << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->allow_high_precision_mv << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->is_motion_mode_switchable << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->use_ref_frame_mvs << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->disable_frame_end_update_cdf << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->allow_warped_motion << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reduced_tx_set << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->skip_mode_present << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->delta_q_present << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->delta_lf_present << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->delta_lf_multi << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->segmentation_enabled << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->segmentation_update_map << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->segmentation_temporal_update << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->segmentation_update_data << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->UsesLr << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->usesChromaLr << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->show_frame << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->showable_frame << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeAV1PictureInfoFlags");
    out << "\t\t" << "StdVideoEncodeAV1PictureInfoFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeAV1ReferenceInfo(std::ostream &out, const StdVideoEncodeAV1ReferenceInfo* structInfo, Decoded_StdVideoEncodeAV1ReferenceInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoEncodeAV1ReferenceInfoFlags(out,
                                                                                    &structInfo->flags,
                                                                                    metaInfo->flags,
                                                                                    consumer);
    std::string pextension_header_struct = "NULL";
    if (structInfo->pExtensionHeader != NULL) {
        pextension_header_struct = GenerateStruct_StdVideoEncodeAV1ExtensionHeader(out,
                                                                                   structInfo->pExtensionHeader,
                                                                                   metaInfo->pExtensionHeader->GetMetaStructPointer(),
                                                                                   consumer);
        pextension_header_struct.insert(0, "&");
    }
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->RefFrameId << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1FrameType(" << structInfo->frame_type << ")" << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->OrderHint) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->reserved1[0]), 3) << "," << std::endl;
    struct_body << "\t\t\t" << pextension_header_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeAV1ReferenceInfo");
    out << "\t\t" << "StdVideoEncodeAV1ReferenceInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeAV1ReferenceInfoFlags(std::ostream &out, const StdVideoEncodeAV1ReferenceInfoFlags* structInfo, Decoded_StdVideoEncodeAV1ReferenceInfoFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->disable_frame_end_update_cdf << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->segmentation_enabled << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeAV1ReferenceInfoFlags");
    out << "\t\t" << "StdVideoEncodeAV1ReferenceInfoFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeH264PictureInfo(std::ostream &out, const StdVideoEncodeH264PictureInfo* structInfo, Decoded_StdVideoEncodeH264PictureInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoEncodeH264PictureInfoFlags(out,
                                                                                   &structInfo->flags,
                                                                                   metaInfo->flags,
                                                                                   consumer);
    std::string pref_lists_struct = "NULL";
    if (structInfo->pRefLists != NULL) {
        pref_lists_struct = GenerateStruct_StdVideoEncodeH264ReferenceListsInfo(out,
                                                                                structInfo->pRefLists,
                                                                                metaInfo->pRefLists->GetMetaStructPointer(),
                                                                                consumer);
        pref_lists_struct.insert(0, "&");
    }
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->seq_parameter_set_id) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->pic_parameter_set_id) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->idr_pic_id << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264PictureType(" << structInfo->primary_pic_type << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_num << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->PicOrderCnt << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->temporal_id) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->reserved1[0]), 3) << "," << std::endl;
    struct_body << "\t\t\t" << pref_lists_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeH264PictureInfo");
    out << "\t\t" << "StdVideoEncodeH264PictureInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeH264PictureInfoFlags(std::ostream &out, const StdVideoEncodeH264PictureInfoFlags* structInfo, Decoded_StdVideoEncodeH264PictureInfoFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->IdrPicFlag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->is_reference << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->no_output_of_prior_pics_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->long_term_reference_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->adaptive_ref_pic_marking_mode_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeH264PictureInfoFlags");
    out << "\t\t" << "StdVideoEncodeH264PictureInfoFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeH264RefListModEntry(std::ostream &out, const StdVideoEncodeH264RefListModEntry* structInfo, Decoded_StdVideoEncodeH264RefListModEntry* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "StdVideoH264ModificationOfPicNumsIdc(" << structInfo->modification_of_pic_nums_idc << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->abs_diff_pic_num_minus1 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->long_term_pic_num << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeH264RefListModEntry");
    out << "\t\t" << "StdVideoEncodeH264RefListModEntry " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeH264RefPicMarkingEntry(std::ostream &out, const StdVideoEncodeH264RefPicMarkingEntry* structInfo, Decoded_StdVideoEncodeH264RefPicMarkingEntry* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "StdVideoH264MemMgmtControlOp(" << structInfo->memory_management_control_operation << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->difference_of_pic_nums_minus1 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->long_term_pic_num << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->long_term_frame_idx << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->max_long_term_frame_idx_plus1 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeH264RefPicMarkingEntry");
    out << "\t\t" << "StdVideoEncodeH264RefPicMarkingEntry " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeH264ReferenceInfo(std::ostream &out, const StdVideoEncodeH264ReferenceInfo* structInfo, Decoded_StdVideoEncodeH264ReferenceInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoEncodeH264ReferenceInfoFlags(out,
                                                                                     &structInfo->flags,
                                                                                     metaInfo->flags,
                                                                                     consumer);
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264PictureType(" << structInfo->primary_pic_type << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->FrameNum << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->PicOrderCnt << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->long_term_pic_num << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->long_term_frame_idx << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->temporal_id) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeH264ReferenceInfo");
    out << "\t\t" << "StdVideoEncodeH264ReferenceInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeH264ReferenceInfoFlags(std::ostream &out, const StdVideoEncodeH264ReferenceInfoFlags* structInfo, Decoded_StdVideoEncodeH264ReferenceInfoFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->used_for_long_term_reference << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeH264ReferenceInfoFlags");
    out << "\t\t" << "StdVideoEncodeH264ReferenceInfoFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeH264ReferenceListsInfo(std::ostream &out, const StdVideoEncodeH264ReferenceListsInfo* structInfo, Decoded_StdVideoEncodeH264ReferenceListsInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoEncodeH264ReferenceListsInfoFlags(out,
                                                                                          &structInfo->flags,
                                                                                          metaInfo->flags,
                                                                                          consumer);
    std::string pref_list0_mod_operations_array = "NULL";
    if (structInfo->pRefList0ModOperations != NULL) {
        pref_list0_mod_operations_array = "pRefList0ModOperations_" + std::to_string(consumer.GetNextId());
        std::string pref_list0_mod_operations_names;
        for (uint32_t idx = 0; idx < structInfo->refList0ModOpCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pRefList0ModOperations + idx != NULL) {
                variable_name = GenerateStruct_StdVideoEncodeH264RefListModEntry(out,
                                                                                 structInfo->pRefList0ModOperations + idx,
                                                                                 metaInfo->pRefList0ModOperations->GetMetaStructPointer() + idx,
                                                                                 consumer);
            }
            pref_list0_mod_operations_names += variable_name + ", ";
        }
        out << "\t\t" << "StdVideoEncodeH264RefListModEntry " << pref_list0_mod_operations_array << "[] = {" << pref_list0_mod_operations_names << "};" << std::endl;
    }
    std::string pref_list1_mod_operations_array = "NULL";
    if (structInfo->pRefList1ModOperations != NULL) {
        pref_list1_mod_operations_array = "pRefList1ModOperations_" + std::to_string(consumer.GetNextId());
        std::string pref_list1_mod_operations_names;
        for (uint32_t idx = 0; idx < structInfo->refList1ModOpCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pRefList1ModOperations + idx != NULL) {
                variable_name = GenerateStruct_StdVideoEncodeH264RefListModEntry(out,
                                                                                 structInfo->pRefList1ModOperations + idx,
                                                                                 metaInfo->pRefList1ModOperations->GetMetaStructPointer() + idx,
                                                                                 consumer);
            }
            pref_list1_mod_operations_names += variable_name + ", ";
        }
        out << "\t\t" << "StdVideoEncodeH264RefListModEntry " << pref_list1_mod_operations_array << "[] = {" << pref_list1_mod_operations_names << "};" << std::endl;
    }
    std::string pref_pic_marking_operations_array = "NULL";
    if (structInfo->pRefPicMarkingOperations != NULL) {
        pref_pic_marking_operations_array = "pRefPicMarkingOperations_" + std::to_string(consumer.GetNextId());
        std::string pref_pic_marking_operations_names;
        for (uint32_t idx = 0; idx < structInfo->refPicMarkingOpCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pRefPicMarkingOperations + idx != NULL) {
                variable_name = GenerateStruct_StdVideoEncodeH264RefPicMarkingEntry(out,
                                                                                    structInfo->pRefPicMarkingOperations + idx,
                                                                                    metaInfo->pRefPicMarkingOperations->GetMetaStructPointer() + idx,
                                                                                    consumer);
            }
            pref_pic_marking_operations_names += variable_name + ", ";
        }
        out << "\t\t" << "StdVideoEncodeH264RefPicMarkingEntry " << pref_pic_marking_operations_array << "[] = {" << pref_pic_marking_operations_names << "};" << std::endl;
    }
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->num_ref_idx_l0_active_minus1) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->num_ref_idx_l1_active_minus1) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->RefPicList0[0]), STD_VIDEO_H264_MAX_NUM_LIST_REF) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->RefPicList1[0]), STD_VIDEO_H264_MAX_NUM_LIST_REF) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->refList0ModOpCount) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->refList1ModOpCount) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->refPicMarkingOpCount) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->reserved1[0]), 7) << "," << std::endl;
    struct_body << "\t\t\t" << pref_list0_mod_operations_array << "," << std::endl;
    struct_body << "\t\t\t" << pref_list1_mod_operations_array << "," << std::endl;
    struct_body << "\t\t\t" << pref_pic_marking_operations_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeH264ReferenceListsInfo");
    out << "\t\t" << "StdVideoEncodeH264ReferenceListsInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeH264ReferenceListsInfoFlags(std::ostream &out, const StdVideoEncodeH264ReferenceListsInfoFlags* structInfo, Decoded_StdVideoEncodeH264ReferenceListsInfoFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->ref_pic_list_modification_flag_l0 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->ref_pic_list_modification_flag_l1 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeH264ReferenceListsInfoFlags");
    out << "\t\t" << "StdVideoEncodeH264ReferenceListsInfoFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeH264SliceHeader(std::ostream &out, const StdVideoEncodeH264SliceHeader* structInfo, Decoded_StdVideoEncodeH264SliceHeader* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoEncodeH264SliceHeaderFlags(out,
                                                                                   &structInfo->flags,
                                                                                   metaInfo->flags,
                                                                                   consumer);
    std::string pweight_table_struct = "NULL";
    if (structInfo->pWeightTable != NULL) {
        pweight_table_struct = GenerateStruct_StdVideoEncodeH264WeightTable(out,
                                                                            structInfo->pWeightTable,
                                                                            metaInfo->pWeightTable->GetMetaStructPointer(),
                                                                            consumer);
        pweight_table_struct.insert(0, "&");
    }
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->first_mb_in_slice << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264SliceType(" << structInfo->slice_type << ")" << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->slice_alpha_c0_offset_div2) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->slice_beta_offset_div2) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->slice_qp_delta) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->reserved1) << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264CabacInitIdc(" << structInfo->cabac_init_idc << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264DisableDeblockingFilterIdc(" << structInfo->disable_deblocking_filter_idc << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pweight_table_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeH264SliceHeader");
    out << "\t\t" << "StdVideoEncodeH264SliceHeader " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeH264SliceHeaderFlags(std::ostream &out, const StdVideoEncodeH264SliceHeaderFlags* structInfo, Decoded_StdVideoEncodeH264SliceHeaderFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->direct_spatial_mv_pred_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->num_ref_idx_active_override_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeH264SliceHeaderFlags");
    out << "\t\t" << "StdVideoEncodeH264SliceHeaderFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeH264WeightTable(std::ostream &out, const StdVideoEncodeH264WeightTable* structInfo, Decoded_StdVideoEncodeH264WeightTable* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoEncodeH264WeightTableFlags(out,
                                                                                   &structInfo->flags,
                                                                                   metaInfo->flags,
                                                                                   consumer);
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->luma_log2_weight_denom) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->chroma_log2_weight_denom) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->luma_weight_l0[0]), STD_VIDEO_H264_MAX_NUM_LIST_REF) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->luma_offset_l0[0]), STD_VIDEO_H264_MAX_NUM_LIST_REF) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->chroma_weight_l0[0][0]), STD_VIDEO_H264_MAX_NUM_LIST_REF) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->chroma_offset_l0[0][0]), STD_VIDEO_H264_MAX_NUM_LIST_REF) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->luma_weight_l1[0]), STD_VIDEO_H264_MAX_NUM_LIST_REF) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->luma_offset_l1[0]), STD_VIDEO_H264_MAX_NUM_LIST_REF) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->chroma_weight_l1[0][0]), STD_VIDEO_H264_MAX_NUM_LIST_REF) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->chroma_offset_l1[0][0]), STD_VIDEO_H264_MAX_NUM_LIST_REF) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeH264WeightTable");
    out << "\t\t" << "StdVideoEncodeH264WeightTable " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoEncodeH264WeightTableFlags(std::ostream &out, const StdVideoEncodeH264WeightTableFlags* structInfo, Decoded_StdVideoEncodeH264WeightTableFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->luma_weight_l0_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->chroma_weight_l0_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->luma_weight_l1_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->chroma_weight_l1_flag << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoEncodeH264WeightTableFlags");
    out << "\t\t" << "StdVideoEncodeH264WeightTableFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoH264HrdParameters(std::ostream &out, const StdVideoH264HrdParameters* structInfo, Decoded_StdVideoH264HrdParameters* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << std::to_string(structInfo->cpb_cnt_minus1) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->bit_rate_scale) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->cpb_size_scale) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->reserved1) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint32_t*>(&structInfo->bit_rate_value_minus1[0]), STD_VIDEO_H264_CPB_CNT_LIST_SIZE) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint32_t*>(&structInfo->cpb_size_value_minus1[0]), STD_VIDEO_H264_CPB_CNT_LIST_SIZE) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->cbr_flag[0]), STD_VIDEO_H264_CPB_CNT_LIST_SIZE) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->initial_cpb_removal_delay_length_minus1 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->cpb_removal_delay_length_minus1 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dpb_output_delay_length_minus1 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->time_offset_length << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoH264HrdParameters");
    out << "\t\t" << "StdVideoH264HrdParameters " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoH264PictureParameterSet(std::ostream &out, const StdVideoH264PictureParameterSet* structInfo, Decoded_StdVideoH264PictureParameterSet* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoH264PpsFlags(out,
                                                                     &structInfo->flags,
                                                                     metaInfo->flags,
                                                                     consumer);
    std::string pscaling_lists_struct = "NULL";
    if (structInfo->pScalingLists != NULL) {
        pscaling_lists_struct = GenerateStruct_StdVideoH264ScalingLists(out,
                                                                        structInfo->pScalingLists,
                                                                        metaInfo->pScalingLists->GetMetaStructPointer(),
                                                                        consumer);
        pscaling_lists_struct.insert(0, "&");
    }
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->seq_parameter_set_id) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->pic_parameter_set_id) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->num_ref_idx_l0_default_active_minus1) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->num_ref_idx_l1_default_active_minus1) << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264WeightedBipredIdc(" << structInfo->weighted_bipred_idc << ")" << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->pic_init_qp_minus26) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->pic_init_qs_minus26) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->chroma_qp_index_offset) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->second_chroma_qp_index_offset) << "," << std::endl;
    struct_body << "\t\t\t" << pscaling_lists_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoH264PictureParameterSet");
    out << "\t\t" << "StdVideoH264PictureParameterSet " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoH264PpsFlags(std::ostream &out, const StdVideoH264PpsFlags* structInfo, Decoded_StdVideoH264PpsFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->transform_8x8_mode_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->redundant_pic_cnt_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->constrained_intra_pred_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deblocking_filter_control_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->weighted_pred_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bottom_field_pic_order_in_frame_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->entropy_coding_mode_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pic_scaling_matrix_present_flag << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoH264PpsFlags");
    out << "\t\t" << "StdVideoH264PpsFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoH264ScalingLists(std::ostream &out, const StdVideoH264ScalingLists* structInfo, Decoded_StdVideoH264ScalingLists* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->scaling_list_present_mask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->use_default_scaling_matrix_mask << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->ScalingList4x4[0][0]), STD_VIDEO_H264_SCALING_LIST_4X4_NUM_LISTS) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->ScalingList8x8[0][0]), STD_VIDEO_H264_SCALING_LIST_8X8_NUM_LISTS) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoH264ScalingLists");
    out << "\t\t" << "StdVideoH264ScalingLists " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoH264SequenceParameterSet(std::ostream &out, const StdVideoH264SequenceParameterSet* structInfo, Decoded_StdVideoH264SequenceParameterSet* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoH264SpsFlags(out,
                                                                     &structInfo->flags,
                                                                     metaInfo->flags,
                                                                     consumer);
    std::string poffset_for_ref_frame_array = "NULL";
    if (structInfo->pOffsetForRefFrame != NULL) {
        poffset_for_ref_frame_array = "pOffsetForRefFrame_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "int32_t " << poffset_for_ref_frame_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pOffsetForRefFrame, structInfo->num_ref_frames_in_pic_order_cnt_cycle) << ";" << std::endl;
    }
    std::string pscaling_lists_struct = "NULL";
    if (structInfo->pScalingLists != NULL) {
        pscaling_lists_struct = GenerateStruct_StdVideoH264ScalingLists(out,
                                                                        structInfo->pScalingLists,
                                                                        metaInfo->pScalingLists->GetMetaStructPointer(),
                                                                        consumer);
        pscaling_lists_struct.insert(0, "&");
    }
    std::string psequence_parameter_set_vui_struct = "NULL";
    if (structInfo->pSequenceParameterSetVui != NULL) {
        psequence_parameter_set_vui_struct = GenerateStruct_StdVideoH264SequenceParameterSetVui(out,
                                                                                                structInfo->pSequenceParameterSetVui,
                                                                                                metaInfo->pSequenceParameterSetVui->GetMetaStructPointer(),
                                                                                                consumer);
        psequence_parameter_set_vui_struct.insert(0, "&");
    }
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264ProfileIdc(" << structInfo->profile_idc << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264LevelIdc(" << structInfo->level_idc << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264ChromaFormatIdc(" << structInfo->chroma_format_idc << ")" << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->seq_parameter_set_id) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->bit_depth_luma_minus8) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->bit_depth_chroma_minus8) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->log2_max_frame_num_minus4) << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264PocType(" << structInfo->pic_order_cnt_type << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->offset_for_non_ref_pic << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->offset_for_top_to_bottom_field << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->log2_max_pic_order_cnt_lsb_minus4) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->num_ref_frames_in_pic_order_cnt_cycle) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->max_num_ref_frames) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->reserved1) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pic_width_in_mbs_minus1 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pic_height_in_map_units_minus1 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_crop_left_offset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_crop_right_offset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_crop_top_offset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_crop_bottom_offset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved2 << "," << std::endl;
    struct_body << "\t\t\t" << poffset_for_ref_frame_array << "," << std::endl;
    struct_body << "\t\t\t" << pscaling_lists_struct << "," << std::endl;
    struct_body << "\t\t\t" << psequence_parameter_set_vui_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoH264SequenceParameterSet");
    out << "\t\t" << "StdVideoH264SequenceParameterSet " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoH264SequenceParameterSetVui(std::ostream &out, const StdVideoH264SequenceParameterSetVui* structInfo, Decoded_StdVideoH264SequenceParameterSetVui* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoH264SpsVuiFlags(out,
                                                                        &structInfo->flags,
                                                                        metaInfo->flags,
                                                                        consumer);
    std::string phrd_parameters_struct = "NULL";
    if (structInfo->pHrdParameters != NULL) {
        phrd_parameters_struct = GenerateStruct_StdVideoH264HrdParameters(out,
                                                                          structInfo->pHrdParameters,
                                                                          metaInfo->pHrdParameters->GetMetaStructPointer(),
                                                                          consumer);
        phrd_parameters_struct.insert(0, "&");
    }
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264AspectRatioIdc(" << structInfo->aspect_ratio_idc << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sar_width << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sar_height << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->video_format) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->colour_primaries) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->transfer_characteristics) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->matrix_coefficients) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->num_units_in_tick << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->time_scale << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->max_num_reorder_frames) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->max_dec_frame_buffering) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->chroma_sample_loc_type_top_field) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->chroma_sample_loc_type_bottom_field) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved1 << "," << std::endl;
    struct_body << "\t\t\t" << phrd_parameters_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoH264SequenceParameterSetVui");
    out << "\t\t" << "StdVideoH264SequenceParameterSetVui " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoH264SpsFlags(std::ostream &out, const StdVideoH264SpsFlags* structInfo, Decoded_StdVideoH264SpsFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->constraint_set0_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->constraint_set1_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->constraint_set2_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->constraint_set3_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->constraint_set4_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->constraint_set5_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->direct_8x8_inference_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->mb_adaptive_frame_field_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_mbs_only_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->delta_pic_order_always_zero_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->separate_colour_plane_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->gaps_in_frame_num_value_allowed_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->qpprime_y_zero_transform_bypass_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frame_cropping_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->seq_scaling_matrix_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vui_parameters_present_flag << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoH264SpsFlags");
    out << "\t\t" << "StdVideoH264SpsFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoH264SpsVuiFlags(std::ostream &out, const StdVideoH264SpsVuiFlags* structInfo, Decoded_StdVideoH264SpsVuiFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->aspect_ratio_info_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->overscan_info_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->overscan_appropriate_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->video_signal_type_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->video_full_range_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->color_description_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->chroma_loc_info_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->timing_info_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fixed_frame_rate_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bitstream_restriction_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->nal_hrd_parameters_present_flag << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vcl_hrd_parameters_present_flag << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoH264SpsVuiFlags");
    out << "\t\t" << "StdVideoH264SpsVuiFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoVP9ColorConfig(std::ostream &out, const StdVideoVP9ColorConfig* structInfo, Decoded_StdVideoVP9ColorConfig* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoVP9ColorConfigFlags(out,
                                                                            &structInfo->flags,
                                                                            metaInfo->flags,
                                                                            consumer);
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->BitDepth) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->subsampling_x) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->subsampling_y) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->reserved1) << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoVP9ColorSpace(" << structInfo->color_space << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoVP9ColorConfig");
    out << "\t\t" << "StdVideoVP9ColorConfig " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoVP9ColorConfigFlags(std::ostream &out, const StdVideoVP9ColorConfigFlags* structInfo, Decoded_StdVideoVP9ColorConfigFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->color_range << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoVP9ColorConfigFlags");
    out << "\t\t" << "StdVideoVP9ColorConfigFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoVP9LoopFilter(std::ostream &out, const StdVideoVP9LoopFilter* structInfo, Decoded_StdVideoVP9LoopFilter* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoVP9LoopFilterFlags(out,
                                                                           &structInfo->flags,
                                                                           metaInfo->flags,
                                                                           consumer);
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->loop_filter_level) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->loop_filter_sharpness) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->update_ref_delta) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->loop_filter_ref_deltas[0]), STD_VIDEO_VP9_MAX_REF_FRAMES) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->update_mode_delta) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int8_t*>(&structInfo->loop_filter_mode_deltas[0]), STD_VIDEO_VP9_LOOP_FILTER_ADJUSTMENTS) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoVP9LoopFilter");
    out << "\t\t" << "StdVideoVP9LoopFilter " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoVP9LoopFilterFlags(std::ostream &out, const StdVideoVP9LoopFilterFlags* structInfo, Decoded_StdVideoVP9LoopFilterFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->loop_filter_delta_enabled << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->loop_filter_delta_update << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoVP9LoopFilterFlags");
    out << "\t\t" << "StdVideoVP9LoopFilterFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoVP9Segmentation(std::ostream &out, const StdVideoVP9Segmentation* structInfo, Decoded_StdVideoVP9Segmentation* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string flags_info_var = GenerateStruct_StdVideoVP9SegmentationFlags(out,
                                                                             &structInfo->flags,
                                                                             metaInfo->flags,
                                                                             consumer);
    struct_body << "\t" << flags_info_var << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->segmentation_tree_probs[0]), STD_VIDEO_VP9_MAX_SEGMENTATION_TREE_PROBS) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->segmentation_pred_prob[0]), STD_VIDEO_VP9_MAX_SEGMENTATION_PRED_PROB) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->FeatureEnabled[0]), STD_VIDEO_VP9_MAX_SEGMENTS) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int16_t*>(&structInfo->FeatureData[0][0]), STD_VIDEO_VP9_MAX_SEGMENTS) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoVP9Segmentation");
    out << "\t\t" << "StdVideoVP9Segmentation " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_StdVideoVP9SegmentationFlags(std::ostream &out, const StdVideoVP9SegmentationFlags* structInfo, Decoded_StdVideoVP9SegmentationFlags* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->segmentation_update_map << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->segmentation_temporal_update << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->segmentation_update_data << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->segmentation_abs_or_delta_update << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reserved << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stdVideoVP9SegmentationFlags");
    out << "\t\t" << "StdVideoVP9SegmentationFlags " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkAllocationCallbacks(std::ostream &out, const VkAllocationCallbacks* structInfo, Decoded_VkAllocationCallbacks* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    out << "\t\t" << "// TODO: Support pUserData (non-struct output) argument." << std::endl;
    struct_body << "\t\t\t" << structInfo->pfnAllocation << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pfnReallocation << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pfnFree << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pfnInternalAllocation << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pfnInternalFree << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "allocationCallbacks");
    out << "\t\t" << "VkAllocationCallbacks " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkApplicationInfo(std::ostream &out, const VkApplicationInfo* structInfo, Decoded_VkApplicationInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->pApplicationName) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->applicationVersion << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->pEngineName) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->engineVersion << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->apiVersion << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "applicationInfo");
    out << "\t\t" << "VkApplicationInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkAttachmentDescription(std::ostream &out, const VkAttachmentDescription* structInfo, Decoded_VkAttachmentDescription* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "VkAttachmentDescriptionFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->format << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlagBits(" << structInfo->samples << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAttachmentLoadOp(" << structInfo->loadOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAttachmentStoreOp(" << structInfo->storeOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAttachmentLoadOp(" << structInfo->stencilLoadOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAttachmentStoreOp(" << structInfo->stencilStoreOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->initialLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->finalLayout << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "attachmentDescription");
    out << "\t\t" << "VkAttachmentDescription " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkAttachmentReference(std::ostream &out, const VkAttachmentReference* structInfo, Decoded_VkAttachmentReference* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->attachment << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->layout << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "attachmentReference");
    out << "\t\t" << "VkAttachmentReference " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBufferCopy(std::ostream &out, const VkBufferCopy* structInfo, Decoded_VkBufferCopy* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->srcOffset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dstOffset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bufferCopy");
    out << "\t\t" << "VkBufferCopy " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBufferCreateInfo(std::ostream &out, const VkBufferCreateInfo* structInfo, Decoded_VkBufferCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pqueue_family_indices_array = "NULL";
    if (structInfo->pQueueFamilyIndices != NULL) {
        pqueue_family_indices_array = "pQueueFamilyIndices_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pqueue_family_indices_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pQueueFamilyIndices, structInfo->queueFamilyIndexCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkBufferCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << "VkBufferUsageFlags(" << structInfo->usage << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSharingMode(" << structInfo->sharingMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->queueFamilyIndexCount << "," << std::endl;
    struct_body << "\t\t\t" << pqueue_family_indices_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bufferCreateInfo");
    out << "\t\t" << "VkBufferCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBufferImageCopy(std::ostream &out, const VkBufferImageCopy* structInfo, Decoded_VkBufferImageCopy* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string image_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                     &structInfo->imageSubresource,
                                                                                     metaInfo->imageSubresource,
                                                                                     consumer);
    std::string image_offset_info_var = GenerateStruct_VkOffset3D(out,
                                                                  &structInfo->imageOffset,
                                                                  metaInfo->imageOffset,
                                                                  consumer);
    std::string image_extent_info_var = GenerateStruct_VkExtent3D(out,
                                                                  &structInfo->imageExtent,
                                                                  metaInfo->imageExtent,
                                                                  consumer);
    struct_body << "\t" << structInfo->bufferOffset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferRowLength << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferImageHeight << "," << std::endl;
    struct_body << "\t\t\t" << image_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << image_offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << image_extent_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bufferImageCopy");
    out << "\t\t" << "VkBufferImageCopy " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBufferMemoryBarrier(std::ostream &out, const VkBufferMemoryBarrier* structInfo, Decoded_VkBufferMemoryBarrier* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags(" << structInfo->srcAccessMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags(" << structInfo->dstAccessMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->srcQueueFamilyIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dstQueueFamilyIndex << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->buffer) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->offset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bufferMemoryBarrier");
    out << "\t\t" << "VkBufferMemoryBarrier " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBufferViewCreateInfo(std::ostream &out, const VkBufferViewCreateInfo* structInfo, Decoded_VkBufferViewCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkBufferViewCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->buffer) << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->format << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->offset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->range << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bufferViewCreateInfo");
    out << "\t\t" << "VkBufferViewCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkClearAttachment(std::ostream &out, const VkClearAttachment* structInfo, Decoded_VkClearAttachment* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "VkImageAspectFlags(" << structInfo->aspectMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->colorAttachment << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(structInfo->clearValue) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "clearAttachment");
    out << "\t\t" << "VkClearAttachment " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkClearDepthStencilValue(std::ostream &out, const VkClearDepthStencilValue* structInfo, Decoded_VkClearDepthStencilValue* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->depth << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stencil << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "clearDepthStencilValue");
    out << "\t\t" << "VkClearDepthStencilValue " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkClearRect(std::ostream &out, const VkClearRect* structInfo, Decoded_VkClearRect* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string rect_info_var = GenerateStruct_VkRect2D(out,
                                                        &structInfo->rect,
                                                        metaInfo->rect,
                                                        consumer);
    struct_body << "\t" << rect_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->baseArrayLayer << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->layerCount << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "clearRect");
    out << "\t\t" << "VkClearRect " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCommandBufferAllocateInfo(std::ostream &out, const VkCommandBufferAllocateInfo* structInfo, Decoded_VkCommandBufferAllocateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->commandPool) << "," << std::endl;
    struct_body << "\t\t\t" << "VkCommandBufferLevel(" << structInfo->level << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->commandBufferCount << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "commandBufferAllocateInfo");
    out << "\t\t" << "VkCommandBufferAllocateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCommandBufferBeginInfo(std::ostream &out, const VkCommandBufferBeginInfo* structInfo, Decoded_VkCommandBufferBeginInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pinheritance_info_struct = "NULL";
    if (structInfo->pInheritanceInfo != NULL) {
        pinheritance_info_struct = GenerateStruct_VkCommandBufferInheritanceInfo(out,
                                                                                 structInfo->pInheritanceInfo,
                                                                                 metaInfo->pInheritanceInfo->GetMetaStructPointer(),
                                                                                 consumer);
        pinheritance_info_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkCommandBufferUsageFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pinheritance_info_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "commandBufferBeginInfo");
    out << "\t\t" << "VkCommandBufferBeginInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCommandBufferInheritanceInfo(std::ostream &out, const VkCommandBufferInheritanceInfo* structInfo, Decoded_VkCommandBufferInheritanceInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->renderPass) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subpass << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->framebuffer) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->occlusionQueryEnable << "," << std::endl;
    struct_body << "\t\t\t" << "VkQueryControlFlags(" << structInfo->queryFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkQueryPipelineStatisticFlags(" << structInfo->pipelineStatistics << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "commandBufferInheritanceInfo");
    out << "\t\t" << "VkCommandBufferInheritanceInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCommandPoolCreateInfo(std::ostream &out, const VkCommandPoolCreateInfo* structInfo, Decoded_VkCommandPoolCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkCommandPoolCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->queueFamilyIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "commandPoolCreateInfo");
    out << "\t\t" << "VkCommandPoolCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkComponentMapping(std::ostream &out, const VkComponentMapping* structInfo, Decoded_VkComponentMapping* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "VkComponentSwizzle(" << structInfo->r << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkComponentSwizzle(" << structInfo->g << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkComponentSwizzle(" << structInfo->b << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkComponentSwizzle(" << structInfo->a << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "componentMapping");
    out << "\t\t" << "VkComponentMapping " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkComputePipelineCreateInfo(std::ostream &out, const VkComputePipelineCreateInfo* structInfo, Decoded_VkComputePipelineCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string stage_info_var = GenerateStruct_VkPipelineShaderStageCreateInfo(out,
                                                                                &structInfo->stage,
                                                                                metaInfo->stage,
                                                                                consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << stage_info_var << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->layout) << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->basePipelineHandle) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->basePipelineIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "computePipelineCreateInfo");
    out << "\t\t" << "VkComputePipelineCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCopyDescriptorSet(std::ostream &out, const VkCopyDescriptorSet* structInfo, Decoded_VkCopyDescriptorSet* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->srcSet) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->srcBinding << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->srcArrayElement << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->dstSet) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dstBinding << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dstArrayElement << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorCount << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "copyDescriptorSet");
    out << "\t\t" << "VkCopyDescriptorSet " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDescriptorBufferInfo(std::ostream &out, const VkDescriptorBufferInfo* structInfo, Decoded_VkDescriptorBufferInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << consumer.GetHandle(metaInfo->buffer) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->offset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->range << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "descriptorBufferInfo");
    out << "\t\t" << "VkDescriptorBufferInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDescriptorPoolCreateInfo(std::ostream &out, const VkDescriptorPoolCreateInfo* structInfo, Decoded_VkDescriptorPoolCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string ppool_sizes_array = "NULL";
    if (structInfo->pPoolSizes != NULL) {
        ppool_sizes_array = "pPoolSizes_" + std::to_string(consumer.GetNextId());
        std::string ppool_sizes_names;
        for (uint32_t idx = 0; idx < structInfo->poolSizeCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pPoolSizes + idx != NULL) {
                variable_name = GenerateStruct_VkDescriptorPoolSize(out,
                                                                    structInfo->pPoolSizes + idx,
                                                                    metaInfo->pPoolSizes->GetMetaStructPointer() + idx,
                                                                    consumer);
            }
            ppool_sizes_names += variable_name + ", ";
        }
        out << "\t\t" << "VkDescriptorPoolSize " << ppool_sizes_array << "[] = {" << ppool_sizes_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDescriptorPoolCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxSets << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->poolSizeCount << "," << std::endl;
    struct_body << "\t\t\t" << ppool_sizes_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "descriptorPoolCreateInfo");
    out << "\t\t" << "VkDescriptorPoolCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDescriptorPoolSize(std::ostream &out, const VkDescriptorPoolSize* structInfo, Decoded_VkDescriptorPoolSize* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "VkDescriptorType(" << structInfo->type << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorCount << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "descriptorPoolSize");
    out << "\t\t" << "VkDescriptorPoolSize " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDescriptorSetAllocateInfo(std::ostream &out, const VkDescriptorSetAllocateInfo* structInfo, Decoded_VkDescriptorSetAllocateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pset_layouts_array = "NULL";
    if (metaInfo->pSetLayouts.GetPointer() != NULL && structInfo->descriptorSetCount > 0) {
        pset_layouts_array = "pset_layouts_array_" + std::to_string(consumer.GetNextId(VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT));
        std::string pset_layouts_values = toStringJoin(metaInfo->pSetLayouts.GetPointer(),
                                                       metaInfo->pSetLayouts.GetPointer() + structInfo->descriptorSetCount,
                                                       [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                       ", ");
        if (structInfo->descriptorSetCount == 1) {
            pset_layouts_array = "&" + pset_layouts_values;
        } else if (structInfo->descriptorSetCount > 1) {
            out << "\t\t" << "VkDescriptorSetLayout " << pset_layouts_array << "[] = {" << pset_layouts_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->descriptorPool) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorSetCount << "," << std::endl;
    struct_body << "\t\t\t" << pset_layouts_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "descriptorSetAllocateInfo");
    out << "\t\t" << "VkDescriptorSetAllocateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDescriptorSetLayoutBinding(std::ostream &out, const VkDescriptorSetLayoutBinding* structInfo, Decoded_VkDescriptorSetLayoutBinding* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pimmutable_samplers_array = "NULL";
    if (metaInfo->pImmutableSamplers.GetPointer() != NULL && structInfo->descriptorCount > 0) {
        pimmutable_samplers_array = "pimmutable_samplers_array_" + std::to_string(consumer.GetNextId(VK_OBJECT_TYPE_SAMPLER));
        std::string pimmutable_samplers_values = toStringJoin(metaInfo->pImmutableSamplers.GetPointer(),
                                                              metaInfo->pImmutableSamplers.GetPointer() + structInfo->descriptorCount,
                                                              [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                              ", ");
        if (structInfo->descriptorCount == 1) {
            pimmutable_samplers_array = "&" + pimmutable_samplers_values;
        } else if (structInfo->descriptorCount > 1) {
            out << "\t\t" << "VkSampler " << pimmutable_samplers_array << "[] = {" << pimmutable_samplers_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << structInfo->binding << "," << std::endl;
    struct_body << "\t\t\t" << "VkDescriptorType(" << structInfo->descriptorType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorCount << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderStageFlags(" << structInfo->stageFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pimmutable_samplers_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "descriptorSetLayoutBinding");
    out << "\t\t" << "VkDescriptorSetLayoutBinding " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDescriptorSetLayoutCreateInfo(std::ostream &out, const VkDescriptorSetLayoutCreateInfo* structInfo, Decoded_VkDescriptorSetLayoutCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pbindings_array = "NULL";
    if (structInfo->pBindings != NULL) {
        pbindings_array = "pBindings_" + std::to_string(consumer.GetNextId());
        std::string pbindings_names;
        for (uint32_t idx = 0; idx < structInfo->bindingCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pBindings + idx != NULL) {
                variable_name = GenerateStruct_VkDescriptorSetLayoutBinding(out,
                                                                            structInfo->pBindings + idx,
                                                                            metaInfo->pBindings->GetMetaStructPointer() + idx,
                                                                            consumer);
            }
            pbindings_names += variable_name + ", ";
        }
        out << "\t\t" << "VkDescriptorSetLayoutBinding " << pbindings_array << "[] = {" << pbindings_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDescriptorSetLayoutCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bindingCount << "," << std::endl;
    struct_body << "\t\t\t" << pbindings_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "descriptorSetLayoutCreateInfo");
    out << "\t\t" << "VkDescriptorSetLayoutCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceCreateInfo(std::ostream &out, const VkDeviceCreateInfo* structInfo, Decoded_VkDeviceCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pqueue_create_infos_array = "NULL";
    if (structInfo->pQueueCreateInfos != NULL) {
        pqueue_create_infos_array = "pQueueCreateInfos_" + std::to_string(consumer.GetNextId());
        std::string pqueue_create_infos_names;
        for (uint32_t idx = 0; idx < structInfo->queueCreateInfoCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pQueueCreateInfos + idx != NULL) {
                variable_name = GenerateStruct_VkDeviceQueueCreateInfo(out,
                                                                       structInfo->pQueueCreateInfos + idx,
                                                                       metaInfo->pQueueCreateInfos->GetMetaStructPointer() + idx,
                                                                       consumer);
            }
            pqueue_create_infos_names += variable_name + ", ";
        }
        out << "\t\t" << "VkDeviceQueueCreateInfo " << pqueue_create_infos_array << "[] = {" << pqueue_create_infos_names << "};" << std::endl;
    }
    std::string pp_enabled_layer_names_var = "NULL";
    if (structInfo->enabledLayerCount) {
    pp_enabled_layer_names_var = "ppEnabledLayerNames_" + std::to_string(consumer.GetNextId());
    out << "\t\t" << "const char* " << pp_enabled_layer_names_var << "[] = " << VulkanCppConsumerBase::EscapeStringArray(structInfo->ppEnabledLayerNames, structInfo->enabledLayerCount) << ";" << std::endl;
    }
    std::string pp_enabled_extension_names_var = "NULL";
    if (structInfo->enabledExtensionCount) {
    pp_enabled_extension_names_var = "ppEnabledExtensionNames_" + std::to_string(consumer.GetNextId());
    out << "\t\t" << "const char* " << pp_enabled_extension_names_var << "[] = " << VulkanCppConsumerBase::EscapeStringArray(structInfo->ppEnabledExtensionNames, structInfo->enabledExtensionCount) << ";" << std::endl;
    }
    std::string penabled_features_struct = "NULL";
    if (structInfo->pEnabledFeatures != NULL) {
        penabled_features_struct = GenerateStruct_VkPhysicalDeviceFeatures(out,
                                                                           structInfo->pEnabledFeatures,
                                                                           metaInfo->pEnabledFeatures->GetMetaStructPointer(),
                                                                           consumer);
        penabled_features_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDeviceCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->queueCreateInfoCount << "," << std::endl;
    struct_body << "\t\t\t" << pqueue_create_infos_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->enabledLayerCount << "," << std::endl;
    struct_body << "\t\t\t" << pp_enabled_layer_names_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->enabledExtensionCount << "," << std::endl;
    struct_body << "\t\t\t" << pp_enabled_extension_names_var << "," << std::endl;
    struct_body << "\t\t\t" << penabled_features_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceCreateInfo");
    out << "\t\t" << "VkDeviceCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceQueueCreateInfo(std::ostream &out, const VkDeviceQueueCreateInfo* structInfo, Decoded_VkDeviceQueueCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pqueue_priorities_array = "NULL";
    if (structInfo->pQueuePriorities != NULL) {
        pqueue_priorities_array = "pQueuePriorities_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "float " << pqueue_priorities_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pQueuePriorities, structInfo->queueCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDeviceQueueCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->queueFamilyIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->queueCount << "," << std::endl;
    struct_body << "\t\t\t" << pqueue_priorities_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceQueueCreateInfo");
    out << "\t\t" << "VkDeviceQueueCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDispatchIndirectCommand(std::ostream &out, const VkDispatchIndirectCommand* structInfo, Decoded_VkDispatchIndirectCommand* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->x << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->y << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->z << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "dispatchIndirectCommand");
    out << "\t\t" << "VkDispatchIndirectCommand " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDrawIndexedIndirectCommand(std::ostream &out, const VkDrawIndexedIndirectCommand* structInfo, Decoded_VkDrawIndexedIndirectCommand* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->indexCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->instanceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->firstIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vertexOffset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->firstInstance << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "drawIndexedIndirectCommand");
    out << "\t\t" << "VkDrawIndexedIndirectCommand " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDrawIndirectCommand(std::ostream &out, const VkDrawIndirectCommand* structInfo, Decoded_VkDrawIndirectCommand* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->vertexCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->instanceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->firstVertex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->firstInstance << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "drawIndirectCommand");
    out << "\t\t" << "VkDrawIndirectCommand " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkEventCreateInfo(std::ostream &out, const VkEventCreateInfo* structInfo, Decoded_VkEventCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkEventCreateFlags(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "eventCreateInfo");
    out << "\t\t" << "VkEventCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExtensionProperties(std::ostream &out, const VkExtensionProperties* structInfo, Decoded_VkExtensionProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << VulkanCppConsumerBase::ToEscape(structInfo->extensionName) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->specVersion << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "extensionProperties");
    out << "\t\t" << "VkExtensionProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExtent2D(std::ostream &out, const VkExtent2D* structInfo, Decoded_VkExtent2D* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->width << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->height << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "extent2D");
    out << "\t\t" << "VkExtent2D " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExtent3D(std::ostream &out, const VkExtent3D* structInfo, Decoded_VkExtent3D* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->width << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->height << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depth << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "extent3D");
    out << "\t\t" << "VkExtent3D " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkFenceCreateInfo(std::ostream &out, const VkFenceCreateInfo* structInfo, Decoded_VkFenceCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkFenceCreateFlags(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "fenceCreateInfo");
    out << "\t\t" << "VkFenceCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkFormatProperties(std::ostream &out, const VkFormatProperties* structInfo, Decoded_VkFormatProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "VkFormatFeatureFlags(" << structInfo->linearTilingFeatures << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormatFeatureFlags(" << structInfo->optimalTilingFeatures << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormatFeatureFlags(" << structInfo->bufferFeatures << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "formatProperties");
    out << "\t\t" << "VkFormatProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkFramebufferCreateInfo(std::ostream &out, const VkFramebufferCreateInfo* structInfo, Decoded_VkFramebufferCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pattachments_array = "NULL";
    if (metaInfo->pAttachments.GetPointer() != NULL && structInfo->attachmentCount > 0) {
        pattachments_array = "pattachments_array_" + std::to_string(consumer.GetNextId());
        std::string pattachments_values = toStringJoin(metaInfo->pAttachments.GetPointer(),
                                                       metaInfo->pAttachments.GetPointer() + structInfo->attachmentCount,
                                                       [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                       ", ");
        if (structInfo->attachmentCount == 1) {
            pattachments_array = "&" + pattachments_values;
        } else if (structInfo->attachmentCount > 1) {
            out << "\t\t" << "VkImageView " << pattachments_array << "[] = {" << pattachments_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkFramebufferCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->renderPass) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->attachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pattachments_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->width << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->height << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->layers << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "framebufferCreateInfo");
    out << "\t\t" << "VkFramebufferCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkGraphicsPipelineCreateInfo(std::ostream &out, const VkGraphicsPipelineCreateInfo* structInfo, Decoded_VkGraphicsPipelineCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pstages_array = "NULL";
    if (structInfo->pStages != NULL) {
        pstages_array = "pStages_" + std::to_string(consumer.GetNextId());
        std::string pstages_names;
        for (uint32_t idx = 0; idx < structInfo->stageCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pStages + idx != NULL) {
                variable_name = GenerateStruct_VkPipelineShaderStageCreateInfo(out,
                                                                               structInfo->pStages + idx,
                                                                               metaInfo->pStages->GetMetaStructPointer() + idx,
                                                                               consumer);
            }
            pstages_names += variable_name + ", ";
        }
        out << "\t\t" << "VkPipelineShaderStageCreateInfo " << pstages_array << "[] = {" << pstages_names << "};" << std::endl;
    }
    std::string pvertex_input_state_struct = "NULL";
    if (structInfo->pVertexInputState != NULL) {
        pvertex_input_state_struct = GenerateStruct_VkPipelineVertexInputStateCreateInfo(out,
                                                                                         structInfo->pVertexInputState,
                                                                                         metaInfo->pVertexInputState->GetMetaStructPointer(),
                                                                                         consumer);
        pvertex_input_state_struct.insert(0, "&");
    }
    std::string pinput_assembly_state_struct = "NULL";
    if (structInfo->pInputAssemblyState != NULL) {
        pinput_assembly_state_struct = GenerateStruct_VkPipelineInputAssemblyStateCreateInfo(out,
                                                                                             structInfo->pInputAssemblyState,
                                                                                             metaInfo->pInputAssemblyState->GetMetaStructPointer(),
                                                                                             consumer);
        pinput_assembly_state_struct.insert(0, "&");
    }
    std::string ptessellation_state_struct = "NULL";
    if (structInfo->pTessellationState != NULL) {
        ptessellation_state_struct = GenerateStruct_VkPipelineTessellationStateCreateInfo(out,
                                                                                          structInfo->pTessellationState,
                                                                                          metaInfo->pTessellationState->GetMetaStructPointer(),
                                                                                          consumer);
        ptessellation_state_struct.insert(0, "&");
    }
    std::string pviewport_state_struct = "NULL";
    if (structInfo->pViewportState != NULL) {
        pviewport_state_struct = GenerateStruct_VkPipelineViewportStateCreateInfo(out,
                                                                                  structInfo->pViewportState,
                                                                                  metaInfo->pViewportState->GetMetaStructPointer(),
                                                                                  consumer);
        pviewport_state_struct.insert(0, "&");
    }
    std::string prasterization_state_struct = "NULL";
    if (structInfo->pRasterizationState != NULL) {
        prasterization_state_struct = GenerateStruct_VkPipelineRasterizationStateCreateInfo(out,
                                                                                            structInfo->pRasterizationState,
                                                                                            metaInfo->pRasterizationState->GetMetaStructPointer(),
                                                                                            consumer);
        prasterization_state_struct.insert(0, "&");
    }
    std::string pmultisample_state_struct = "NULL";
    if (structInfo->pMultisampleState != NULL) {
        pmultisample_state_struct = GenerateStruct_VkPipelineMultisampleStateCreateInfo(out,
                                                                                        structInfo->pMultisampleState,
                                                                                        metaInfo->pMultisampleState->GetMetaStructPointer(),
                                                                                        consumer);
        pmultisample_state_struct.insert(0, "&");
    }
    std::string pdepth_stencil_state_struct = "NULL";
    if (structInfo->pDepthStencilState != NULL) {
        pdepth_stencil_state_struct = GenerateStruct_VkPipelineDepthStencilStateCreateInfo(out,
                                                                                           structInfo->pDepthStencilState,
                                                                                           metaInfo->pDepthStencilState->GetMetaStructPointer(),
                                                                                           consumer);
        pdepth_stencil_state_struct.insert(0, "&");
    }
    std::string pcolor_blend_state_struct = "NULL";
    if (structInfo->pColorBlendState != NULL) {
        pcolor_blend_state_struct = GenerateStruct_VkPipelineColorBlendStateCreateInfo(out,
                                                                                       structInfo->pColorBlendState,
                                                                                       metaInfo->pColorBlendState->GetMetaStructPointer(),
                                                                                       consumer);
        pcolor_blend_state_struct.insert(0, "&");
    }
    std::string pdynamic_state_struct = "NULL";
    if (structInfo->pDynamicState != NULL) {
        pdynamic_state_struct = GenerateStruct_VkPipelineDynamicStateCreateInfo(out,
                                                                                structInfo->pDynamicState,
                                                                                metaInfo->pDynamicState->GetMetaStructPointer(),
                                                                                consumer);
        pdynamic_state_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stageCount << "," << std::endl;
    struct_body << "\t\t\t" << pstages_array << "," << std::endl;
    struct_body << "\t\t\t" << pvertex_input_state_struct << "," << std::endl;
    struct_body << "\t\t\t" << pinput_assembly_state_struct << "," << std::endl;
    struct_body << "\t\t\t" << ptessellation_state_struct << "," << std::endl;
    struct_body << "\t\t\t" << pviewport_state_struct << "," << std::endl;
    struct_body << "\t\t\t" << prasterization_state_struct << "," << std::endl;
    struct_body << "\t\t\t" << pmultisample_state_struct << "," << std::endl;
    struct_body << "\t\t\t" << pdepth_stencil_state_struct << "," << std::endl;
    struct_body << "\t\t\t" << pcolor_blend_state_struct << "," << std::endl;
    struct_body << "\t\t\t" << pdynamic_state_struct << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->layout) << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->renderPass) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subpass << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->basePipelineHandle) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->basePipelineIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "graphicsPipelineCreateInfo");
    out << "\t\t" << "VkGraphicsPipelineCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageBlit(std::ostream &out, const VkImageBlit* structInfo, Decoded_VkImageBlit* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string src_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                   &structInfo->srcSubresource,
                                                                                   metaInfo->srcSubresource,
                                                                                   consumer);
    std::string dst_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                   &structInfo->dstSubresource,
                                                                                   metaInfo->dstSubresource,
                                                                                   consumer);
    struct_body << "\t" << src_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const VkOffset3D*>(&structInfo->srcOffsets[0]), 2) << "," << std::endl;
    struct_body << "\t\t\t" << dst_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const VkOffset3D*>(&structInfo->dstOffsets[0]), 2) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageBlit");
    out << "\t\t" << "VkImageBlit " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageCopy(std::ostream &out, const VkImageCopy* structInfo, Decoded_VkImageCopy* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string src_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                   &structInfo->srcSubresource,
                                                                                   metaInfo->srcSubresource,
                                                                                   consumer);
    std::string src_offset_info_var = GenerateStruct_VkOffset3D(out,
                                                                &structInfo->srcOffset,
                                                                metaInfo->srcOffset,
                                                                consumer);
    std::string dst_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                   &structInfo->dstSubresource,
                                                                                   metaInfo->dstSubresource,
                                                                                   consumer);
    std::string dst_offset_info_var = GenerateStruct_VkOffset3D(out,
                                                                &structInfo->dstOffset,
                                                                metaInfo->dstOffset,
                                                                consumer);
    std::string extent_info_var = GenerateStruct_VkExtent3D(out,
                                                            &structInfo->extent,
                                                            metaInfo->extent,
                                                            consumer);
    struct_body << "\t" << src_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << src_offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << dst_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << dst_offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << extent_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageCopy");
    out << "\t\t" << "VkImageCopy " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageCreateInfo(std::ostream &out, const VkImageCreateInfo* structInfo, Decoded_VkImageCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string extent_info_var = GenerateStruct_VkExtent3D(out,
                                                            &structInfo->extent,
                                                            metaInfo->extent,
                                                            consumer);
    std::string pqueue_family_indices_array = "NULL";
    if (structInfo->pQueueFamilyIndices != NULL) {
        pqueue_family_indices_array = "pQueueFamilyIndices_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pqueue_family_indices_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pQueueFamilyIndices, structInfo->queueFamilyIndexCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageType(" << structInfo->imageType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->format << ")" << "," << std::endl;
    struct_body << "\t\t\t" << extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->mipLevels << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->arrayLayers << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlagBits(" << structInfo->samples << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageTiling(" << structInfo->tiling << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageUsageFlags(" << structInfo->usage << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSharingMode(" << structInfo->sharingMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->queueFamilyIndexCount << "," << std::endl;
    struct_body << "\t\t\t" << pqueue_family_indices_array << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->initialLayout << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageCreateInfo");
    out << "\t\t" << "VkImageCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageFormatProperties(std::ostream &out, const VkImageFormatProperties* structInfo, Decoded_VkImageFormatProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string max_extent_info_var = GenerateStruct_VkExtent3D(out,
                                                                &structInfo->maxExtent,
                                                                metaInfo->maxExtent,
                                                                consumer);
    struct_body << "\t" << max_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxMipLevels << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxArrayLayers << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlags(" << structInfo->sampleCounts << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxResourceSize << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageFormatProperties");
    out << "\t\t" << "VkImageFormatProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageMemoryBarrier(std::ostream &out, const VkImageMemoryBarrier* structInfo, Decoded_VkImageMemoryBarrier* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string subresource_range_info_var = GenerateStruct_VkImageSubresourceRange(out,
                                                                                    &structInfo->subresourceRange,
                                                                                    metaInfo->subresourceRange,
                                                                                    consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags(" << structInfo->srcAccessMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags(" << structInfo->dstAccessMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->oldLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->newLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->srcQueueFamilyIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dstQueueFamilyIndex << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->image) << "," << std::endl;
    struct_body << "\t\t\t" << subresource_range_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageMemoryBarrier");
    out << "\t\t" << "VkImageMemoryBarrier " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageResolve(std::ostream &out, const VkImageResolve* structInfo, Decoded_VkImageResolve* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string src_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                   &structInfo->srcSubresource,
                                                                                   metaInfo->srcSubresource,
                                                                                   consumer);
    std::string src_offset_info_var = GenerateStruct_VkOffset3D(out,
                                                                &structInfo->srcOffset,
                                                                metaInfo->srcOffset,
                                                                consumer);
    std::string dst_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                   &structInfo->dstSubresource,
                                                                                   metaInfo->dstSubresource,
                                                                                   consumer);
    std::string dst_offset_info_var = GenerateStruct_VkOffset3D(out,
                                                                &structInfo->dstOffset,
                                                                metaInfo->dstOffset,
                                                                consumer);
    std::string extent_info_var = GenerateStruct_VkExtent3D(out,
                                                            &structInfo->extent,
                                                            metaInfo->extent,
                                                            consumer);
    struct_body << "\t" << src_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << src_offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << dst_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << dst_offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << extent_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageResolve");
    out << "\t\t" << "VkImageResolve " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageSubresource(std::ostream &out, const VkImageSubresource* structInfo, Decoded_VkImageSubresource* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "VkImageAspectFlags(" << structInfo->aspectMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->mipLevel << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->arrayLayer << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageSubresource");
    out << "\t\t" << "VkImageSubresource " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageSubresourceLayers(std::ostream &out, const VkImageSubresourceLayers* structInfo, Decoded_VkImageSubresourceLayers* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "VkImageAspectFlags(" << structInfo->aspectMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->mipLevel << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->baseArrayLayer << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->layerCount << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageSubresourceLayers");
    out << "\t\t" << "VkImageSubresourceLayers " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageSubresourceRange(std::ostream &out, const VkImageSubresourceRange* structInfo, Decoded_VkImageSubresourceRange* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "VkImageAspectFlags(" << structInfo->aspectMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->baseMipLevel << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->levelCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->baseArrayLayer << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->layerCount << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageSubresourceRange");
    out << "\t\t" << "VkImageSubresourceRange " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageViewCreateInfo(std::ostream &out, const VkImageViewCreateInfo* structInfo, Decoded_VkImageViewCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string components_info_var = GenerateStruct_VkComponentMapping(out,
                                                                        &structInfo->components,
                                                                        metaInfo->components,
                                                                        consumer);
    std::string subresource_range_info_var = GenerateStruct_VkImageSubresourceRange(out,
                                                                                    &structInfo->subresourceRange,
                                                                                    metaInfo->subresourceRange,
                                                                                    consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageViewCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->image) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageViewType(" << structInfo->viewType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->format << ")" << "," << std::endl;
    struct_body << "\t\t\t" << components_info_var << "," << std::endl;
    struct_body << "\t\t\t" << subresource_range_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageViewCreateInfo");
    out << "\t\t" << "VkImageViewCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkLayerProperties(std::ostream &out, const VkLayerProperties* structInfo, Decoded_VkLayerProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << VulkanCppConsumerBase::ToEscape(structInfo->layerName) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->specVersion << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->implementationVersion << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->description) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "layerProperties");
    out << "\t\t" << "VkLayerProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMappedMemoryRange(std::ostream &out, const VkMappedMemoryRange* structInfo, Decoded_VkMappedMemoryRange* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->memory) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->offset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "mappedMemoryRange");
    out << "\t\t" << "VkMappedMemoryRange " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryBarrier(std::ostream &out, const VkMemoryBarrier* structInfo, Decoded_VkMemoryBarrier* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags(" << structInfo->srcAccessMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags(" << structInfo->dstAccessMask << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryBarrier");
    out << "\t\t" << "VkMemoryBarrier " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryHeap(std::ostream &out, const VkMemoryHeap* structInfo, Decoded_VkMemoryHeap* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->size << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << "VkMemoryHeapFlags(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryHeap");
    out << "\t\t" << "VkMemoryHeap " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryRequirements(std::ostream &out, const VkMemoryRequirements* structInfo, Decoded_VkMemoryRequirements* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->size << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->alignment << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->memoryTypeBits << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryRequirements");
    out << "\t\t" << "VkMemoryRequirements " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryType(std::ostream &out, const VkMemoryType* structInfo, Decoded_VkMemoryType* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "VkMemoryPropertyFlags(" << structInfo->propertyFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->heapIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryType");
    out << "\t\t" << "VkMemoryType " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkOffset2D(std::ostream &out, const VkOffset2D* structInfo, Decoded_VkOffset2D* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->x << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->y << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "offset2D");
    out << "\t\t" << "VkOffset2D " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkOffset3D(std::ostream &out, const VkOffset3D* structInfo, Decoded_VkOffset3D* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->x << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->y << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->z << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "offset3D");
    out << "\t\t" << "VkOffset3D " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceFeatures(std::ostream &out, const VkPhysicalDeviceFeatures* structInfo, Decoded_VkPhysicalDeviceFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->robustBufferAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fullDrawIndexUint32 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->imageCubeArray << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->independentBlend << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->geometryShader << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->tessellationShader << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sampleRateShading << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dualSrcBlend << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->logicOp << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->multiDrawIndirect << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->drawIndirectFirstInstance << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthClamp << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthBiasClamp << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fillModeNonSolid << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthBounds << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->wideLines << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->largePoints << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->alphaToOne << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->multiViewport << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->samplerAnisotropy << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->textureCompressionETC2 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->textureCompressionASTC_LDR << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->textureCompressionBC << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->occlusionQueryPrecise << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineStatisticsQuery << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vertexPipelineStoresAndAtomics << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fragmentStoresAndAtomics << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderTessellationAndGeometryPointSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderImageGatherExtended << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageImageExtendedFormats << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageImageMultisample << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageImageReadWithoutFormat << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageImageWriteWithoutFormat << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderUniformBufferArrayDynamicIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSampledImageArrayDynamicIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageBufferArrayDynamicIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageImageArrayDynamicIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderClipDistance << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderCullDistance << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderFloat64 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderInt64 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderInt16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderResourceResidency << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderResourceMinLod << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sparseBinding << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sparseResidencyBuffer << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sparseResidencyImage2D << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sparseResidencyImage3D << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sparseResidency2Samples << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sparseResidency4Samples << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sparseResidency8Samples << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sparseResidency16Samples << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sparseResidencyAliased << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->variableMultisampleRate << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->inheritedQueries << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceFeatures");
    out << "\t\t" << "VkPhysicalDeviceFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceLimits(std::ostream &out, const VkPhysicalDeviceLimits* structInfo, Decoded_VkPhysicalDeviceLimits* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->maxImageDimension1D << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxImageDimension2D << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxImageDimension3D << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxImageDimensionCube << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxImageArrayLayers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTexelBufferElements << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxUniformBufferRange << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxStorageBufferRange << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPushConstantsSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxMemoryAllocationCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxSamplerAllocationCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferImageGranularity << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sparseAddressSpaceSize << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxBoundDescriptorSets << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorSamplers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUniformBuffers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorStorageBuffers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorSampledImages << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorStorageImages << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorInputAttachments << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageResources << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetSamplers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUniformBuffers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUniformBuffersDynamic << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetStorageBuffers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetStorageBuffersDynamic << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetSampledImages << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetStorageImages << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetInputAttachments << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxVertexInputAttributes << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxVertexInputBindings << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxVertexInputAttributeOffset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxVertexInputBindingStride << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxVertexOutputComponents << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTessellationGenerationLevel << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTessellationPatchSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTessellationControlPerVertexInputComponents << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTessellationControlPerVertexOutputComponents << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTessellationControlPerPatchOutputComponents << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTessellationControlTotalOutputComponents << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTessellationEvaluationInputComponents << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTessellationEvaluationOutputComponents << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxGeometryShaderInvocations << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxGeometryInputComponents << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxGeometryOutputComponents << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxGeometryOutputVertices << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxGeometryTotalOutputComponents << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxFragmentInputComponents << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxFragmentOutputAttachments << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxFragmentDualSrcAttachments << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxFragmentCombinedOutputResources << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxComputeSharedMemorySize << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint32_t*>(&structInfo->maxComputeWorkGroupCount[0]), 3) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxComputeWorkGroupInvocations << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint32_t*>(&structInfo->maxComputeWorkGroupSize[0]), 3) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subPixelPrecisionBits << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subTexelPrecisionBits << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->mipmapPrecisionBits << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDrawIndexedIndexValue << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDrawIndirectCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxSamplerLodBias << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxSamplerAnisotropy << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxViewports << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint32_t*>(&structInfo->maxViewportDimensions[0]), 2) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const float*>(&structInfo->viewportBoundsRange[0]), 2) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->viewportSubPixelBits << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minMemoryMapAlignment << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minTexelBufferOffsetAlignment << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minUniformBufferOffsetAlignment << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minStorageBufferOffsetAlignment << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minTexelOffset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTexelOffset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minTexelGatherOffset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTexelGatherOffset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minInterpolationOffset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxInterpolationOffset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subPixelInterpolationOffsetBits << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxFramebufferWidth << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxFramebufferHeight << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxFramebufferLayers << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlags(" << structInfo->framebufferColorSampleCounts << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlags(" << structInfo->framebufferDepthSampleCounts << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlags(" << structInfo->framebufferStencilSampleCounts << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlags(" << structInfo->framebufferNoAttachmentsSampleCounts << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxColorAttachments << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlags(" << structInfo->sampledImageColorSampleCounts << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlags(" << structInfo->sampledImageIntegerSampleCounts << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlags(" << structInfo->sampledImageDepthSampleCounts << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlags(" << structInfo->sampledImageStencilSampleCounts << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlags(" << structInfo->storageImageSampleCounts << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxSampleMaskWords << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->timestampComputeAndGraphics << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->timestampPeriod << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxClipDistances << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxCullDistances << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxCombinedClipAndCullDistances << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->discreteQueuePriorities << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const float*>(&structInfo->pointSizeRange[0]), 2) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const float*>(&structInfo->lineWidthRange[0]), 2) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pointSizeGranularity << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->lineWidthGranularity << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->strictLines << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->standardSampleLocations << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->optimalBufferCopyOffsetAlignment << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->optimalBufferCopyRowPitchAlignment << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->nonCoherentAtomSize << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceLimits");
    out << "\t\t" << "VkPhysicalDeviceLimits " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMemoryProperties(std::ostream &out, const VkPhysicalDeviceMemoryProperties* structInfo, Decoded_VkPhysicalDeviceMemoryProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->memoryTypeCount << "," << std::endl;
	struct_body << "\t\t\t{}," << std::endl;
    struct_body << "\t\t\t" << structInfo->memoryHeapCount << "," << std::endl;
	struct_body << "\t\t\t{}," << std::endl;
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMemoryProperties");
    out << "\t\t" << "VkPhysicalDeviceMemoryProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceProperties(std::ostream &out, const VkPhysicalDeviceProperties* structInfo, Decoded_VkPhysicalDeviceProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string limits_info_var = GenerateStruct_VkPhysicalDeviceLimits(out,
                                                                        &structInfo->limits,
                                                                        metaInfo->limits,
                                                                        consumer);
    std::string sparse_properties_info_var = GenerateStruct_VkPhysicalDeviceSparseProperties(out,
                                                                                             &structInfo->sparseProperties,
                                                                                             metaInfo->sparseProperties,
                                                                                             consumer);
    struct_body << "\t" << structInfo->apiVersion << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->driverVersion << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vendorID << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceID << "," << std::endl;
    struct_body << "\t\t\t" << "VkPhysicalDeviceType(" << structInfo->deviceType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->deviceName) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->pipelineCacheUUID[0]), VK_UUID_SIZE) << "," << std::endl;
    struct_body << "\t\t\t" << limits_info_var << "," << std::endl;
    struct_body << "\t\t\t" << sparse_properties_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceProperties");
    out << "\t\t" << "VkPhysicalDeviceProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceSparseProperties(std::ostream &out, const VkPhysicalDeviceSparseProperties* structInfo, Decoded_VkPhysicalDeviceSparseProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->residencyStandard2DBlockShape << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->residencyStandard2DMultisampleBlockShape << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->residencyStandard3DBlockShape << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->residencyAlignedMipSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->residencyNonResidentStrict << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceSparseProperties");
    out << "\t\t" << "VkPhysicalDeviceSparseProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineCacheCreateInfo(std::ostream &out, const VkPipelineCacheCreateInfo* structInfo, Decoded_VkPipelineCacheCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pinitial_data_array = "NULL";
    if (structInfo->pInitialData != NULL) {
        std::string pinitial_data_values;
        for (uint32_t idx0 = 0; idx0 < structInfo->initialDataSize; ++idx0) {
            pinitial_data_values += std::to_string(reinterpret_cast<const uint8_t*>(structInfo->pInitialData)[idx0]) + ", ";
        }
        pinitial_data_array = "pInitialData_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint8_t " << pinitial_data_array << "[] = {" << pinitial_data_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineCacheCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->initialDataSize << "," << std::endl;
    struct_body << "\t\t\t" << pinitial_data_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineCacheCreateInfo");
    out << "\t\t" << "VkPipelineCacheCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineCacheHeaderVersionOne(std::ostream &out, const VkPipelineCacheHeaderVersionOne* structInfo, Decoded_VkPipelineCacheHeaderVersionOne* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->headerSize << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineCacheHeaderVersion(" << structInfo->headerVersion << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vendorID << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceID << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->pipelineCacheUUID[0]), VK_UUID_SIZE) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineCacheHeaderVersionOne");
    out << "\t\t" << "VkPipelineCacheHeaderVersionOne " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineColorBlendAttachmentState(std::ostream &out, const VkPipelineColorBlendAttachmentState* structInfo, Decoded_VkPipelineColorBlendAttachmentState* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->blendEnable << "," << std::endl;
    struct_body << "\t\t\t" << "VkBlendFactor(" << structInfo->srcColorBlendFactor << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkBlendFactor(" << structInfo->dstColorBlendFactor << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkBlendOp(" << structInfo->colorBlendOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkBlendFactor(" << structInfo->srcAlphaBlendFactor << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkBlendFactor(" << structInfo->dstAlphaBlendFactor << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkBlendOp(" << structInfo->alphaBlendOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkColorComponentFlags(" << structInfo->colorWriteMask << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineColorBlendAttachmentState");
    out << "\t\t" << "VkPipelineColorBlendAttachmentState " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineColorBlendStateCreateInfo(std::ostream &out, const VkPipelineColorBlendStateCreateInfo* structInfo, Decoded_VkPipelineColorBlendStateCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pattachments_array = "NULL";
    if (structInfo->pAttachments != NULL) {
        pattachments_array = "pAttachments_" + std::to_string(consumer.GetNextId());
        std::string pattachments_names;
        for (uint32_t idx = 0; idx < structInfo->attachmentCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pAttachments + idx != NULL) {
                variable_name = GenerateStruct_VkPipelineColorBlendAttachmentState(out,
                                                                                   structInfo->pAttachments + idx,
                                                                                   metaInfo->pAttachments->GetMetaStructPointer() + idx,
                                                                                   consumer);
            }
            pattachments_names += variable_name + ", ";
        }
        out << "\t\t" << "VkPipelineColorBlendAttachmentState " << pattachments_array << "[] = {" << pattachments_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineColorBlendStateCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->logicOpEnable << "," << std::endl;
    struct_body << "\t\t\t" << "VkLogicOp(" << structInfo->logicOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->attachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pattachments_array << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const float*>(&structInfo->blendConstants[0]), 4) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineColorBlendStateCreateInfo");
    out << "\t\t" << "VkPipelineColorBlendStateCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineDepthStencilStateCreateInfo(std::ostream &out, const VkPipelineDepthStencilStateCreateInfo* structInfo, Decoded_VkPipelineDepthStencilStateCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string front_info_var = GenerateStruct_VkStencilOpState(out,
                                                                 &structInfo->front,
                                                                 metaInfo->front,
                                                                 consumer);
    std::string back_info_var = GenerateStruct_VkStencilOpState(out,
                                                                &structInfo->back,
                                                                metaInfo->back,
                                                                consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineDepthStencilStateCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthTestEnable << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthWriteEnable << "," << std::endl;
    struct_body << "\t\t\t" << "VkCompareOp(" << structInfo->depthCompareOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthBoundsTestEnable << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stencilTestEnable << "," << std::endl;
    struct_body << "\t\t\t" << front_info_var << "," << std::endl;
    struct_body << "\t\t\t" << back_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minDepthBounds << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDepthBounds << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineDepthStencilStateCreateInfo");
    out << "\t\t" << "VkPipelineDepthStencilStateCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineDynamicStateCreateInfo(std::ostream &out, const VkPipelineDynamicStateCreateInfo* structInfo, Decoded_VkPipelineDynamicStateCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pdynamic_states_values;
    std::string pdynamic_states_array = "NULL";
    if (structInfo->pDynamicStates != NULL) {
        for (uint32_t idx = 0; idx < structInfo->dynamicStateCount; idx++) {
            pdynamic_states_values += util::ToString<VkDynamicState>(structInfo->pDynamicStates[idx]) + ", ";
        }
        pdynamic_states_array = "pDynamicStates_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkDynamicState " << pdynamic_states_array << "[] = {" << pdynamic_states_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineDynamicStateCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dynamicStateCount << "," << std::endl;
    struct_body << "\t\t\t" << pdynamic_states_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineDynamicStateCreateInfo");
    out << "\t\t" << "VkPipelineDynamicStateCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineInputAssemblyStateCreateInfo(std::ostream &out, const VkPipelineInputAssemblyStateCreateInfo* structInfo, Decoded_VkPipelineInputAssemblyStateCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineInputAssemblyStateCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPrimitiveTopology(" << structInfo->topology << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->primitiveRestartEnable << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineInputAssemblyStateCreateInfo");
    out << "\t\t" << "VkPipelineInputAssemblyStateCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineLayoutCreateInfo(std::ostream &out, const VkPipelineLayoutCreateInfo* structInfo, Decoded_VkPipelineLayoutCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pset_layouts_array = "NULL";
    if (metaInfo->pSetLayouts.GetPointer() != NULL && structInfo->setLayoutCount > 0) {
        pset_layouts_array = "pset_layouts_array_" + std::to_string(consumer.GetNextId(VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT));
        std::string pset_layouts_values = toStringJoin(metaInfo->pSetLayouts.GetPointer(),
                                                       metaInfo->pSetLayouts.GetPointer() + structInfo->setLayoutCount,
                                                       [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                       ", ");
        if (structInfo->setLayoutCount == 1) {
            pset_layouts_array = "&" + pset_layouts_values;
        } else if (structInfo->setLayoutCount > 1) {
            out << "\t\t" << "VkDescriptorSetLayout " << pset_layouts_array << "[] = {" << pset_layouts_values << "};" << std::endl;
        }
    }
    std::string ppush_constant_ranges_array = "NULL";
    if (structInfo->pPushConstantRanges != NULL) {
        ppush_constant_ranges_array = "pPushConstantRanges_" + std::to_string(consumer.GetNextId());
        std::string ppush_constant_ranges_names;
        for (uint32_t idx = 0; idx < structInfo->pushConstantRangeCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pPushConstantRanges + idx != NULL) {
                variable_name = GenerateStruct_VkPushConstantRange(out,
                                                                   structInfo->pPushConstantRanges + idx,
                                                                   metaInfo->pPushConstantRanges->GetMetaStructPointer() + idx,
                                                                   consumer);
            }
            ppush_constant_ranges_names += variable_name + ", ";
        }
        out << "\t\t" << "VkPushConstantRange " << ppush_constant_ranges_array << "[] = {" << ppush_constant_ranges_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineLayoutCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->setLayoutCount << "," << std::endl;
    struct_body << "\t\t\t" << pset_layouts_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pushConstantRangeCount << "," << std::endl;
    struct_body << "\t\t\t" << ppush_constant_ranges_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineLayoutCreateInfo");
    out << "\t\t" << "VkPipelineLayoutCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineMultisampleStateCreateInfo(std::ostream &out, const VkPipelineMultisampleStateCreateInfo* structInfo, Decoded_VkPipelineMultisampleStateCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string psample_mask_array = "NULL";
    if (structInfo->pSampleMask != NULL) {
        std::string psample_mask_values;
        for (uint32_t idx0 = 0; idx0 < (structInfo->rasterizationSamples + 31) / 32; ++idx0) {
            psample_mask_values += std::to_string(structInfo->pSampleMask[idx0]) + ", ";
        }
        psample_mask_array = "pSampleMask_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkSampleMask " << psample_mask_array << "[] = {" << psample_mask_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineMultisampleStateCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlagBits(" << structInfo->rasterizationSamples << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sampleShadingEnable << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minSampleShading << "," << std::endl;
    struct_body << "\t\t\t" << psample_mask_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->alphaToCoverageEnable << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->alphaToOneEnable << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineMultisampleStateCreateInfo");
    out << "\t\t" << "VkPipelineMultisampleStateCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineRasterizationStateCreateInfo(std::ostream &out, const VkPipelineRasterizationStateCreateInfo* structInfo, Decoded_VkPipelineRasterizationStateCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineRasterizationStateCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthClampEnable << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->rasterizerDiscardEnable << "," << std::endl;
    struct_body << "\t\t\t" << "VkPolygonMode(" << structInfo->polygonMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkCullModeFlags(" << structInfo->cullMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFrontFace(" << structInfo->frontFace << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthBiasEnable << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthBiasConstantFactor << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthBiasClamp << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthBiasSlopeFactor << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->lineWidth << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineRasterizationStateCreateInfo");
    out << "\t\t" << "VkPipelineRasterizationStateCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineShaderStageCreateInfo(std::ostream &out, const VkPipelineShaderStageCreateInfo* structInfo, Decoded_VkPipelineShaderStageCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pspecialization_info_struct = "NULL";
    if (structInfo->pSpecializationInfo != NULL) {
        pspecialization_info_struct = GenerateStruct_VkSpecializationInfo(out,
                                                                          structInfo->pSpecializationInfo,
                                                                          metaInfo->pSpecializationInfo->GetMetaStructPointer(),
                                                                          consumer);
        pspecialization_info_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineShaderStageCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderStageFlagBits(" << structInfo->stage << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->module) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->pName) << "," << std::endl;
    struct_body << "\t\t\t" << pspecialization_info_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineShaderStageCreateInfo");
    out << "\t\t" << "VkPipelineShaderStageCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineTessellationStateCreateInfo(std::ostream &out, const VkPipelineTessellationStateCreateInfo* structInfo, Decoded_VkPipelineTessellationStateCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineTessellationStateCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->patchControlPoints << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineTessellationStateCreateInfo");
    out << "\t\t" << "VkPipelineTessellationStateCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineVertexInputStateCreateInfo(std::ostream &out, const VkPipelineVertexInputStateCreateInfo* structInfo, Decoded_VkPipelineVertexInputStateCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pvertex_binding_descriptions_array = "NULL";
    if (structInfo->pVertexBindingDescriptions != NULL) {
        pvertex_binding_descriptions_array = "pVertexBindingDescriptions_" + std::to_string(consumer.GetNextId());
        std::string pvertex_binding_descriptions_names;
        for (uint32_t idx = 0; idx < structInfo->vertexBindingDescriptionCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pVertexBindingDescriptions + idx != NULL) {
                variable_name = GenerateStruct_VkVertexInputBindingDescription(out,
                                                                               structInfo->pVertexBindingDescriptions + idx,
                                                                               metaInfo->pVertexBindingDescriptions->GetMetaStructPointer() + idx,
                                                                               consumer);
            }
            pvertex_binding_descriptions_names += variable_name + ", ";
        }
        out << "\t\t" << "VkVertexInputBindingDescription " << pvertex_binding_descriptions_array << "[] = {" << pvertex_binding_descriptions_names << "};" << std::endl;
    }
    std::string pvertex_attribute_descriptions_array = "NULL";
    if (structInfo->pVertexAttributeDescriptions != NULL) {
        pvertex_attribute_descriptions_array = "pVertexAttributeDescriptions_" + std::to_string(consumer.GetNextId());
        std::string pvertex_attribute_descriptions_names;
        for (uint32_t idx = 0; idx < structInfo->vertexAttributeDescriptionCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pVertexAttributeDescriptions + idx != NULL) {
                variable_name = GenerateStruct_VkVertexInputAttributeDescription(out,
                                                                                 structInfo->pVertexAttributeDescriptions + idx,
                                                                                 metaInfo->pVertexAttributeDescriptions->GetMetaStructPointer() + idx,
                                                                                 consumer);
            }
            pvertex_attribute_descriptions_names += variable_name + ", ";
        }
        out << "\t\t" << "VkVertexInputAttributeDescription " << pvertex_attribute_descriptions_array << "[] = {" << pvertex_attribute_descriptions_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineVertexInputStateCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vertexBindingDescriptionCount << "," << std::endl;
    struct_body << "\t\t\t" << pvertex_binding_descriptions_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vertexAttributeDescriptionCount << "," << std::endl;
    struct_body << "\t\t\t" << pvertex_attribute_descriptions_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineVertexInputStateCreateInfo");
    out << "\t\t" << "VkPipelineVertexInputStateCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineViewportStateCreateInfo(std::ostream &out, const VkPipelineViewportStateCreateInfo* structInfo, Decoded_VkPipelineViewportStateCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pviewports_array = "NULL";
    if (structInfo->pViewports != NULL) {
        pviewports_array = "pViewports_" + std::to_string(consumer.GetNextId());
        std::string pviewports_names;
        for (uint32_t idx = 0; idx < structInfo->viewportCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pViewports + idx != NULL) {
                variable_name = GenerateStruct_VkViewport(out,
                                                          structInfo->pViewports + idx,
                                                          metaInfo->pViewports->GetMetaStructPointer() + idx,
                                                          consumer);
            }
            pviewports_names += variable_name + ", ";
        }
        out << "\t\t" << "VkViewport " << pviewports_array << "[] = {" << pviewports_names << "};" << std::endl;
    }
    std::string pscissors_array = "NULL";
    if (structInfo->pScissors != NULL) {
        pscissors_array = "pScissors_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkRect2D " << pscissors_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pScissors, structInfo->scissorCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineViewportStateCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->viewportCount << "," << std::endl;
    struct_body << "\t\t\t" << pviewports_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->scissorCount << "," << std::endl;
    struct_body << "\t\t\t" << pscissors_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineViewportStateCreateInfo");
    out << "\t\t" << "VkPipelineViewportStateCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPushConstantRange(std::ostream &out, const VkPushConstantRange* structInfo, Decoded_VkPushConstantRange* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "VkShaderStageFlags(" << structInfo->stageFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->offset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pushConstantRange");
    out << "\t\t" << "VkPushConstantRange " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkQueryPoolCreateInfo(std::ostream &out, const VkQueryPoolCreateInfo* structInfo, Decoded_VkQueryPoolCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkQueryPoolCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkQueryType(" << structInfo->queryType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->queryCount << "," << std::endl;
    struct_body << "\t\t\t" << "VkQueryPipelineStatisticFlags(" << structInfo->pipelineStatistics << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "queryPoolCreateInfo");
    out << "\t\t" << "VkQueryPoolCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkQueueFamilyProperties(std::ostream &out, const VkQueueFamilyProperties* structInfo, Decoded_VkQueueFamilyProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string min_image_transfer_granularity_info_var = GenerateStruct_VkExtent3D(out,
                                                                                    &structInfo->minImageTransferGranularity,
                                                                                    metaInfo->minImageTransferGranularity,
                                                                                    consumer);
    struct_body << "\t" << "VkQueueFlags(" << structInfo->queueFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->queueCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->timestampValidBits << "," << std::endl;
    struct_body << "\t\t\t" << min_image_transfer_granularity_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "queueFamilyProperties");
    out << "\t\t" << "VkQueueFamilyProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRect2D(std::ostream &out, const VkRect2D* structInfo, Decoded_VkRect2D* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string offset_info_var = GenerateStruct_VkOffset2D(out,
                                                            &structInfo->offset,
                                                            metaInfo->offset,
                                                            consumer);
    std::string extent_info_var = GenerateStruct_VkExtent2D(out,
                                                            &structInfo->extent,
                                                            metaInfo->extent,
                                                            consumer);
    struct_body << "\t" << offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << extent_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "rect2D");
    out << "\t\t" << "VkRect2D " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRenderPassBeginInfo(std::ostream &out, const VkRenderPassBeginInfo* structInfo, Decoded_VkRenderPassBeginInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string render_area_info_var = GenerateStruct_VkRect2D(out,
                                                               &structInfo->renderArea,
                                                               metaInfo->renderArea,
                                                               consumer);
    std::string pclear_values_array = "NULL";
    if (structInfo->pClearValues != NULL) {
        pclear_values_array = "pClearValues_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkClearValue " << pclear_values_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pClearValues, structInfo->clearValueCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->renderPass) << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->framebuffer) << "," << std::endl;
    struct_body << "\t\t\t" << render_area_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->clearValueCount << "," << std::endl;
    struct_body << "\t\t\t" << pclear_values_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "renderPassBeginInfo");
    out << "\t\t" << "VkRenderPassBeginInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRenderPassCreateInfo(std::ostream &out, const VkRenderPassCreateInfo* structInfo, Decoded_VkRenderPassCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pattachments_array = "NULL";
    if (structInfo->pAttachments != NULL) {
        pattachments_array = "pAttachments_" + std::to_string(consumer.GetNextId());
        std::string pattachments_names;
        for (uint32_t idx = 0; idx < structInfo->attachmentCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pAttachments + idx != NULL) {
                variable_name = GenerateStruct_VkAttachmentDescription(out,
                                                                       structInfo->pAttachments + idx,
                                                                       metaInfo->pAttachments->GetMetaStructPointer() + idx,
                                                                       consumer);
            }
            pattachments_names += variable_name + ", ";
        }
        out << "\t\t" << "VkAttachmentDescription " << pattachments_array << "[] = {" << pattachments_names << "};" << std::endl;
    }
    std::string psubpasses_array = "NULL";
    if (structInfo->pSubpasses != NULL) {
        psubpasses_array = "pSubpasses_" + std::to_string(consumer.GetNextId());
        std::string psubpasses_names;
        for (uint32_t idx = 0; idx < structInfo->subpassCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pSubpasses + idx != NULL) {
                variable_name = GenerateStruct_VkSubpassDescription(out,
                                                                    structInfo->pSubpasses + idx,
                                                                    metaInfo->pSubpasses->GetMetaStructPointer() + idx,
                                                                    consumer);
            }
            psubpasses_names += variable_name + ", ";
        }
        out << "\t\t" << "VkSubpassDescription " << psubpasses_array << "[] = {" << psubpasses_names << "};" << std::endl;
    }
    std::string pdependencies_array = "NULL";
    if (structInfo->pDependencies != NULL) {
        pdependencies_array = "pDependencies_" + std::to_string(consumer.GetNextId());
        std::string pdependencies_names;
        for (uint32_t idx = 0; idx < structInfo->dependencyCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pDependencies + idx != NULL) {
                variable_name = GenerateStruct_VkSubpassDependency(out,
                                                                   structInfo->pDependencies + idx,
                                                                   metaInfo->pDependencies->GetMetaStructPointer() + idx,
                                                                   consumer);
            }
            pdependencies_names += variable_name + ", ";
        }
        out << "\t\t" << "VkSubpassDependency " << pdependencies_array << "[] = {" << pdependencies_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkRenderPassCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->attachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pattachments_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subpassCount << "," << std::endl;
    struct_body << "\t\t\t" << psubpasses_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dependencyCount << "," << std::endl;
    struct_body << "\t\t\t" << pdependencies_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "renderPassCreateInfo");
    out << "\t\t" << "VkRenderPassCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSamplerCreateInfo(std::ostream &out, const VkSamplerCreateInfo* structInfo, Decoded_VkSamplerCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkSamplerCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFilter(" << structInfo->magFilter << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFilter(" << structInfo->minFilter << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSamplerMipmapMode(" << structInfo->mipmapMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSamplerAddressMode(" << structInfo->addressModeU << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSamplerAddressMode(" << structInfo->addressModeV << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSamplerAddressMode(" << structInfo->addressModeW << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->mipLodBias << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->anisotropyEnable << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxAnisotropy << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->compareEnable << "," << std::endl;
    struct_body << "\t\t\t" << "VkCompareOp(" << structInfo->compareOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minLod << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxLod << "," << std::endl;
    struct_body << "\t\t\t" << "VkBorderColor(" << structInfo->borderColor << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->unnormalizedCoordinates << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "samplerCreateInfo");
    out << "\t\t" << "VkSamplerCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSemaphoreCreateInfo(std::ostream &out, const VkSemaphoreCreateInfo* structInfo, Decoded_VkSemaphoreCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkSemaphoreCreateFlags(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "semaphoreCreateInfo");
    out << "\t\t" << "VkSemaphoreCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkShaderModuleCreateInfo(std::ostream &out, const VkShaderModuleCreateInfo* structInfo, Decoded_VkShaderModuleCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pcode_array = "NULL";
    if (structInfo->pCode != NULL) {
        pcode_array = "pCode_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pcode_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pCode, structInfo->codeSize / 4) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderModuleCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->codeSize << "," << std::endl;
    struct_body << "\t\t\t" << pcode_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "shaderModuleCreateInfo");
    out << "\t\t" << "VkShaderModuleCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSparseBufferMemoryBindInfo(std::ostream &out, const VkSparseBufferMemoryBindInfo* structInfo, Decoded_VkSparseBufferMemoryBindInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pbinds_array = "NULL";
    if (structInfo->pBinds != NULL) {
        pbinds_array = "pBinds_" + std::to_string(consumer.GetNextId());
        std::string pbinds_names;
        for (uint32_t idx = 0; idx < structInfo->bindCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pBinds + idx != NULL) {
                variable_name = GenerateStruct_VkSparseMemoryBind(out,
                                                                  structInfo->pBinds + idx,
                                                                  metaInfo->pBinds->GetMetaStructPointer() + idx,
                                                                  consumer);
            }
            pbinds_names += variable_name + ", ";
        }
        out << "\t\t" << "VkSparseMemoryBind " << pbinds_array << "[] = {" << pbinds_names << "};" << std::endl;
    }
    struct_body << "\t" << consumer.GetHandle(metaInfo->buffer) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bindCount << "," << std::endl;
    struct_body << "\t\t\t" << pbinds_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "sparseBufferMemoryBindInfo");
    out << "\t\t" << "VkSparseBufferMemoryBindInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSparseImageFormatProperties(std::ostream &out, const VkSparseImageFormatProperties* structInfo, Decoded_VkSparseImageFormatProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string image_granularity_info_var = GenerateStruct_VkExtent3D(out,
                                                                       &structInfo->imageGranularity,
                                                                       metaInfo->imageGranularity,
                                                                       consumer);
    struct_body << "\t" << "VkImageAspectFlags(" << structInfo->aspectMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << image_granularity_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "VkSparseImageFormatFlags(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "sparseImageFormatProperties");
    out << "\t\t" << "VkSparseImageFormatProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSparseImageMemoryBind(std::ostream &out, const VkSparseImageMemoryBind* structInfo, Decoded_VkSparseImageMemoryBind* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string subresource_info_var = GenerateStruct_VkImageSubresource(out,
                                                                         &structInfo->subresource,
                                                                         metaInfo->subresource,
                                                                         consumer);
    std::string offset_info_var = GenerateStruct_VkOffset3D(out,
                                                            &structInfo->offset,
                                                            metaInfo->offset,
                                                            consumer);
    std::string extent_info_var = GenerateStruct_VkExtent3D(out,
                                                            &structInfo->extent,
                                                            metaInfo->extent,
                                                            consumer);
    struct_body << "\t" << subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->memory) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->memoryOffset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSparseMemoryBindFlags(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "sparseImageMemoryBind");
    out << "\t\t" << "VkSparseImageMemoryBind " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSparseImageMemoryBindInfo(std::ostream &out, const VkSparseImageMemoryBindInfo* structInfo, Decoded_VkSparseImageMemoryBindInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pbinds_array = "NULL";
    if (structInfo->pBinds != NULL) {
        pbinds_array = "pBinds_" + std::to_string(consumer.GetNextId());
        std::string pbinds_names;
        for (uint32_t idx = 0; idx < structInfo->bindCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pBinds + idx != NULL) {
                variable_name = GenerateStruct_VkSparseImageMemoryBind(out,
                                                                       structInfo->pBinds + idx,
                                                                       metaInfo->pBinds->GetMetaStructPointer() + idx,
                                                                       consumer);
            }
            pbinds_names += variable_name + ", ";
        }
        out << "\t\t" << "VkSparseImageMemoryBind " << pbinds_array << "[] = {" << pbinds_names << "};" << std::endl;
    }
    struct_body << "\t" << consumer.GetHandle(metaInfo->image) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bindCount << "," << std::endl;
    struct_body << "\t\t\t" << pbinds_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "sparseImageMemoryBindInfo");
    out << "\t\t" << "VkSparseImageMemoryBindInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSparseImageMemoryRequirements(std::ostream &out, const VkSparseImageMemoryRequirements* structInfo, Decoded_VkSparseImageMemoryRequirements* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string format_properties_info_var = GenerateStruct_VkSparseImageFormatProperties(out,
                                                                                          &structInfo->formatProperties,
                                                                                          metaInfo->formatProperties,
                                                                                          consumer);
    struct_body << "\t" << format_properties_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->imageMipTailFirstLod << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->imageMipTailSize << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->imageMipTailOffset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->imageMipTailStride << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "sparseImageMemoryRequirements");
    out << "\t\t" << "VkSparseImageMemoryRequirements " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSparseImageOpaqueMemoryBindInfo(std::ostream &out, const VkSparseImageOpaqueMemoryBindInfo* structInfo, Decoded_VkSparseImageOpaqueMemoryBindInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pbinds_array = "NULL";
    if (structInfo->pBinds != NULL) {
        pbinds_array = "pBinds_" + std::to_string(consumer.GetNextId());
        std::string pbinds_names;
        for (uint32_t idx = 0; idx < structInfo->bindCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pBinds + idx != NULL) {
                variable_name = GenerateStruct_VkSparseMemoryBind(out,
                                                                  structInfo->pBinds + idx,
                                                                  metaInfo->pBinds->GetMetaStructPointer() + idx,
                                                                  consumer);
            }
            pbinds_names += variable_name + ", ";
        }
        out << "\t\t" << "VkSparseMemoryBind " << pbinds_array << "[] = {" << pbinds_names << "};" << std::endl;
    }
    struct_body << "\t" << consumer.GetHandle(metaInfo->image) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bindCount << "," << std::endl;
    struct_body << "\t\t\t" << pbinds_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "sparseImageOpaqueMemoryBindInfo");
    out << "\t\t" << "VkSparseImageOpaqueMemoryBindInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSparseMemoryBind(std::ostream &out, const VkSparseMemoryBind* structInfo, Decoded_VkSparseMemoryBind* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->resourceOffset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->memory) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->memoryOffset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSparseMemoryBindFlags(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "sparseMemoryBind");
    out << "\t\t" << "VkSparseMemoryBind " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSpecializationInfo(std::ostream &out, const VkSpecializationInfo* structInfo, Decoded_VkSpecializationInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pmap_entries_array = "NULL";
    if (structInfo->pMapEntries != NULL) {
        pmap_entries_array = "pMapEntries_" + std::to_string(consumer.GetNextId());
        std::string pmap_entries_names;
        for (uint32_t idx = 0; idx < structInfo->mapEntryCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pMapEntries + idx != NULL) {
                variable_name = GenerateStruct_VkSpecializationMapEntry(out,
                                                                        structInfo->pMapEntries + idx,
                                                                        metaInfo->pMapEntries->GetMetaStructPointer() + idx,
                                                                        consumer);
            }
            pmap_entries_names += variable_name + ", ";
        }
        out << "\t\t" << "VkSpecializationMapEntry " << pmap_entries_array << "[] = {" << pmap_entries_names << "};" << std::endl;
    }
    std::string pdata_array = "NULL";
    if (structInfo->pData != NULL) {
        std::string pdata_values;
        for (uint32_t idx0 = 0; idx0 < structInfo->dataSize; ++idx0) {
            pdata_values += std::to_string(reinterpret_cast<const uint8_t*>(structInfo->pData)[idx0]) + ", ";
        }
        pdata_array = "pData_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint8_t " << pdata_array << "[] = {" << pdata_values << "};" << std::endl;
    }
    struct_body << "\t" << structInfo->mapEntryCount << "," << std::endl;
    struct_body << "\t\t\t" << pmap_entries_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dataSize << "," << std::endl;
    struct_body << "\t\t\t" << pdata_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "specializationInfo");
    out << "\t\t" << "VkSpecializationInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSpecializationMapEntry(std::ostream &out, const VkSpecializationMapEntry* structInfo, Decoded_VkSpecializationMapEntry* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->constantID << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->offset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "specializationMapEntry");
    out << "\t\t" << "VkSpecializationMapEntry " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkStencilOpState(std::ostream &out, const VkStencilOpState* structInfo, Decoded_VkStencilOpState* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "VkStencilOp(" << structInfo->failOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkStencilOp(" << structInfo->passOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkStencilOp(" << structInfo->depthFailOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkCompareOp(" << structInfo->compareOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->compareMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->writeMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->reference << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stencilOpState");
    out << "\t\t" << "VkStencilOpState " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSubpassDependency(std::ostream &out, const VkSubpassDependency* structInfo, Decoded_VkSubpassDependency* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->srcSubpass << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dstSubpass << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineStageFlags(" << structInfo->srcStageMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineStageFlags(" << structInfo->dstStageMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags(" << structInfo->srcAccessMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags(" << structInfo->dstAccessMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkDependencyFlags(" << structInfo->dependencyFlags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "subpassDependency");
    out << "\t\t" << "VkSubpassDependency " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSubpassDescription(std::ostream &out, const VkSubpassDescription* structInfo, Decoded_VkSubpassDescription* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pinput_attachments_array = "NULL";
    if (structInfo->pInputAttachments != NULL) {
        pinput_attachments_array = "pInputAttachments_" + std::to_string(consumer.GetNextId());
        std::string pinput_attachments_names;
        for (uint32_t idx = 0; idx < structInfo->inputAttachmentCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pInputAttachments + idx != NULL) {
                variable_name = GenerateStruct_VkAttachmentReference(out,
                                                                     structInfo->pInputAttachments + idx,
                                                                     metaInfo->pInputAttachments->GetMetaStructPointer() + idx,
                                                                     consumer);
            }
            pinput_attachments_names += variable_name + ", ";
        }
        out << "\t\t" << "VkAttachmentReference " << pinput_attachments_array << "[] = {" << pinput_attachments_names << "};" << std::endl;
    }
    std::string pcolor_attachments_array = "NULL";
    if (structInfo->pColorAttachments != NULL) {
        pcolor_attachments_array = "pColorAttachments_" + std::to_string(consumer.GetNextId());
        std::string pcolor_attachments_names;
        for (uint32_t idx = 0; idx < structInfo->colorAttachmentCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pColorAttachments + idx != NULL) {
                variable_name = GenerateStruct_VkAttachmentReference(out,
                                                                     structInfo->pColorAttachments + idx,
                                                                     metaInfo->pColorAttachments->GetMetaStructPointer() + idx,
                                                                     consumer);
            }
            pcolor_attachments_names += variable_name + ", ";
        }
        out << "\t\t" << "VkAttachmentReference " << pcolor_attachments_array << "[] = {" << pcolor_attachments_names << "};" << std::endl;
    }
    std::string presolve_attachments_array = "NULL";
    if (structInfo->pResolveAttachments != NULL) {
        presolve_attachments_array = "pResolveAttachments_" + std::to_string(consumer.GetNextId());
        std::string presolve_attachments_names;
        for (uint32_t idx = 0; idx < structInfo->colorAttachmentCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pResolveAttachments + idx != NULL) {
                variable_name = GenerateStruct_VkAttachmentReference(out,
                                                                     structInfo->pResolveAttachments + idx,
                                                                     metaInfo->pResolveAttachments->GetMetaStructPointer() + idx,
                                                                     consumer);
            }
            presolve_attachments_names += variable_name + ", ";
        }
        out << "\t\t" << "VkAttachmentReference " << presolve_attachments_array << "[] = {" << presolve_attachments_names << "};" << std::endl;
    }
    std::string pdepth_stencil_attachment_struct = "NULL";
    if (structInfo->pDepthStencilAttachment != NULL) {
        pdepth_stencil_attachment_struct = GenerateStruct_VkAttachmentReference(out,
                                                                                structInfo->pDepthStencilAttachment,
                                                                                metaInfo->pDepthStencilAttachment->GetMetaStructPointer(),
                                                                                consumer);
        pdepth_stencil_attachment_struct.insert(0, "&");
    }
    std::string ppreserve_attachments_array = "NULL";
    if (structInfo->pPreserveAttachments != NULL) {
        ppreserve_attachments_array = "pPreserveAttachments_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << ppreserve_attachments_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pPreserveAttachments, structInfo->preserveAttachmentCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkSubpassDescriptionFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineBindPoint(" << structInfo->pipelineBindPoint << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->inputAttachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pinput_attachments_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->colorAttachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pcolor_attachments_array << "," << std::endl;
    struct_body << "\t\t\t" << presolve_attachments_array << "," << std::endl;
    struct_body << "\t\t\t" << pdepth_stencil_attachment_struct << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preserveAttachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << ppreserve_attachments_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "subpassDescription");
    out << "\t\t" << "VkSubpassDescription " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSubresourceLayout(std::ostream &out, const VkSubresourceLayout* structInfo, Decoded_VkSubresourceLayout* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->offset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->rowPitch << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->arrayPitch << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthPitch << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "subresourceLayout");
    out << "\t\t" << "VkSubresourceLayout " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVertexInputAttributeDescription(std::ostream &out, const VkVertexInputAttributeDescription* structInfo, Decoded_VkVertexInputAttributeDescription* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->location << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->binding << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->format << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->offset << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "vertexInputAttributeDescription");
    out << "\t\t" << "VkVertexInputAttributeDescription " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVertexInputBindingDescription(std::ostream &out, const VkVertexInputBindingDescription* structInfo, Decoded_VkVertexInputBindingDescription* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->binding << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stride << "," << std::endl;
    struct_body << "\t\t\t" << "VkVertexInputRate(" << structInfo->inputRate << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "vertexInputBindingDescription");
    out << "\t\t" << "VkVertexInputBindingDescription " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkViewport(std::ostream &out, const VkViewport* structInfo, Decoded_VkViewport* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->x << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->y << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->width << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->height << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minDepth << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDepth << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "viewport");
    out << "\t\t" << "VkViewport " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBindBufferMemoryDeviceGroupInfo(std::ostream &out, const VkBindBufferMemoryDeviceGroupInfo* structInfo, Decoded_VkBindBufferMemoryDeviceGroupInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pdevice_indices_array = "NULL";
    if (structInfo->pDeviceIndices != NULL) {
        pdevice_indices_array = "pDeviceIndices_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pdevice_indices_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pDeviceIndices, structInfo->deviceIndexCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceIndexCount << "," << std::endl;
    struct_body << "\t\t\t" << pdevice_indices_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bindBufferMemoryDeviceGroupInfo");
    out << "\t\t" << "VkBindBufferMemoryDeviceGroupInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBindBufferMemoryInfo(std::ostream &out, const VkBindBufferMemoryInfo* structInfo, Decoded_VkBindBufferMemoryInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->buffer) << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->memory) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->memoryOffset << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bindBufferMemoryInfo");
    out << "\t\t" << "VkBindBufferMemoryInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBindImageMemoryDeviceGroupInfo(std::ostream &out, const VkBindImageMemoryDeviceGroupInfo* structInfo, Decoded_VkBindImageMemoryDeviceGroupInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pdevice_indices_array = "NULL";
    if (structInfo->pDeviceIndices != NULL) {
        pdevice_indices_array = "pDeviceIndices_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pdevice_indices_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pDeviceIndices, structInfo->deviceIndexCount) << ";" << std::endl;
    }
    std::string psplit_instance_bind_regions_array = "NULL";
    if (structInfo->pSplitInstanceBindRegions != NULL) {
        psplit_instance_bind_regions_array = "pSplitInstanceBindRegions_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkRect2D " << psplit_instance_bind_regions_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pSplitInstanceBindRegions, structInfo->splitInstanceBindRegionCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceIndexCount << "," << std::endl;
    struct_body << "\t\t\t" << pdevice_indices_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->splitInstanceBindRegionCount << "," << std::endl;
    struct_body << "\t\t\t" << psplit_instance_bind_regions_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bindImageMemoryDeviceGroupInfo");
    out << "\t\t" << "VkBindImageMemoryDeviceGroupInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBindImageMemoryInfo(std::ostream &out, const VkBindImageMemoryInfo* structInfo, Decoded_VkBindImageMemoryInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->image) << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->memory) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->memoryOffset << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bindImageMemoryInfo");
    out << "\t\t" << "VkBindImageMemoryInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBindImagePlaneMemoryInfo(std::ostream &out, const VkBindImagePlaneMemoryInfo* structInfo, Decoded_VkBindImagePlaneMemoryInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageAspectFlagBits(" << structInfo->planeAspect << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bindImagePlaneMemoryInfo");
    out << "\t\t" << "VkBindImagePlaneMemoryInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBufferMemoryRequirementsInfo2(std::ostream &out, const VkBufferMemoryRequirementsInfo2* structInfo, Decoded_VkBufferMemoryRequirementsInfo2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->buffer) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bufferMemoryRequirementsInfo2");
    out << "\t\t" << "VkBufferMemoryRequirementsInfo2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDescriptorSetLayoutSupport(std::ostream &out, const VkDescriptorSetLayoutSupport* structInfo, Decoded_VkDescriptorSetLayoutSupport* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->supported << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "descriptorSetLayoutSupport");
    out << "\t\t" << "VkDescriptorSetLayoutSupport " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDescriptorUpdateTemplateCreateInfo(std::ostream &out, const VkDescriptorUpdateTemplateCreateInfo* structInfo, Decoded_VkDescriptorUpdateTemplateCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pdescriptor_update_entries_array = "NULL";
    if (structInfo->pDescriptorUpdateEntries != NULL) {
        pdescriptor_update_entries_array = "pDescriptorUpdateEntries_" + std::to_string(consumer.GetNextId());
        std::string pdescriptor_update_entries_names;
        for (uint32_t idx = 0; idx < structInfo->descriptorUpdateEntryCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pDescriptorUpdateEntries + idx != NULL) {
                variable_name = GenerateStruct_VkDescriptorUpdateTemplateEntry(out,
                                                                               structInfo->pDescriptorUpdateEntries + idx,
                                                                               metaInfo->pDescriptorUpdateEntries->GetMetaStructPointer() + idx,
                                                                               consumer);
            }
            pdescriptor_update_entries_names += variable_name + ", ";
        }
        out << "\t\t" << "VkDescriptorUpdateTemplateEntry " << pdescriptor_update_entries_array << "[] = {" << pdescriptor_update_entries_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDescriptorUpdateTemplateCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorUpdateEntryCount << "," << std::endl;
    struct_body << "\t\t\t" << pdescriptor_update_entries_array << "," << std::endl;
    struct_body << "\t\t\t" << "VkDescriptorUpdateTemplateType(" << structInfo->templateType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->descriptorSetLayout) << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineBindPoint(" << structInfo->pipelineBindPoint << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->pipelineLayout) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->set << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "descriptorUpdateTemplateCreateInfo");
    out << "\t\t" << "VkDescriptorUpdateTemplateCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceGroupBindSparseInfo(std::ostream &out, const VkDeviceGroupBindSparseInfo* structInfo, Decoded_VkDeviceGroupBindSparseInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->resourceDeviceIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->memoryDeviceIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceGroupBindSparseInfo");
    out << "\t\t" << "VkDeviceGroupBindSparseInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceGroupCommandBufferBeginInfo(std::ostream &out, const VkDeviceGroupCommandBufferBeginInfo* structInfo, Decoded_VkDeviceGroupCommandBufferBeginInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceMask << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceGroupCommandBufferBeginInfo");
    out << "\t\t" << "VkDeviceGroupCommandBufferBeginInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceGroupDeviceCreateInfo(std::ostream &out, const VkDeviceGroupDeviceCreateInfo* structInfo, Decoded_VkDeviceGroupDeviceCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pphysical_devices_array = "NULL";
    if (metaInfo->pPhysicalDevices.GetPointer() != NULL && structInfo->physicalDeviceCount > 0) {
        pphysical_devices_array = "pphysical_devices_array_" + std::to_string(consumer.GetNextId(VK_OBJECT_TYPE_PHYSICAL_DEVICE));
        std::string pphysical_devices_values = toStringJoin(metaInfo->pPhysicalDevices.GetPointer(),
                                                            metaInfo->pPhysicalDevices.GetPointer() + structInfo->physicalDeviceCount,
                                                            [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                            ", ");
        if (structInfo->physicalDeviceCount == 1) {
            pphysical_devices_array = "&" + pphysical_devices_values;
        } else if (structInfo->physicalDeviceCount > 1) {
            out << "\t\t" << "VkPhysicalDevice " << pphysical_devices_array << "[] = {" << pphysical_devices_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->physicalDeviceCount << "," << std::endl;
    struct_body << "\t\t\t" << pphysical_devices_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceGroupDeviceCreateInfo");
    out << "\t\t" << "VkDeviceGroupDeviceCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceGroupRenderPassBeginInfo(std::ostream &out, const VkDeviceGroupRenderPassBeginInfo* structInfo, Decoded_VkDeviceGroupRenderPassBeginInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pdevice_render_areas_array = "NULL";
    if (structInfo->pDeviceRenderAreas != NULL) {
        pdevice_render_areas_array = "pDeviceRenderAreas_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkRect2D " << pdevice_render_areas_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pDeviceRenderAreas, structInfo->deviceRenderAreaCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceRenderAreaCount << "," << std::endl;
    struct_body << "\t\t\t" << pdevice_render_areas_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceGroupRenderPassBeginInfo");
    out << "\t\t" << "VkDeviceGroupRenderPassBeginInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceGroupSubmitInfo(std::ostream &out, const VkDeviceGroupSubmitInfo* structInfo, Decoded_VkDeviceGroupSubmitInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pwait_semaphore_device_indices_array = "NULL";
    if (structInfo->pWaitSemaphoreDeviceIndices != NULL) {
        pwait_semaphore_device_indices_array = "pWaitSemaphoreDeviceIndices_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pwait_semaphore_device_indices_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pWaitSemaphoreDeviceIndices, structInfo->waitSemaphoreCount) << ";" << std::endl;
    }
    std::string pcommand_buffer_device_masks_array = "NULL";
    if (structInfo->pCommandBufferDeviceMasks != NULL) {
        pcommand_buffer_device_masks_array = "pCommandBufferDeviceMasks_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pcommand_buffer_device_masks_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pCommandBufferDeviceMasks, structInfo->commandBufferCount) << ";" << std::endl;
    }
    std::string psignal_semaphore_device_indices_array = "NULL";
    if (structInfo->pSignalSemaphoreDeviceIndices != NULL) {
        psignal_semaphore_device_indices_array = "pSignalSemaphoreDeviceIndices_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << psignal_semaphore_device_indices_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pSignalSemaphoreDeviceIndices, structInfo->signalSemaphoreCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->waitSemaphoreCount << "," << std::endl;
    struct_body << "\t\t\t" << pwait_semaphore_device_indices_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->commandBufferCount << "," << std::endl;
    struct_body << "\t\t\t" << pcommand_buffer_device_masks_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->signalSemaphoreCount << "," << std::endl;
    struct_body << "\t\t\t" << psignal_semaphore_device_indices_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceGroupSubmitInfo");
    out << "\t\t" << "VkDeviceGroupSubmitInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceQueueInfo2(std::ostream &out, const VkDeviceQueueInfo2* structInfo, Decoded_VkDeviceQueueInfo2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDeviceQueueCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->queueFamilyIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->queueIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceQueueInfo2");
    out << "\t\t" << "VkDeviceQueueInfo2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExportFenceCreateInfo(std::ostream &out, const VkExportFenceCreateInfo* structInfo, Decoded_VkExportFenceCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalFenceHandleTypeFlags(" << structInfo->handleTypes << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "exportFenceCreateInfo");
    out << "\t\t" << "VkExportFenceCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExportMemoryAllocateInfo(std::ostream &out, const VkExportMemoryAllocateInfo* structInfo, Decoded_VkExportMemoryAllocateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlags(" << structInfo->handleTypes << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "exportMemoryAllocateInfo");
    out << "\t\t" << "VkExportMemoryAllocateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExportSemaphoreCreateInfo(std::ostream &out, const VkExportSemaphoreCreateInfo* structInfo, Decoded_VkExportSemaphoreCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalSemaphoreHandleTypeFlags(" << structInfo->handleTypes << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "exportSemaphoreCreateInfo");
    out << "\t\t" << "VkExportSemaphoreCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExternalBufferProperties(std::ostream &out, const VkExternalBufferProperties* structInfo, Decoded_VkExternalBufferProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string external_memory_properties_info_var = GenerateStruct_VkExternalMemoryProperties(out,
                                                                                                &structInfo->externalMemoryProperties,
                                                                                                metaInfo->externalMemoryProperties,
                                                                                                consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << external_memory_properties_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "externalBufferProperties");
    out << "\t\t" << "VkExternalBufferProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExternalFenceProperties(std::ostream &out, const VkExternalFenceProperties* structInfo, Decoded_VkExternalFenceProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalFenceHandleTypeFlags(" << structInfo->exportFromImportedHandleTypes << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalFenceHandleTypeFlags(" << structInfo->compatibleHandleTypes << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalFenceFeatureFlags(" << structInfo->externalFenceFeatures << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "externalFenceProperties");
    out << "\t\t" << "VkExternalFenceProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExternalImageFormatProperties(std::ostream &out, const VkExternalImageFormatProperties* structInfo, Decoded_VkExternalImageFormatProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string external_memory_properties_info_var = GenerateStruct_VkExternalMemoryProperties(out,
                                                                                                &structInfo->externalMemoryProperties,
                                                                                                metaInfo->externalMemoryProperties,
                                                                                                consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << external_memory_properties_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "externalImageFormatProperties");
    out << "\t\t" << "VkExternalImageFormatProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExternalMemoryBufferCreateInfo(std::ostream &out, const VkExternalMemoryBufferCreateInfo* structInfo, Decoded_VkExternalMemoryBufferCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlags(" << structInfo->handleTypes << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "externalMemoryBufferCreateInfo");
    out << "\t\t" << "VkExternalMemoryBufferCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExternalMemoryImageCreateInfo(std::ostream &out, const VkExternalMemoryImageCreateInfo* structInfo, Decoded_VkExternalMemoryImageCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlags(" << structInfo->handleTypes << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "externalMemoryImageCreateInfo");
    out << "\t\t" << "VkExternalMemoryImageCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExternalMemoryProperties(std::ostream &out, const VkExternalMemoryProperties* structInfo, Decoded_VkExternalMemoryProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "VkExternalMemoryFeatureFlags(" << structInfo->externalMemoryFeatures << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlags(" << structInfo->exportFromImportedHandleTypes << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlags(" << structInfo->compatibleHandleTypes << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "externalMemoryProperties");
    out << "\t\t" << "VkExternalMemoryProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExternalSemaphoreProperties(std::ostream &out, const VkExternalSemaphoreProperties* structInfo, Decoded_VkExternalSemaphoreProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalSemaphoreHandleTypeFlags(" << structInfo->exportFromImportedHandleTypes << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalSemaphoreHandleTypeFlags(" << structInfo->compatibleHandleTypes << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalSemaphoreFeatureFlags(" << structInfo->externalSemaphoreFeatures << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "externalSemaphoreProperties");
    out << "\t\t" << "VkExternalSemaphoreProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkFormatProperties2(std::ostream &out, const VkFormatProperties2* structInfo, Decoded_VkFormatProperties2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string format_properties_info_var = GenerateStruct_VkFormatProperties(out,
                                                                               &structInfo->formatProperties,
                                                                               metaInfo->formatProperties,
                                                                               consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << format_properties_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "formatProperties2");
    out << "\t\t" << "VkFormatProperties2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageFormatProperties2(std::ostream &out, const VkImageFormatProperties2* structInfo, Decoded_VkImageFormatProperties2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string image_format_properties_info_var = GenerateStruct_VkImageFormatProperties(out,
                                                                                          &structInfo->imageFormatProperties,
                                                                                          metaInfo->imageFormatProperties,
                                                                                          consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << image_format_properties_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageFormatProperties2");
    out << "\t\t" << "VkImageFormatProperties2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageMemoryRequirementsInfo2(std::ostream &out, const VkImageMemoryRequirementsInfo2* structInfo, Decoded_VkImageMemoryRequirementsInfo2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->image) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageMemoryRequirementsInfo2");
    out << "\t\t" << "VkImageMemoryRequirementsInfo2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImagePlaneMemoryRequirementsInfo(std::ostream &out, const VkImagePlaneMemoryRequirementsInfo* structInfo, Decoded_VkImagePlaneMemoryRequirementsInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageAspectFlagBits(" << structInfo->planeAspect << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imagePlaneMemoryRequirementsInfo");
    out << "\t\t" << "VkImagePlaneMemoryRequirementsInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageSparseMemoryRequirementsInfo2(std::ostream &out, const VkImageSparseMemoryRequirementsInfo2* structInfo, Decoded_VkImageSparseMemoryRequirementsInfo2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->image) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageSparseMemoryRequirementsInfo2");
    out << "\t\t" << "VkImageSparseMemoryRequirementsInfo2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageViewUsageCreateInfo(std::ostream &out, const VkImageViewUsageCreateInfo* structInfo, Decoded_VkImageViewUsageCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageUsageFlags(" << structInfo->usage << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageViewUsageCreateInfo");
    out << "\t\t" << "VkImageViewUsageCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkInputAttachmentAspectReference(std::ostream &out, const VkInputAttachmentAspectReference* structInfo, Decoded_VkInputAttachmentAspectReference* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->subpass << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->inputAttachmentIndex << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageAspectFlags(" << structInfo->aspectMask << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "inputAttachmentAspectReference");
    out << "\t\t" << "VkInputAttachmentAspectReference " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryDedicatedAllocateInfo(std::ostream &out, const VkMemoryDedicatedAllocateInfo* structInfo, Decoded_VkMemoryDedicatedAllocateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->image) << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->buffer) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryDedicatedAllocateInfo");
    out << "\t\t" << "VkMemoryDedicatedAllocateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryDedicatedRequirements(std::ostream &out, const VkMemoryDedicatedRequirements* structInfo, Decoded_VkMemoryDedicatedRequirements* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->prefersDedicatedAllocation << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->requiresDedicatedAllocation << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryDedicatedRequirements");
    out << "\t\t" << "VkMemoryDedicatedRequirements " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryRequirements2(std::ostream &out, const VkMemoryRequirements2* structInfo, Decoded_VkMemoryRequirements2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string memory_requirements_info_var = GenerateStruct_VkMemoryRequirements(out,
                                                                                   &structInfo->memoryRequirements,
                                                                                   metaInfo->memoryRequirements,
                                                                                   consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << memory_requirements_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryRequirements2");
    out << "\t\t" << variable_name << " = {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevice16BitStorageFeatures(std::ostream &out, const VkPhysicalDevice16BitStorageFeatures* structInfo, Decoded_VkPhysicalDevice16BitStorageFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->storageBuffer16BitAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->uniformAndStorageBuffer16BitAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->storagePushConstant16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->storageInputOutput16 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevice16BitStorageFeatures");
    out << "\t\t" << "VkPhysicalDevice16BitStorageFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceExternalBufferInfo(std::ostream &out, const VkPhysicalDeviceExternalBufferInfo* structInfo, Decoded_VkPhysicalDeviceExternalBufferInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkBufferCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkBufferUsageFlags(" << structInfo->usage << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlagBits(" << structInfo->handleType << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceExternalBufferInfo");
    out << "\t\t" << "VkPhysicalDeviceExternalBufferInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceExternalFenceInfo(std::ostream &out, const VkPhysicalDeviceExternalFenceInfo* structInfo, Decoded_VkPhysicalDeviceExternalFenceInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalFenceHandleTypeFlagBits(" << structInfo->handleType << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceExternalFenceInfo");
    out << "\t\t" << "VkPhysicalDeviceExternalFenceInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceExternalImageFormatInfo(std::ostream &out, const VkPhysicalDeviceExternalImageFormatInfo* structInfo, Decoded_VkPhysicalDeviceExternalImageFormatInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlagBits(" << structInfo->handleType << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceExternalImageFormatInfo");
    out << "\t\t" << "VkPhysicalDeviceExternalImageFormatInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceExternalSemaphoreInfo(std::ostream &out, const VkPhysicalDeviceExternalSemaphoreInfo* structInfo, Decoded_VkPhysicalDeviceExternalSemaphoreInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalSemaphoreHandleTypeFlagBits(" << structInfo->handleType << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceExternalSemaphoreInfo");
    out << "\t\t" << "VkPhysicalDeviceExternalSemaphoreInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceFeatures2(std::ostream &out, const VkPhysicalDeviceFeatures2* structInfo, Decoded_VkPhysicalDeviceFeatures2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string features_info_var = GenerateStruct_VkPhysicalDeviceFeatures(out,
                                                                            &structInfo->features,
                                                                            metaInfo->features,
                                                                            consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << features_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceFeatures2");
    out << "\t\t" << "VkPhysicalDeviceFeatures2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceGroupProperties(std::ostream &out, const VkPhysicalDeviceGroupProperties* structInfo, Decoded_VkPhysicalDeviceGroupProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->physicalDeviceCount << "," << std::endl;
    out << "\t\t" << "// TODO: Support physicalDevices (output with array length value?) argument." << std::endl;
    struct_body << "\t\t\t" << structInfo->subsetAllocation << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceGroupProperties");
    out << "\t\t" << "VkPhysicalDeviceGroupProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceIDProperties(std::ostream &out, const VkPhysicalDeviceIDProperties* structInfo, Decoded_VkPhysicalDeviceIDProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->deviceUUID[0]), VK_UUID_SIZE) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->driverUUID[0]), VK_UUID_SIZE) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->deviceLUID[0]), VK_LUID_SIZE) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceNodeMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceLUIDValid << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceIDProperties");
    out << "\t\t" << "VkPhysicalDeviceIDProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceImageFormatInfo2(std::ostream &out, const VkPhysicalDeviceImageFormatInfo2* structInfo, Decoded_VkPhysicalDeviceImageFormatInfo2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->format << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageType(" << structInfo->type << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageTiling(" << structInfo->tiling << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageUsageFlags(" << structInfo->usage << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageCreateFlags(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceImageFormatInfo2");
    out << "\t\t" << "VkPhysicalDeviceImageFormatInfo2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMaintenance3Properties(std::ostream &out, const VkPhysicalDeviceMaintenance3Properties* structInfo, Decoded_VkPhysicalDeviceMaintenance3Properties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerSetDescriptors << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxMemoryAllocationSize << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMaintenance3Properties");
    out << "\t\t" << "VkPhysicalDeviceMaintenance3Properties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMemoryProperties2(std::ostream &out, const VkPhysicalDeviceMemoryProperties2* structInfo, Decoded_VkPhysicalDeviceMemoryProperties2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string memory_properties_info_var = GenerateStruct_VkPhysicalDeviceMemoryProperties(out,
                                                                                             &structInfo->memoryProperties,
                                                                                             metaInfo->memoryProperties,
                                                                                             consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << memory_properties_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMemoryProperties2");
    out << "\t\t" << "VkPhysicalDeviceMemoryProperties2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMultiviewFeatures(std::ostream &out, const VkPhysicalDeviceMultiviewFeatures* structInfo, Decoded_VkPhysicalDeviceMultiviewFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->multiview << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->multiviewGeometryShader << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->multiviewTessellationShader << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMultiviewFeatures");
    out << "\t\t" << "VkPhysicalDeviceMultiviewFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMultiviewProperties(std::ostream &out, const VkPhysicalDeviceMultiviewProperties* structInfo, Decoded_VkPhysicalDeviceMultiviewProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxMultiviewViewCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxMultiviewInstanceIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMultiviewProperties");
    out << "\t\t" << "VkPhysicalDeviceMultiviewProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePointClippingProperties(std::ostream &out, const VkPhysicalDevicePointClippingProperties* structInfo, Decoded_VkPhysicalDevicePointClippingProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPointClippingBehavior(" << structInfo->pointClippingBehavior << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePointClippingProperties");
    out << "\t\t" << "VkPhysicalDevicePointClippingProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceProperties2(std::ostream &out, const VkPhysicalDeviceProperties2* structInfo, Decoded_VkPhysicalDeviceProperties2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string properties_info_var = GenerateStruct_VkPhysicalDeviceProperties(out,
                                                                                &structInfo->properties,
                                                                                metaInfo->properties,
                                                                                consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << properties_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceProperties2");
    out << "\t\t" << "VkPhysicalDeviceProperties2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceProtectedMemoryFeatures(std::ostream &out, const VkPhysicalDeviceProtectedMemoryFeatures* structInfo, Decoded_VkPhysicalDeviceProtectedMemoryFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->protectedMemory << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceProtectedMemoryFeatures");
    out << "\t\t" << "VkPhysicalDeviceProtectedMemoryFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceProtectedMemoryProperties(std::ostream &out, const VkPhysicalDeviceProtectedMemoryProperties* structInfo, Decoded_VkPhysicalDeviceProtectedMemoryProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->protectedNoFault << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceProtectedMemoryProperties");
    out << "\t\t" << "VkPhysicalDeviceProtectedMemoryProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceSamplerYcbcrConversionFeatures(std::ostream &out, const VkPhysicalDeviceSamplerYcbcrConversionFeatures* structInfo, Decoded_VkPhysicalDeviceSamplerYcbcrConversionFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->samplerYcbcrConversion << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceSamplerYcbcrConversionFeatures");
    out << "\t\t" << "VkPhysicalDeviceSamplerYcbcrConversionFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderDrawParametersFeatures(std::ostream &out, const VkPhysicalDeviceShaderDrawParametersFeatures* structInfo, Decoded_VkPhysicalDeviceShaderDrawParametersFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDrawParameters << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderDrawParametersFeatures");
    out << "\t\t" << "VkPhysicalDeviceShaderDrawParametersFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceSparseImageFormatInfo2(std::ostream &out, const VkPhysicalDeviceSparseImageFormatInfo2* structInfo, Decoded_VkPhysicalDeviceSparseImageFormatInfo2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->format << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageType(" << structInfo->type << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlagBits(" << structInfo->samples << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageUsageFlags(" << structInfo->usage << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageTiling(" << structInfo->tiling << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceSparseImageFormatInfo2");
    out << "\t\t" << "VkPhysicalDeviceSparseImageFormatInfo2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceSubgroupProperties(std::ostream &out, const VkPhysicalDeviceSubgroupProperties* structInfo, Decoded_VkPhysicalDeviceSubgroupProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subgroupSize << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderStageFlags(" << structInfo->supportedStages << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSubgroupFeatureFlags(" << structInfo->supportedOperations << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->quadOperationsInAllStages << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceSubgroupProperties");
    out << "\t\t" << "VkPhysicalDeviceSubgroupProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVariablePointersFeatures(std::ostream &out, const VkPhysicalDeviceVariablePointersFeatures* structInfo, Decoded_VkPhysicalDeviceVariablePointersFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->variablePointersStorageBuffer << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->variablePointers << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVariablePointersFeatures");
    out << "\t\t" << "VkPhysicalDeviceVariablePointersFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineTessellationDomainOriginStateCreateInfo(std::ostream &out, const VkPipelineTessellationDomainOriginStateCreateInfo* structInfo, Decoded_VkPipelineTessellationDomainOriginStateCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkTessellationDomainOrigin(" << structInfo->domainOrigin << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineTessellationDomainOriginStateCreateInfo");
    out << "\t\t" << "VkPipelineTessellationDomainOriginStateCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkProtectedSubmitInfo(std::ostream &out, const VkProtectedSubmitInfo* structInfo, Decoded_VkProtectedSubmitInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->protectedSubmit << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "protectedSubmitInfo");
    out << "\t\t" << "VkProtectedSubmitInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkQueueFamilyProperties2(std::ostream &out, const VkQueueFamilyProperties2* structInfo, Decoded_VkQueueFamilyProperties2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string queue_family_properties_info_var = GenerateStruct_VkQueueFamilyProperties(out,
                                                                                          &structInfo->queueFamilyProperties,
                                                                                          metaInfo->queueFamilyProperties,
                                                                                          consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << queue_family_properties_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "queueFamilyProperties2");
    out << "\t\t" << "VkQueueFamilyProperties2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRenderPassInputAttachmentAspectCreateInfo(std::ostream &out, const VkRenderPassInputAttachmentAspectCreateInfo* structInfo, Decoded_VkRenderPassInputAttachmentAspectCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string paspect_references_array = "NULL";
    if (structInfo->pAspectReferences != NULL) {
        paspect_references_array = "pAspectReferences_" + std::to_string(consumer.GetNextId());
        std::string paspect_references_names;
        for (uint32_t idx = 0; idx < structInfo->aspectReferenceCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pAspectReferences + idx != NULL) {
                variable_name = GenerateStruct_VkInputAttachmentAspectReference(out,
                                                                                structInfo->pAspectReferences + idx,
                                                                                metaInfo->pAspectReferences->GetMetaStructPointer() + idx,
                                                                                consumer);
            }
            paspect_references_names += variable_name + ", ";
        }
        out << "\t\t" << "VkInputAttachmentAspectReference " << paspect_references_array << "[] = {" << paspect_references_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->aspectReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << paspect_references_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "renderPassInputAttachmentAspectCreateInfo");
    out << "\t\t" << "VkRenderPassInputAttachmentAspectCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRenderPassMultiviewCreateInfo(std::ostream &out, const VkRenderPassMultiviewCreateInfo* structInfo, Decoded_VkRenderPassMultiviewCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pview_masks_array = "NULL";
    if (structInfo->pViewMasks != NULL) {
        pview_masks_array = "pViewMasks_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pview_masks_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pViewMasks, structInfo->subpassCount) << ";" << std::endl;
    }
    std::string pview_offsets_array = "NULL";
    if (structInfo->pViewOffsets != NULL) {
        pview_offsets_array = "pViewOffsets_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "int32_t " << pview_offsets_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pViewOffsets, structInfo->dependencyCount) << ";" << std::endl;
    }
    std::string pcorrelation_masks_array = "NULL";
    if (structInfo->pCorrelationMasks != NULL) {
        pcorrelation_masks_array = "pCorrelationMasks_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pcorrelation_masks_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pCorrelationMasks, structInfo->correlationMaskCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subpassCount << "," << std::endl;
    struct_body << "\t\t\t" << pview_masks_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dependencyCount << "," << std::endl;
    struct_body << "\t\t\t" << pview_offsets_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->correlationMaskCount << "," << std::endl;
    struct_body << "\t\t\t" << pcorrelation_masks_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "renderPassMultiviewCreateInfo");
    out << "\t\t" << "VkRenderPassMultiviewCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSamplerYcbcrConversionCreateInfo(std::ostream &out, const VkSamplerYcbcrConversionCreateInfo* structInfo, Decoded_VkSamplerYcbcrConversionCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string components_info_var = GenerateStruct_VkComponentMapping(out,
                                                                        &structInfo->components,
                                                                        metaInfo->components,
                                                                        consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->format << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSamplerYcbcrModelConversion(" << structInfo->ycbcrModel << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSamplerYcbcrRange(" << structInfo->ycbcrRange << ")" << "," << std::endl;
    struct_body << "\t\t\t" << components_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "VkChromaLocation(" << structInfo->xChromaOffset << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkChromaLocation(" << structInfo->yChromaOffset << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFilter(" << structInfo->chromaFilter << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->forceExplicitReconstruction << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "samplerYcbcrConversionCreateInfo");
    out << "\t\t" << "VkSamplerYcbcrConversionCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSamplerYcbcrConversionImageFormatProperties(std::ostream &out, const VkSamplerYcbcrConversionImageFormatProperties* structInfo, Decoded_VkSamplerYcbcrConversionImageFormatProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->combinedImageSamplerDescriptorCount << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "samplerYcbcrConversionImageFormatProperties");
    out << "\t\t" << "VkSamplerYcbcrConversionImageFormatProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSamplerYcbcrConversionInfo(std::ostream &out, const VkSamplerYcbcrConversionInfo* structInfo, Decoded_VkSamplerYcbcrConversionInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->conversion) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "samplerYcbcrConversionInfo");
    out << "\t\t" << "VkSamplerYcbcrConversionInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSparseImageFormatProperties2(std::ostream &out, const VkSparseImageFormatProperties2* structInfo, Decoded_VkSparseImageFormatProperties2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string properties_info_var = GenerateStruct_VkSparseImageFormatProperties(out,
                                                                                   &structInfo->properties,
                                                                                   metaInfo->properties,
                                                                                   consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << properties_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "sparseImageFormatProperties2");
    out << "\t\t" << "VkSparseImageFormatProperties2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSparseImageMemoryRequirements2(std::ostream &out, const VkSparseImageMemoryRequirements2* structInfo, Decoded_VkSparseImageMemoryRequirements2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string memory_requirements_info_var = GenerateStruct_VkSparseImageMemoryRequirements(out,
                                                                                              &structInfo->memoryRequirements,
                                                                                              metaInfo->memoryRequirements,
                                                                                              consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << memory_requirements_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "sparseImageMemoryRequirements2");
    out << "\t\t" << "VkSparseImageMemoryRequirements2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkAttachmentDescription2(std::ostream &out, const VkAttachmentDescription2* structInfo, Decoded_VkAttachmentDescription2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkAttachmentDescriptionFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->format << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlagBits(" << structInfo->samples << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAttachmentLoadOp(" << structInfo->loadOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAttachmentStoreOp(" << structInfo->storeOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAttachmentLoadOp(" << structInfo->stencilLoadOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAttachmentStoreOp(" << structInfo->stencilStoreOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->initialLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->finalLayout << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "attachmentDescription2");
    out << "\t\t" << "VkAttachmentDescription2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkAttachmentDescriptionStencilLayout(std::ostream &out, const VkAttachmentDescriptionStencilLayout* structInfo, Decoded_VkAttachmentDescriptionStencilLayout* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->stencilInitialLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->stencilFinalLayout << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "attachmentDescriptionStencilLayout");
    out << "\t\t" << "VkAttachmentDescriptionStencilLayout " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkAttachmentReference2(std::ostream &out, const VkAttachmentReference2* structInfo, Decoded_VkAttachmentReference2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->attachment << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->layout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageAspectFlags(" << structInfo->aspectMask << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "attachmentReference2");
    out << "\t\t" << "VkAttachmentReference2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkAttachmentReferenceStencilLayout(std::ostream &out, const VkAttachmentReferenceStencilLayout* structInfo, Decoded_VkAttachmentReferenceStencilLayout* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->stencilLayout << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "attachmentReferenceStencilLayout");
    out << "\t\t" << "VkAttachmentReferenceStencilLayout " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBufferDeviceAddressInfo(std::ostream &out, const VkBufferDeviceAddressInfo* structInfo, Decoded_VkBufferDeviceAddressInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->buffer) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bufferDeviceAddressInfo");
    out << "\t\t" << "VkBufferDeviceAddressInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBufferOpaqueCaptureAddressCreateInfo(std::ostream &out, const VkBufferOpaqueCaptureAddressCreateInfo* structInfo, Decoded_VkBufferOpaqueCaptureAddressCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->opaqueCaptureAddress << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bufferOpaqueCaptureAddressCreateInfo");
    out << "\t\t" << "VkBufferOpaqueCaptureAddressCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkConformanceVersion(std::ostream &out, const VkConformanceVersion* structInfo, Decoded_VkConformanceVersion* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << std::to_string(structInfo->major) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->minor) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->subminor) << "," << std::endl;
    struct_body << "\t\t\t" << std::to_string(structInfo->patch) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "conformanceVersion");
    out << "\t\t" << "VkConformanceVersion " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDescriptorSetLayoutBindingFlagsCreateInfo(std::ostream &out, const VkDescriptorSetLayoutBindingFlagsCreateInfo* structInfo, Decoded_VkDescriptorSetLayoutBindingFlagsCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pbinding_flags_values;
    std::string pbinding_flags_array = "NULL";
    if (structInfo->pBindingFlags != NULL) {
        for (uint32_t idx = 0; idx < structInfo->bindingCount; idx++) {
            pbinding_flags_values += util::ToString<VkDescriptorBindingFlags>(structInfo->pBindingFlags[idx]) + ", ";
        }
        pbinding_flags_array = "pBindingFlags_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkDescriptorBindingFlags " << pbinding_flags_array << "[] = {" << pbinding_flags_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bindingCount << "," << std::endl;
    struct_body << "\t\t\t" << pbinding_flags_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "descriptorSetLayoutBindingFlagsCreateInfo");
    out << "\t\t" << "VkDescriptorSetLayoutBindingFlagsCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDescriptorSetVariableDescriptorCountAllocateInfo(std::ostream &out, const VkDescriptorSetVariableDescriptorCountAllocateInfo* structInfo, Decoded_VkDescriptorSetVariableDescriptorCountAllocateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pdescriptor_counts_array = "NULL";
    if (structInfo->pDescriptorCounts != NULL) {
        pdescriptor_counts_array = "pDescriptorCounts_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pdescriptor_counts_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pDescriptorCounts, structInfo->descriptorSetCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorSetCount << "," << std::endl;
    struct_body << "\t\t\t" << pdescriptor_counts_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "descriptorSetVariableDescriptorCountAllocateInfo");
    out << "\t\t" << "VkDescriptorSetVariableDescriptorCountAllocateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDescriptorSetVariableDescriptorCountLayoutSupport(std::ostream &out, const VkDescriptorSetVariableDescriptorCountLayoutSupport* structInfo, Decoded_VkDescriptorSetVariableDescriptorCountLayoutSupport* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxVariableDescriptorCount << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "descriptorSetVariableDescriptorCountLayoutSupport");
    out << "\t\t" << "VkDescriptorSetVariableDescriptorCountLayoutSupport " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceMemoryOpaqueCaptureAddressInfo(std::ostream &out, const VkDeviceMemoryOpaqueCaptureAddressInfo* structInfo, Decoded_VkDeviceMemoryOpaqueCaptureAddressInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->memory) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceMemoryOpaqueCaptureAddressInfo");
    out << "\t\t" << "VkDeviceMemoryOpaqueCaptureAddressInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkFramebufferAttachmentImageInfo(std::ostream &out, const VkFramebufferAttachmentImageInfo* structInfo, Decoded_VkFramebufferAttachmentImageInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pview_formats_values;
    std::string pview_formats_array = "NULL";
    if (structInfo->pViewFormats != NULL) {
        for (uint32_t idx = 0; idx < structInfo->viewFormatCount; idx++) {
            pview_formats_values += util::ToString<VkFormat>(structInfo->pViewFormats[idx]) + ", ";
        }
        pview_formats_array = "pViewFormats_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkFormat " << pview_formats_array << "[] = {" << pview_formats_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageUsageFlags(" << structInfo->usage << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->width << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->height << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->layerCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->viewFormatCount << "," << std::endl;
    struct_body << "\t\t\t" << pview_formats_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "framebufferAttachmentImageInfo");
    out << "\t\t" << "VkFramebufferAttachmentImageInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkFramebufferAttachmentsCreateInfo(std::ostream &out, const VkFramebufferAttachmentsCreateInfo* structInfo, Decoded_VkFramebufferAttachmentsCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pattachment_image_infos_array = "NULL";
    if (structInfo->pAttachmentImageInfos != NULL) {
        pattachment_image_infos_array = "pAttachmentImageInfos_" + std::to_string(consumer.GetNextId());
        std::string pattachment_image_infos_names;
        for (uint32_t idx = 0; idx < structInfo->attachmentImageInfoCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pAttachmentImageInfos + idx != NULL) {
                variable_name = GenerateStruct_VkFramebufferAttachmentImageInfo(out,
                                                                                structInfo->pAttachmentImageInfos + idx,
                                                                                metaInfo->pAttachmentImageInfos->GetMetaStructPointer() + idx,
                                                                                consumer);
            }
            pattachment_image_infos_names += variable_name + ", ";
        }
        out << "\t\t" << "VkFramebufferAttachmentImageInfo " << pattachment_image_infos_array << "[] = {" << pattachment_image_infos_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->attachmentImageInfoCount << "," << std::endl;
    struct_body << "\t\t\t" << pattachment_image_infos_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "framebufferAttachmentsCreateInfo");
    out << "\t\t" << "VkFramebufferAttachmentsCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageFormatListCreateInfo(std::ostream &out, const VkImageFormatListCreateInfo* structInfo, Decoded_VkImageFormatListCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pview_formats_values;
    std::string pview_formats_array = "NULL";
    if (structInfo->pViewFormats != NULL) {
        for (uint32_t idx = 0; idx < structInfo->viewFormatCount; idx++) {
            pview_formats_values += util::ToString<VkFormat>(structInfo->pViewFormats[idx]) + ", ";
        }
        pview_formats_array = "pViewFormats_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkFormat " << pview_formats_array << "[] = {" << pview_formats_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->viewFormatCount << "," << std::endl;
    struct_body << "\t\t\t" << pview_formats_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageFormatListCreateInfo");
    out << "\t\t" << "VkImageFormatListCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageStencilUsageCreateInfo(std::ostream &out, const VkImageStencilUsageCreateInfo* structInfo, Decoded_VkImageStencilUsageCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageUsageFlags(" << structInfo->stencilUsage << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageStencilUsageCreateInfo");
    out << "\t\t" << "VkImageStencilUsageCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryOpaqueCaptureAddressAllocateInfo(std::ostream &out, const VkMemoryOpaqueCaptureAddressAllocateInfo* structInfo, Decoded_VkMemoryOpaqueCaptureAddressAllocateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->opaqueCaptureAddress << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryOpaqueCaptureAddressAllocateInfo");
    out << "\t\t" << "VkMemoryOpaqueCaptureAddressAllocateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevice8BitStorageFeatures(std::ostream &out, const VkPhysicalDevice8BitStorageFeatures* structInfo, Decoded_VkPhysicalDevice8BitStorageFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->storageBuffer8BitAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->uniformAndStorageBuffer8BitAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->storagePushConstant8 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevice8BitStorageFeatures");
    out << "\t\t" << "VkPhysicalDevice8BitStorageFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceBufferDeviceAddressFeatures(std::ostream &out, const VkPhysicalDeviceBufferDeviceAddressFeatures* structInfo, Decoded_VkPhysicalDeviceBufferDeviceAddressFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferDeviceAddress << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferDeviceAddressCaptureReplay << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferDeviceAddressMultiDevice << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceBufferDeviceAddressFeatures");
    out << "\t\t" << "VkPhysicalDeviceBufferDeviceAddressFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceDepthStencilResolveProperties(std::ostream &out, const VkPhysicalDeviceDepthStencilResolveProperties* structInfo, Decoded_VkPhysicalDeviceDepthStencilResolveProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkResolveModeFlags(" << structInfo->supportedDepthResolveModes << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkResolveModeFlags(" << structInfo->supportedStencilResolveModes << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->independentResolveNone << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->independentResolve << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceDepthStencilResolveProperties");
    out << "\t\t" << "VkPhysicalDeviceDepthStencilResolveProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceDescriptorIndexingFeatures(std::ostream &out, const VkPhysicalDeviceDescriptorIndexingFeatures* structInfo, Decoded_VkPhysicalDeviceDescriptorIndexingFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderInputAttachmentArrayDynamicIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderUniformTexelBufferArrayDynamicIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageTexelBufferArrayDynamicIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderUniformBufferArrayNonUniformIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSampledImageArrayNonUniformIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageBufferArrayNonUniformIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageImageArrayNonUniformIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderInputAttachmentArrayNonUniformIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderUniformTexelBufferArrayNonUniformIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageTexelBufferArrayNonUniformIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingUniformBufferUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingSampledImageUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingStorageImageUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingStorageBufferUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingUniformTexelBufferUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingStorageTexelBufferUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingUpdateUnusedWhilePending << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingPartiallyBound << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingVariableDescriptorCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->runtimeDescriptorArray << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceDescriptorIndexingFeatures");
    out << "\t\t" << "VkPhysicalDeviceDescriptorIndexingFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceDescriptorIndexingProperties(std::ostream &out, const VkPhysicalDeviceDescriptorIndexingProperties* structInfo, Decoded_VkPhysicalDeviceDescriptorIndexingProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxUpdateAfterBindDescriptorsInAllPools << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderUniformBufferArrayNonUniformIndexingNative << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSampledImageArrayNonUniformIndexingNative << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageBufferArrayNonUniformIndexingNative << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageImageArrayNonUniformIndexingNative << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderInputAttachmentArrayNonUniformIndexingNative << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->robustBufferAccessUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->quadDivergentImplicitLod << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUpdateAfterBindSamplers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUpdateAfterBindUniformBuffers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUpdateAfterBindStorageBuffers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUpdateAfterBindSampledImages << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUpdateAfterBindStorageImages << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUpdateAfterBindInputAttachments << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageUpdateAfterBindResources << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindSamplers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindUniformBuffers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindStorageBuffers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindSampledImages << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindStorageImages << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindInputAttachments << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceDescriptorIndexingProperties");
    out << "\t\t" << "VkPhysicalDeviceDescriptorIndexingProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceDriverProperties(std::ostream &out, const VkPhysicalDeviceDriverProperties* structInfo, Decoded_VkPhysicalDeviceDriverProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string conformance_version_info_var = GenerateStruct_VkConformanceVersion(out,
                                                                                   &structInfo->conformanceVersion,
                                                                                   metaInfo->conformanceVersion,
                                                                                   consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDriverId(" << structInfo->driverID << ")" << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->driverName) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->driverInfo) << "," << std::endl;
    struct_body << "\t\t\t" << conformance_version_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceDriverProperties");
    out << "\t\t" << "VkPhysicalDeviceDriverProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceFloatControlsProperties(std::ostream &out, const VkPhysicalDeviceFloatControlsProperties* structInfo, Decoded_VkPhysicalDeviceFloatControlsProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderFloatControlsIndependence(" << structInfo->denormBehaviorIndependence << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderFloatControlsIndependence(" << structInfo->roundingModeIndependence << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSignedZeroInfNanPreserveFloat16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSignedZeroInfNanPreserveFloat32 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSignedZeroInfNanPreserveFloat64 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDenormPreserveFloat16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDenormPreserveFloat32 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDenormPreserveFloat64 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDenormFlushToZeroFloat16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDenormFlushToZeroFloat32 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDenormFlushToZeroFloat64 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderRoundingModeRTEFloat16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderRoundingModeRTEFloat32 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderRoundingModeRTEFloat64 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderRoundingModeRTZFloat16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderRoundingModeRTZFloat32 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderRoundingModeRTZFloat64 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceFloatControlsProperties");
    out << "\t\t" << "VkPhysicalDeviceFloatControlsProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceHostQueryResetFeatures(std::ostream &out, const VkPhysicalDeviceHostQueryResetFeatures* structInfo, Decoded_VkPhysicalDeviceHostQueryResetFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->hostQueryReset << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceHostQueryResetFeatures");
    out << "\t\t" << "VkPhysicalDeviceHostQueryResetFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceImagelessFramebufferFeatures(std::ostream &out, const VkPhysicalDeviceImagelessFramebufferFeatures* structInfo, Decoded_VkPhysicalDeviceImagelessFramebufferFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->imagelessFramebuffer << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceImagelessFramebufferFeatures");
    out << "\t\t" << "VkPhysicalDeviceImagelessFramebufferFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceSamplerFilterMinmaxProperties(std::ostream &out, const VkPhysicalDeviceSamplerFilterMinmaxProperties* structInfo, Decoded_VkPhysicalDeviceSamplerFilterMinmaxProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->filterMinmaxSingleComponentFormats << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->filterMinmaxImageComponentMapping << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceSamplerFilterMinmaxProperties");
    out << "\t\t" << "VkPhysicalDeviceSamplerFilterMinmaxProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceScalarBlockLayoutFeatures(std::ostream &out, const VkPhysicalDeviceScalarBlockLayoutFeatures* structInfo, Decoded_VkPhysicalDeviceScalarBlockLayoutFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->scalarBlockLayout << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceScalarBlockLayoutFeatures");
    out << "\t\t" << "VkPhysicalDeviceScalarBlockLayoutFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(std::ostream &out, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* structInfo, Decoded_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->separateDepthStencilLayouts << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceSeparateDepthStencilLayoutsFeatures");
    out << "\t\t" << "VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderAtomicInt64Features(std::ostream &out, const VkPhysicalDeviceShaderAtomicInt64Features* structInfo, Decoded_VkPhysicalDeviceShaderAtomicInt64Features* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderBufferInt64Atomics << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSharedInt64Atomics << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderAtomicInt64Features");
    out << "\t\t" << "VkPhysicalDeviceShaderAtomicInt64Features " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderFloat16Int8Features(std::ostream &out, const VkPhysicalDeviceShaderFloat16Int8Features* structInfo, Decoded_VkPhysicalDeviceShaderFloat16Int8Features* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderFloat16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderInt8 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderFloat16Int8Features");
    out << "\t\t" << "VkPhysicalDeviceShaderFloat16Int8Features " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(std::ostream &out, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* structInfo, Decoded_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSubgroupExtendedTypes << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderSubgroupExtendedTypesFeatures");
    out << "\t\t" << "VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceTimelineSemaphoreFeatures(std::ostream &out, const VkPhysicalDeviceTimelineSemaphoreFeatures* structInfo, Decoded_VkPhysicalDeviceTimelineSemaphoreFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->timelineSemaphore << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceTimelineSemaphoreFeatures");
    out << "\t\t" << "VkPhysicalDeviceTimelineSemaphoreFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceTimelineSemaphoreProperties(std::ostream &out, const VkPhysicalDeviceTimelineSemaphoreProperties* structInfo, Decoded_VkPhysicalDeviceTimelineSemaphoreProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTimelineSemaphoreValueDifference << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceTimelineSemaphoreProperties");
    out << "\t\t" << "VkPhysicalDeviceTimelineSemaphoreProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(std::ostream &out, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures* structInfo, Decoded_VkPhysicalDeviceUniformBufferStandardLayoutFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->uniformBufferStandardLayout << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceUniformBufferStandardLayoutFeatures");
    out << "\t\t" << "VkPhysicalDeviceUniformBufferStandardLayoutFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVulkan11Features(std::ostream &out, const VkPhysicalDeviceVulkan11Features* structInfo, Decoded_VkPhysicalDeviceVulkan11Features* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->storageBuffer16BitAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->uniformAndStorageBuffer16BitAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->storagePushConstant16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->storageInputOutput16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->multiview << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->multiviewGeometryShader << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->multiviewTessellationShader << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->variablePointersStorageBuffer << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->variablePointers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->protectedMemory << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->samplerYcbcrConversion << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDrawParameters << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVulkan11Features");
    out << "\t\t" << "VkPhysicalDeviceVulkan11Features " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVulkan11Properties(std::ostream &out, const VkPhysicalDeviceVulkan11Properties* structInfo, Decoded_VkPhysicalDeviceVulkan11Properties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->deviceUUID[0]), VK_UUID_SIZE) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->driverUUID[0]), VK_UUID_SIZE) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->deviceLUID[0]), VK_LUID_SIZE) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceNodeMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceLUIDValid << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subgroupSize << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderStageFlags(" << structInfo->subgroupSupportedStages << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSubgroupFeatureFlags(" << structInfo->subgroupSupportedOperations << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subgroupQuadOperationsInAllStages << "," << std::endl;
    struct_body << "\t\t\t" << "VkPointClippingBehavior(" << structInfo->pointClippingBehavior << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxMultiviewViewCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxMultiviewInstanceIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->protectedNoFault << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerSetDescriptors << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxMemoryAllocationSize << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVulkan11Properties");
    out << "\t\t" << "VkPhysicalDeviceVulkan11Properties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVulkan12Features(std::ostream &out, const VkPhysicalDeviceVulkan12Features* structInfo, Decoded_VkPhysicalDeviceVulkan12Features* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->samplerMirrorClampToEdge << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->drawIndirectCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->storageBuffer8BitAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->uniformAndStorageBuffer8BitAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->storagePushConstant8 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderBufferInt64Atomics << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSharedInt64Atomics << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderFloat16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderInt8 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderInputAttachmentArrayDynamicIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderUniformTexelBufferArrayDynamicIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageTexelBufferArrayDynamicIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderUniformBufferArrayNonUniformIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSampledImageArrayNonUniformIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageBufferArrayNonUniformIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageImageArrayNonUniformIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderInputAttachmentArrayNonUniformIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderUniformTexelBufferArrayNonUniformIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageTexelBufferArrayNonUniformIndexing << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingUniformBufferUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingSampledImageUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingStorageImageUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingStorageBufferUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingUniformTexelBufferUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingStorageTexelBufferUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingUpdateUnusedWhilePending << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingPartiallyBound << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingVariableDescriptorCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->runtimeDescriptorArray << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->samplerFilterMinmax << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->scalarBlockLayout << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->imagelessFramebuffer << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->uniformBufferStandardLayout << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSubgroupExtendedTypes << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->separateDepthStencilLayouts << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->hostQueryReset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->timelineSemaphore << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferDeviceAddress << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferDeviceAddressCaptureReplay << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferDeviceAddressMultiDevice << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vulkanMemoryModel << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vulkanMemoryModelDeviceScope << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vulkanMemoryModelAvailabilityVisibilityChains << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderOutputViewportIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderOutputLayer << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subgroupBroadcastDynamicId << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVulkan12Features");
    out << "\t\t" << "VkPhysicalDeviceVulkan12Features " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVulkan12Properties(std::ostream &out, const VkPhysicalDeviceVulkan12Properties* structInfo, Decoded_VkPhysicalDeviceVulkan12Properties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string conformance_version_info_var = GenerateStruct_VkConformanceVersion(out,
                                                                                   &structInfo->conformanceVersion,
                                                                                   metaInfo->conformanceVersion,
                                                                                   consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDriverId(" << structInfo->driverID << ")" << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->driverName) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->driverInfo) << "," << std::endl;
    struct_body << "\t\t\t" << conformance_version_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderFloatControlsIndependence(" << structInfo->denormBehaviorIndependence << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderFloatControlsIndependence(" << structInfo->roundingModeIndependence << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSignedZeroInfNanPreserveFloat16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSignedZeroInfNanPreserveFloat32 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSignedZeroInfNanPreserveFloat64 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDenormPreserveFloat16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDenormPreserveFloat32 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDenormPreserveFloat64 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDenormFlushToZeroFloat16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDenormFlushToZeroFloat32 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDenormFlushToZeroFloat64 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderRoundingModeRTEFloat16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderRoundingModeRTEFloat32 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderRoundingModeRTEFloat64 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderRoundingModeRTZFloat16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderRoundingModeRTZFloat32 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderRoundingModeRTZFloat64 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxUpdateAfterBindDescriptorsInAllPools << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderUniformBufferArrayNonUniformIndexingNative << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSampledImageArrayNonUniformIndexingNative << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageBufferArrayNonUniformIndexingNative << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderStorageImageArrayNonUniformIndexingNative << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderInputAttachmentArrayNonUniformIndexingNative << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->robustBufferAccessUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->quadDivergentImplicitLod << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUpdateAfterBindSamplers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUpdateAfterBindUniformBuffers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUpdateAfterBindStorageBuffers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUpdateAfterBindSampledImages << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUpdateAfterBindStorageImages << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUpdateAfterBindInputAttachments << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageUpdateAfterBindResources << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindSamplers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindUniformBuffers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindStorageBuffers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindSampledImages << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindStorageImages << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindInputAttachments << "," << std::endl;
    struct_body << "\t\t\t" << "VkResolveModeFlags(" << structInfo->supportedDepthResolveModes << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkResolveModeFlags(" << structInfo->supportedStencilResolveModes << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->independentResolveNone << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->independentResolve << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->filterMinmaxSingleComponentFormats << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->filterMinmaxImageComponentMapping << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTimelineSemaphoreValueDifference << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlags(" << structInfo->framebufferIntegerColorSampleCounts << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVulkan12Properties");
    out << "\t\t" << "VkPhysicalDeviceVulkan12Properties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVulkanMemoryModelFeatures(std::ostream &out, const VkPhysicalDeviceVulkanMemoryModelFeatures* structInfo, Decoded_VkPhysicalDeviceVulkanMemoryModelFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vulkanMemoryModel << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vulkanMemoryModelDeviceScope << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vulkanMemoryModelAvailabilityVisibilityChains << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVulkanMemoryModelFeatures");
    out << "\t\t" << "VkPhysicalDeviceVulkanMemoryModelFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRenderPassAttachmentBeginInfo(std::ostream &out, const VkRenderPassAttachmentBeginInfo* structInfo, Decoded_VkRenderPassAttachmentBeginInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pattachments_array = "NULL";
    if (metaInfo->pAttachments.GetPointer() != NULL && structInfo->attachmentCount > 0) {
        pattachments_array = "pattachments_array_" + std::to_string(consumer.GetNextId());
        std::string pattachments_values = toStringJoin(metaInfo->pAttachments.GetPointer(),
                                                       metaInfo->pAttachments.GetPointer() + structInfo->attachmentCount,
                                                       [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                       ", ");
        if (structInfo->attachmentCount == 1) {
            pattachments_array = "&" + pattachments_values;
        } else if (structInfo->attachmentCount > 1) {
            out << "\t\t" << "VkImageView " << pattachments_array << "[] = {" << pattachments_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->attachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pattachments_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "renderPassAttachmentBeginInfo");
    out << "\t\t" << "VkRenderPassAttachmentBeginInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRenderPassCreateInfo2(std::ostream &out, const VkRenderPassCreateInfo2* structInfo, Decoded_VkRenderPassCreateInfo2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pattachments_array = "NULL";
    if (structInfo->pAttachments != NULL) {
        pattachments_array = "pAttachments_" + std::to_string(consumer.GetNextId());
        std::string pattachments_names;
        for (uint32_t idx = 0; idx < structInfo->attachmentCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pAttachments + idx != NULL) {
                variable_name = GenerateStruct_VkAttachmentDescription2(out,
                                                                        structInfo->pAttachments + idx,
                                                                        metaInfo->pAttachments->GetMetaStructPointer() + idx,
                                                                        consumer);
            }
            pattachments_names += variable_name + ", ";
        }
        out << "\t\t" << "VkAttachmentDescription2 " << pattachments_array << "[] = {" << pattachments_names << "};" << std::endl;
    }
    std::string psubpasses_array = "NULL";
    if (structInfo->pSubpasses != NULL) {
        psubpasses_array = "pSubpasses_" + std::to_string(consumer.GetNextId());
        std::string psubpasses_names;
        for (uint32_t idx = 0; idx < structInfo->subpassCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pSubpasses + idx != NULL) {
                variable_name = GenerateStruct_VkSubpassDescription2(out,
                                                                     structInfo->pSubpasses + idx,
                                                                     metaInfo->pSubpasses->GetMetaStructPointer() + idx,
                                                                     consumer);
            }
            psubpasses_names += variable_name + ", ";
        }
        out << "\t\t" << "VkSubpassDescription2 " << psubpasses_array << "[] = {" << psubpasses_names << "};" << std::endl;
    }
    std::string pdependencies_array = "NULL";
    if (structInfo->pDependencies != NULL) {
        pdependencies_array = "pDependencies_" + std::to_string(consumer.GetNextId());
        std::string pdependencies_names;
        for (uint32_t idx = 0; idx < structInfo->dependencyCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pDependencies + idx != NULL) {
                variable_name = GenerateStruct_VkSubpassDependency2(out,
                                                                    structInfo->pDependencies + idx,
                                                                    metaInfo->pDependencies->GetMetaStructPointer() + idx,
                                                                    consumer);
            }
            pdependencies_names += variable_name + ", ";
        }
        out << "\t\t" << "VkSubpassDependency2 " << pdependencies_array << "[] = {" << pdependencies_names << "};" << std::endl;
    }
    std::string pcorrelated_view_masks_array = "NULL";
    if (structInfo->pCorrelatedViewMasks != NULL) {
        pcorrelated_view_masks_array = "pCorrelatedViewMasks_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pcorrelated_view_masks_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pCorrelatedViewMasks, structInfo->correlatedViewMaskCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkRenderPassCreateFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->attachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pattachments_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subpassCount << "," << std::endl;
    struct_body << "\t\t\t" << psubpasses_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dependencyCount << "," << std::endl;
    struct_body << "\t\t\t" << pdependencies_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->correlatedViewMaskCount << "," << std::endl;
    struct_body << "\t\t\t" << pcorrelated_view_masks_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "renderPassCreateInfo2");
    out << "\t\t" << "VkRenderPassCreateInfo2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSamplerReductionModeCreateInfo(std::ostream &out, const VkSamplerReductionModeCreateInfo* structInfo, Decoded_VkSamplerReductionModeCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkSamplerReductionMode(" << structInfo->reductionMode << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "samplerReductionModeCreateInfo");
    out << "\t\t" << "VkSamplerReductionModeCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSemaphoreSignalInfo(std::ostream &out, const VkSemaphoreSignalInfo* structInfo, Decoded_VkSemaphoreSignalInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->semaphore) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->value << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "semaphoreSignalInfo");
    out << "\t\t" << "VkSemaphoreSignalInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSemaphoreTypeCreateInfo(std::ostream &out, const VkSemaphoreTypeCreateInfo* structInfo, Decoded_VkSemaphoreTypeCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkSemaphoreType(" << structInfo->semaphoreType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->initialValue << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "semaphoreTypeCreateInfo");
    out << "\t\t" << "VkSemaphoreTypeCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSemaphoreWaitInfo(std::ostream &out, const VkSemaphoreWaitInfo* structInfo, Decoded_VkSemaphoreWaitInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string psemaphores_array = "NULL";
    if (metaInfo->pSemaphores.GetPointer() != NULL && structInfo->semaphoreCount > 0) {
        psemaphores_array = "psemaphores_array_" + std::to_string(consumer.GetNextId(VK_OBJECT_TYPE_SEMAPHORE));
        std::string psemaphores_values = toStringJoin(metaInfo->pSemaphores.GetPointer(),
                                                      metaInfo->pSemaphores.GetPointer() + structInfo->semaphoreCount,
                                                      [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                      ", ");
        if (structInfo->semaphoreCount == 1) {
            psemaphores_array = "&" + psemaphores_values;
        } else if (structInfo->semaphoreCount > 1) {
            out << "\t\t" << "VkSemaphore " << psemaphores_array << "[] = {" << psemaphores_values << "};" << std::endl;
        }
    }
    std::string pvalues_array = "pvalues_array_" + std::to_string(consumer.GetNextId());
    if (structInfo->semaphoreCount > 0) {
        std::string pvalues_values = toStringJoin(structInfo->pValues,
                                                  structInfo->pValues + structInfo->semaphoreCount,
                                                  [](uint64_t current) { return std::to_string(current); },
                                                  ", ");
        if (structInfo->semaphoreCount == 1) {
            pvalues_array = "&" + pvalues_values;
        } else if (structInfo->semaphoreCount > 1) {
            out << "\t\t" << "uint64_t " << pvalues_array << "[] = {" << pvalues_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkSemaphoreWaitFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->semaphoreCount << "," << std::endl;
    struct_body << "\t\t\t" << psemaphores_array << "," << std::endl;
    struct_body << "\t\t\t" << "{ *" << pvalues_array << " }" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "semaphoreWaitInfo");
    out << "\t\t" << "VkSemaphoreWaitInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSubpassBeginInfo(std::ostream &out, const VkSubpassBeginInfo* structInfo, Decoded_VkSubpassBeginInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkSubpassContents(" << structInfo->contents << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "subpassBeginInfo");
    out << "\t\t" << "VkSubpassBeginInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSubpassDependency2(std::ostream &out, const VkSubpassDependency2* structInfo, Decoded_VkSubpassDependency2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->srcSubpass << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dstSubpass << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineStageFlags(" << structInfo->srcStageMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineStageFlags(" << structInfo->dstStageMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags(" << structInfo->srcAccessMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags(" << structInfo->dstAccessMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkDependencyFlags(" << structInfo->dependencyFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->viewOffset << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "subpassDependency2");
    out << "\t\t" << "VkSubpassDependency2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSubpassDescription2(std::ostream &out, const VkSubpassDescription2* structInfo, Decoded_VkSubpassDescription2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pinput_attachments_array = "NULL";
    if (structInfo->pInputAttachments != NULL) {
        pinput_attachments_array = "pInputAttachments_" + std::to_string(consumer.GetNextId());
        std::string pinput_attachments_names;
        for (uint32_t idx = 0; idx < structInfo->inputAttachmentCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pInputAttachments + idx != NULL) {
                variable_name = GenerateStruct_VkAttachmentReference2(out,
                                                                      structInfo->pInputAttachments + idx,
                                                                      metaInfo->pInputAttachments->GetMetaStructPointer() + idx,
                                                                      consumer);
            }
            pinput_attachments_names += variable_name + ", ";
        }
        out << "\t\t" << "VkAttachmentReference2 " << pinput_attachments_array << "[] = {" << pinput_attachments_names << "};" << std::endl;
    }
    std::string pcolor_attachments_array = "NULL";
    if (structInfo->pColorAttachments != NULL) {
        pcolor_attachments_array = "pColorAttachments_" + std::to_string(consumer.GetNextId());
        std::string pcolor_attachments_names;
        for (uint32_t idx = 0; idx < structInfo->colorAttachmentCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pColorAttachments + idx != NULL) {
                variable_name = GenerateStruct_VkAttachmentReference2(out,
                                                                      structInfo->pColorAttachments + idx,
                                                                      metaInfo->pColorAttachments->GetMetaStructPointer() + idx,
                                                                      consumer);
            }
            pcolor_attachments_names += variable_name + ", ";
        }
        out << "\t\t" << "VkAttachmentReference2 " << pcolor_attachments_array << "[] = {" << pcolor_attachments_names << "};" << std::endl;
    }
    std::string presolve_attachments_array = "NULL";
    if (structInfo->pResolveAttachments != NULL) {
        presolve_attachments_array = "pResolveAttachments_" + std::to_string(consumer.GetNextId());
        std::string presolve_attachments_names;
        for (uint32_t idx = 0; idx < structInfo->colorAttachmentCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pResolveAttachments + idx != NULL) {
                variable_name = GenerateStruct_VkAttachmentReference2(out,
                                                                      structInfo->pResolveAttachments + idx,
                                                                      metaInfo->pResolveAttachments->GetMetaStructPointer() + idx,
                                                                      consumer);
            }
            presolve_attachments_names += variable_name + ", ";
        }
        out << "\t\t" << "VkAttachmentReference2 " << presolve_attachments_array << "[] = {" << presolve_attachments_names << "};" << std::endl;
    }
    std::string pdepth_stencil_attachment_struct = "NULL";
    if (structInfo->pDepthStencilAttachment != NULL) {
        pdepth_stencil_attachment_struct = GenerateStruct_VkAttachmentReference2(out,
                                                                                 structInfo->pDepthStencilAttachment,
                                                                                 metaInfo->pDepthStencilAttachment->GetMetaStructPointer(),
                                                                                 consumer);
        pdepth_stencil_attachment_struct.insert(0, "&");
    }
    std::string ppreserve_attachments_array = "NULL";
    if (structInfo->pPreserveAttachments != NULL) {
        ppreserve_attachments_array = "pPreserveAttachments_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << ppreserve_attachments_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pPreserveAttachments, structInfo->preserveAttachmentCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkSubpassDescriptionFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineBindPoint(" << structInfo->pipelineBindPoint << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->viewMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->inputAttachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pinput_attachments_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->colorAttachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pcolor_attachments_array << "," << std::endl;
    struct_body << "\t\t\t" << presolve_attachments_array << "," << std::endl;
    struct_body << "\t\t\t" << pdepth_stencil_attachment_struct << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preserveAttachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << ppreserve_attachments_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "subpassDescription2");
    out << "\t\t" << "VkSubpassDescription2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSubpassDescriptionDepthStencilResolve(std::ostream &out, const VkSubpassDescriptionDepthStencilResolve* structInfo, Decoded_VkSubpassDescriptionDepthStencilResolve* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pdepth_stencil_resolve_attachment_struct = "NULL";
    if (structInfo->pDepthStencilResolveAttachment != NULL) {
        pdepth_stencil_resolve_attachment_struct = GenerateStruct_VkAttachmentReference2(out,
                                                                                         structInfo->pDepthStencilResolveAttachment,
                                                                                         metaInfo->pDepthStencilResolveAttachment->GetMetaStructPointer(),
                                                                                         consumer);
        pdepth_stencil_resolve_attachment_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkResolveModeFlagBits(" << structInfo->depthResolveMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkResolveModeFlagBits(" << structInfo->stencilResolveMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pdepth_stencil_resolve_attachment_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "subpassDescriptionDepthStencilResolve");
    out << "\t\t" << "VkSubpassDescriptionDepthStencilResolve " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSubpassEndInfo(std::ostream &out, const VkSubpassEndInfo* structInfo, Decoded_VkSubpassEndInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "subpassEndInfo");
    out << "\t\t" << "VkSubpassEndInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkTimelineSemaphoreSubmitInfo(std::ostream &out, const VkTimelineSemaphoreSubmitInfo* structInfo, Decoded_VkTimelineSemaphoreSubmitInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pwait_semaphore_values_array = "pwait_semaphore_values_array_" + std::to_string(consumer.GetNextId());
    if (structInfo->waitSemaphoreValueCount > 0) {
        std::string pwait_semaphore_values_values = toStringJoin(structInfo->pWaitSemaphoreValues,
                                                                 structInfo->pWaitSemaphoreValues + structInfo->waitSemaphoreValueCount,
                                                                 [](uint64_t current) { return std::to_string(current); },
                                                                 ", ");
        if (structInfo->waitSemaphoreValueCount == 1) {
            pwait_semaphore_values_array = "&" + pwait_semaphore_values_values;
        } else if (structInfo->waitSemaphoreValueCount > 1) {
            out << "\t\t" << "uint64_t " << pwait_semaphore_values_array << "[] = {" << pwait_semaphore_values_values << "};" << std::endl;
        }
    }
    std::string psignal_semaphore_values_array = "psignal_semaphore_values_array_" + std::to_string(consumer.GetNextId());
    if (structInfo->signalSemaphoreValueCount > 0) {
        std::string psignal_semaphore_values_values = toStringJoin(structInfo->pSignalSemaphoreValues,
                                                                   structInfo->pSignalSemaphoreValues + structInfo->signalSemaphoreValueCount,
                                                                   [](uint64_t current) { return std::to_string(current); },
                                                                   ", ");
        if (structInfo->signalSemaphoreValueCount == 1) {
            psignal_semaphore_values_array = "&" + psignal_semaphore_values_values;
        } else if (structInfo->signalSemaphoreValueCount > 1) {
            out << "\t\t" << "uint64_t " << psignal_semaphore_values_array << "[] = {" << psignal_semaphore_values_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->waitSemaphoreValueCount << "," << std::endl;
    struct_body << "\t\t\t" << "{ *" << pwait_semaphore_values_array << " }" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->signalSemaphoreValueCount << "," << std::endl;
    struct_body << "\t\t\t" << "{ *" << psignal_semaphore_values_array << " }" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "timelineSemaphoreSubmitInfo");
    out << "\t\t" << "VkTimelineSemaphoreSubmitInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBlitImageInfo2(std::ostream &out, const VkBlitImageInfo2* structInfo, Decoded_VkBlitImageInfo2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pregions_array = "NULL";
    if (structInfo->pRegions != NULL) {
        pregions_array = "pRegions_" + std::to_string(consumer.GetNextId());
        std::string pregions_names;
        for (uint32_t idx = 0; idx < structInfo->regionCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pRegions + idx != NULL) {
                variable_name = GenerateStruct_VkImageBlit2(out,
                                                            structInfo->pRegions + idx,
                                                            metaInfo->pRegions->GetMetaStructPointer() + idx,
                                                            consumer);
            }
            pregions_names += variable_name + ", ";
        }
        out << "\t\t" << "VkImageBlit2 " << pregions_array << "[] = {" << pregions_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->srcImage) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->srcImageLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->dstImage) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->dstImageLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->regionCount << "," << std::endl;
    struct_body << "\t\t\t" << pregions_array << "," << std::endl;
    struct_body << "\t\t\t" << "VkFilter(" << structInfo->filter << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "blitImageInfo2");
    out << "\t\t" << "VkBlitImageInfo2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBufferCopy2(std::ostream &out, const VkBufferCopy2* structInfo, Decoded_VkBufferCopy2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->srcOffset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dstOffset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bufferCopy2");
    out << "\t\t" << "VkBufferCopy2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBufferImageCopy2(std::ostream &out, const VkBufferImageCopy2* structInfo, Decoded_VkBufferImageCopy2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string image_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                     &structInfo->imageSubresource,
                                                                                     metaInfo->imageSubresource,
                                                                                     consumer);
    std::string image_offset_info_var = GenerateStruct_VkOffset3D(out,
                                                                  &structInfo->imageOffset,
                                                                  metaInfo->imageOffset,
                                                                  consumer);
    std::string image_extent_info_var = GenerateStruct_VkExtent3D(out,
                                                                  &structInfo->imageExtent,
                                                                  metaInfo->imageExtent,
                                                                  consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferOffset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferRowLength << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferImageHeight << "," << std::endl;
    struct_body << "\t\t\t" << image_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << image_offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << image_extent_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bufferImageCopy2");
    out << "\t\t" << "VkBufferImageCopy2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBufferMemoryBarrier2(std::ostream &out, const VkBufferMemoryBarrier2* structInfo, Decoded_VkBufferMemoryBarrier2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineStageFlags2(" << structInfo->srcStageMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags2(" << structInfo->srcAccessMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineStageFlags2(" << structInfo->dstStageMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags2(" << structInfo->dstAccessMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->srcQueueFamilyIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dstQueueFamilyIndex << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->buffer) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->offset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bufferMemoryBarrier2");
    out << "\t\t" << "VkBufferMemoryBarrier2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCommandBufferInheritanceRenderingInfo(std::ostream &out, const VkCommandBufferInheritanceRenderingInfo* structInfo, Decoded_VkCommandBufferInheritanceRenderingInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pcolor_attachment_formats_values;
    std::string pcolor_attachment_formats_array = "NULL";
    if (structInfo->pColorAttachmentFormats != NULL) {
        for (uint32_t idx = 0; idx < structInfo->colorAttachmentCount; idx++) {
            pcolor_attachment_formats_values += util::ToString<VkFormat>(structInfo->pColorAttachmentFormats[idx]) + ", ";
        }
        pcolor_attachment_formats_array = "pColorAttachmentFormats_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkFormat " << pcolor_attachment_formats_array << "[] = {" << pcolor_attachment_formats_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkRenderingFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->viewMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->colorAttachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pcolor_attachment_formats_array << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->depthAttachmentFormat << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->stencilAttachmentFormat << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlagBits(" << structInfo->rasterizationSamples << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "commandBufferInheritanceRenderingInfo");
    out << "\t\t" << "VkCommandBufferInheritanceRenderingInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCommandBufferSubmitInfo(std::ostream &out, const VkCommandBufferSubmitInfo* structInfo, Decoded_VkCommandBufferSubmitInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->commandBuffer) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceMask << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "commandBufferSubmitInfo");
    out << "\t\t" << "VkCommandBufferSubmitInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCopyBufferInfo2(std::ostream &out, const VkCopyBufferInfo2* structInfo, Decoded_VkCopyBufferInfo2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pregions_array = "NULL";
    if (structInfo->pRegions != NULL) {
        pregions_array = "pRegions_" + std::to_string(consumer.GetNextId());
        std::string pregions_names;
        for (uint32_t idx = 0; idx < structInfo->regionCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pRegions + idx != NULL) {
                variable_name = GenerateStruct_VkBufferCopy2(out,
                                                             structInfo->pRegions + idx,
                                                             metaInfo->pRegions->GetMetaStructPointer() + idx,
                                                             consumer);
            }
            pregions_names += variable_name + ", ";
        }
        out << "\t\t" << "VkBufferCopy2 " << pregions_array << "[] = {" << pregions_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->srcBuffer) << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->dstBuffer) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->regionCount << "," << std::endl;
    struct_body << "\t\t\t" << pregions_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "copyBufferInfo2");
    out << "\t\t" << "VkCopyBufferInfo2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCopyBufferToImageInfo2(std::ostream &out, const VkCopyBufferToImageInfo2* structInfo, Decoded_VkCopyBufferToImageInfo2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pregions_array = "NULL";
    if (structInfo->pRegions != NULL) {
        pregions_array = "pRegions_" + std::to_string(consumer.GetNextId());
        std::string pregions_names;
        for (uint32_t idx = 0; idx < structInfo->regionCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pRegions + idx != NULL) {
                variable_name = GenerateStruct_VkBufferImageCopy2(out,
                                                                  structInfo->pRegions + idx,
                                                                  metaInfo->pRegions->GetMetaStructPointer() + idx,
                                                                  consumer);
            }
            pregions_names += variable_name + ", ";
        }
        out << "\t\t" << "VkBufferImageCopy2 " << pregions_array << "[] = {" << pregions_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->srcBuffer) << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->dstImage) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->dstImageLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->regionCount << "," << std::endl;
    struct_body << "\t\t\t" << pregions_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "copyBufferToImageInfo2");
    out << "\t\t" << "VkCopyBufferToImageInfo2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCopyImageInfo2(std::ostream &out, const VkCopyImageInfo2* structInfo, Decoded_VkCopyImageInfo2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pregions_array = "NULL";
    if (structInfo->pRegions != NULL) {
        pregions_array = "pRegions_" + std::to_string(consumer.GetNextId());
        std::string pregions_names;
        for (uint32_t idx = 0; idx < structInfo->regionCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pRegions + idx != NULL) {
                variable_name = GenerateStruct_VkImageCopy2(out,
                                                            structInfo->pRegions + idx,
                                                            metaInfo->pRegions->GetMetaStructPointer() + idx,
                                                            consumer);
            }
            pregions_names += variable_name + ", ";
        }
        out << "\t\t" << "VkImageCopy2 " << pregions_array << "[] = {" << pregions_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->srcImage) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->srcImageLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->dstImage) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->dstImageLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->regionCount << "," << std::endl;
    struct_body << "\t\t\t" << pregions_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "copyImageInfo2");
    out << "\t\t" << "VkCopyImageInfo2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCopyImageToBufferInfo2(std::ostream &out, const VkCopyImageToBufferInfo2* structInfo, Decoded_VkCopyImageToBufferInfo2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pregions_array = "NULL";
    if (structInfo->pRegions != NULL) {
        pregions_array = "pRegions_" + std::to_string(consumer.GetNextId());
        std::string pregions_names;
        for (uint32_t idx = 0; idx < structInfo->regionCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pRegions + idx != NULL) {
                variable_name = GenerateStruct_VkBufferImageCopy2(out,
                                                                  structInfo->pRegions + idx,
                                                                  metaInfo->pRegions->GetMetaStructPointer() + idx,
                                                                  consumer);
            }
            pregions_names += variable_name + ", ";
        }
        out << "\t\t" << "VkBufferImageCopy2 " << pregions_array << "[] = {" << pregions_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->srcImage) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->srcImageLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->dstBuffer) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->regionCount << "," << std::endl;
    struct_body << "\t\t\t" << pregions_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "copyImageToBufferInfo2");
    out << "\t\t" << "VkCopyImageToBufferInfo2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDependencyInfo(std::ostream &out, const VkDependencyInfo* structInfo, Decoded_VkDependencyInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pmemory_barriers_array = "NULL";
    if (structInfo->pMemoryBarriers != NULL) {
        pmemory_barriers_array = "pMemoryBarriers_" + std::to_string(consumer.GetNextId());
        std::string pmemory_barriers_names;
        for (uint32_t idx = 0; idx < structInfo->memoryBarrierCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pMemoryBarriers + idx != NULL) {
                variable_name = GenerateStruct_VkMemoryBarrier2(out,
                                                                structInfo->pMemoryBarriers + idx,
                                                                metaInfo->pMemoryBarriers->GetMetaStructPointer() + idx,
                                                                consumer);
            }
            pmemory_barriers_names += variable_name + ", ";
        }
        out << "\t\t" << "VkMemoryBarrier2 " << pmemory_barriers_array << "[] = {" << pmemory_barriers_names << "};" << std::endl;
    }
    std::string pbuffer_memory_barriers_array = "NULL";
    if (structInfo->pBufferMemoryBarriers != NULL) {
        pbuffer_memory_barriers_array = "pBufferMemoryBarriers_" + std::to_string(consumer.GetNextId());
        std::string pbuffer_memory_barriers_names;
        for (uint32_t idx = 0; idx < structInfo->bufferMemoryBarrierCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pBufferMemoryBarriers + idx != NULL) {
                variable_name = GenerateStruct_VkBufferMemoryBarrier2(out,
                                                                      structInfo->pBufferMemoryBarriers + idx,
                                                                      metaInfo->pBufferMemoryBarriers->GetMetaStructPointer() + idx,
                                                                      consumer);
            }
            pbuffer_memory_barriers_names += variable_name + ", ";
        }
        out << "\t\t" << "VkBufferMemoryBarrier2 " << pbuffer_memory_barriers_array << "[] = {" << pbuffer_memory_barriers_names << "};" << std::endl;
    }
    std::string pimage_memory_barriers_array = "NULL";
    if (structInfo->pImageMemoryBarriers != NULL) {
        pimage_memory_barriers_array = "pImageMemoryBarriers_" + std::to_string(consumer.GetNextId());
        std::string pimage_memory_barriers_names;
        for (uint32_t idx = 0; idx < structInfo->imageMemoryBarrierCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pImageMemoryBarriers + idx != NULL) {
                variable_name = GenerateStruct_VkImageMemoryBarrier2(out,
                                                                     structInfo->pImageMemoryBarriers + idx,
                                                                     metaInfo->pImageMemoryBarriers->GetMetaStructPointer() + idx,
                                                                     consumer);
            }
            pimage_memory_barriers_names += variable_name + ", ";
        }
        out << "\t\t" << "VkImageMemoryBarrier2 " << pimage_memory_barriers_array << "[] = {" << pimage_memory_barriers_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDependencyFlags(" << structInfo->dependencyFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->memoryBarrierCount << "," << std::endl;
    struct_body << "\t\t\t" << pmemory_barriers_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferMemoryBarrierCount << "," << std::endl;
    struct_body << "\t\t\t" << pbuffer_memory_barriers_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->imageMemoryBarrierCount << "," << std::endl;
    struct_body << "\t\t\t" << pimage_memory_barriers_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "dependencyInfo");
    out << "\t\t" << "VkDependencyInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDescriptorPoolInlineUniformBlockCreateInfo(std::ostream &out, const VkDescriptorPoolInlineUniformBlockCreateInfo* structInfo, Decoded_VkDescriptorPoolInlineUniformBlockCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxInlineUniformBlockBindings << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "descriptorPoolInlineUniformBlockCreateInfo");
    out << "\t\t" << "VkDescriptorPoolInlineUniformBlockCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceBufferMemoryRequirements(std::ostream &out, const VkDeviceBufferMemoryRequirements* structInfo, Decoded_VkDeviceBufferMemoryRequirements* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pcreate_info_struct = "NULL";
    if (structInfo->pCreateInfo != NULL) {
        pcreate_info_struct = GenerateStruct_VkBufferCreateInfo(out,
                                                                structInfo->pCreateInfo,
                                                                metaInfo->pCreateInfo->GetMetaStructPointer(),
                                                                consumer);
        pcreate_info_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pcreate_info_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceBufferMemoryRequirements");
    out << "\t\t" << "VkDeviceBufferMemoryRequirements " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceImageMemoryRequirements(std::ostream &out, const VkDeviceImageMemoryRequirements* structInfo, Decoded_VkDeviceImageMemoryRequirements* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pcreate_info_struct = "NULL";
    if (structInfo->pCreateInfo != NULL) {
        pcreate_info_struct = GenerateStruct_VkImageCreateInfo(out,
                                                               structInfo->pCreateInfo,
                                                               metaInfo->pCreateInfo->GetMetaStructPointer(),
                                                               consumer);
        pcreate_info_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pcreate_info_struct << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageAspectFlagBits(" << structInfo->planeAspect << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceImageMemoryRequirements");
    out << "\t\t" << "VkDeviceImageMemoryRequirements " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDevicePrivateDataCreateInfo(std::ostream &out, const VkDevicePrivateDataCreateInfo* structInfo, Decoded_VkDevicePrivateDataCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->privateDataSlotRequestCount << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "devicePrivateDataCreateInfo");
    out << "\t\t" << "VkDevicePrivateDataCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkFormatProperties3(std::ostream &out, const VkFormatProperties3* structInfo, Decoded_VkFormatProperties3* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormatFeatureFlags2(" << structInfo->linearTilingFeatures << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormatFeatureFlags2(" << structInfo->optimalTilingFeatures << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormatFeatureFlags2(" << structInfo->bufferFeatures << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "formatProperties3");
    out << "\t\t" << "VkFormatProperties3 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageBlit2(std::ostream &out, const VkImageBlit2* structInfo, Decoded_VkImageBlit2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string src_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                   &structInfo->srcSubresource,
                                                                                   metaInfo->srcSubresource,
                                                                                   consumer);
    std::string dst_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                   &structInfo->dstSubresource,
                                                                                   metaInfo->dstSubresource,
                                                                                   consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << src_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const VkOffset3D*>(&structInfo->srcOffsets[0]), 2) << "," << std::endl;
    struct_body << "\t\t\t" << dst_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const VkOffset3D*>(&structInfo->dstOffsets[0]), 2) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageBlit2");
    out << "\t\t" << "VkImageBlit2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageCopy2(std::ostream &out, const VkImageCopy2* structInfo, Decoded_VkImageCopy2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string src_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                   &structInfo->srcSubresource,
                                                                                   metaInfo->srcSubresource,
                                                                                   consumer);
    std::string src_offset_info_var = GenerateStruct_VkOffset3D(out,
                                                                &structInfo->srcOffset,
                                                                metaInfo->srcOffset,
                                                                consumer);
    std::string dst_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                   &structInfo->dstSubresource,
                                                                                   metaInfo->dstSubresource,
                                                                                   consumer);
    std::string dst_offset_info_var = GenerateStruct_VkOffset3D(out,
                                                                &structInfo->dstOffset,
                                                                metaInfo->dstOffset,
                                                                consumer);
    std::string extent_info_var = GenerateStruct_VkExtent3D(out,
                                                            &structInfo->extent,
                                                            metaInfo->extent,
                                                            consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << src_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << src_offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << dst_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << dst_offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << extent_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageCopy2");
    out << "\t\t" << "VkImageCopy2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageMemoryBarrier2(std::ostream &out, const VkImageMemoryBarrier2* structInfo, Decoded_VkImageMemoryBarrier2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string subresource_range_info_var = GenerateStruct_VkImageSubresourceRange(out,
                                                                                    &structInfo->subresourceRange,
                                                                                    metaInfo->subresourceRange,
                                                                                    consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineStageFlags2(" << structInfo->srcStageMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags2(" << structInfo->srcAccessMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineStageFlags2(" << structInfo->dstStageMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags2(" << structInfo->dstAccessMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->oldLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->newLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->srcQueueFamilyIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dstQueueFamilyIndex << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->image) << "," << std::endl;
    struct_body << "\t\t\t" << subresource_range_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageMemoryBarrier2");
    out << "\t\t" << "VkImageMemoryBarrier2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageResolve2(std::ostream &out, const VkImageResolve2* structInfo, Decoded_VkImageResolve2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string src_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                   &structInfo->srcSubresource,
                                                                                   metaInfo->srcSubresource,
                                                                                   consumer);
    std::string src_offset_info_var = GenerateStruct_VkOffset3D(out,
                                                                &structInfo->srcOffset,
                                                                metaInfo->srcOffset,
                                                                consumer);
    std::string dst_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                   &structInfo->dstSubresource,
                                                                                   metaInfo->dstSubresource,
                                                                                   consumer);
    std::string dst_offset_info_var = GenerateStruct_VkOffset3D(out,
                                                                &structInfo->dstOffset,
                                                                metaInfo->dstOffset,
                                                                consumer);
    std::string extent_info_var = GenerateStruct_VkExtent3D(out,
                                                            &structInfo->extent,
                                                            metaInfo->extent,
                                                            consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << src_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << src_offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << dst_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << dst_offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << extent_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageResolve2");
    out << "\t\t" << "VkImageResolve2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryBarrier2(std::ostream &out, const VkMemoryBarrier2* structInfo, Decoded_VkMemoryBarrier2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineStageFlags2(" << structInfo->srcStageMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags2(" << structInfo->srcAccessMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineStageFlags2(" << structInfo->dstStageMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags2(" << structInfo->dstAccessMask << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryBarrier2");
    out << "\t\t" << "VkMemoryBarrier2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceDynamicRenderingFeatures(std::ostream &out, const VkPhysicalDeviceDynamicRenderingFeatures* structInfo, Decoded_VkPhysicalDeviceDynamicRenderingFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dynamicRendering << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceDynamicRenderingFeatures");
    out << "\t\t" << "VkPhysicalDeviceDynamicRenderingFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceImageRobustnessFeatures(std::ostream &out, const VkPhysicalDeviceImageRobustnessFeatures* structInfo, Decoded_VkPhysicalDeviceImageRobustnessFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->robustImageAccess << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceImageRobustnessFeatures");
    out << "\t\t" << "VkPhysicalDeviceImageRobustnessFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceInlineUniformBlockFeatures(std::ostream &out, const VkPhysicalDeviceInlineUniformBlockFeatures* structInfo, Decoded_VkPhysicalDeviceInlineUniformBlockFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->inlineUniformBlock << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingInlineUniformBlockUpdateAfterBind << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceInlineUniformBlockFeatures");
    out << "\t\t" << "VkPhysicalDeviceInlineUniformBlockFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceInlineUniformBlockProperties(std::ostream &out, const VkPhysicalDeviceInlineUniformBlockProperties* structInfo, Decoded_VkPhysicalDeviceInlineUniformBlockProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxInlineUniformBlockSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorInlineUniformBlocks << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetInlineUniformBlocks << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindInlineUniformBlocks << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceInlineUniformBlockProperties");
    out << "\t\t" << "VkPhysicalDeviceInlineUniformBlockProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMaintenance4Features(std::ostream &out, const VkPhysicalDeviceMaintenance4Features* structInfo, Decoded_VkPhysicalDeviceMaintenance4Features* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maintenance4 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMaintenance4Features");
    out << "\t\t" << "VkPhysicalDeviceMaintenance4Features " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMaintenance4Properties(std::ostream &out, const VkPhysicalDeviceMaintenance4Properties* structInfo, Decoded_VkPhysicalDeviceMaintenance4Properties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxBufferSize << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMaintenance4Properties");
    out << "\t\t" << "VkPhysicalDeviceMaintenance4Properties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePipelineCreationCacheControlFeatures(std::ostream &out, const VkPhysicalDevicePipelineCreationCacheControlFeatures* structInfo, Decoded_VkPhysicalDevicePipelineCreationCacheControlFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineCreationCacheControl << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePipelineCreationCacheControlFeatures");
    out << "\t\t" << "VkPhysicalDevicePipelineCreationCacheControlFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePrivateDataFeatures(std::ostream &out, const VkPhysicalDevicePrivateDataFeatures* structInfo, Decoded_VkPhysicalDevicePrivateDataFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->privateData << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePrivateDataFeatures");
    out << "\t\t" << "VkPhysicalDevicePrivateDataFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(std::ostream &out, const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* structInfo, Decoded_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDemoteToHelperInvocation << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderDemoteToHelperInvocationFeatures");
    out << "\t\t" << "VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderIntegerDotProductFeatures(std::ostream &out, const VkPhysicalDeviceShaderIntegerDotProductFeatures* structInfo, Decoded_VkPhysicalDeviceShaderIntegerDotProductFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderIntegerDotProduct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderIntegerDotProductFeatures");
    out << "\t\t" << "VkPhysicalDeviceShaderIntegerDotProductFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderIntegerDotProductProperties(std::ostream &out, const VkPhysicalDeviceShaderIntegerDotProductProperties* structInfo, Decoded_VkPhysicalDeviceShaderIntegerDotProductProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct8BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct8BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct8BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct4x8BitPackedUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct4x8BitPackedSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct4x8BitPackedMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct16BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct16BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct16BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct32BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct32BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct32BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct64BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct64BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct64BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating8BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating16BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating32BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating64BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderIntegerDotProductProperties");
    out << "\t\t" << "VkPhysicalDeviceShaderIntegerDotProductProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderTerminateInvocationFeatures(std::ostream &out, const VkPhysicalDeviceShaderTerminateInvocationFeatures* structInfo, Decoded_VkPhysicalDeviceShaderTerminateInvocationFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderTerminateInvocation << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderTerminateInvocationFeatures");
    out << "\t\t" << "VkPhysicalDeviceShaderTerminateInvocationFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceSubgroupSizeControlFeatures(std::ostream &out, const VkPhysicalDeviceSubgroupSizeControlFeatures* structInfo, Decoded_VkPhysicalDeviceSubgroupSizeControlFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subgroupSizeControl << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->computeFullSubgroups << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceSubgroupSizeControlFeatures");
    out << "\t\t" << "VkPhysicalDeviceSubgroupSizeControlFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceSubgroupSizeControlProperties(std::ostream &out, const VkPhysicalDeviceSubgroupSizeControlProperties* structInfo, Decoded_VkPhysicalDeviceSubgroupSizeControlProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minSubgroupSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxSubgroupSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxComputeWorkgroupSubgroups << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderStageFlags(" << structInfo->requiredSubgroupSizeStages << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceSubgroupSizeControlProperties");
    out << "\t\t" << "VkPhysicalDeviceSubgroupSizeControlProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceSynchronization2Features(std::ostream &out, const VkPhysicalDeviceSynchronization2Features* structInfo, Decoded_VkPhysicalDeviceSynchronization2Features* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->synchronization2 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceSynchronization2Features");
    out << "\t\t" << "VkPhysicalDeviceSynchronization2Features " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceTexelBufferAlignmentProperties(std::ostream &out, const VkPhysicalDeviceTexelBufferAlignmentProperties* structInfo, Decoded_VkPhysicalDeviceTexelBufferAlignmentProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->storageTexelBufferOffsetAlignmentBytes << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->storageTexelBufferOffsetSingleTexelAlignment << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->uniformTexelBufferOffsetAlignmentBytes << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->uniformTexelBufferOffsetSingleTexelAlignment << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceTexelBufferAlignmentProperties");
    out << "\t\t" << "VkPhysicalDeviceTexelBufferAlignmentProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(std::ostream &out, const VkPhysicalDeviceTextureCompressionASTCHDRFeatures* structInfo, Decoded_VkPhysicalDeviceTextureCompressionASTCHDRFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->textureCompressionASTC_HDR << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceTextureCompressionASTCHDRFeatures");
    out << "\t\t" << "VkPhysicalDeviceTextureCompressionASTCHDRFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceToolProperties(std::ostream &out, const VkPhysicalDeviceToolProperties* structInfo, Decoded_VkPhysicalDeviceToolProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->name) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->version) << "," << std::endl;
    struct_body << "\t\t\t" << "VkToolPurposeFlags(" << structInfo->purposes << ")" << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->description) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->layer) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceToolProperties");
    out << "\t\t" << "VkPhysicalDeviceToolProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVulkan13Features(std::ostream &out, const VkPhysicalDeviceVulkan13Features* structInfo, Decoded_VkPhysicalDeviceVulkan13Features* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->robustImageAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->inlineUniformBlock << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorBindingInlineUniformBlockUpdateAfterBind << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineCreationCacheControl << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->privateData << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDemoteToHelperInvocation << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderTerminateInvocation << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subgroupSizeControl << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->computeFullSubgroups << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->synchronization2 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->textureCompressionASTC_HDR << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderZeroInitializeWorkgroupMemory << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dynamicRendering << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderIntegerDotProduct << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maintenance4 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVulkan13Features");
    out << "\t\t" << "VkPhysicalDeviceVulkan13Features " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVulkan13Properties(std::ostream &out, const VkPhysicalDeviceVulkan13Properties* structInfo, Decoded_VkPhysicalDeviceVulkan13Properties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minSubgroupSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxSubgroupSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxComputeWorkgroupSubgroups << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderStageFlags(" << structInfo->requiredSubgroupSizeStages << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxInlineUniformBlockSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorInlineUniformBlocks << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetInlineUniformBlocks << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindInlineUniformBlocks << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxInlineUniformTotalSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct8BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct8BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct8BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct4x8BitPackedUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct4x8BitPackedSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct4x8BitPackedMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct16BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct16BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct16BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct32BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct32BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct32BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct64BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct64BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProduct64BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating8BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating16BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating32BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating64BitSignedAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->storageTexelBufferOffsetAlignmentBytes << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->storageTexelBufferOffsetSingleTexelAlignment << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->uniformTexelBufferOffsetAlignmentBytes << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->uniformTexelBufferOffsetSingleTexelAlignment << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxBufferSize << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVulkan13Properties");
    out << "\t\t" << "VkPhysicalDeviceVulkan13Properties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(std::ostream &out, const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* structInfo, Decoded_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderZeroInitializeWorkgroupMemory << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceZeroInitializeWorkgroupMemoryFeatures");
    out << "\t\t" << "VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineCreationFeedback(std::ostream &out, const VkPipelineCreationFeedback* structInfo, Decoded_VkPipelineCreationFeedback* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "VkPipelineCreationFeedbackFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->duration << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineCreationFeedback");
    out << "\t\t" << "VkPipelineCreationFeedback " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineCreationFeedbackCreateInfo(std::ostream &out, const VkPipelineCreationFeedbackCreateInfo* structInfo, Decoded_VkPipelineCreationFeedbackCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string ppipeline_creation_feedback_name = "NULL";
    if (structInfo->pPipelineCreationFeedback != NULL) {
        ppipeline_creation_feedback_name = GenerateStruct_VkPipelineCreationFeedback(out,
                                                                                     structInfo->pPipelineCreationFeedback,
                                                                                     metaInfo->pPipelineCreationFeedback->GetMetaStructPointer(),
                                                                                     consumer);
        ppipeline_creation_feedback_name.insert(0, "&");
    }
    std::string ppipeline_stage_creation_feedbacks_array = "NULL";
    if (structInfo->pPipelineStageCreationFeedbacks != NULL) {
        ppipeline_stage_creation_feedbacks_array = "pPipelineStageCreationFeedbacks_" + std::to_string(consumer.GetNextId());
        std::string ppipeline_stage_creation_feedbacks_names;
        for (uint32_t idx = 0; idx < structInfo->pipelineStageCreationFeedbackCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pPipelineStageCreationFeedbacks + idx != NULL) {
                variable_name = GenerateStruct_VkPipelineCreationFeedback(out,
                                                                          structInfo->pPipelineStageCreationFeedbacks + idx,
                                                                          metaInfo->pPipelineStageCreationFeedbacks->GetMetaStructPointer() + idx,
                                                                          consumer);
            }
            ppipeline_stage_creation_feedbacks_names += variable_name + ", ";
        }
        out << "\t\t" << "VkPipelineCreationFeedback " << ppipeline_stage_creation_feedbacks_array << "[] = {" << ppipeline_stage_creation_feedbacks_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << ppipeline_creation_feedback_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineStageCreationFeedbackCount << "," << std::endl;
    struct_body << "\t\t\t" << ppipeline_stage_creation_feedbacks_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineCreationFeedbackCreateInfo");
    out << "\t\t" << "VkPipelineCreationFeedbackCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineRenderingCreateInfo(std::ostream &out, const VkPipelineRenderingCreateInfo* structInfo, Decoded_VkPipelineRenderingCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pcolor_attachment_formats_values;
    std::string pcolor_attachment_formats_array = "NULL";
    if (structInfo->pColorAttachmentFormats != NULL) {
        for (uint32_t idx = 0; idx < structInfo->colorAttachmentCount; idx++) {
            pcolor_attachment_formats_values += util::ToString<VkFormat>(structInfo->pColorAttachmentFormats[idx]) + ", ";
        }
        pcolor_attachment_formats_array = "pColorAttachmentFormats_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkFormat " << pcolor_attachment_formats_array << "[] = {" << pcolor_attachment_formats_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->viewMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->colorAttachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pcolor_attachment_formats_array << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->depthAttachmentFormat << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->stencilAttachmentFormat << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineRenderingCreateInfo");
    out << "\t\t" << "VkPipelineRenderingCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(std::ostream &out, const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* structInfo, Decoded_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->requiredSubgroupSize << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineShaderStageRequiredSubgroupSizeCreateInfo");
    out << "\t\t" << "VkPipelineShaderStageRequiredSubgroupSizeCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPrivateDataSlotCreateInfo(std::ostream &out, const VkPrivateDataSlotCreateInfo* structInfo, Decoded_VkPrivateDataSlotCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPrivateDataSlotCreateFlags(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "privateDataSlotCreateInfo");
    out << "\t\t" << "VkPrivateDataSlotCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRenderingAttachmentInfo(std::ostream &out, const VkRenderingAttachmentInfo* structInfo, Decoded_VkRenderingAttachmentInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->imageView) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->imageLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkResolveModeFlagBits(" << structInfo->resolveMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->resolveImageView) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->resolveImageLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAttachmentLoadOp(" << structInfo->loadOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAttachmentStoreOp(" << structInfo->storeOp << ")" << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(structInfo->clearValue) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "renderingAttachmentInfo");
    out << "\t\t" << "VkRenderingAttachmentInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRenderingInfo(std::ostream &out, const VkRenderingInfo* structInfo, Decoded_VkRenderingInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string render_area_info_var = GenerateStruct_VkRect2D(out,
                                                               &structInfo->renderArea,
                                                               metaInfo->renderArea,
                                                               consumer);
    std::string pcolor_attachments_array = "NULL";
    if (structInfo->pColorAttachments != NULL) {
        pcolor_attachments_array = "pColorAttachments_" + std::to_string(consumer.GetNextId());
        std::string pcolor_attachments_names;
        for (uint32_t idx = 0; idx < structInfo->colorAttachmentCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pColorAttachments + idx != NULL) {
                variable_name = GenerateStruct_VkRenderingAttachmentInfo(out,
                                                                         structInfo->pColorAttachments + idx,
                                                                         metaInfo->pColorAttachments->GetMetaStructPointer() + idx,
                                                                         consumer);
            }
            pcolor_attachments_names += variable_name + ", ";
        }
        out << "\t\t" << "VkRenderingAttachmentInfo " << pcolor_attachments_array << "[] = {" << pcolor_attachments_names << "};" << std::endl;
    }
    std::string pdepth_attachment_struct = "NULL";
    if (structInfo->pDepthAttachment != NULL) {
        pdepth_attachment_struct = GenerateStruct_VkRenderingAttachmentInfo(out,
                                                                            structInfo->pDepthAttachment,
                                                                            metaInfo->pDepthAttachment->GetMetaStructPointer(),
                                                                            consumer);
        pdepth_attachment_struct.insert(0, "&");
    }
    std::string pstencil_attachment_struct = "NULL";
    if (structInfo->pStencilAttachment != NULL) {
        pstencil_attachment_struct = GenerateStruct_VkRenderingAttachmentInfo(out,
                                                                              structInfo->pStencilAttachment,
                                                                              metaInfo->pStencilAttachment->GetMetaStructPointer(),
                                                                              consumer);
        pstencil_attachment_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkRenderingFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << render_area_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->layerCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->viewMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->colorAttachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pcolor_attachments_array << "," << std::endl;
    struct_body << "\t\t\t" << pdepth_attachment_struct << "," << std::endl;
    struct_body << "\t\t\t" << pstencil_attachment_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "renderingInfo");
    out << "\t\t" << "VkRenderingInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkResolveImageInfo2(std::ostream &out, const VkResolveImageInfo2* structInfo, Decoded_VkResolveImageInfo2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pregions_array = "NULL";
    if (structInfo->pRegions != NULL) {
        pregions_array = "pRegions_" + std::to_string(consumer.GetNextId());
        std::string pregions_names;
        for (uint32_t idx = 0; idx < structInfo->regionCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pRegions + idx != NULL) {
                variable_name = GenerateStruct_VkImageResolve2(out,
                                                               structInfo->pRegions + idx,
                                                               metaInfo->pRegions->GetMetaStructPointer() + idx,
                                                               consumer);
            }
            pregions_names += variable_name + ", ";
        }
        out << "\t\t" << "VkImageResolve2 " << pregions_array << "[] = {" << pregions_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->srcImage) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->srcImageLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->dstImage) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->dstImageLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->regionCount << "," << std::endl;
    struct_body << "\t\t\t" << pregions_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "resolveImageInfo2");
    out << "\t\t" << "VkResolveImageInfo2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSemaphoreSubmitInfo(std::ostream &out, const VkSemaphoreSubmitInfo* structInfo, Decoded_VkSemaphoreSubmitInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->semaphore) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->value << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineStageFlags2(" << structInfo->stageMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "semaphoreSubmitInfo");
    out << "\t\t" << "VkSemaphoreSubmitInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkWriteDescriptorSetInlineUniformBlock(std::ostream &out, const VkWriteDescriptorSetInlineUniformBlock* structInfo, Decoded_VkWriteDescriptorSetInlineUniformBlock* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pdata_array = "NULL";
    if (structInfo->pData != NULL) {
        std::string pdata_values;
        for (uint32_t idx0 = 0; idx0 < structInfo->dataSize; ++idx0) {
            pdata_values += std::to_string(reinterpret_cast<const uint8_t*>(structInfo->pData)[idx0]) + ", ";
        }
        pdata_array = "pData_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint8_t " << pdata_array << "[] = {" << pdata_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dataSize << "," << std::endl;
    struct_body << "\t\t\t" << pdata_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "writeDescriptorSetInlineUniformBlock");
    out << "\t\t" << "VkWriteDescriptorSetInlineUniformBlock " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBindDescriptorSetsInfo(std::ostream &out, const VkBindDescriptorSetsInfo* structInfo, Decoded_VkBindDescriptorSetsInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pdescriptor_sets_array = "NULL";
    if (metaInfo->pDescriptorSets.GetPointer() != NULL && structInfo->descriptorSetCount > 0) {
        pdescriptor_sets_array = "pdescriptor_sets_array_" + std::to_string(consumer.GetNextId(VK_OBJECT_TYPE_DESCRIPTOR_SET));
        std::string pdescriptor_sets_values = toStringJoin(metaInfo->pDescriptorSets.GetPointer(),
                                                           metaInfo->pDescriptorSets.GetPointer() + structInfo->descriptorSetCount,
                                                           [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                           ", ");
        if (structInfo->descriptorSetCount == 1) {
            pdescriptor_sets_array = "&" + pdescriptor_sets_values;
        } else if (structInfo->descriptorSetCount > 1) {
            out << "\t\t" << "VkDescriptorSet " << pdescriptor_sets_array << "[] = {" << pdescriptor_sets_values << "};" << std::endl;
        }
    }
    std::string pdynamic_offsets_array = "NULL";
    if (structInfo->pDynamicOffsets != NULL) {
        pdynamic_offsets_array = "pDynamicOffsets_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pdynamic_offsets_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pDynamicOffsets, structInfo->dynamicOffsetCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderStageFlags(" << structInfo->stageFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->layout) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->firstSet << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorSetCount << "," << std::endl;
    struct_body << "\t\t\t" << pdescriptor_sets_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dynamicOffsetCount << "," << std::endl;
    struct_body << "\t\t\t" << pdynamic_offsets_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bindDescriptorSetsInfo");
    out << "\t\t" << "VkBindDescriptorSetsInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBindMemoryStatus(std::ostream &out, const VkBindMemoryStatus* structInfo, Decoded_VkBindMemoryStatus* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    out << "\t\t" << "// TODO: Support pResult (non-struct output) argument." << std::endl;
    std::string variable_name = consumer.AddStruct(struct_body, "bindMemoryStatus");
    out << "\t\t" << "VkBindMemoryStatus " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBufferUsageFlags2CreateInfo(std::ostream &out, const VkBufferUsageFlags2CreateInfo* structInfo, Decoded_VkBufferUsageFlags2CreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkBufferUsageFlags2(" << structInfo->usage << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bufferUsageFlags2CreateInfo");
    out << "\t\t" << "VkBufferUsageFlags2CreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCopyImageToImageInfo(std::ostream &out, const VkCopyImageToImageInfo* structInfo, Decoded_VkCopyImageToImageInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pregions_array = "NULL";
    if (structInfo->pRegions != NULL) {
        pregions_array = "pRegions_" + std::to_string(consumer.GetNextId());
        std::string pregions_names;
        for (uint32_t idx = 0; idx < structInfo->regionCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pRegions + idx != NULL) {
                variable_name = GenerateStruct_VkImageCopy2(out,
                                                            structInfo->pRegions + idx,
                                                            metaInfo->pRegions->GetMetaStructPointer() + idx,
                                                            consumer);
            }
            pregions_names += variable_name + ", ";
        }
        out << "\t\t" << "VkImageCopy2 " << pregions_array << "[] = {" << pregions_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkHostImageCopyFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->srcImage) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->srcImageLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->dstImage) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->dstImageLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->regionCount << "," << std::endl;
    struct_body << "\t\t\t" << pregions_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "copyImageToImageInfo");
    out << "\t\t" << "VkCopyImageToImageInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceImageSubresourceInfo(std::ostream &out, const VkDeviceImageSubresourceInfo* structInfo, Decoded_VkDeviceImageSubresourceInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pcreate_info_struct = "NULL";
    if (structInfo->pCreateInfo != NULL) {
        pcreate_info_struct = GenerateStruct_VkImageCreateInfo(out,
                                                               structInfo->pCreateInfo,
                                                               metaInfo->pCreateInfo->GetMetaStructPointer(),
                                                               consumer);
        pcreate_info_struct.insert(0, "&");
    }
    std::string psubresource_struct = "NULL";
    if (structInfo->pSubresource != NULL) {
        psubresource_struct = GenerateStruct_VkImageSubresource2(out,
                                                                 structInfo->pSubresource,
                                                                 metaInfo->pSubresource->GetMetaStructPointer(),
                                                                 consumer);
        psubresource_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pcreate_info_struct << "," << std::endl;
    struct_body << "\t\t\t" << psubresource_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceImageSubresourceInfo");
    out << "\t\t" << "VkDeviceImageSubresourceInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceQueueGlobalPriorityCreateInfo(std::ostream &out, const VkDeviceQueueGlobalPriorityCreateInfo* structInfo, Decoded_VkDeviceQueueGlobalPriorityCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkQueueGlobalPriority(" << structInfo->globalPriority << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceQueueGlobalPriorityCreateInfo");
    out << "\t\t" << "VkDeviceQueueGlobalPriorityCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkHostImageCopyDevicePerformanceQuery(std::ostream &out, const VkHostImageCopyDevicePerformanceQuery* structInfo, Decoded_VkHostImageCopyDevicePerformanceQuery* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->optimalDeviceAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->identicalMemoryLayout << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "hostImageCopyDevicePerformanceQuery");
    out << "\t\t" << "VkHostImageCopyDevicePerformanceQuery " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkHostImageLayoutTransitionInfo(std::ostream &out, const VkHostImageLayoutTransitionInfo* structInfo, Decoded_VkHostImageLayoutTransitionInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string subresource_range_info_var = GenerateStruct_VkImageSubresourceRange(out,
                                                                                    &structInfo->subresourceRange,
                                                                                    metaInfo->subresourceRange,
                                                                                    consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->image) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->oldLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->newLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << subresource_range_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "hostImageLayoutTransitionInfo");
    out << "\t\t" << "VkHostImageLayoutTransitionInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageSubresource2(std::ostream &out, const VkImageSubresource2* structInfo, Decoded_VkImageSubresource2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string image_subresource_info_var = GenerateStruct_VkImageSubresource(out,
                                                                               &structInfo->imageSubresource,
                                                                               metaInfo->imageSubresource,
                                                                               consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << image_subresource_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageSubresource2");
    out << "\t\t" << "VkImageSubresource2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryMapInfo(std::ostream &out, const VkMemoryMapInfo* structInfo, Decoded_VkMemoryMapInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkMemoryMapFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->memory) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->offset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryMapInfo");
    out << "\t\t" << "VkMemoryMapInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryUnmapInfo(std::ostream &out, const VkMemoryUnmapInfo* structInfo, Decoded_VkMemoryUnmapInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkMemoryUnmapFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->memory) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryUnmapInfo");
    out << "\t\t" << "VkMemoryUnmapInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(std::ostream &out, const VkPhysicalDeviceDynamicRenderingLocalReadFeatures* structInfo, Decoded_VkPhysicalDeviceDynamicRenderingLocalReadFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dynamicRenderingLocalRead << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceDynamicRenderingLocalReadFeatures");
    out << "\t\t" << "VkPhysicalDeviceDynamicRenderingLocalReadFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceGlobalPriorityQueryFeatures(std::ostream &out, const VkPhysicalDeviceGlobalPriorityQueryFeatures* structInfo, Decoded_VkPhysicalDeviceGlobalPriorityQueryFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->globalPriorityQuery << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceGlobalPriorityQueryFeatures");
    out << "\t\t" << "VkPhysicalDeviceGlobalPriorityQueryFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceHostImageCopyFeatures(std::ostream &out, const VkPhysicalDeviceHostImageCopyFeatures* structInfo, Decoded_VkPhysicalDeviceHostImageCopyFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->hostImageCopy << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceHostImageCopyFeatures");
    out << "\t\t" << "VkPhysicalDeviceHostImageCopyFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceHostImageCopyProperties(std::ostream &out, const VkPhysicalDeviceHostImageCopyProperties* structInfo, Decoded_VkPhysicalDeviceHostImageCopyProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pcopy_src_layouts_array = "NULL";
    if (structInfo->pCopySrcLayouts != NULL) {
        std::string pcopy_src_layouts_values;
        for (uint32_t idx = 0; idx < structInfo->copySrcLayoutCount; idx++) {
            pcopy_src_layouts_values += util::ToString<VkImageLayout>(structInfo->pCopySrcLayouts[idx]) + ", ";
        }
        pcopy_src_layouts_array = "pCopySrcLayouts_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkImageLayout " << pcopy_src_layouts_array << "[] = {" << pcopy_src_layouts_values << "};" << std::endl;
    }
    std::string pcopy_dst_layouts_array = "NULL";
    if (structInfo->pCopyDstLayouts != NULL) {
        std::string pcopy_dst_layouts_values;
        for (uint32_t idx = 0; idx < structInfo->copyDstLayoutCount; idx++) {
            pcopy_dst_layouts_values += util::ToString<VkImageLayout>(structInfo->pCopyDstLayouts[idx]) + ", ";
        }
        pcopy_dst_layouts_array = "pCopyDstLayouts_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkImageLayout " << pcopy_dst_layouts_array << "[] = {" << pcopy_dst_layouts_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->copySrcLayoutCount << "," << std::endl;
    struct_body << "\t\t\t" << pcopy_src_layouts_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->copyDstLayoutCount << "," << std::endl;
    struct_body << "\t\t\t" << pcopy_dst_layouts_array << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->optimalTilingLayoutUUID[0]), VK_UUID_SIZE) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->identicalMemoryTypeRequirements << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceHostImageCopyProperties");
    out << "\t\t" << "VkPhysicalDeviceHostImageCopyProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceIndexTypeUint8Features(std::ostream &out, const VkPhysicalDeviceIndexTypeUint8Features* structInfo, Decoded_VkPhysicalDeviceIndexTypeUint8Features* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->indexTypeUint8 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceIndexTypeUint8Features");
    out << "\t\t" << "VkPhysicalDeviceIndexTypeUint8Features " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceLineRasterizationFeatures(std::ostream &out, const VkPhysicalDeviceLineRasterizationFeatures* structInfo, Decoded_VkPhysicalDeviceLineRasterizationFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->rectangularLines << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bresenhamLines << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->smoothLines << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stippledRectangularLines << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stippledBresenhamLines << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stippledSmoothLines << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceLineRasterizationFeatures");
    out << "\t\t" << "VkPhysicalDeviceLineRasterizationFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceLineRasterizationProperties(std::ostream &out, const VkPhysicalDeviceLineRasterizationProperties* structInfo, Decoded_VkPhysicalDeviceLineRasterizationProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->lineSubPixelPrecisionBits << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceLineRasterizationProperties");
    out << "\t\t" << "VkPhysicalDeviceLineRasterizationProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMaintenance5Features(std::ostream &out, const VkPhysicalDeviceMaintenance5Features* structInfo, Decoded_VkPhysicalDeviceMaintenance5Features* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maintenance5 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMaintenance5Features");
    out << "\t\t" << "VkPhysicalDeviceMaintenance5Features " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMaintenance5Properties(std::ostream &out, const VkPhysicalDeviceMaintenance5Properties* structInfo, Decoded_VkPhysicalDeviceMaintenance5Properties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->earlyFragmentMultisampleCoverageAfterSampleCounting << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->earlyFragmentSampleMaskTestBeforeSampleCounting << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthStencilSwizzleOneSupport << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->polygonModePointSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->nonStrictSinglePixelWideLinesUseParallelogram << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->nonStrictWideLinesUseParallelogram << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMaintenance5Properties");
    out << "\t\t" << "VkPhysicalDeviceMaintenance5Properties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMaintenance6Features(std::ostream &out, const VkPhysicalDeviceMaintenance6Features* structInfo, Decoded_VkPhysicalDeviceMaintenance6Features* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maintenance6 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMaintenance6Features");
    out << "\t\t" << "VkPhysicalDeviceMaintenance6Features " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMaintenance6Properties(std::ostream &out, const VkPhysicalDeviceMaintenance6Properties* structInfo, Decoded_VkPhysicalDeviceMaintenance6Properties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->blockTexelViewCompatibleMultipleLayers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxCombinedImageSamplerDescriptorCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fragmentShadingRateClampCombinerInputs << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMaintenance6Properties");
    out << "\t\t" << "VkPhysicalDeviceMaintenance6Properties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePipelineProtectedAccessFeatures(std::ostream &out, const VkPhysicalDevicePipelineProtectedAccessFeatures* structInfo, Decoded_VkPhysicalDevicePipelineProtectedAccessFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineProtectedAccess << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePipelineProtectedAccessFeatures");
    out << "\t\t" << "VkPhysicalDevicePipelineProtectedAccessFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePipelineRobustnessFeatures(std::ostream &out, const VkPhysicalDevicePipelineRobustnessFeatures* structInfo, Decoded_VkPhysicalDevicePipelineRobustnessFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineRobustness << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePipelineRobustnessFeatures");
    out << "\t\t" << "VkPhysicalDevicePipelineRobustnessFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePipelineRobustnessProperties(std::ostream &out, const VkPhysicalDevicePipelineRobustnessProperties* structInfo, Decoded_VkPhysicalDevicePipelineRobustnessProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineRobustnessBufferBehavior(" << structInfo->defaultRobustnessStorageBuffers << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineRobustnessBufferBehavior(" << structInfo->defaultRobustnessUniformBuffers << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineRobustnessBufferBehavior(" << structInfo->defaultRobustnessVertexInputs << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineRobustnessImageBehavior(" << structInfo->defaultRobustnessImages << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePipelineRobustnessProperties");
    out << "\t\t" << "VkPhysicalDevicePipelineRobustnessProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePushDescriptorProperties(std::ostream &out, const VkPhysicalDevicePushDescriptorProperties* structInfo, Decoded_VkPhysicalDevicePushDescriptorProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPushDescriptors << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePushDescriptorProperties");
    out << "\t\t" << "VkPhysicalDevicePushDescriptorProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderExpectAssumeFeatures(std::ostream &out, const VkPhysicalDeviceShaderExpectAssumeFeatures* structInfo, Decoded_VkPhysicalDeviceShaderExpectAssumeFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderExpectAssume << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderExpectAssumeFeatures");
    out << "\t\t" << "VkPhysicalDeviceShaderExpectAssumeFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderFloatControls2Features(std::ostream &out, const VkPhysicalDeviceShaderFloatControls2Features* structInfo, Decoded_VkPhysicalDeviceShaderFloatControls2Features* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderFloatControls2 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderFloatControls2Features");
    out << "\t\t" << "VkPhysicalDeviceShaderFloatControls2Features " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderSubgroupRotateFeatures(std::ostream &out, const VkPhysicalDeviceShaderSubgroupRotateFeatures* structInfo, Decoded_VkPhysicalDeviceShaderSubgroupRotateFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSubgroupRotate << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSubgroupRotateClustered << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderSubgroupRotateFeatures");
    out << "\t\t" << "VkPhysicalDeviceShaderSubgroupRotateFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVertexAttributeDivisorFeatures(std::ostream &out, const VkPhysicalDeviceVertexAttributeDivisorFeatures* structInfo, Decoded_VkPhysicalDeviceVertexAttributeDivisorFeatures* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vertexAttributeInstanceRateDivisor << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vertexAttributeInstanceRateZeroDivisor << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVertexAttributeDivisorFeatures");
    out << "\t\t" << "VkPhysicalDeviceVertexAttributeDivisorFeatures " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVertexAttributeDivisorProperties(std::ostream &out, const VkPhysicalDeviceVertexAttributeDivisorProperties* structInfo, Decoded_VkPhysicalDeviceVertexAttributeDivisorProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxVertexAttribDivisor << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->supportsNonZeroFirstInstance << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVertexAttributeDivisorProperties");
    out << "\t\t" << "VkPhysicalDeviceVertexAttributeDivisorProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVulkan14Features(std::ostream &out, const VkPhysicalDeviceVulkan14Features* structInfo, Decoded_VkPhysicalDeviceVulkan14Features* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->globalPriorityQuery << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSubgroupRotate << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSubgroupRotateClustered << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderFloatControls2 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderExpectAssume << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->rectangularLines << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bresenhamLines << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->smoothLines << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stippledRectangularLines << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stippledBresenhamLines << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stippledSmoothLines << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vertexAttributeInstanceRateDivisor << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vertexAttributeInstanceRateZeroDivisor << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->indexTypeUint8 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dynamicRenderingLocalRead << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maintenance5 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maintenance6 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineProtectedAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineRobustness << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->hostImageCopy << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pushDescriptor << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVulkan14Features");
    out << "\t\t" << "VkPhysicalDeviceVulkan14Features " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVulkan14Properties(std::ostream &out, const VkPhysicalDeviceVulkan14Properties* structInfo, Decoded_VkPhysicalDeviceVulkan14Properties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pcopy_src_layouts_array = "NULL";
    if (structInfo->pCopySrcLayouts != NULL) {
        std::string pcopy_src_layouts_values;
        for (uint32_t idx = 0; idx < structInfo->copySrcLayoutCount; idx++) {
            pcopy_src_layouts_values += util::ToString<VkImageLayout>(structInfo->pCopySrcLayouts[idx]) + ", ";
        }
        pcopy_src_layouts_array = "pCopySrcLayouts_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkImageLayout " << pcopy_src_layouts_array << "[] = {" << pcopy_src_layouts_values << "};" << std::endl;
    }
    std::string pcopy_dst_layouts_array = "NULL";
    if (structInfo->pCopyDstLayouts != NULL) {
        std::string pcopy_dst_layouts_values;
        for (uint32_t idx = 0; idx < structInfo->copyDstLayoutCount; idx++) {
            pcopy_dst_layouts_values += util::ToString<VkImageLayout>(structInfo->pCopyDstLayouts[idx]) + ", ";
        }
        pcopy_dst_layouts_array = "pCopyDstLayouts_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkImageLayout " << pcopy_dst_layouts_array << "[] = {" << pcopy_dst_layouts_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->lineSubPixelPrecisionBits << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxVertexAttribDivisor << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->supportsNonZeroFirstInstance << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPushDescriptors << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dynamicRenderingLocalReadDepthStencilAttachments << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dynamicRenderingLocalReadMultisampledAttachments << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->earlyFragmentMultisampleCoverageAfterSampleCounting << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->earlyFragmentSampleMaskTestBeforeSampleCounting << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthStencilSwizzleOneSupport << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->polygonModePointSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->nonStrictSinglePixelWideLinesUseParallelogram << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->nonStrictWideLinesUseParallelogram << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->blockTexelViewCompatibleMultipleLayers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxCombinedImageSamplerDescriptorCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fragmentShadingRateClampCombinerInputs << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineRobustnessBufferBehavior(" << structInfo->defaultRobustnessStorageBuffers << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineRobustnessBufferBehavior(" << structInfo->defaultRobustnessUniformBuffers << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineRobustnessBufferBehavior(" << structInfo->defaultRobustnessVertexInputs << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineRobustnessImageBehavior(" << structInfo->defaultRobustnessImages << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->copySrcLayoutCount << "," << std::endl;
    struct_body << "\t\t\t" << pcopy_src_layouts_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->copyDstLayoutCount << "," << std::endl;
    struct_body << "\t\t\t" << pcopy_dst_layouts_array << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->optimalTilingLayoutUUID[0]), VK_UUID_SIZE) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->identicalMemoryTypeRequirements << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVulkan14Properties");
    out << "\t\t" << "VkPhysicalDeviceVulkan14Properties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineCreateFlags2CreateInfo(std::ostream &out, const VkPipelineCreateFlags2CreateInfo* structInfo, Decoded_VkPipelineCreateFlags2CreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineCreateFlags2(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineCreateFlags2CreateInfo");
    out << "\t\t" << "VkPipelineCreateFlags2CreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineRasterizationLineStateCreateInfo(std::ostream &out, const VkPipelineRasterizationLineStateCreateInfo* structInfo, Decoded_VkPipelineRasterizationLineStateCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkLineRasterizationMode(" << structInfo->lineRasterizationMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stippledLineEnable << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->lineStippleFactor << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->lineStipplePattern << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineRasterizationLineStateCreateInfo");
    out << "\t\t" << "VkPipelineRasterizationLineStateCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineRobustnessCreateInfo(std::ostream &out, const VkPipelineRobustnessCreateInfo* structInfo, Decoded_VkPipelineRobustnessCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineRobustnessBufferBehavior(" << structInfo->storageBuffers << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineRobustnessBufferBehavior(" << structInfo->uniformBuffers << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineRobustnessBufferBehavior(" << structInfo->vertexInputs << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineRobustnessImageBehavior(" << structInfo->images << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineRobustnessCreateInfo");
    out << "\t\t" << "VkPipelineRobustnessCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineVertexInputDivisorStateCreateInfo(std::ostream &out, const VkPipelineVertexInputDivisorStateCreateInfo* structInfo, Decoded_VkPipelineVertexInputDivisorStateCreateInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pvertex_binding_divisors_array = "NULL";
    if (structInfo->pVertexBindingDivisors != NULL) {
        pvertex_binding_divisors_array = "pVertexBindingDivisors_" + std::to_string(consumer.GetNextId());
        std::string pvertex_binding_divisors_names;
        for (uint32_t idx = 0; idx < structInfo->vertexBindingDivisorCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pVertexBindingDivisors + idx != NULL) {
                variable_name = GenerateStruct_VkVertexInputBindingDivisorDescription(out,
                                                                                      structInfo->pVertexBindingDivisors + idx,
                                                                                      metaInfo->pVertexBindingDivisors->GetMetaStructPointer() + idx,
                                                                                      consumer);
            }
            pvertex_binding_divisors_names += variable_name + ", ";
        }
        out << "\t\t" << "VkVertexInputBindingDivisorDescription " << pvertex_binding_divisors_array << "[] = {" << pvertex_binding_divisors_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vertexBindingDivisorCount << "," << std::endl;
    struct_body << "\t\t\t" << pvertex_binding_divisors_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineVertexInputDivisorStateCreateInfo");
    out << "\t\t" << "VkPipelineVertexInputDivisorStateCreateInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPushConstantsInfo(std::ostream &out, const VkPushConstantsInfo* structInfo, Decoded_VkPushConstantsInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pvalues_array = "NULL";
    if (structInfo->pValues != NULL) {
        std::string pvalues_values;
        for (uint32_t idx0 = 0; idx0 < structInfo->size; ++idx0) {
            pvalues_values += std::to_string(reinterpret_cast<const uint8_t*>(structInfo->pValues)[idx0]) + ", ";
        }
        pvalues_array = "pValues_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint8_t " << pvalues_array << "[] = {" << pvalues_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->layout) << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderStageFlags(" << structInfo->stageFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->offset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << "," << std::endl;
    struct_body << "\t\t\t" << pvalues_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pushConstantsInfo");
    out << "\t\t" << "VkPushConstantsInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPushDescriptorSetInfo(std::ostream &out, const VkPushDescriptorSetInfo* structInfo, Decoded_VkPushDescriptorSetInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pdescriptor_writes_array = "NULL";
    if (structInfo->pDescriptorWrites != NULL) {
        pdescriptor_writes_array = "pDescriptorWrites_" + std::to_string(consumer.GetNextId());
        std::string pdescriptor_writes_names;
        for (uint32_t idx = 0; idx < structInfo->descriptorWriteCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pDescriptorWrites + idx != NULL) {
                variable_name = GenerateStruct_VkWriteDescriptorSet(out,
                                                                    structInfo->pDescriptorWrites + idx,
                                                                    metaInfo->pDescriptorWrites->GetMetaStructPointer() + idx,
                                                                    consumer);
            }
            pdescriptor_writes_names += variable_name + ", ";
        }
        out << "\t\t" << "VkWriteDescriptorSet " << pdescriptor_writes_array << "[] = {" << pdescriptor_writes_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderStageFlags(" << structInfo->stageFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->layout) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->set << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->descriptorWriteCount << "," << std::endl;
    struct_body << "\t\t\t" << pdescriptor_writes_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pushDescriptorSetInfo");
    out << "\t\t" << "VkPushDescriptorSetInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkQueueFamilyGlobalPriorityProperties(std::ostream &out, const VkQueueFamilyGlobalPriorityProperties* structInfo, Decoded_VkQueueFamilyGlobalPriorityProperties* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->priorityCount << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const VkQueueGlobalPriority*>(&structInfo->priorities[0]), VK_MAX_GLOBAL_PRIORITY_SIZE) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "queueFamilyGlobalPriorityProperties");
    out << "\t\t" << "VkQueueFamilyGlobalPriorityProperties " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRenderingAreaInfo(std::ostream &out, const VkRenderingAreaInfo* structInfo, Decoded_VkRenderingAreaInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pcolor_attachment_formats_values;
    std::string pcolor_attachment_formats_array = "NULL";
    if (structInfo->pColorAttachmentFormats != NULL) {
        for (uint32_t idx = 0; idx < structInfo->colorAttachmentCount; idx++) {
            pcolor_attachment_formats_values += util::ToString<VkFormat>(structInfo->pColorAttachmentFormats[idx]) + ", ";
        }
        pcolor_attachment_formats_array = "pColorAttachmentFormats_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkFormat " << pcolor_attachment_formats_array << "[] = {" << pcolor_attachment_formats_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->viewMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->colorAttachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pcolor_attachment_formats_array << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->depthAttachmentFormat << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->stencilAttachmentFormat << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "renderingAreaInfo");
    out << "\t\t" << "VkRenderingAreaInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRenderingAttachmentLocationInfo(std::ostream &out, const VkRenderingAttachmentLocationInfo* structInfo, Decoded_VkRenderingAttachmentLocationInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pcolor_attachment_locations_array = "NULL";
    if (structInfo->pColorAttachmentLocations != NULL) {
        pcolor_attachment_locations_array = "pColorAttachmentLocations_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pcolor_attachment_locations_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pColorAttachmentLocations, structInfo->colorAttachmentCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->colorAttachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pcolor_attachment_locations_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "renderingAttachmentLocationInfo");
    out << "\t\t" << "VkRenderingAttachmentLocationInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRenderingInputAttachmentIndexInfo(std::ostream &out, const VkRenderingInputAttachmentIndexInfo* structInfo, Decoded_VkRenderingInputAttachmentIndexInfo* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pcolor_attachment_input_indices_array = "NULL";
    if (structInfo->pColorAttachmentInputIndices != NULL) {
        pcolor_attachment_input_indices_array = "pColorAttachmentInputIndices_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pcolor_attachment_input_indices_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pColorAttachmentInputIndices, structInfo->colorAttachmentCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->colorAttachmentCount << "," << std::endl;
    struct_body << "\t\t\t" << pcolor_attachment_input_indices_array << "," << std::endl;
    std::string variable_name = consumer.AddStruct(struct_body, "renderingInputAttachmentIndexInfo");
    out << "\t\t" << "VkRenderingInputAttachmentIndexInfo " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSubresourceHostMemcpySize(std::ostream &out, const VkSubresourceHostMemcpySize* structInfo, Decoded_VkSubresourceHostMemcpySize* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "subresourceHostMemcpySize");
    out << "\t\t" << "VkSubresourceHostMemcpySize " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSubresourceLayout2(std::ostream &out, const VkSubresourceLayout2* structInfo, Decoded_VkSubresourceLayout2* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string subresource_layout_info_var = GenerateStruct_VkSubresourceLayout(out,
                                                                                 &structInfo->subresourceLayout,
                                                                                 metaInfo->subresourceLayout,
                                                                                 consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << subresource_layout_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "subresourceLayout2");
    out << "\t\t" << "VkSubresourceLayout2 " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVertexInputBindingDivisorDescription(std::ostream &out, const VkVertexInputBindingDivisorDescription* structInfo, Decoded_VkVertexInputBindingDivisorDescription* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->binding << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->divisor << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "vertexInputBindingDivisorDescription");
    out << "\t\t" << "VkVertexInputBindingDivisorDescription " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSurfaceCapabilitiesKHR(std::ostream &out, const VkSurfaceCapabilitiesKHR* structInfo, Decoded_VkSurfaceCapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string current_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                    &structInfo->currentExtent,
                                                                    metaInfo->currentExtent,
                                                                    consumer);
    std::string min_image_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                      &structInfo->minImageExtent,
                                                                      metaInfo->minImageExtent,
                                                                      consumer);
    std::string max_image_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                      &structInfo->maxImageExtent,
                                                                      metaInfo->maxImageExtent,
                                                                      consumer);
    struct_body << "\t" << structInfo->minImageCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxImageCount << "," << std::endl;
    struct_body << "\t\t\t" << current_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << min_image_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << max_image_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxImageArrayLayers << "," << std::endl;
    struct_body << "\t\t\t" << "VkSurfaceTransformFlagsKHR(" << structInfo->supportedTransforms << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSurfaceTransformFlagBitsKHR(" << structInfo->currentTransform << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkCompositeAlphaFlagsKHR(" << structInfo->supportedCompositeAlpha << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageUsageFlags(" << structInfo->supportedUsageFlags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "surfaceCapabilitiesKHR");
    out << "\t\t" << "VkSurfaceCapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSurfaceFormatKHR(std::ostream &out, const VkSurfaceFormatKHR* structInfo, Decoded_VkSurfaceFormatKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << "VkFormat(" << structInfo->format << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkColorSpaceKHR(" << structInfo->colorSpace << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "surfaceFormatKHR");
    out << "\t\t" << "VkSurfaceFormatKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkAcquireNextImageInfoKHR(std::ostream &out, const VkAcquireNextImageInfoKHR* structInfo, Decoded_VkAcquireNextImageInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->swapchain) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->timeout << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->semaphore) << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->fence) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceMask << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "acquireNextImageInfoKHR");
    out << "\t\t" << "VkAcquireNextImageInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBindImageMemorySwapchainInfoKHR(std::ostream &out, const VkBindImageMemorySwapchainInfoKHR* structInfo, Decoded_VkBindImageMemorySwapchainInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->swapchain) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->imageIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bindImageMemorySwapchainInfoKHR");
    out << "\t\t" << "VkBindImageMemorySwapchainInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceGroupPresentCapabilitiesKHR(std::ostream &out, const VkDeviceGroupPresentCapabilitiesKHR* structInfo, Decoded_VkDeviceGroupPresentCapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint32_t*>(&structInfo->presentMask[0]), VK_MAX_DEVICE_GROUP_SIZE) << "," << std::endl;
    struct_body << "\t\t\t" << "VkDeviceGroupPresentModeFlagsKHR(" << structInfo->modes << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceGroupPresentCapabilitiesKHR");
    out << "\t\t" << "VkDeviceGroupPresentCapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceGroupPresentInfoKHR(std::ostream &out, const VkDeviceGroupPresentInfoKHR* structInfo, Decoded_VkDeviceGroupPresentInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pdevice_masks_array = "NULL";
    if (structInfo->pDeviceMasks != NULL) {
        pdevice_masks_array = "pDeviceMasks_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pdevice_masks_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pDeviceMasks, structInfo->swapchainCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->swapchainCount << "," << std::endl;
    struct_body << "\t\t\t" << pdevice_masks_array << "," << std::endl;
    struct_body << "\t\t\t" << "VkDeviceGroupPresentModeFlagBitsKHR(" << structInfo->mode << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceGroupPresentInfoKHR");
    out << "\t\t" << "VkDeviceGroupPresentInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceGroupSwapchainCreateInfoKHR(std::ostream &out, const VkDeviceGroupSwapchainCreateInfoKHR* structInfo, Decoded_VkDeviceGroupSwapchainCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDeviceGroupPresentModeFlagsKHR(" << structInfo->modes << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceGroupSwapchainCreateInfoKHR");
    out << "\t\t" << "VkDeviceGroupSwapchainCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageSwapchainCreateInfoKHR(std::ostream &out, const VkImageSwapchainCreateInfoKHR* structInfo, Decoded_VkImageSwapchainCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->swapchain) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageSwapchainCreateInfoKHR");
    out << "\t\t" << "VkImageSwapchainCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplayModeCreateInfoKHR(std::ostream &out, const VkDisplayModeCreateInfoKHR* structInfo, Decoded_VkDisplayModeCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string parameters_info_var = GenerateStruct_VkDisplayModeParametersKHR(out,
                                                                                &structInfo->parameters,
                                                                                metaInfo->parameters,
                                                                                consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDisplayModeCreateFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << parameters_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displayModeCreateInfoKHR");
    out << "\t\t" << "VkDisplayModeCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplayModeParametersKHR(std::ostream &out, const VkDisplayModeParametersKHR* structInfo, Decoded_VkDisplayModeParametersKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string visible_region_info_var = GenerateStruct_VkExtent2D(out,
                                                                    &structInfo->visibleRegion,
                                                                    metaInfo->visibleRegion,
                                                                    consumer);
    struct_body << "\t" << visible_region_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->refreshRate << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displayModeParametersKHR");
    out << "\t\t" << "VkDisplayModeParametersKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplayModePropertiesKHR(std::ostream &out, const VkDisplayModePropertiesKHR* structInfo, Decoded_VkDisplayModePropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string parameters_info_var = GenerateStruct_VkDisplayModeParametersKHR(out,
                                                                                &structInfo->parameters,
                                                                                metaInfo->parameters,
                                                                                consumer);
    struct_body << "\t" << consumer.GetHandle(metaInfo->displayMode) << "," << std::endl;
    struct_body << "\t\t\t" << parameters_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displayModePropertiesKHR");
    out << "\t\t" << "VkDisplayModePropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplayPlaneCapabilitiesKHR(std::ostream &out, const VkDisplayPlaneCapabilitiesKHR* structInfo, Decoded_VkDisplayPlaneCapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string min_src_position_info_var = GenerateStruct_VkOffset2D(out,
                                                                      &structInfo->minSrcPosition,
                                                                      metaInfo->minSrcPosition,
                                                                      consumer);
    std::string max_src_position_info_var = GenerateStruct_VkOffset2D(out,
                                                                      &structInfo->maxSrcPosition,
                                                                      metaInfo->maxSrcPosition,
                                                                      consumer);
    std::string min_src_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                    &structInfo->minSrcExtent,
                                                                    metaInfo->minSrcExtent,
                                                                    consumer);
    std::string max_src_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                    &structInfo->maxSrcExtent,
                                                                    metaInfo->maxSrcExtent,
                                                                    consumer);
    std::string min_dst_position_info_var = GenerateStruct_VkOffset2D(out,
                                                                      &structInfo->minDstPosition,
                                                                      metaInfo->minDstPosition,
                                                                      consumer);
    std::string max_dst_position_info_var = GenerateStruct_VkOffset2D(out,
                                                                      &structInfo->maxDstPosition,
                                                                      metaInfo->maxDstPosition,
                                                                      consumer);
    std::string min_dst_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                    &structInfo->minDstExtent,
                                                                    metaInfo->minDstExtent,
                                                                    consumer);
    std::string max_dst_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                    &structInfo->maxDstExtent,
                                                                    metaInfo->maxDstExtent,
                                                                    consumer);
    struct_body << "\t" << "VkDisplayPlaneAlphaFlagsKHR(" << structInfo->supportedAlpha << ")" << "," << std::endl;
    struct_body << "\t\t\t" << min_src_position_info_var << "," << std::endl;
    struct_body << "\t\t\t" << max_src_position_info_var << "," << std::endl;
    struct_body << "\t\t\t" << min_src_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << max_src_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << min_dst_position_info_var << "," << std::endl;
    struct_body << "\t\t\t" << max_dst_position_info_var << "," << std::endl;
    struct_body << "\t\t\t" << min_dst_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << max_dst_extent_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displayPlaneCapabilitiesKHR");
    out << "\t\t" << "VkDisplayPlaneCapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplayPlanePropertiesKHR(std::ostream &out, const VkDisplayPlanePropertiesKHR* structInfo, Decoded_VkDisplayPlanePropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << consumer.GetHandle(metaInfo->currentDisplay) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->currentStackIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displayPlanePropertiesKHR");
    out << "\t\t" << "VkDisplayPlanePropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplayPropertiesKHR(std::ostream &out, const VkDisplayPropertiesKHR* structInfo, Decoded_VkDisplayPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string physical_dimensions_info_var = GenerateStruct_VkExtent2D(out,
                                                                         &structInfo->physicalDimensions,
                                                                         metaInfo->physicalDimensions,
                                                                         consumer);
    std::string physical_resolution_info_var = GenerateStruct_VkExtent2D(out,
                                                                         &structInfo->physicalResolution,
                                                                         metaInfo->physicalResolution,
                                                                         consumer);
    struct_body << "\t" << consumer.GetHandle(metaInfo->display) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->displayName) << "," << std::endl;
    struct_body << "\t\t\t" << physical_dimensions_info_var << "," << std::endl;
    struct_body << "\t\t\t" << physical_resolution_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "VkSurfaceTransformFlagsKHR(" << structInfo->supportedTransforms << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->planeReorderPossible << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->persistentContent << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displayPropertiesKHR");
    out << "\t\t" << "VkDisplayPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplaySurfaceCreateInfoKHR(std::ostream &out, const VkDisplaySurfaceCreateInfoKHR* structInfo, Decoded_VkDisplaySurfaceCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string image_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                  &structInfo->imageExtent,
                                                                  metaInfo->imageExtent,
                                                                  consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDisplaySurfaceCreateFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->displayMode) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->planeIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->planeStackIndex << "," << std::endl;
    struct_body << "\t\t\t" << "VkSurfaceTransformFlagBitsKHR(" << structInfo->transform << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->globalAlpha << "," << std::endl;
    struct_body << "\t\t\t" << "VkDisplayPlaneAlphaFlagBitsKHR(" << structInfo->alphaMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << image_extent_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displaySurfaceCreateInfoKHR");
    out << "\t\t" << "VkDisplaySurfaceCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplayPresentInfoKHR(std::ostream &out, const VkDisplayPresentInfoKHR* structInfo, Decoded_VkDisplayPresentInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string src_rect_info_var = GenerateStruct_VkRect2D(out,
                                                            &structInfo->srcRect,
                                                            metaInfo->srcRect,
                                                            consumer);
    std::string dst_rect_info_var = GenerateStruct_VkRect2D(out,
                                                            &structInfo->dstRect,
                                                            metaInfo->dstRect,
                                                            consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << src_rect_info_var << "," << std::endl;
    struct_body << "\t\t\t" << dst_rect_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->persistent << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displayPresentInfoKHR");
    out << "\t\t" << "VkDisplayPresentInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkXlibSurfaceCreateInfoKHR(std::ostream &out, const VkXlibSurfaceCreateInfoKHR* structInfo, Decoded_VkXlibSurfaceCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkXlibSurfaceCreateFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<Display*>(" << structInfo->dpy << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->window << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "xlibSurfaceCreateInfoKHR");
    out << "\t\t" << "VkXlibSurfaceCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    out << "\t\t" << "OverrideVkXlibSurfaceCreateInfoKHR(&" << variable_name << ", " << "appdata" << ");" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkXcbSurfaceCreateInfoKHR(std::ostream &out, const VkXcbSurfaceCreateInfoKHR* structInfo, Decoded_VkXcbSurfaceCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkXcbSurfaceCreateFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<xcb_connection_t*>(" << structInfo->connection << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->window << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "xcbSurfaceCreateInfoKHR");
    out << "\t\t" << "VkXcbSurfaceCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    out << "\t\t" << "OverrideVkXcbSurfaceCreateInfoKHR(&" << variable_name << ", " << "appdata" << ");" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkWaylandSurfaceCreateInfoKHR(std::ostream &out, const VkWaylandSurfaceCreateInfoKHR* structInfo, Decoded_VkWaylandSurfaceCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkWaylandSurfaceCreateFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<struct wl_display*>(" << structInfo->display << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<struct wl_surface*>(" << structInfo->surface << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "waylandSurfaceCreateInfoKHR");
    out << "\t\t" << "VkWaylandSurfaceCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    out << "\t\t" << "OverrideVkWaylandSurfaceCreateInfoKHR(&" << variable_name << ", " << "appdata" << ");" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkAndroidSurfaceCreateInfoKHR(std::ostream &out, const VkAndroidSurfaceCreateInfoKHR* structInfo, Decoded_VkAndroidSurfaceCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkAndroidSurfaceCreateFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<struct ANativeWindow*>(" << structInfo->window << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "androidSurfaceCreateInfoKHR");
    out << "\t\t" << "VkAndroidSurfaceCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    out << "\t\t" << "OverrideVkAndroidSurfaceCreateInfoKHR(&" << variable_name << ", " << "appdata" << ");" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkWin32SurfaceCreateInfoKHR(std::ostream &out, const VkWin32SurfaceCreateInfoKHR* structInfo, Decoded_VkWin32SurfaceCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkWin32SurfaceCreateFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<HINSTANCE>(" << structInfo->hinstance << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<HWND>(" << structInfo->hwnd << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "win32SurfaceCreateInfoKHR");
    out << "\t\t" << "VkWin32SurfaceCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    out << "\t\t" << "OverrideVkWin32SurfaceCreateInfoKHR(&" << variable_name << ", " << "appdata" << ");" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBindVideoSessionMemoryInfoKHR(std::ostream &out, const VkBindVideoSessionMemoryInfoKHR* structInfo, Decoded_VkBindVideoSessionMemoryInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->memoryBindIndex << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->memory) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->memoryOffset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->memorySize << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bindVideoSessionMemoryInfoKHR");
    out << "\t\t" << "VkBindVideoSessionMemoryInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVideoFormatInfoKHR(std::ostream &out, const VkPhysicalDeviceVideoFormatInfoKHR* structInfo, Decoded_VkPhysicalDeviceVideoFormatInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageUsageFlags(" << structInfo->imageUsage << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVideoFormatInfoKHR");
    out << "\t\t" << "VkPhysicalDeviceVideoFormatInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkQueueFamilyQueryResultStatusPropertiesKHR(std::ostream &out, const VkQueueFamilyQueryResultStatusPropertiesKHR* structInfo, Decoded_VkQueueFamilyQueryResultStatusPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->queryResultStatusSupport << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "queueFamilyQueryResultStatusPropertiesKHR");
    out << "\t\t" << "VkQueueFamilyQueryResultStatusPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkQueueFamilyVideoPropertiesKHR(std::ostream &out, const VkQueueFamilyVideoPropertiesKHR* structInfo, Decoded_VkQueueFamilyVideoPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoCodecOperationFlagsKHR(" << structInfo->videoCodecOperations << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "queueFamilyVideoPropertiesKHR");
    out << "\t\t" << "VkQueueFamilyVideoPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoBeginCodingInfoKHR(std::ostream &out, const VkVideoBeginCodingInfoKHR* structInfo, Decoded_VkVideoBeginCodingInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string preference_slots_array = "NULL";
    if (structInfo->pReferenceSlots != NULL) {
        preference_slots_array = "pReferenceSlots_" + std::to_string(consumer.GetNextId());
        std::string preference_slots_names;
        for (uint32_t idx = 0; idx < structInfo->referenceSlotCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pReferenceSlots + idx != NULL) {
                variable_name = GenerateStruct_VkVideoReferenceSlotInfoKHR(out,
                                                                           structInfo->pReferenceSlots + idx,
                                                                           metaInfo->pReferenceSlots->GetMetaStructPointer() + idx,
                                                                           consumer);
            }
            preference_slots_names += variable_name + ", ";
        }
        out << "\t\t" << "VkVideoReferenceSlotInfoKHR " << preference_slots_array << "[] = {" << preference_slots_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoBeginCodingFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->videoSession) << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->videoSessionParameters) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->referenceSlotCount << "," << std::endl;
    struct_body << "\t\t\t" << preference_slots_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoBeginCodingInfoKHR");
    out << "\t\t" << "VkVideoBeginCodingInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoCapabilitiesKHR(std::ostream &out, const VkVideoCapabilitiesKHR* structInfo, Decoded_VkVideoCapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string picture_access_granularity_info_var = GenerateStruct_VkExtent2D(out,
                                                                                &structInfo->pictureAccessGranularity,
                                                                                metaInfo->pictureAccessGranularity,
                                                                                consumer);
    std::string min_coded_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                      &structInfo->minCodedExtent,
                                                                      metaInfo->minCodedExtent,
                                                                      consumer);
    std::string max_coded_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                      &structInfo->maxCodedExtent,
                                                                      metaInfo->maxCodedExtent,
                                                                      consumer);
    std::string std_header_version_info_var = GenerateStruct_VkExtensionProperties(out,
                                                                                   &structInfo->stdHeaderVersion,
                                                                                   metaInfo->stdHeaderVersion,
                                                                                   consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoCapabilityFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minBitstreamBufferOffsetAlignment << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minBitstreamBufferSizeAlignment << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << picture_access_granularity_info_var << "," << std::endl;
    struct_body << "\t\t\t" << min_coded_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << max_coded_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDpbSlots << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxActiveReferencePictures << "," << std::endl;
    struct_body << "\t\t\t" << std_header_version_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoCapabilitiesKHR");
    out << "\t\t" << "VkVideoCapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoCodingControlInfoKHR(std::ostream &out, const VkVideoCodingControlInfoKHR* structInfo, Decoded_VkVideoCodingControlInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoCodingControlFlagsKHR(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoCodingControlInfoKHR");
    out << "\t\t" << "VkVideoCodingControlInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEndCodingInfoKHR(std::ostream &out, const VkVideoEndCodingInfoKHR* structInfo, Decoded_VkVideoEndCodingInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEndCodingFlagsKHR(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEndCodingInfoKHR");
    out << "\t\t" << "VkVideoEndCodingInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoFormatPropertiesKHR(std::ostream &out, const VkVideoFormatPropertiesKHR* structInfo, Decoded_VkVideoFormatPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string component_mapping_info_var = GenerateStruct_VkComponentMapping(out,
                                                                               &structInfo->componentMapping,
                                                                               metaInfo->componentMapping,
                                                                               consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->format << ")" << "," << std::endl;
    struct_body << "\t\t\t" << component_mapping_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageCreateFlags(" << structInfo->imageCreateFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageType(" << structInfo->imageType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageTiling(" << structInfo->imageTiling << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageUsageFlags(" << structInfo->imageUsageFlags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoFormatPropertiesKHR");
    out << "\t\t" << "VkVideoFormatPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoPictureResourceInfoKHR(std::ostream &out, const VkVideoPictureResourceInfoKHR* structInfo, Decoded_VkVideoPictureResourceInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string coded_offset_info_var = GenerateStruct_VkOffset2D(out,
                                                                  &structInfo->codedOffset,
                                                                  metaInfo->codedOffset,
                                                                  consumer);
    std::string coded_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                  &structInfo->codedExtent,
                                                                  metaInfo->codedExtent,
                                                                  consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << coded_offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << coded_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->baseArrayLayer << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->imageViewBinding) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoPictureResourceInfoKHR");
    out << "\t\t" << "VkVideoPictureResourceInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoProfileInfoKHR(std::ostream &out, const VkVideoProfileInfoKHR* structInfo, Decoded_VkVideoProfileInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoCodecOperationFlagBitsKHR(" << structInfo->videoCodecOperation << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoChromaSubsamplingFlagsKHR(" << structInfo->chromaSubsampling << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoComponentBitDepthFlagsKHR(" << structInfo->lumaBitDepth << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoComponentBitDepthFlagsKHR(" << structInfo->chromaBitDepth << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoProfileInfoKHR");
    out << "\t\t" << "VkVideoProfileInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoProfileListInfoKHR(std::ostream &out, const VkVideoProfileListInfoKHR* structInfo, Decoded_VkVideoProfileListInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pprofiles_array = "NULL";
    if (structInfo->pProfiles != NULL) {
        pprofiles_array = "pProfiles_" + std::to_string(consumer.GetNextId());
        std::string pprofiles_names;
        for (uint32_t idx = 0; idx < structInfo->profileCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pProfiles + idx != NULL) {
                variable_name = GenerateStruct_VkVideoProfileInfoKHR(out,
                                                                     structInfo->pProfiles + idx,
                                                                     metaInfo->pProfiles->GetMetaStructPointer() + idx,
                                                                     consumer);
            }
            pprofiles_names += variable_name + ", ";
        }
        out << "\t\t" << "VkVideoProfileInfoKHR " << pprofiles_array << "[] = {" << pprofiles_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->profileCount << "," << std::endl;
    struct_body << "\t\t\t" << pprofiles_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoProfileListInfoKHR");
    out << "\t\t" << "VkVideoProfileListInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoReferenceSlotInfoKHR(std::ostream &out, const VkVideoReferenceSlotInfoKHR* structInfo, Decoded_VkVideoReferenceSlotInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string ppicture_resource_struct = "NULL";
    if (structInfo->pPictureResource != NULL) {
        ppicture_resource_struct = GenerateStruct_VkVideoPictureResourceInfoKHR(out,
                                                                                structInfo->pPictureResource,
                                                                                metaInfo->pPictureResource->GetMetaStructPointer(),
                                                                                consumer);
        ppicture_resource_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->slotIndex << "," << std::endl;
    struct_body << "\t\t\t" << ppicture_resource_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoReferenceSlotInfoKHR");
    out << "\t\t" << "VkVideoReferenceSlotInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoSessionCreateInfoKHR(std::ostream &out, const VkVideoSessionCreateInfoKHR* structInfo, Decoded_VkVideoSessionCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pvideo_profile_struct = "NULL";
    if (structInfo->pVideoProfile != NULL) {
        pvideo_profile_struct = GenerateStruct_VkVideoProfileInfoKHR(out,
                                                                     structInfo->pVideoProfile,
                                                                     metaInfo->pVideoProfile->GetMetaStructPointer(),
                                                                     consumer);
        pvideo_profile_struct.insert(0, "&");
    }
    std::string max_coded_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                      &structInfo->maxCodedExtent,
                                                                      metaInfo->maxCodedExtent,
                                                                      consumer);
    std::string pstd_header_version_struct = "NULL";
    if (structInfo->pStdHeaderVersion != NULL) {
        pstd_header_version_struct = GenerateStruct_VkExtensionProperties(out,
                                                                          structInfo->pStdHeaderVersion,
                                                                          metaInfo->pStdHeaderVersion->GetMetaStructPointer(),
                                                                          consumer);
        pstd_header_version_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->queueFamilyIndex << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoSessionCreateFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pvideo_profile_struct << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->pictureFormat << ")" << "," << std::endl;
    struct_body << "\t\t\t" << max_coded_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->referencePictureFormat << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDpbSlots << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxActiveReferencePictures << "," << std::endl;
    struct_body << "\t\t\t" << pstd_header_version_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoSessionCreateInfoKHR");
    out << "\t\t" << "VkVideoSessionCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoSessionMemoryRequirementsKHR(std::ostream &out, const VkVideoSessionMemoryRequirementsKHR* structInfo, Decoded_VkVideoSessionMemoryRequirementsKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string memory_requirements_info_var = GenerateStruct_VkMemoryRequirements(out,
                                                                                   &structInfo->memoryRequirements,
                                                                                   metaInfo->memoryRequirements,
                                                                                   consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->memoryBindIndex << "," << std::endl;
    struct_body << "\t\t\t" << memory_requirements_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoSessionMemoryRequirementsKHR");
    out << "\t\t" << "VkVideoSessionMemoryRequirementsKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoSessionParametersCreateInfoKHR(std::ostream &out, const VkVideoSessionParametersCreateInfoKHR* structInfo, Decoded_VkVideoSessionParametersCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoSessionParametersCreateFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->videoSessionParametersTemplate) << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->videoSession) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoSessionParametersCreateInfoKHR");
    out << "\t\t" << "VkVideoSessionParametersCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoSessionParametersUpdateInfoKHR(std::ostream &out, const VkVideoSessionParametersUpdateInfoKHR* structInfo, Decoded_VkVideoSessionParametersUpdateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->updateSequenceCount << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoSessionParametersUpdateInfoKHR");
    out << "\t\t" << "VkVideoSessionParametersUpdateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeCapabilitiesKHR(std::ostream &out, const VkVideoDecodeCapabilitiesKHR* structInfo, Decoded_VkVideoDecodeCapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoDecodeCapabilityFlagsKHR(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeCapabilitiesKHR");
    out << "\t\t" << "VkVideoDecodeCapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeInfoKHR(std::ostream &out, const VkVideoDecodeInfoKHR* structInfo, Decoded_VkVideoDecodeInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string dst_picture_resource_info_var = GenerateStruct_VkVideoPictureResourceInfoKHR(out,
                                                                                             &structInfo->dstPictureResource,
                                                                                             metaInfo->dstPictureResource,
                                                                                             consumer);
    std::string psetup_reference_slot_struct = "NULL";
    if (structInfo->pSetupReferenceSlot != NULL) {
        psetup_reference_slot_struct = GenerateStruct_VkVideoReferenceSlotInfoKHR(out,
                                                                                  structInfo->pSetupReferenceSlot,
                                                                                  metaInfo->pSetupReferenceSlot->GetMetaStructPointer(),
                                                                                  consumer);
        psetup_reference_slot_struct.insert(0, "&");
    }
    std::string preference_slots_array = "NULL";
    if (structInfo->pReferenceSlots != NULL) {
        preference_slots_array = "pReferenceSlots_" + std::to_string(consumer.GetNextId());
        std::string preference_slots_names;
        for (uint32_t idx = 0; idx < structInfo->referenceSlotCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pReferenceSlots + idx != NULL) {
                variable_name = GenerateStruct_VkVideoReferenceSlotInfoKHR(out,
                                                                           structInfo->pReferenceSlots + idx,
                                                                           metaInfo->pReferenceSlots->GetMetaStructPointer() + idx,
                                                                           consumer);
            }
            preference_slots_names += variable_name + ", ";
        }
        out << "\t\t" << "VkVideoReferenceSlotInfoKHR " << preference_slots_array << "[] = {" << preference_slots_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoDecodeFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->srcBuffer) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->srcBufferOffset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->srcBufferRange << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << dst_picture_resource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << psetup_reference_slot_struct << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->referenceSlotCount << "," << std::endl;
    struct_body << "\t\t\t" << preference_slots_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeInfoKHR");
    out << "\t\t" << "VkVideoDecodeInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeUsageInfoKHR(std::ostream &out, const VkVideoDecodeUsageInfoKHR* structInfo, Decoded_VkVideoDecodeUsageInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoDecodeUsageFlagsKHR(" << structInfo->videoUsageHints << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeUsageInfoKHR");
    out << "\t\t" << "VkVideoDecodeUsageInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264CapabilitiesKHR(std::ostream &out, const VkVideoEncodeH264CapabilitiesKHR* structInfo, Decoded_VkVideoEncodeH264CapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeH264CapabilityFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264LevelIdc(" << structInfo->maxLevelIdc << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxSliceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxPPictureL0ReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxBPictureL0ReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxL1ReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTemporalLayerCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->expectDyadicTemporalLayerPattern << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minQp << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxQp << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->prefersGopRemainingFrames << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->requiresGopRemainingFrames << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeH264StdFlagsKHR(" << structInfo->stdSyntaxFlags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264CapabilitiesKHR");
    out << "\t\t" << "VkVideoEncodeH264CapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264DpbSlotInfoKHR(std::ostream &out, const VkVideoEncodeH264DpbSlotInfoKHR* structInfo, Decoded_VkVideoEncodeH264DpbSlotInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pstd_reference_info_struct = "NULL";
    if (structInfo->pStdReferenceInfo != NULL) {
        pstd_reference_info_struct = GenerateStruct_StdVideoEncodeH264ReferenceInfo(out,
                                                                                    structInfo->pStdReferenceInfo,
                                                                                    metaInfo->pStdReferenceInfo->GetMetaStructPointer(),
                                                                                    consumer);
        pstd_reference_info_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pstd_reference_info_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264DpbSlotInfoKHR");
    out << "\t\t" << "VkVideoEncodeH264DpbSlotInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264FrameSizeKHR(std::ostream &out, const VkVideoEncodeH264FrameSizeKHR* structInfo, Decoded_VkVideoEncodeH264FrameSizeKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->frameISize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->framePSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frameBSize << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264FrameSizeKHR");
    out << "\t\t" << "VkVideoEncodeH264FrameSizeKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264GopRemainingFrameInfoKHR(std::ostream &out, const VkVideoEncodeH264GopRemainingFrameInfoKHR* structInfo, Decoded_VkVideoEncodeH264GopRemainingFrameInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->useGopRemainingFrames << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->gopRemainingI << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->gopRemainingP << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->gopRemainingB << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264GopRemainingFrameInfoKHR");
    out << "\t\t" << "VkVideoEncodeH264GopRemainingFrameInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264NaluSliceInfoKHR(std::ostream &out, const VkVideoEncodeH264NaluSliceInfoKHR* structInfo, Decoded_VkVideoEncodeH264NaluSliceInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pstd_slice_header_struct = "NULL";
    if (structInfo->pStdSliceHeader != NULL) {
        pstd_slice_header_struct = GenerateStruct_StdVideoEncodeH264SliceHeader(out,
                                                                                structInfo->pStdSliceHeader,
                                                                                metaInfo->pStdSliceHeader->GetMetaStructPointer(),
                                                                                consumer);
        pstd_slice_header_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->constantQp << "," << std::endl;
    struct_body << "\t\t\t" << pstd_slice_header_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264NaluSliceInfoKHR");
    out << "\t\t" << "VkVideoEncodeH264NaluSliceInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264PictureInfoKHR(std::ostream &out, const VkVideoEncodeH264PictureInfoKHR* structInfo, Decoded_VkVideoEncodeH264PictureInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pnalu_slice_entries_array = "NULL";
    if (structInfo->pNaluSliceEntries != NULL) {
        pnalu_slice_entries_array = "pNaluSliceEntries_" + std::to_string(consumer.GetNextId());
        std::string pnalu_slice_entries_names;
        for (uint32_t idx = 0; idx < structInfo->naluSliceEntryCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pNaluSliceEntries + idx != NULL) {
                variable_name = GenerateStruct_VkVideoEncodeH264NaluSliceInfoKHR(out,
                                                                                 structInfo->pNaluSliceEntries + idx,
                                                                                 metaInfo->pNaluSliceEntries->GetMetaStructPointer() + idx,
                                                                                 consumer);
            }
            pnalu_slice_entries_names += variable_name + ", ";
        }
        out << "\t\t" << "VkVideoEncodeH264NaluSliceInfoKHR " << pnalu_slice_entries_array << "[] = {" << pnalu_slice_entries_names << "};" << std::endl;
    }
    std::string pstd_picture_info_struct = "NULL";
    if (structInfo->pStdPictureInfo != NULL) {
        pstd_picture_info_struct = GenerateStruct_StdVideoEncodeH264PictureInfo(out,
                                                                                structInfo->pStdPictureInfo,
                                                                                metaInfo->pStdPictureInfo->GetMetaStructPointer(),
                                                                                consumer);
        pstd_picture_info_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->naluSliceEntryCount << "," << std::endl;
    struct_body << "\t\t\t" << pnalu_slice_entries_array << "," << std::endl;
    struct_body << "\t\t\t" << pstd_picture_info_struct << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->generatePrefixNalu << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264PictureInfoKHR");
    out << "\t\t" << "VkVideoEncodeH264PictureInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264ProfileInfoKHR(std::ostream &out, const VkVideoEncodeH264ProfileInfoKHR* structInfo, Decoded_VkVideoEncodeH264ProfileInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264ProfileIdc(" << structInfo->stdProfileIdc << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264ProfileInfoKHR");
    out << "\t\t" << "VkVideoEncodeH264ProfileInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264QpKHR(std::ostream &out, const VkVideoEncodeH264QpKHR* structInfo, Decoded_VkVideoEncodeH264QpKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->qpI << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->qpP << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->qpB << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264QpKHR");
    out << "\t\t" << "VkVideoEncodeH264QpKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264QualityLevelPropertiesKHR(std::ostream &out, const VkVideoEncodeH264QualityLevelPropertiesKHR* structInfo, Decoded_VkVideoEncodeH264QualityLevelPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string preferred_constant_qp_info_var = GenerateStruct_VkVideoEncodeH264QpKHR(out,
                                                                                       &structInfo->preferredConstantQp,
                                                                                       metaInfo->preferredConstantQp,
                                                                                       consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeH264RateControlFlagsKHR(" << structInfo->preferredRateControlFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredGopFrameCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredIdrPeriod << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredConsecutiveBFrameCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredTemporalLayerCount << "," << std::endl;
    struct_body << "\t\t\t" << preferred_constant_qp_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredMaxL0ReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredMaxL1ReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredStdEntropyCodingModeFlag << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264QualityLevelPropertiesKHR");
    out << "\t\t" << "VkVideoEncodeH264QualityLevelPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264RateControlInfoKHR(std::ostream &out, const VkVideoEncodeH264RateControlInfoKHR* structInfo, Decoded_VkVideoEncodeH264RateControlInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeH264RateControlFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->gopFrameCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->idrPeriod << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->consecutiveBFrameCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->temporalLayerCount << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264RateControlInfoKHR");
    out << "\t\t" << "VkVideoEncodeH264RateControlInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264RateControlLayerInfoKHR(std::ostream &out, const VkVideoEncodeH264RateControlLayerInfoKHR* structInfo, Decoded_VkVideoEncodeH264RateControlLayerInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string min_qp_info_var = GenerateStruct_VkVideoEncodeH264QpKHR(out,
                                                                        &structInfo->minQp,
                                                                        metaInfo->minQp,
                                                                        consumer);
    std::string max_qp_info_var = GenerateStruct_VkVideoEncodeH264QpKHR(out,
                                                                        &structInfo->maxQp,
                                                                        metaInfo->maxQp,
                                                                        consumer);
    std::string max_frame_size_info_var = GenerateStruct_VkVideoEncodeH264FrameSizeKHR(out,
                                                                                       &structInfo->maxFrameSize,
                                                                                       metaInfo->maxFrameSize,
                                                                                       consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->useMinQp << "," << std::endl;
    struct_body << "\t\t\t" << min_qp_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->useMaxQp << "," << std::endl;
    struct_body << "\t\t\t" << max_qp_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->useMaxFrameSize << "," << std::endl;
    struct_body << "\t\t\t" << max_frame_size_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264RateControlLayerInfoKHR");
    out << "\t\t" << "VkVideoEncodeH264RateControlLayerInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264SessionCreateInfoKHR(std::ostream &out, const VkVideoEncodeH264SessionCreateInfoKHR* structInfo, Decoded_VkVideoEncodeH264SessionCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->useMaxLevelIdc << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264LevelIdc(" << structInfo->maxLevelIdc << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264SessionCreateInfoKHR");
    out << "\t\t" << "VkVideoEncodeH264SessionCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264SessionParametersAddInfoKHR(std::ostream &out, const VkVideoEncodeH264SessionParametersAddInfoKHR* structInfo, Decoded_VkVideoEncodeH264SessionParametersAddInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pstd_s_pss_array = "NULL";
    if (structInfo->pStdSPSs != NULL) {
        pstd_s_pss_array = "pStdSPSs_" + std::to_string(consumer.GetNextId());
        std::string pstd_s_pss_names;
        for (uint32_t idx = 0; idx < structInfo->stdSPSCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pStdSPSs + idx != NULL) {
                variable_name = GenerateStruct_StdVideoH264SequenceParameterSet(out,
                                                                                structInfo->pStdSPSs + idx,
                                                                                metaInfo->pStdSPSs->GetMetaStructPointer() + idx,
                                                                                consumer);
            }
            pstd_s_pss_names += variable_name + ", ";
        }
        out << "\t\t" << "StdVideoH264SequenceParameterSet " << pstd_s_pss_array << "[] = {" << pstd_s_pss_names << "};" << std::endl;
    }
    std::string pstd_pp_ss_array = "NULL";
    if (structInfo->pStdPPSs != NULL) {
        pstd_pp_ss_array = "pStdPPSs_" + std::to_string(consumer.GetNextId());
        std::string pstd_pp_ss_names;
        for (uint32_t idx = 0; idx < structInfo->stdPPSCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pStdPPSs + idx != NULL) {
                variable_name = GenerateStruct_StdVideoH264PictureParameterSet(out,
                                                                               structInfo->pStdPPSs + idx,
                                                                               metaInfo->pStdPPSs->GetMetaStructPointer() + idx,
                                                                               consumer);
            }
            pstd_pp_ss_names += variable_name + ", ";
        }
        out << "\t\t" << "StdVideoH264PictureParameterSet " << pstd_pp_ss_array << "[] = {" << pstd_pp_ss_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stdSPSCount << "," << std::endl;
    struct_body << "\t\t\t" << pstd_s_pss_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stdPPSCount << "," << std::endl;
    struct_body << "\t\t\t" << pstd_pp_ss_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264SessionParametersAddInfoKHR");
    out << "\t\t" << "VkVideoEncodeH264SessionParametersAddInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264SessionParametersCreateInfoKHR(std::ostream &out, const VkVideoEncodeH264SessionParametersCreateInfoKHR* structInfo, Decoded_VkVideoEncodeH264SessionParametersCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pparameters_add_info_struct = "NULL";
    if (structInfo->pParametersAddInfo != NULL) {
        pparameters_add_info_struct = GenerateStruct_VkVideoEncodeH264SessionParametersAddInfoKHR(out,
                                                                                                  structInfo->pParametersAddInfo,
                                                                                                  metaInfo->pParametersAddInfo->GetMetaStructPointer(),
                                                                                                  consumer);
        pparameters_add_info_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxStdSPSCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxStdPPSCount << "," << std::endl;
    struct_body << "\t\t\t" << pparameters_add_info_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264SessionParametersCreateInfoKHR");
    out << "\t\t" << "VkVideoEncodeH264SessionParametersCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264SessionParametersFeedbackInfoKHR(std::ostream &out, const VkVideoEncodeH264SessionParametersFeedbackInfoKHR* structInfo, Decoded_VkVideoEncodeH264SessionParametersFeedbackInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->hasStdSPSOverrides << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->hasStdPPSOverrides << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264SessionParametersFeedbackInfoKHR");
    out << "\t\t" << "VkVideoEncodeH264SessionParametersFeedbackInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264SessionParametersGetInfoKHR(std::ostream &out, const VkVideoEncodeH264SessionParametersGetInfoKHR* structInfo, Decoded_VkVideoEncodeH264SessionParametersGetInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->writeStdSPS << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->writeStdPPS << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stdSPSId << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stdPPSId << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264SessionParametersGetInfoKHR");
    out << "\t\t" << "VkVideoEncodeH264SessionParametersGetInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeH264CapabilitiesKHR(std::ostream &out, const VkVideoDecodeH264CapabilitiesKHR* structInfo, Decoded_VkVideoDecodeH264CapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string field_offset_granularity_info_var = GenerateStruct_VkOffset2D(out,
                                                                              &structInfo->fieldOffsetGranularity,
                                                                              metaInfo->fieldOffsetGranularity,
                                                                              consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264LevelIdc(" << structInfo->maxLevelIdc << ")" << "," << std::endl;
    struct_body << "\t\t\t" << field_offset_granularity_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeH264CapabilitiesKHR");
    out << "\t\t" << "VkVideoDecodeH264CapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeH264DpbSlotInfoKHR(std::ostream &out, const VkVideoDecodeH264DpbSlotInfoKHR* structInfo, Decoded_VkVideoDecodeH264DpbSlotInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pstd_reference_info_struct = "NULL";
    if (structInfo->pStdReferenceInfo != NULL) {
        pstd_reference_info_struct = GenerateStruct_StdVideoDecodeH264ReferenceInfo(out,
                                                                                    structInfo->pStdReferenceInfo,
                                                                                    metaInfo->pStdReferenceInfo->GetMetaStructPointer(),
                                                                                    consumer);
        pstd_reference_info_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pstd_reference_info_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeH264DpbSlotInfoKHR");
    out << "\t\t" << "VkVideoDecodeH264DpbSlotInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeH264PictureInfoKHR(std::ostream &out, const VkVideoDecodeH264PictureInfoKHR* structInfo, Decoded_VkVideoDecodeH264PictureInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pstd_picture_info_struct = "NULL";
    if (structInfo->pStdPictureInfo != NULL) {
        pstd_picture_info_struct = GenerateStruct_StdVideoDecodeH264PictureInfo(out,
                                                                                structInfo->pStdPictureInfo,
                                                                                metaInfo->pStdPictureInfo->GetMetaStructPointer(),
                                                                                consumer);
        pstd_picture_info_struct.insert(0, "&");
    }
    std::string pslice_offsets_array = "NULL";
    if (structInfo->pSliceOffsets != NULL) {
        pslice_offsets_array = "pSliceOffsets_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pslice_offsets_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pSliceOffsets, structInfo->sliceCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pstd_picture_info_struct << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->sliceCount << "," << std::endl;
    struct_body << "\t\t\t" << pslice_offsets_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeH264PictureInfoKHR");
    out << "\t\t" << "VkVideoDecodeH264PictureInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeH264ProfileInfoKHR(std::ostream &out, const VkVideoDecodeH264ProfileInfoKHR* structInfo, Decoded_VkVideoDecodeH264ProfileInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoH264ProfileIdc(" << structInfo->stdProfileIdc << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoDecodeH264PictureLayoutFlagBitsKHR(" << structInfo->pictureLayout << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeH264ProfileInfoKHR");
    out << "\t\t" << "VkVideoDecodeH264ProfileInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeH264SessionParametersAddInfoKHR(std::ostream &out, const VkVideoDecodeH264SessionParametersAddInfoKHR* structInfo, Decoded_VkVideoDecodeH264SessionParametersAddInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pstd_s_pss_array = "NULL";
    if (structInfo->pStdSPSs != NULL) {
        pstd_s_pss_array = "pStdSPSs_" + std::to_string(consumer.GetNextId());
        std::string pstd_s_pss_names;
        for (uint32_t idx = 0; idx < structInfo->stdSPSCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pStdSPSs + idx != NULL) {
                variable_name = GenerateStruct_StdVideoH264SequenceParameterSet(out,
                                                                                structInfo->pStdSPSs + idx,
                                                                                metaInfo->pStdSPSs->GetMetaStructPointer() + idx,
                                                                                consumer);
            }
            pstd_s_pss_names += variable_name + ", ";
        }
        out << "\t\t" << "StdVideoH264SequenceParameterSet " << pstd_s_pss_array << "[] = {" << pstd_s_pss_names << "};" << std::endl;
    }
    std::string pstd_pp_ss_array = "NULL";
    if (structInfo->pStdPPSs != NULL) {
        pstd_pp_ss_array = "pStdPPSs_" + std::to_string(consumer.GetNextId());
        std::string pstd_pp_ss_names;
        for (uint32_t idx = 0; idx < structInfo->stdPPSCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pStdPPSs + idx != NULL) {
                variable_name = GenerateStruct_StdVideoH264PictureParameterSet(out,
                                                                               structInfo->pStdPPSs + idx,
                                                                               metaInfo->pStdPPSs->GetMetaStructPointer() + idx,
                                                                               consumer);
            }
            pstd_pp_ss_names += variable_name + ", ";
        }
        out << "\t\t" << "StdVideoH264PictureParameterSet " << pstd_pp_ss_array << "[] = {" << pstd_pp_ss_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stdSPSCount << "," << std::endl;
    struct_body << "\t\t\t" << pstd_s_pss_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stdPPSCount << "," << std::endl;
    struct_body << "\t\t\t" << pstd_pp_ss_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeH264SessionParametersAddInfoKHR");
    out << "\t\t" << "VkVideoDecodeH264SessionParametersAddInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeH264SessionParametersCreateInfoKHR(std::ostream &out, const VkVideoDecodeH264SessionParametersCreateInfoKHR* structInfo, Decoded_VkVideoDecodeH264SessionParametersCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pparameters_add_info_struct = "NULL";
    if (structInfo->pParametersAddInfo != NULL) {
        pparameters_add_info_struct = GenerateStruct_VkVideoDecodeH264SessionParametersAddInfoKHR(out,
                                                                                                  structInfo->pParametersAddInfo,
                                                                                                  metaInfo->pParametersAddInfo->GetMetaStructPointer(),
                                                                                                  consumer);
        pparameters_add_info_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxStdSPSCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxStdPPSCount << "," << std::endl;
    struct_body << "\t\t\t" << pparameters_add_info_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeH264SessionParametersCreateInfoKHR");
    out << "\t\t" << "VkVideoDecodeH264SessionParametersCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExportMemoryWin32HandleInfoKHR(std::ostream &out, const VkExportMemoryWin32HandleInfoKHR* structInfo, Decoded_VkExportMemoryWin32HandleInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pAttributes << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dwAccess << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<LPCWSTR>(" << util::strings::convert_wstring_to_utf8(structInfo->name) << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "exportMemoryWin32HandleInfoKHR");
    out << "\t\t" << "VkExportMemoryWin32HandleInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImportMemoryWin32HandleInfoKHR(std::ostream &out, const VkImportMemoryWin32HandleInfoKHR* structInfo, Decoded_VkImportMemoryWin32HandleInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlagBits(" << structInfo->handleType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<HANDLE>(" << structInfo->handle << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<LPCWSTR>(" << util::strings::convert_wstring_to_utf8(structInfo->name) << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "importMemoryWin32HandleInfoKHR");
    out << "\t\t" << "VkImportMemoryWin32HandleInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryGetWin32HandleInfoKHR(std::ostream &out, const VkMemoryGetWin32HandleInfoKHR* structInfo, Decoded_VkMemoryGetWin32HandleInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->memory) << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlagBits(" << structInfo->handleType << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryGetWin32HandleInfoKHR");
    out << "\t\t" << "VkMemoryGetWin32HandleInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryWin32HandlePropertiesKHR(std::ostream &out, const VkMemoryWin32HandlePropertiesKHR* structInfo, Decoded_VkMemoryWin32HandlePropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->memoryTypeBits << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryWin32HandlePropertiesKHR");
    out << "\t\t" << "VkMemoryWin32HandlePropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImportMemoryFdInfoKHR(std::ostream &out, const VkImportMemoryFdInfoKHR* structInfo, Decoded_VkImportMemoryFdInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlagBits(" << structInfo->handleType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fd << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "importMemoryFdInfoKHR");
    out << "\t\t" << "VkImportMemoryFdInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryFdPropertiesKHR(std::ostream &out, const VkMemoryFdPropertiesKHR* structInfo, Decoded_VkMemoryFdPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->memoryTypeBits << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryFdPropertiesKHR");
    out << "\t\t" << "VkMemoryFdPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryGetFdInfoKHR(std::ostream &out, const VkMemoryGetFdInfoKHR* structInfo, Decoded_VkMemoryGetFdInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->memory) << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlagBits(" << structInfo->handleType << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryGetFdInfoKHR");
    out << "\t\t" << "VkMemoryGetFdInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkWin32KeyedMutexAcquireReleaseInfoKHR(std::ostream &out, const VkWin32KeyedMutexAcquireReleaseInfoKHR* structInfo, Decoded_VkWin32KeyedMutexAcquireReleaseInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pacquire_syncs_array = "NULL";
    if (metaInfo->pAcquireSyncs.GetPointer() != NULL && structInfo->acquireCount > 0) {
        pacquire_syncs_array = "pacquire_syncs_array_" + std::to_string(consumer.GetNextId(VK_OBJECT_TYPE_DEVICE_MEMORY));
        std::string pacquire_syncs_values = toStringJoin(metaInfo->pAcquireSyncs.GetPointer(),
                                                         metaInfo->pAcquireSyncs.GetPointer() + structInfo->acquireCount,
                                                         [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                         ", ");
        if (structInfo->acquireCount == 1) {
            pacquire_syncs_array = "&" + pacquire_syncs_values;
        } else if (structInfo->acquireCount > 1) {
            out << "\t\t" << "VkDeviceMemory " << pacquire_syncs_array << "[] = {" << pacquire_syncs_values << "};" << std::endl;
        }
    }
    std::string pacquire_keys_array = "pacquire_keys_array_" + std::to_string(consumer.GetNextId());
    if (structInfo->acquireCount > 0) {
        std::string pacquire_keys_values = toStringJoin(structInfo->pAcquireKeys,
                                                        structInfo->pAcquireKeys + structInfo->acquireCount,
                                                        [](uint64_t current) { return std::to_string(current); },
                                                        ", ");
        if (structInfo->acquireCount == 1) {
            pacquire_keys_array = "&" + pacquire_keys_values;
        } else if (structInfo->acquireCount > 1) {
            out << "\t\t" << "uint64_t " << pacquire_keys_array << "[] = {" << pacquire_keys_values << "};" << std::endl;
        }
    }
    std::string pacquire_timeouts_array = "NULL";
    if (structInfo->pAcquireTimeouts != NULL) {
        pacquire_timeouts_array = "pAcquireTimeouts_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pacquire_timeouts_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pAcquireTimeouts, structInfo->acquireCount) << ";" << std::endl;
    }
    std::string prelease_syncs_array = "NULL";
    if (metaInfo->pReleaseSyncs.GetPointer() != NULL && structInfo->releaseCount > 0) {
        prelease_syncs_array = "prelease_syncs_array_" + std::to_string(consumer.GetNextId(VK_OBJECT_TYPE_DEVICE_MEMORY));
        std::string prelease_syncs_values = toStringJoin(metaInfo->pReleaseSyncs.GetPointer(),
                                                         metaInfo->pReleaseSyncs.GetPointer() + structInfo->releaseCount,
                                                         [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                         ", ");
        if (structInfo->releaseCount == 1) {
            prelease_syncs_array = "&" + prelease_syncs_values;
        } else if (structInfo->releaseCount > 1) {
            out << "\t\t" << "VkDeviceMemory " << prelease_syncs_array << "[] = {" << prelease_syncs_values << "};" << std::endl;
        }
    }
    std::string prelease_keys_array = "prelease_keys_array_" + std::to_string(consumer.GetNextId());
    if (structInfo->releaseCount > 0) {
        std::string prelease_keys_values = toStringJoin(structInfo->pReleaseKeys,
                                                        structInfo->pReleaseKeys + structInfo->releaseCount,
                                                        [](uint64_t current) { return std::to_string(current); },
                                                        ", ");
        if (structInfo->releaseCount == 1) {
            prelease_keys_array = "&" + prelease_keys_values;
        } else if (structInfo->releaseCount > 1) {
            out << "\t\t" << "uint64_t " << prelease_keys_array << "[] = {" << prelease_keys_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->acquireCount << "," << std::endl;
    struct_body << "\t\t\t" << pacquire_syncs_array << "," << std::endl;
    struct_body << "\t\t\t" << "{ *" << pacquire_keys_array << " }" << "," << std::endl;
    struct_body << "\t\t\t" << pacquire_timeouts_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->releaseCount << "," << std::endl;
    struct_body << "\t\t\t" << prelease_syncs_array << "," << std::endl;
    struct_body << "\t\t\t" << "{ *" << prelease_keys_array << " }" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "win32KeyedMutexAcquireReleaseInfoKHR");
    out << "\t\t" << "VkWin32KeyedMutexAcquireReleaseInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkD3D12FenceSubmitInfoKHR(std::ostream &out, const VkD3D12FenceSubmitInfoKHR* structInfo, Decoded_VkD3D12FenceSubmitInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pwait_semaphore_values_array = "pwait_semaphore_values_array_" + std::to_string(consumer.GetNextId());
    if (structInfo->waitSemaphoreValuesCount > 0) {
        std::string pwait_semaphore_values_values = toStringJoin(structInfo->pWaitSemaphoreValues,
                                                                 structInfo->pWaitSemaphoreValues + structInfo->waitSemaphoreValuesCount,
                                                                 [](uint64_t current) { return std::to_string(current); },
                                                                 ", ");
        if (structInfo->waitSemaphoreValuesCount == 1) {
            pwait_semaphore_values_array = "&" + pwait_semaphore_values_values;
        } else if (structInfo->waitSemaphoreValuesCount > 1) {
            out << "\t\t" << "uint64_t " << pwait_semaphore_values_array << "[] = {" << pwait_semaphore_values_values << "};" << std::endl;
        }
    }
    std::string psignal_semaphore_values_array = "psignal_semaphore_values_array_" + std::to_string(consumer.GetNextId());
    if (structInfo->signalSemaphoreValuesCount > 0) {
        std::string psignal_semaphore_values_values = toStringJoin(structInfo->pSignalSemaphoreValues,
                                                                   structInfo->pSignalSemaphoreValues + structInfo->signalSemaphoreValuesCount,
                                                                   [](uint64_t current) { return std::to_string(current); },
                                                                   ", ");
        if (structInfo->signalSemaphoreValuesCount == 1) {
            psignal_semaphore_values_array = "&" + psignal_semaphore_values_values;
        } else if (structInfo->signalSemaphoreValuesCount > 1) {
            out << "\t\t" << "uint64_t " << psignal_semaphore_values_array << "[] = {" << psignal_semaphore_values_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->waitSemaphoreValuesCount << "," << std::endl;
    struct_body << "\t\t\t" << "{ *" << pwait_semaphore_values_array << " }" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->signalSemaphoreValuesCount << "," << std::endl;
    struct_body << "\t\t\t" << "{ *" << psignal_semaphore_values_array << " }" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "d3D12FenceSubmitInfoKHR");
    out << "\t\t" << "VkD3D12FenceSubmitInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExportSemaphoreWin32HandleInfoKHR(std::ostream &out, const VkExportSemaphoreWin32HandleInfoKHR* structInfo, Decoded_VkExportSemaphoreWin32HandleInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pAttributes << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dwAccess << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<LPCWSTR>(" << util::strings::convert_wstring_to_utf8(structInfo->name) << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "exportSemaphoreWin32HandleInfoKHR");
    out << "\t\t" << "VkExportSemaphoreWin32HandleInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImportSemaphoreWin32HandleInfoKHR(std::ostream &out, const VkImportSemaphoreWin32HandleInfoKHR* structInfo, Decoded_VkImportSemaphoreWin32HandleInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->semaphore) << "," << std::endl;
    struct_body << "\t\t\t" << "VkSemaphoreImportFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalSemaphoreHandleTypeFlagBits(" << structInfo->handleType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<HANDLE>(" << structInfo->handle << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<LPCWSTR>(" << util::strings::convert_wstring_to_utf8(structInfo->name) << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "importSemaphoreWin32HandleInfoKHR");
    out << "\t\t" << "VkImportSemaphoreWin32HandleInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSemaphoreGetWin32HandleInfoKHR(std::ostream &out, const VkSemaphoreGetWin32HandleInfoKHR* structInfo, Decoded_VkSemaphoreGetWin32HandleInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->semaphore) << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalSemaphoreHandleTypeFlagBits(" << structInfo->handleType << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "semaphoreGetWin32HandleInfoKHR");
    out << "\t\t" << "VkSemaphoreGetWin32HandleInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImportSemaphoreFdInfoKHR(std::ostream &out, const VkImportSemaphoreFdInfoKHR* structInfo, Decoded_VkImportSemaphoreFdInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->semaphore) << "," << std::endl;
    struct_body << "\t\t\t" << "VkSemaphoreImportFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalSemaphoreHandleTypeFlagBits(" << structInfo->handleType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fd << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "importSemaphoreFdInfoKHR");
    out << "\t\t" << "VkImportSemaphoreFdInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSemaphoreGetFdInfoKHR(std::ostream &out, const VkSemaphoreGetFdInfoKHR* structInfo, Decoded_VkSemaphoreGetFdInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->semaphore) << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalSemaphoreHandleTypeFlagBits(" << structInfo->handleType << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "semaphoreGetFdInfoKHR");
    out << "\t\t" << "VkSemaphoreGetFdInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPresentRegionKHR(std::ostream &out, const VkPresentRegionKHR* structInfo, Decoded_VkPresentRegionKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string prectangles_array = "NULL";
    if (structInfo->pRectangles != NULL) {
        prectangles_array = "pRectangles_" + std::to_string(consumer.GetNextId());
        std::string prectangles_names;
        for (uint32_t idx = 0; idx < structInfo->rectangleCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pRectangles + idx != NULL) {
                variable_name = GenerateStruct_VkRectLayerKHR(out,
                                                              structInfo->pRectangles + idx,
                                                              metaInfo->pRectangles->GetMetaStructPointer() + idx,
                                                              consumer);
            }
            prectangles_names += variable_name + ", ";
        }
        out << "\t\t" << "VkRectLayerKHR " << prectangles_array << "[] = {" << prectangles_names << "};" << std::endl;
    }
    struct_body << "\t" << structInfo->rectangleCount << "," << std::endl;
    struct_body << "\t\t\t" << prectangles_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "presentRegionKHR");
    out << "\t\t" << "VkPresentRegionKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPresentRegionsKHR(std::ostream &out, const VkPresentRegionsKHR* structInfo, Decoded_VkPresentRegionsKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pregions_array = "NULL";
    if (structInfo->pRegions != NULL) {
        pregions_array = "pRegions_" + std::to_string(consumer.GetNextId());
        std::string pregions_names;
        for (uint32_t idx = 0; idx < structInfo->swapchainCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pRegions + idx != NULL) {
                variable_name = GenerateStruct_VkPresentRegionKHR(out,
                                                                  structInfo->pRegions + idx,
                                                                  metaInfo->pRegions->GetMetaStructPointer() + idx,
                                                                  consumer);
            }
            pregions_names += variable_name + ", ";
        }
        out << "\t\t" << "VkPresentRegionKHR " << pregions_array << "[] = {" << pregions_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->swapchainCount << "," << std::endl;
    struct_body << "\t\t\t" << pregions_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "presentRegionsKHR");
    out << "\t\t" << "VkPresentRegionsKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRectLayerKHR(std::ostream &out, const VkRectLayerKHR* structInfo, Decoded_VkRectLayerKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string offset_info_var = GenerateStruct_VkOffset2D(out,
                                                            &structInfo->offset,
                                                            metaInfo->offset,
                                                            consumer);
    std::string extent_info_var = GenerateStruct_VkExtent2D(out,
                                                            &structInfo->extent,
                                                            metaInfo->extent,
                                                            consumer);
    struct_body << "\t" << offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->layer << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "rectLayerKHR");
    out << "\t\t" << "VkRectLayerKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSharedPresentSurfaceCapabilitiesKHR(std::ostream &out, const VkSharedPresentSurfaceCapabilitiesKHR* structInfo, Decoded_VkSharedPresentSurfaceCapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageUsageFlags(" << structInfo->sharedPresentSupportedUsageFlags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "sharedPresentSurfaceCapabilitiesKHR");
    out << "\t\t" << "VkSharedPresentSurfaceCapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExportFenceWin32HandleInfoKHR(std::ostream &out, const VkExportFenceWin32HandleInfoKHR* structInfo, Decoded_VkExportFenceWin32HandleInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pAttributes << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dwAccess << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<LPCWSTR>(" << util::strings::convert_wstring_to_utf8(structInfo->name) << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "exportFenceWin32HandleInfoKHR");
    out << "\t\t" << "VkExportFenceWin32HandleInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkFenceGetWin32HandleInfoKHR(std::ostream &out, const VkFenceGetWin32HandleInfoKHR* structInfo, Decoded_VkFenceGetWin32HandleInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->fence) << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalFenceHandleTypeFlagBits(" << structInfo->handleType << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "fenceGetWin32HandleInfoKHR");
    out << "\t\t" << "VkFenceGetWin32HandleInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImportFenceWin32HandleInfoKHR(std::ostream &out, const VkImportFenceWin32HandleInfoKHR* structInfo, Decoded_VkImportFenceWin32HandleInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->fence) << "," << std::endl;
    struct_body << "\t\t\t" << "VkFenceImportFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalFenceHandleTypeFlagBits(" << structInfo->handleType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<HANDLE>(" << structInfo->handle << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<LPCWSTR>(" << util::strings::convert_wstring_to_utf8(structInfo->name) << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "importFenceWin32HandleInfoKHR");
    out << "\t\t" << "VkImportFenceWin32HandleInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkFenceGetFdInfoKHR(std::ostream &out, const VkFenceGetFdInfoKHR* structInfo, Decoded_VkFenceGetFdInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->fence) << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalFenceHandleTypeFlagBits(" << structInfo->handleType << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "fenceGetFdInfoKHR");
    out << "\t\t" << "VkFenceGetFdInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImportFenceFdInfoKHR(std::ostream &out, const VkImportFenceFdInfoKHR* structInfo, Decoded_VkImportFenceFdInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->fence) << "," << std::endl;
    struct_body << "\t\t\t" << "VkFenceImportFlags(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalFenceHandleTypeFlagBits(" << structInfo->handleType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fd << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "importFenceFdInfoKHR");
    out << "\t\t" << "VkImportFenceFdInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkAcquireProfilingLockInfoKHR(std::ostream &out, const VkAcquireProfilingLockInfoKHR* structInfo, Decoded_VkAcquireProfilingLockInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkAcquireProfilingLockFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->timeout << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "acquireProfilingLockInfoKHR");
    out << "\t\t" << "VkAcquireProfilingLockInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPerformanceCounterDescriptionKHR(std::ostream &out, const VkPerformanceCounterDescriptionKHR* structInfo, Decoded_VkPerformanceCounterDescriptionKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPerformanceCounterDescriptionFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->name) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->category) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->description) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "performanceCounterDescriptionKHR");
    out << "\t\t" << "VkPerformanceCounterDescriptionKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPerformanceCounterKHR(std::ostream &out, const VkPerformanceCounterKHR* structInfo, Decoded_VkPerformanceCounterKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPerformanceCounterUnitKHR(" << structInfo->unit << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPerformanceCounterScopeKHR(" << structInfo->scope << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPerformanceCounterStorageKHR(" << structInfo->storage << ")" << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->uuid[0]), VK_UUID_SIZE) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "performanceCounterKHR");
    out << "\t\t" << "VkPerformanceCounterKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPerformanceQuerySubmitInfoKHR(std::ostream &out, const VkPerformanceQuerySubmitInfoKHR* structInfo, Decoded_VkPerformanceQuerySubmitInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->counterPassIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "performanceQuerySubmitInfoKHR");
    out << "\t\t" << "VkPerformanceQuerySubmitInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePerformanceQueryFeaturesKHR(std::ostream &out, const VkPhysicalDevicePerformanceQueryFeaturesKHR* structInfo, Decoded_VkPhysicalDevicePerformanceQueryFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->performanceCounterQueryPools << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->performanceCounterMultipleQueryPools << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePerformanceQueryFeaturesKHR");
    out << "\t\t" << "VkPhysicalDevicePerformanceQueryFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePerformanceQueryPropertiesKHR(std::ostream &out, const VkPhysicalDevicePerformanceQueryPropertiesKHR* structInfo, Decoded_VkPhysicalDevicePerformanceQueryPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->allowCommandBufferQueryCopies << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePerformanceQueryPropertiesKHR");
    out << "\t\t" << "VkPhysicalDevicePerformanceQueryPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkQueryPoolPerformanceCreateInfoKHR(std::ostream &out, const VkQueryPoolPerformanceCreateInfoKHR* structInfo, Decoded_VkQueryPoolPerformanceCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pcounter_indices_array = "NULL";
    if (structInfo->pCounterIndices != NULL) {
        pcounter_indices_array = "pCounterIndices_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pcounter_indices_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pCounterIndices, structInfo->counterIndexCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->queueFamilyIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->counterIndexCount << "," << std::endl;
    struct_body << "\t\t\t" << pcounter_indices_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "queryPoolPerformanceCreateInfoKHR");
    out << "\t\t" << "VkQueryPoolPerformanceCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceSurfaceInfo2KHR(std::ostream &out, const VkPhysicalDeviceSurfaceInfo2KHR* structInfo, Decoded_VkPhysicalDeviceSurfaceInfo2KHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->surface) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceSurfaceInfo2KHR");
    out << "\t\t" << "VkPhysicalDeviceSurfaceInfo2KHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSurfaceCapabilities2KHR(std::ostream &out, const VkSurfaceCapabilities2KHR* structInfo, Decoded_VkSurfaceCapabilities2KHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string surface_capabilities_info_var = GenerateStruct_VkSurfaceCapabilitiesKHR(out,
                                                                                        &structInfo->surfaceCapabilities,
                                                                                        metaInfo->surfaceCapabilities,
                                                                                        consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << surface_capabilities_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "surfaceCapabilities2KHR");
    out << "\t\t" << "VkSurfaceCapabilities2KHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSurfaceFormat2KHR(std::ostream &out, const VkSurfaceFormat2KHR* structInfo, Decoded_VkSurfaceFormat2KHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string surface_format_info_var = GenerateStruct_VkSurfaceFormatKHR(out,
                                                                            &structInfo->surfaceFormat,
                                                                            metaInfo->surfaceFormat,
                                                                            consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << surface_format_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "surfaceFormat2KHR");
    out << "\t\t" << "VkSurfaceFormat2KHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplayModeProperties2KHR(std::ostream &out, const VkDisplayModeProperties2KHR* structInfo, Decoded_VkDisplayModeProperties2KHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string display_mode_properties_info_var = GenerateStruct_VkDisplayModePropertiesKHR(out,
                                                                                             &structInfo->displayModeProperties,
                                                                                             metaInfo->displayModeProperties,
                                                                                             consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << display_mode_properties_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displayModeProperties2KHR");
    out << "\t\t" << "VkDisplayModeProperties2KHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplayPlaneCapabilities2KHR(std::ostream &out, const VkDisplayPlaneCapabilities2KHR* structInfo, Decoded_VkDisplayPlaneCapabilities2KHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string capabilities_info_var = GenerateStruct_VkDisplayPlaneCapabilitiesKHR(out,
                                                                                     &structInfo->capabilities,
                                                                                     metaInfo->capabilities,
                                                                                     consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << capabilities_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displayPlaneCapabilities2KHR");
    out << "\t\t" << "VkDisplayPlaneCapabilities2KHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplayPlaneInfo2KHR(std::ostream &out, const VkDisplayPlaneInfo2KHR* structInfo, Decoded_VkDisplayPlaneInfo2KHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->mode) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->planeIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displayPlaneInfo2KHR");
    out << "\t\t" << "VkDisplayPlaneInfo2KHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplayPlaneProperties2KHR(std::ostream &out, const VkDisplayPlaneProperties2KHR* structInfo, Decoded_VkDisplayPlaneProperties2KHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string display_plane_properties_info_var = GenerateStruct_VkDisplayPlanePropertiesKHR(out,
                                                                                               &structInfo->displayPlaneProperties,
                                                                                               metaInfo->displayPlaneProperties,
                                                                                               consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << display_plane_properties_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displayPlaneProperties2KHR");
    out << "\t\t" << "VkDisplayPlaneProperties2KHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplayProperties2KHR(std::ostream &out, const VkDisplayProperties2KHR* structInfo, Decoded_VkDisplayProperties2KHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string display_properties_info_var = GenerateStruct_VkDisplayPropertiesKHR(out,
                                                                                    &structInfo->displayProperties,
                                                                                    metaInfo->displayProperties,
                                                                                    consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << display_properties_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displayProperties2KHR");
    out << "\t\t" << "VkDisplayProperties2KHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderBfloat16FeaturesKHR(std::ostream &out, const VkPhysicalDeviceShaderBfloat16FeaturesKHR* structInfo, Decoded_VkPhysicalDeviceShaderBfloat16FeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderBFloat16Type << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderBFloat16DotProduct << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderBFloat16CooperativeMatrix << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderBfloat16FeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceShaderBfloat16FeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePortabilitySubsetFeaturesKHR(std::ostream &out, const VkPhysicalDevicePortabilitySubsetFeaturesKHR* structInfo, Decoded_VkPhysicalDevicePortabilitySubsetFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->constantAlphaColorBlendFactors << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->events << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->imageViewFormatReinterpretation << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->imageViewFormatSwizzle << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->imageView2DOn3DImage << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->multisampleArrayImage << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->mutableComparisonSamplers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pointPolygons << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->samplerMipLodBias << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->separateStencilMaskRef << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSampleRateInterpolationFunctions << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->tessellationIsolines << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->tessellationPointMode << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->triangleFans << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vertexAttributeAccessBeyondStride << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePortabilitySubsetFeaturesKHR");
    out << "\t\t" << "VkPhysicalDevicePortabilitySubsetFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePortabilitySubsetPropertiesKHR(std::ostream &out, const VkPhysicalDevicePortabilitySubsetPropertiesKHR* structInfo, Decoded_VkPhysicalDevicePortabilitySubsetPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minVertexInputBindingStrideAlignment << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePortabilitySubsetPropertiesKHR");
    out << "\t\t" << "VkPhysicalDevicePortabilitySubsetPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderClockFeaturesKHR(std::ostream &out, const VkPhysicalDeviceShaderClockFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceShaderClockFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSubgroupClock << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderDeviceClock << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderClockFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceShaderClockFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkFragmentShadingRateAttachmentInfoKHR(std::ostream &out, const VkFragmentShadingRateAttachmentInfoKHR* structInfo, Decoded_VkFragmentShadingRateAttachmentInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pfragment_shading_rate_attachment_struct = "NULL";
    if (structInfo->pFragmentShadingRateAttachment != NULL) {
        pfragment_shading_rate_attachment_struct = GenerateStruct_VkAttachmentReference2(out,
                                                                                         structInfo->pFragmentShadingRateAttachment,
                                                                                         metaInfo->pFragmentShadingRateAttachment->GetMetaStructPointer(),
                                                                                         consumer);
        pfragment_shading_rate_attachment_struct.insert(0, "&");
    }
    std::string shading_rate_attachment_texel_size_info_var = GenerateStruct_VkExtent2D(out,
                                                                                        &structInfo->shadingRateAttachmentTexelSize,
                                                                                        metaInfo->shadingRateAttachmentTexelSize,
                                                                                        consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pfragment_shading_rate_attachment_struct << "," << std::endl;
    struct_body << "\t\t\t" << shading_rate_attachment_texel_size_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "fragmentShadingRateAttachmentInfoKHR");
    out << "\t\t" << "VkFragmentShadingRateAttachmentInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceFragmentShadingRateFeaturesKHR(std::ostream &out, const VkPhysicalDeviceFragmentShadingRateFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceFragmentShadingRateFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineFragmentShadingRate << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->primitiveFragmentShadingRate << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->attachmentFragmentShadingRate << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceFragmentShadingRateFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceFragmentShadingRateFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceFragmentShadingRateKHR(std::ostream &out, const VkPhysicalDeviceFragmentShadingRateKHR* structInfo, Decoded_VkPhysicalDeviceFragmentShadingRateKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string fragment_size_info_var = GenerateStruct_VkExtent2D(out,
                                                                   &structInfo->fragmentSize,
                                                                   metaInfo->fragmentSize,
                                                                   consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlags(" << structInfo->sampleCounts << ")" << "," << std::endl;
    struct_body << "\t\t\t" << fragment_size_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceFragmentShadingRateKHR");
    out << "\t\t" << "VkPhysicalDeviceFragmentShadingRateKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceFragmentShadingRatePropertiesKHR(std::ostream &out, const VkPhysicalDeviceFragmentShadingRatePropertiesKHR* structInfo, Decoded_VkPhysicalDeviceFragmentShadingRatePropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string min_fragment_shading_rate_attachment_texel_size_info_var = GenerateStruct_VkExtent2D(out,
                                                                                                     &structInfo->minFragmentShadingRateAttachmentTexelSize,
                                                                                                     metaInfo->minFragmentShadingRateAttachmentTexelSize,
                                                                                                     consumer);
    std::string max_fragment_shading_rate_attachment_texel_size_info_var = GenerateStruct_VkExtent2D(out,
                                                                                                     &structInfo->maxFragmentShadingRateAttachmentTexelSize,
                                                                                                     metaInfo->maxFragmentShadingRateAttachmentTexelSize,
                                                                                                     consumer);
    std::string max_fragment_size_info_var = GenerateStruct_VkExtent2D(out,
                                                                       &structInfo->maxFragmentSize,
                                                                       metaInfo->maxFragmentSize,
                                                                       consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << min_fragment_shading_rate_attachment_texel_size_info_var << "," << std::endl;
    struct_body << "\t\t\t" << max_fragment_shading_rate_attachment_texel_size_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxFragmentShadingRateAttachmentTexelSizeAspectRatio << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->primitiveFragmentShadingRateWithMultipleViewports << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->layeredShadingRateAttachments << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fragmentShadingRateNonTrivialCombinerOps << "," << std::endl;
    struct_body << "\t\t\t" << max_fragment_size_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxFragmentSizeAspectRatio << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxFragmentShadingRateCoverageSamples << "," << std::endl;
    struct_body << "\t\t\t" << "VkSampleCountFlagBits(" << structInfo->maxFragmentShadingRateRasterizationSamples << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fragmentShadingRateWithShaderDepthStencilWrites << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fragmentShadingRateWithSampleMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fragmentShadingRateWithShaderSampleMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fragmentShadingRateWithConservativeRasterization << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fragmentShadingRateWithFragmentShaderInterlock << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fragmentShadingRateWithCustomSampleLocations << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fragmentShadingRateStrictMultiplyCombiner << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceFragmentShadingRatePropertiesKHR");
    out << "\t\t" << "VkPhysicalDeviceFragmentShadingRatePropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineFragmentShadingRateStateCreateInfoKHR(std::ostream &out, const VkPipelineFragmentShadingRateStateCreateInfoKHR* structInfo, Decoded_VkPipelineFragmentShadingRateStateCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string fragment_size_info_var = GenerateStruct_VkExtent2D(out,
                                                                   &structInfo->fragmentSize,
                                                                   metaInfo->fragmentSize,
                                                                   consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << fragment_size_info_var << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const VkFragmentShadingRateCombinerOpKHR*>(&structInfo->combinerOps[0]), 2) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineFragmentShadingRateStateCreateInfoKHR");
    out << "\t\t" << "VkPipelineFragmentShadingRateStateCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRenderingFragmentShadingRateAttachmentInfoKHR(std::ostream &out, const VkRenderingFragmentShadingRateAttachmentInfoKHR* structInfo, Decoded_VkRenderingFragmentShadingRateAttachmentInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string shading_rate_attachment_texel_size_info_var = GenerateStruct_VkExtent2D(out,
                                                                                        &structInfo->shadingRateAttachmentTexelSize,
                                                                                        metaInfo->shadingRateAttachmentTexelSize,
                                                                                        consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->imageView) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->imageLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << shading_rate_attachment_texel_size_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "renderingFragmentShadingRateAttachmentInfoKHR");
    out << "\t\t" << "VkRenderingFragmentShadingRateAttachmentInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderQuadControlFeaturesKHR(std::ostream &out, const VkPhysicalDeviceShaderQuadControlFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceShaderQuadControlFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderQuadControl << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderQuadControlFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceShaderQuadControlFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSurfaceProtectedCapabilitiesKHR(std::ostream &out, const VkSurfaceProtectedCapabilitiesKHR* structInfo, Decoded_VkSurfaceProtectedCapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->supportsProtected << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "surfaceProtectedCapabilitiesKHR");
    out << "\t\t" << "VkSurfaceProtectedCapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePresentWaitFeaturesKHR(std::ostream &out, const VkPhysicalDevicePresentWaitFeaturesKHR* structInfo, Decoded_VkPhysicalDevicePresentWaitFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->presentWait << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePresentWaitFeaturesKHR");
    out << "\t\t" << "VkPhysicalDevicePresentWaitFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(std::ostream &out, const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* structInfo, Decoded_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineExecutableInfo << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePipelineExecutablePropertiesFeaturesKHR");
    out << "\t\t" << "VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineExecutableInfoKHR(std::ostream &out, const VkPipelineExecutableInfoKHR* structInfo, Decoded_VkPipelineExecutableInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->pipeline) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->executableIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineExecutableInfoKHR");
    out << "\t\t" << "VkPipelineExecutableInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineExecutableInternalRepresentationKHR(std::ostream &out, const VkPipelineExecutableInternalRepresentationKHR* structInfo, Decoded_VkPipelineExecutableInternalRepresentationKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->name) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->description) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->isText << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dataSize << "," << std::endl;
    out << "\t\t" << "// TODO: Support pData (output with array length value?) argument." << std::endl;
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineExecutableInternalRepresentationKHR");
    out << "\t\t" << "VkPipelineExecutableInternalRepresentationKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineExecutablePropertiesKHR(std::ostream &out, const VkPipelineExecutablePropertiesKHR* structInfo, Decoded_VkPipelineExecutablePropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderStageFlags(" << structInfo->stages << ")" << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->name) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->description) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->subgroupSize << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineExecutablePropertiesKHR");
    out << "\t\t" << "VkPipelineExecutablePropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineExecutableStatisticKHR(std::ostream &out, const VkPipelineExecutableStatisticKHR* structInfo, Decoded_VkPipelineExecutableStatisticKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->name) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->description) << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineExecutableStatisticFormatKHR(" << structInfo->format << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->value.b32 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineExecutableStatisticKHR");
    out << "\t\t" << "VkPipelineExecutableStatisticKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineInfoKHR(std::ostream &out, const VkPipelineInfoKHR* structInfo, Decoded_VkPipelineInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->pipeline) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineInfoKHR");
    out << "\t\t" << "VkPipelineInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineLibraryCreateInfoKHR(std::ostream &out, const VkPipelineLibraryCreateInfoKHR* structInfo, Decoded_VkPipelineLibraryCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string plibraries_array = "NULL";
    if (metaInfo->pLibraries.GetPointer() != NULL && structInfo->libraryCount > 0) {
        plibraries_array = "plibraries_array_" + std::to_string(consumer.GetNextId(VK_OBJECT_TYPE_PIPELINE));
        std::string plibraries_values = toStringJoin(metaInfo->pLibraries.GetPointer(),
                                                     metaInfo->pLibraries.GetPointer() + structInfo->libraryCount,
                                                     [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                     ", ");
        if (structInfo->libraryCount == 1) {
            plibraries_array = "&" + plibraries_values;
        } else if (structInfo->libraryCount > 1) {
            out << "\t\t" << "VkPipeline " << plibraries_array << "[] = {" << plibraries_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->libraryCount << "," << std::endl;
    struct_body << "\t\t\t" << plibraries_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineLibraryCreateInfoKHR");
    out << "\t\t" << "VkPipelineLibraryCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePresentIdFeaturesKHR(std::ostream &out, const VkPhysicalDevicePresentIdFeaturesKHR* structInfo, Decoded_VkPhysicalDevicePresentIdFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->presentId << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePresentIdFeaturesKHR");
    out << "\t\t" << "VkPhysicalDevicePresentIdFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPresentIdKHR(std::ostream &out, const VkPresentIdKHR* structInfo, Decoded_VkPresentIdKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string ppresent_ids_array = "ppresent_ids_array_" + std::to_string(consumer.GetNextId());
    if (structInfo->swapchainCount > 0) {
        std::string ppresent_ids_values = toStringJoin(structInfo->pPresentIds,
                                                       structInfo->pPresentIds + structInfo->swapchainCount,
                                                       [](uint64_t current) { return std::to_string(current); },
                                                       ", ");
        if (structInfo->swapchainCount == 1) {
            ppresent_ids_array = "&" + ppresent_ids_values;
        } else if (structInfo->swapchainCount > 1) {
            out << "\t\t" << "uint64_t " << ppresent_ids_array << "[] = {" << ppresent_ids_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->swapchainCount << "," << std::endl;
    struct_body << "\t\t\t" << "{ *" << ppresent_ids_array << " }" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "presentIdKHR");
    out << "\t\t" << "VkPresentIdKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR(std::ostream &out, const VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR* structInfo, Decoded_VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pvideo_profile_struct = "NULL";
    if (structInfo->pVideoProfile != NULL) {
        pvideo_profile_struct = GenerateStruct_VkVideoProfileInfoKHR(out,
                                                                     structInfo->pVideoProfile,
                                                                     metaInfo->pVideoProfile->GetMetaStructPointer(),
                                                                     consumer);
        pvideo_profile_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pvideo_profile_struct << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->qualityLevel << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVideoEncodeQualityLevelInfoKHR");
    out << "\t\t" << "VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkQueryPoolVideoEncodeFeedbackCreateInfoKHR(std::ostream &out, const VkQueryPoolVideoEncodeFeedbackCreateInfoKHR* structInfo, Decoded_VkQueryPoolVideoEncodeFeedbackCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeFeedbackFlagsKHR(" << structInfo->encodeFeedbackFlags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "queryPoolVideoEncodeFeedbackCreateInfoKHR");
    out << "\t\t" << "VkQueryPoolVideoEncodeFeedbackCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeCapabilitiesKHR(std::ostream &out, const VkVideoEncodeCapabilitiesKHR* structInfo, Decoded_VkVideoEncodeCapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string encode_input_picture_granularity_info_var = GenerateStruct_VkExtent2D(out,
                                                                                      &structInfo->encodeInputPictureGranularity,
                                                                                      metaInfo->encodeInputPictureGranularity,
                                                                                      consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeCapabilityFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeRateControlModeFlagsKHR(" << structInfo->rateControlModes << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxRateControlLayers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxBitrate << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxQualityLevels << "," << std::endl;
    struct_body << "\t\t\t" << encode_input_picture_granularity_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeFeedbackFlagsKHR(" << structInfo->supportedEncodeFeedbackFlags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeCapabilitiesKHR");
    out << "\t\t" << "VkVideoEncodeCapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeInfoKHR(std::ostream &out, const VkVideoEncodeInfoKHR* structInfo, Decoded_VkVideoEncodeInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string src_picture_resource_info_var = GenerateStruct_VkVideoPictureResourceInfoKHR(out,
                                                                                             &structInfo->srcPictureResource,
                                                                                             metaInfo->srcPictureResource,
                                                                                             consumer);
    std::string psetup_reference_slot_struct = "NULL";
    if (structInfo->pSetupReferenceSlot != NULL) {
        psetup_reference_slot_struct = GenerateStruct_VkVideoReferenceSlotInfoKHR(out,
                                                                                  structInfo->pSetupReferenceSlot,
                                                                                  metaInfo->pSetupReferenceSlot->GetMetaStructPointer(),
                                                                                  consumer);
        psetup_reference_slot_struct.insert(0, "&");
    }
    std::string preference_slots_array = "NULL";
    if (structInfo->pReferenceSlots != NULL) {
        preference_slots_array = "pReferenceSlots_" + std::to_string(consumer.GetNextId());
        std::string preference_slots_names;
        for (uint32_t idx = 0; idx < structInfo->referenceSlotCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pReferenceSlots + idx != NULL) {
                variable_name = GenerateStruct_VkVideoReferenceSlotInfoKHR(out,
                                                                           structInfo->pReferenceSlots + idx,
                                                                           metaInfo->pReferenceSlots->GetMetaStructPointer() + idx,
                                                                           consumer);
            }
            preference_slots_names += variable_name + ", ";
        }
        out << "\t\t" << "VkVideoReferenceSlotInfoKHR " << preference_slots_array << "[] = {" << preference_slots_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->dstBuffer) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dstBufferOffset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dstBufferRange << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << src_picture_resource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << psetup_reference_slot_struct << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->referenceSlotCount << "," << std::endl;
    struct_body << "\t\t\t" << preference_slots_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->precedingExternallyEncodedBytes << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeInfoKHR");
    out << "\t\t" << "VkVideoEncodeInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeQualityLevelInfoKHR(std::ostream &out, const VkVideoEncodeQualityLevelInfoKHR* structInfo, Decoded_VkVideoEncodeQualityLevelInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->qualityLevel << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeQualityLevelInfoKHR");
    out << "\t\t" << "VkVideoEncodeQualityLevelInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeQualityLevelPropertiesKHR(std::ostream &out, const VkVideoEncodeQualityLevelPropertiesKHR* structInfo, Decoded_VkVideoEncodeQualityLevelPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeRateControlModeFlagBitsKHR(" << structInfo->preferredRateControlMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredRateControlLayerCount << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeQualityLevelPropertiesKHR");
    out << "\t\t" << "VkVideoEncodeQualityLevelPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeRateControlInfoKHR(std::ostream &out, const VkVideoEncodeRateControlInfoKHR* structInfo, Decoded_VkVideoEncodeRateControlInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string players_array = "NULL";
    if (structInfo->pLayers != NULL) {
        players_array = "pLayers_" + std::to_string(consumer.GetNextId());
        std::string players_names;
        for (uint32_t idx = 0; idx < structInfo->layerCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pLayers + idx != NULL) {
                variable_name = GenerateStruct_VkVideoEncodeRateControlLayerInfoKHR(out,
                                                                                    structInfo->pLayers + idx,
                                                                                    metaInfo->pLayers->GetMetaStructPointer() + idx,
                                                                                    consumer);
            }
            players_names += variable_name + ", ";
        }
        out << "\t\t" << "VkVideoEncodeRateControlLayerInfoKHR " << players_array << "[] = {" << players_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeRateControlFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeRateControlModeFlagBitsKHR(" << structInfo->rateControlMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->layerCount << "," << std::endl;
    struct_body << "\t\t\t" << players_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->virtualBufferSizeInMs << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->initialVirtualBufferSizeInMs << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeRateControlInfoKHR");
    out << "\t\t" << "VkVideoEncodeRateControlInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeRateControlLayerInfoKHR(std::ostream &out, const VkVideoEncodeRateControlLayerInfoKHR* structInfo, Decoded_VkVideoEncodeRateControlLayerInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->averageBitrate << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxBitrate << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frameRateNumerator << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frameRateDenominator << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeRateControlLayerInfoKHR");
    out << "\t\t" << "VkVideoEncodeRateControlLayerInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeSessionParametersFeedbackInfoKHR(std::ostream &out, const VkVideoEncodeSessionParametersFeedbackInfoKHR* structInfo, Decoded_VkVideoEncodeSessionParametersFeedbackInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->hasOverrides << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeSessionParametersFeedbackInfoKHR");
    out << "\t\t" << "VkVideoEncodeSessionParametersFeedbackInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeSessionParametersGetInfoKHR(std::ostream &out, const VkVideoEncodeSessionParametersGetInfoKHR* structInfo, Decoded_VkVideoEncodeSessionParametersGetInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->videoSessionParameters) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeSessionParametersGetInfoKHR");
    out << "\t\t" << "VkVideoEncodeSessionParametersGetInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeUsageInfoKHR(std::ostream &out, const VkVideoEncodeUsageInfoKHR* structInfo, Decoded_VkVideoEncodeUsageInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeUsageFlagsKHR(" << structInfo->videoUsageHints << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeContentFlagsKHR(" << structInfo->videoContentHints << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeTuningModeKHR(" << structInfo->tuningMode << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeUsageInfoKHR");
    out << "\t\t" << "VkVideoEncodeUsageInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR(std::ostream &out, const VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->fragmentShaderBarycentric << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceFragmentShaderBarycentricFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR(std::ostream &out, const VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR* structInfo, Decoded_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->triStripVertexOrderIndependentOfProvokingVertex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceFragmentShaderBarycentricPropertiesKHR");
    out << "\t\t" << "VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR(std::ostream &out, const VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderSubgroupUniformControlFlow << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR(std::ostream &out, const VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->workgroupMemoryExplicitLayout << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->workgroupMemoryExplicitLayoutScalarBlockLayout << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->workgroupMemoryExplicitLayout8BitAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->workgroupMemoryExplicitLayout16BitAccess << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR(std::ostream &out, const VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR* structInfo, Decoded_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->rayTracingMaintenance1 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->rayTracingPipelineTraceRaysIndirect2 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceRayTracingMaintenance1FeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkTraceRaysIndirectCommand2KHR(std::ostream &out, const VkTraceRaysIndirectCommand2KHR* structInfo, Decoded_VkTraceRaysIndirectCommand2KHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->raygenShaderRecordAddress << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->raygenShaderRecordSize << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->missShaderBindingTableAddress << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->missShaderBindingTableSize << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->missShaderBindingTableStride << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->hitShaderBindingTableAddress << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->hitShaderBindingTableSize << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->hitShaderBindingTableStride << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->callableShaderBindingTableAddress << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->callableShaderBindingTableSize << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->callableShaderBindingTableStride << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->width << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->height << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depth << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "traceRaysIndirectCommand2KHR");
    out << "\t\t" << "VkTraceRaysIndirectCommand2KHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderUntypedPointersFeaturesKHR(std::ostream &out, const VkPhysicalDeviceShaderUntypedPointersFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceShaderUntypedPointersFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderUntypedPointers << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderUntypedPointersFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceShaderUntypedPointersFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR(std::ostream &out, const VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderMaximalReconvergence << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderMaximalReconvergenceFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePresentId2FeaturesKHR(std::ostream &out, const VkPhysicalDevicePresentId2FeaturesKHR* structInfo, Decoded_VkPhysicalDevicePresentId2FeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->presentId2 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePresentId2FeaturesKHR");
    out << "\t\t" << "VkPhysicalDevicePresentId2FeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPresentId2KHR(std::ostream &out, const VkPresentId2KHR* structInfo, Decoded_VkPresentId2KHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string ppresent_ids_array = "ppresent_ids_array_" + std::to_string(consumer.GetNextId());
    if (structInfo->swapchainCount > 0) {
        std::string ppresent_ids_values = toStringJoin(structInfo->pPresentIds,
                                                       structInfo->pPresentIds + structInfo->swapchainCount,
                                                       [](uint64_t current) { return std::to_string(current); },
                                                       ", ");
        if (structInfo->swapchainCount == 1) {
            ppresent_ids_array = "&" + ppresent_ids_values;
        } else if (structInfo->swapchainCount > 1) {
            out << "\t\t" << "uint64_t " << ppresent_ids_array << "[] = {" << ppresent_ids_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->swapchainCount << "," << std::endl;
    struct_body << "\t\t\t" << "{ *" << ppresent_ids_array << " }" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "presentId2KHR");
    out << "\t\t" << "VkPresentId2KHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSurfaceCapabilitiesPresentId2KHR(std::ostream &out, const VkSurfaceCapabilitiesPresentId2KHR* structInfo, Decoded_VkSurfaceCapabilitiesPresentId2KHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->presentId2Supported << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "surfaceCapabilitiesPresentId2KHR");
    out << "\t\t" << "VkSurfaceCapabilitiesPresentId2KHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePresentWait2FeaturesKHR(std::ostream &out, const VkPhysicalDevicePresentWait2FeaturesKHR* structInfo, Decoded_VkPhysicalDevicePresentWait2FeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->presentWait2 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePresentWait2FeaturesKHR");
    out << "\t\t" << "VkPhysicalDevicePresentWait2FeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPresentWait2InfoKHR(std::ostream &out, const VkPresentWait2InfoKHR* structInfo, Decoded_VkPresentWait2InfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->presentId << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->timeout << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "presentWait2InfoKHR");
    out << "\t\t" << "VkPresentWait2InfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSurfaceCapabilitiesPresentWait2KHR(std::ostream &out, const VkSurfaceCapabilitiesPresentWait2KHR* structInfo, Decoded_VkSurfaceCapabilitiesPresentWait2KHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->presentWait2Supported << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "surfaceCapabilitiesPresentWait2KHR");
    out << "\t\t" << "VkSurfaceCapabilitiesPresentWait2KHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR(std::ostream &out, const VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->rayTracingPositionFetch << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceRayTracingPositionFetchFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDevicePipelineBinaryInternalCacheControlKHR(std::ostream &out, const VkDevicePipelineBinaryInternalCacheControlKHR* structInfo, Decoded_VkDevicePipelineBinaryInternalCacheControlKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->disableInternalCache << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "devicePipelineBinaryInternalCacheControlKHR");
    out << "\t\t" << "VkDevicePipelineBinaryInternalCacheControlKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePipelineBinaryFeaturesKHR(std::ostream &out, const VkPhysicalDevicePipelineBinaryFeaturesKHR* structInfo, Decoded_VkPhysicalDevicePipelineBinaryFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineBinaries << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePipelineBinaryFeaturesKHR");
    out << "\t\t" << "VkPhysicalDevicePipelineBinaryFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePipelineBinaryPropertiesKHR(std::ostream &out, const VkPhysicalDevicePipelineBinaryPropertiesKHR* structInfo, Decoded_VkPhysicalDevicePipelineBinaryPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineBinaryInternalCache << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineBinaryInternalCacheControl << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineBinaryPrefersInternalCache << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineBinaryPrecompiledInternalCache << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineBinaryCompressedData << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePipelineBinaryPropertiesKHR");
    out << "\t\t" << "VkPhysicalDevicePipelineBinaryPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineBinaryCreateInfoKHR(std::ostream &out, const VkPipelineBinaryCreateInfoKHR* structInfo, Decoded_VkPipelineBinaryCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pkeys_and_data_info_struct = "NULL";
    if (structInfo->pKeysAndDataInfo != NULL) {
        pkeys_and_data_info_struct = GenerateStruct_VkPipelineBinaryKeysAndDataKHR(out,
                                                                                   structInfo->pKeysAndDataInfo,
                                                                                   metaInfo->pKeysAndDataInfo->GetMetaStructPointer(),
                                                                                   consumer);
        pkeys_and_data_info_struct.insert(0, "&");
    }
    std::string ppipeline_create_info_struct = "NULL";
    if (structInfo->pPipelineCreateInfo != NULL) {
        ppipeline_create_info_struct = GenerateStruct_VkPipelineCreateInfoKHR(out,
                                                                              structInfo->pPipelineCreateInfo,
                                                                              metaInfo->pPipelineCreateInfo->GetMetaStructPointer(),
                                                                              consumer);
        ppipeline_create_info_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pkeys_and_data_info_struct << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->pipeline) << "," << std::endl;
    struct_body << "\t\t\t" << ppipeline_create_info_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineBinaryCreateInfoKHR");
    out << "\t\t" << "VkPipelineBinaryCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineBinaryDataInfoKHR(std::ostream &out, const VkPipelineBinaryDataInfoKHR* structInfo, Decoded_VkPipelineBinaryDataInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->pipelineBinary) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineBinaryDataInfoKHR");
    out << "\t\t" << "VkPipelineBinaryDataInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineBinaryDataKHR(std::ostream &out, const VkPipelineBinaryDataKHR* structInfo, Decoded_VkPipelineBinaryDataKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->dataSize << "," << std::endl;
    out << "\t\t" << "// TODO: Support pData (output with array length value?) argument." << std::endl;
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineBinaryDataKHR");
    out << "\t\t" << "VkPipelineBinaryDataKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineBinaryHandlesInfoKHR(std::ostream &out, const VkPipelineBinaryHandlesInfoKHR* structInfo, Decoded_VkPipelineBinaryHandlesInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pipelineBinaryCount << "," << std::endl;
    out << "\t\t" << "// TODO: Support pPipelineBinaries (output with array length value?) argument." << std::endl;
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineBinaryHandlesInfoKHR");
    out << "\t\t" << "VkPipelineBinaryHandlesInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineBinaryInfoKHR(std::ostream &out, const VkPipelineBinaryInfoKHR* structInfo, Decoded_VkPipelineBinaryInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string ppipeline_binaries_array = "NULL";
    if (metaInfo->pPipelineBinaries.GetPointer() != NULL && structInfo->binaryCount > 0) {
        ppipeline_binaries_array = "ppipeline_binaries_array_" + std::to_string(consumer.GetNextId(VK_OBJECT_TYPE_PIPELINE_BINARY_KHR));
        std::string ppipeline_binaries_values = toStringJoin(metaInfo->pPipelineBinaries.GetPointer(),
                                                             metaInfo->pPipelineBinaries.GetPointer() + structInfo->binaryCount,
                                                             [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                             ", ");
        if (structInfo->binaryCount == 1) {
            ppipeline_binaries_array = "&" + ppipeline_binaries_values;
        } else if (structInfo->binaryCount > 1) {
            out << "\t\t" << "VkPipelineBinaryKHR " << ppipeline_binaries_array << "[] = {" << ppipeline_binaries_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->binaryCount << "," << std::endl;
    struct_body << "\t\t\t" << ppipeline_binaries_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineBinaryInfoKHR");
    out << "\t\t" << "VkPipelineBinaryInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineBinaryKeyKHR(std::ostream &out, const VkPipelineBinaryKeyKHR* structInfo, Decoded_VkPipelineBinaryKeyKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->keySize << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint8_t*>(&structInfo->key[0]), VK_MAX_PIPELINE_BINARY_KEY_SIZE_KHR) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineBinaryKeyKHR");
    out << "\t\t" << "VkPipelineBinaryKeyKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineBinaryKeysAndDataKHR(std::ostream &out, const VkPipelineBinaryKeysAndDataKHR* structInfo, Decoded_VkPipelineBinaryKeysAndDataKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string ppipeline_binary_keys_array = "NULL";
    if (structInfo->pPipelineBinaryKeys != NULL) {
        ppipeline_binary_keys_array = "pPipelineBinaryKeys_" + std::to_string(consumer.GetNextId());
        std::string ppipeline_binary_keys_names;
        for (uint32_t idx = 0; idx < structInfo->binaryCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pPipelineBinaryKeys + idx != NULL) {
                variable_name = GenerateStruct_VkPipelineBinaryKeyKHR(out,
                                                                      structInfo->pPipelineBinaryKeys + idx,
                                                                      metaInfo->pPipelineBinaryKeys->GetMetaStructPointer() + idx,
                                                                      consumer);
            }
            ppipeline_binary_keys_names += variable_name + ", ";
        }
        out << "\t\t" << "VkPipelineBinaryKeyKHR " << ppipeline_binary_keys_array << "[] = {" << ppipeline_binary_keys_names << "};" << std::endl;
    }
    std::string ppipeline_binary_data_array = "NULL";
    if (structInfo->pPipelineBinaryData != NULL) {
        ppipeline_binary_data_array = "pPipelineBinaryData_" + std::to_string(consumer.GetNextId());
        std::string ppipeline_binary_data_names;
        for (uint32_t idx = 0; idx < structInfo->binaryCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pPipelineBinaryData + idx != NULL) {
                variable_name = GenerateStruct_VkPipelineBinaryDataKHR(out,
                                                                       structInfo->pPipelineBinaryData + idx,
                                                                       metaInfo->pPipelineBinaryData->GetMetaStructPointer() + idx,
                                                                       consumer);
            }
            ppipeline_binary_data_names += variable_name + ", ";
        }
        out << "\t\t" << "VkPipelineBinaryDataKHR " << ppipeline_binary_data_array << "[] = {" << ppipeline_binary_data_names << "};" << std::endl;
    }
    struct_body << "\t" << structInfo->binaryCount << "," << std::endl;
    struct_body << "\t\t\t" << ppipeline_binary_keys_array << "," << std::endl;
    struct_body << "\t\t\t" << ppipeline_binary_data_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineBinaryKeysAndDataKHR");
    out << "\t\t" << "VkPipelineBinaryKeysAndDataKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineCreateInfoKHR(std::ostream &out, const VkPipelineCreateInfoKHR* structInfo, Decoded_VkPipelineCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineCreateInfoKHR");
    out << "\t\t" << "VkPipelineCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkReleaseCapturedPipelineDataInfoKHR(std::ostream &out, const VkReleaseCapturedPipelineDataInfoKHR* structInfo, Decoded_VkReleaseCapturedPipelineDataInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->pipeline) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "releaseCapturedPipelineDataInfoKHR");
    out << "\t\t" << "VkReleaseCapturedPipelineDataInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSurfacePresentModeCompatibilityKHR(std::ostream &out, const VkSurfacePresentModeCompatibilityKHR* structInfo, Decoded_VkSurfacePresentModeCompatibilityKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string ppresent_modes_array = "NULL";
    if (structInfo->pPresentModes != NULL) {
        std::string ppresent_modes_values;
        for (uint32_t idx = 0; idx < structInfo->presentModeCount; idx++) {
            ppresent_modes_values += util::ToString<VkPresentModeKHR>(structInfo->pPresentModes[idx]) + ", ";
        }
        ppresent_modes_array = "pPresentModes_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkPresentModeKHR " << ppresent_modes_array << "[] = {" << ppresent_modes_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->presentModeCount << "," << std::endl;
    struct_body << "\t\t\t" << ppresent_modes_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "surfacePresentModeCompatibilityKHR");
    out << "\t\t" << "VkSurfacePresentModeCompatibilityKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSurfacePresentModeKHR(std::ostream &out, const VkSurfacePresentModeKHR* structInfo, Decoded_VkSurfacePresentModeKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPresentModeKHR(" << structInfo->presentMode << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "surfacePresentModeKHR");
    out << "\t\t" << "VkSurfacePresentModeKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSurfacePresentScalingCapabilitiesKHR(std::ostream &out, const VkSurfacePresentScalingCapabilitiesKHR* structInfo, Decoded_VkSurfacePresentScalingCapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string min_scaled_image_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                             &structInfo->minScaledImageExtent,
                                                                             metaInfo->minScaledImageExtent,
                                                                             consumer);
    std::string max_scaled_image_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                             &structInfo->maxScaledImageExtent,
                                                                             metaInfo->maxScaledImageExtent,
                                                                             consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPresentScalingFlagsKHR(" << structInfo->supportedPresentScaling << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPresentGravityFlagsKHR(" << structInfo->supportedPresentGravityX << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPresentGravityFlagsKHR(" << structInfo->supportedPresentGravityY << ")" << "," << std::endl;
    struct_body << "\t\t\t" << min_scaled_image_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << max_scaled_image_extent_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "surfacePresentScalingCapabilitiesKHR");
    out << "\t\t" << "VkSurfacePresentScalingCapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceSwapchainMaintenance1FeaturesKHR(std::ostream &out, const VkPhysicalDeviceSwapchainMaintenance1FeaturesKHR* structInfo, Decoded_VkPhysicalDeviceSwapchainMaintenance1FeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->swapchainMaintenance1 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceSwapchainMaintenance1FeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceSwapchainMaintenance1FeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkReleaseSwapchainImagesInfoKHR(std::ostream &out, const VkReleaseSwapchainImagesInfoKHR* structInfo, Decoded_VkReleaseSwapchainImagesInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pimage_indices_array = "NULL";
    if (structInfo->pImageIndices != NULL) {
        pimage_indices_array = "pImageIndices_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pimage_indices_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pImageIndices, structInfo->imageIndexCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->swapchain) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->imageIndexCount << "," << std::endl;
    struct_body << "\t\t\t" << pimage_indices_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "releaseSwapchainImagesInfoKHR");
    out << "\t\t" << "VkReleaseSwapchainImagesInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSwapchainPresentFenceInfoKHR(std::ostream &out, const VkSwapchainPresentFenceInfoKHR* structInfo, Decoded_VkSwapchainPresentFenceInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pfences_array = "NULL";
    if (metaInfo->pFences.GetPointer() != NULL && structInfo->swapchainCount > 0) {
        pfences_array = "pfences_array_" + std::to_string(consumer.GetNextId(VK_OBJECT_TYPE_FENCE));
        std::string pfences_values = toStringJoin(metaInfo->pFences.GetPointer(),
                                                  metaInfo->pFences.GetPointer() + structInfo->swapchainCount,
                                                  [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                  ", ");
        if (structInfo->swapchainCount == 1) {
            pfences_array = "&" + pfences_values;
        } else if (structInfo->swapchainCount > 1) {
            out << "\t\t" << "VkFence " << pfences_array << "[] = {" << pfences_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->swapchainCount << "," << std::endl;
    struct_body << "\t\t\t" << pfences_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "swapchainPresentFenceInfoKHR");
    out << "\t\t" << "VkSwapchainPresentFenceInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSwapchainPresentModeInfoKHR(std::ostream &out, const VkSwapchainPresentModeInfoKHR* structInfo, Decoded_VkSwapchainPresentModeInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string ppresent_modes_values;
    std::string ppresent_modes_array = "NULL";
    if (structInfo->pPresentModes != NULL) {
        for (uint32_t idx = 0; idx < structInfo->swapchainCount; idx++) {
            ppresent_modes_values += util::ToString<VkPresentModeKHR>(structInfo->pPresentModes[idx]) + ", ";
        }
        ppresent_modes_array = "pPresentModes_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkPresentModeKHR " << ppresent_modes_array << "[] = {" << ppresent_modes_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->swapchainCount << "," << std::endl;
    struct_body << "\t\t\t" << ppresent_modes_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "swapchainPresentModeInfoKHR");
    out << "\t\t" << "VkSwapchainPresentModeInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSwapchainPresentModesCreateInfoKHR(std::ostream &out, const VkSwapchainPresentModesCreateInfoKHR* structInfo, Decoded_VkSwapchainPresentModesCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string ppresent_modes_values;
    std::string ppresent_modes_array = "NULL";
    if (structInfo->pPresentModes != NULL) {
        for (uint32_t idx = 0; idx < structInfo->presentModeCount; idx++) {
            ppresent_modes_values += util::ToString<VkPresentModeKHR>(structInfo->pPresentModes[idx]) + ", ";
        }
        ppresent_modes_array = "pPresentModes_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkPresentModeKHR " << ppresent_modes_array << "[] = {" << ppresent_modes_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->presentModeCount << "," << std::endl;
    struct_body << "\t\t\t" << ppresent_modes_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "swapchainPresentModesCreateInfoKHR");
    out << "\t\t" << "VkSwapchainPresentModesCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSwapchainPresentScalingCreateInfoKHR(std::ostream &out, const VkSwapchainPresentScalingCreateInfoKHR* structInfo, Decoded_VkSwapchainPresentScalingCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPresentScalingFlagsKHR(" << structInfo->scalingBehavior << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPresentGravityFlagsKHR(" << structInfo->presentGravityX << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkPresentGravityFlagsKHR(" << structInfo->presentGravityY << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "swapchainPresentScalingCreateInfoKHR");
    out << "\t\t" << "VkSwapchainPresentScalingCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCooperativeMatrixPropertiesKHR(std::ostream &out, const VkCooperativeMatrixPropertiesKHR* structInfo, Decoded_VkCooperativeMatrixPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->MSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->NSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->KSize << "," << std::endl;
    struct_body << "\t\t\t" << "VkComponentTypeKHR(" << structInfo->AType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkComponentTypeKHR(" << structInfo->BType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkComponentTypeKHR(" << structInfo->CType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkComponentTypeKHR(" << structInfo->ResultType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->saturatingAccumulation << "," << std::endl;
    struct_body << "\t\t\t" << "VkScopeKHR(" << structInfo->scope << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "cooperativeMatrixPropertiesKHR");
    out << "\t\t" << "VkCooperativeMatrixPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceCooperativeMatrixFeaturesKHR(std::ostream &out, const VkPhysicalDeviceCooperativeMatrixFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceCooperativeMatrixFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->cooperativeMatrix << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->cooperativeMatrixRobustBufferAccess << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceCooperativeMatrixFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceCooperativeMatrixFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceCooperativeMatrixPropertiesKHR(std::ostream &out, const VkPhysicalDeviceCooperativeMatrixPropertiesKHR* structInfo, Decoded_VkPhysicalDeviceCooperativeMatrixPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderStageFlags(" << structInfo->cooperativeMatrixSupportedStages << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceCooperativeMatrixPropertiesKHR");
    out << "\t\t" << "VkPhysicalDeviceCooperativeMatrixPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR(std::ostream &out, const VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->computeDerivativeGroupQuads << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->computeDerivativeGroupLinear << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceComputeShaderDerivativesFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR(std::ostream &out, const VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR* structInfo, Decoded_VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->meshAndTaskShaderDerivatives << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceComputeShaderDerivativesPropertiesKHR");
    out << "\t\t" << "VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeAV1CapabilitiesKHR(std::ostream &out, const VkVideoDecodeAV1CapabilitiesKHR* structInfo, Decoded_VkVideoDecodeAV1CapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1Level(" << structInfo->maxLevel << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeAV1CapabilitiesKHR");
    out << "\t\t" << "VkVideoDecodeAV1CapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeAV1DpbSlotInfoKHR(std::ostream &out, const VkVideoDecodeAV1DpbSlotInfoKHR* structInfo, Decoded_VkVideoDecodeAV1DpbSlotInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pstd_reference_info_struct = "NULL";
    if (structInfo->pStdReferenceInfo != NULL) {
        pstd_reference_info_struct = GenerateStruct_StdVideoDecodeAV1ReferenceInfo(out,
                                                                                   structInfo->pStdReferenceInfo,
                                                                                   metaInfo->pStdReferenceInfo->GetMetaStructPointer(),
                                                                                   consumer);
        pstd_reference_info_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pstd_reference_info_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeAV1DpbSlotInfoKHR");
    out << "\t\t" << "VkVideoDecodeAV1DpbSlotInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeAV1PictureInfoKHR(std::ostream &out, const VkVideoDecodeAV1PictureInfoKHR* structInfo, Decoded_VkVideoDecodeAV1PictureInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pstd_picture_info_struct = "NULL";
    if (structInfo->pStdPictureInfo != NULL) {
        pstd_picture_info_struct = GenerateStruct_StdVideoDecodeAV1PictureInfo(out,
                                                                               structInfo->pStdPictureInfo,
                                                                               metaInfo->pStdPictureInfo->GetMetaStructPointer(),
                                                                               consumer);
        pstd_picture_info_struct.insert(0, "&");
    }
    std::string ptile_offsets_array = "NULL";
    if (structInfo->pTileOffsets != NULL) {
        ptile_offsets_array = "pTileOffsets_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << ptile_offsets_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pTileOffsets, structInfo->tileCount) << ";" << std::endl;
    }
    std::string ptile_sizes_array = "NULL";
    if (structInfo->pTileSizes != NULL) {
        ptile_sizes_array = "pTileSizes_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << ptile_sizes_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pTileSizes, structInfo->tileCount) << ";" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pstd_picture_info_struct << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int32_t*>(&structInfo->referenceNameSlotIndices[0]), VK_MAX_VIDEO_AV1_REFERENCES_PER_FRAME_KHR) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->frameHeaderOffset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->tileCount << "," << std::endl;
    struct_body << "\t\t\t" << ptile_offsets_array << "," << std::endl;
    struct_body << "\t\t\t" << ptile_sizes_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeAV1PictureInfoKHR");
    out << "\t\t" << "VkVideoDecodeAV1PictureInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeAV1ProfileInfoKHR(std::ostream &out, const VkVideoDecodeAV1ProfileInfoKHR* structInfo, Decoded_VkVideoDecodeAV1ProfileInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1Profile(" << structInfo->stdProfile << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->filmGrainSupport << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeAV1ProfileInfoKHR");
    out << "\t\t" << "VkVideoDecodeAV1ProfileInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeAV1SessionParametersCreateInfoKHR(std::ostream &out, const VkVideoDecodeAV1SessionParametersCreateInfoKHR* structInfo, Decoded_VkVideoDecodeAV1SessionParametersCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pstd_sequence_header_struct = "NULL";
    if (structInfo->pStdSequenceHeader != NULL) {
        pstd_sequence_header_struct = GenerateStruct_StdVideoAV1SequenceHeader(out,
                                                                               structInfo->pStdSequenceHeader,
                                                                               metaInfo->pStdSequenceHeader->GetMetaStructPointer(),
                                                                               consumer);
        pstd_sequence_header_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pstd_sequence_header_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeAV1SessionParametersCreateInfoKHR");
    out << "\t\t" << "VkVideoDecodeAV1SessionParametersCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVideoEncodeAV1FeaturesKHR(std::ostream &out, const VkPhysicalDeviceVideoEncodeAV1FeaturesKHR* structInfo, Decoded_VkPhysicalDeviceVideoEncodeAV1FeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->videoEncodeAV1 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVideoEncodeAV1FeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceVideoEncodeAV1FeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeAV1CapabilitiesKHR(std::ostream &out, const VkVideoEncodeAV1CapabilitiesKHR* structInfo, Decoded_VkVideoEncodeAV1CapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string coded_picture_alignment_info_var = GenerateStruct_VkExtent2D(out,
                                                                             &structInfo->codedPictureAlignment,
                                                                             metaInfo->codedPictureAlignment,
                                                                             consumer);
    std::string max_tiles_info_var = GenerateStruct_VkExtent2D(out,
                                                               &structInfo->maxTiles,
                                                               metaInfo->maxTiles,
                                                               consumer);
    std::string min_tile_size_info_var = GenerateStruct_VkExtent2D(out,
                                                                   &structInfo->minTileSize,
                                                                   metaInfo->minTileSize,
                                                                   consumer);
    std::string max_tile_size_info_var = GenerateStruct_VkExtent2D(out,
                                                                   &structInfo->maxTileSize,
                                                                   metaInfo->maxTileSize,
                                                                   consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeAV1CapabilityFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1Level(" << structInfo->maxLevel << ")" << "," << std::endl;
    struct_body << "\t\t\t" << coded_picture_alignment_info_var << "," << std::endl;
    struct_body << "\t\t\t" << max_tiles_info_var << "," << std::endl;
    struct_body << "\t\t\t" << min_tile_size_info_var << "," << std::endl;
    struct_body << "\t\t\t" << max_tile_size_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeAV1SuperblockSizeFlagsKHR(" << structInfo->superblockSizes << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxSingleReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->singleReferenceNameMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxUnidirectionalCompoundReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxUnidirectionalCompoundGroup1ReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->unidirectionalCompoundReferenceNameMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxBidirectionalCompoundReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxBidirectionalCompoundGroup1ReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxBidirectionalCompoundGroup2ReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bidirectionalCompoundReferenceNameMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTemporalLayerCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxSpatialLayerCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxOperatingPoints << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minQIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxQIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->prefersGopRemainingFrames << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->requiresGopRemainingFrames << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeAV1StdFlagsKHR(" << structInfo->stdSyntaxFlags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeAV1CapabilitiesKHR");
    out << "\t\t" << "VkVideoEncodeAV1CapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeAV1DpbSlotInfoKHR(std::ostream &out, const VkVideoEncodeAV1DpbSlotInfoKHR* structInfo, Decoded_VkVideoEncodeAV1DpbSlotInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pstd_reference_info_struct = "NULL";
    if (structInfo->pStdReferenceInfo != NULL) {
        pstd_reference_info_struct = GenerateStruct_StdVideoEncodeAV1ReferenceInfo(out,
                                                                                   structInfo->pStdReferenceInfo,
                                                                                   metaInfo->pStdReferenceInfo->GetMetaStructPointer(),
                                                                                   consumer);
        pstd_reference_info_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pstd_reference_info_struct << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeAV1DpbSlotInfoKHR");
    out << "\t\t" << "VkVideoEncodeAV1DpbSlotInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeAV1FrameSizeKHR(std::ostream &out, const VkVideoEncodeAV1FrameSizeKHR* structInfo, Decoded_VkVideoEncodeAV1FrameSizeKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->intraFrameSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->predictiveFrameSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bipredictiveFrameSize << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeAV1FrameSizeKHR");
    out << "\t\t" << "VkVideoEncodeAV1FrameSizeKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeAV1GopRemainingFrameInfoKHR(std::ostream &out, const VkVideoEncodeAV1GopRemainingFrameInfoKHR* structInfo, Decoded_VkVideoEncodeAV1GopRemainingFrameInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->useGopRemainingFrames << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->gopRemainingIntra << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->gopRemainingPredictive << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->gopRemainingBipredictive << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeAV1GopRemainingFrameInfoKHR");
    out << "\t\t" << "VkVideoEncodeAV1GopRemainingFrameInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeAV1PictureInfoKHR(std::ostream &out, const VkVideoEncodeAV1PictureInfoKHR* structInfo, Decoded_VkVideoEncodeAV1PictureInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pstd_picture_info_struct = "NULL";
    if (structInfo->pStdPictureInfo != NULL) {
        pstd_picture_info_struct = GenerateStruct_StdVideoEncodeAV1PictureInfo(out,
                                                                               structInfo->pStdPictureInfo,
                                                                               metaInfo->pStdPictureInfo->GetMetaStructPointer(),
                                                                               consumer);
        pstd_picture_info_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeAV1PredictionModeKHR(" << structInfo->predictionMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeAV1RateControlGroupKHR(" << structInfo->rateControlGroup << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->constantQIndex << "," << std::endl;
    struct_body << "\t\t\t" << pstd_picture_info_struct << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int32_t*>(&structInfo->referenceNameSlotIndices[0]), VK_MAX_VIDEO_AV1_REFERENCES_PER_FRAME_KHR) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->primaryReferenceCdfOnly << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->generateObuExtensionHeader << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeAV1PictureInfoKHR");
    out << "\t\t" << "VkVideoEncodeAV1PictureInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeAV1ProfileInfoKHR(std::ostream &out, const VkVideoEncodeAV1ProfileInfoKHR* structInfo, Decoded_VkVideoEncodeAV1ProfileInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1Profile(" << structInfo->stdProfile << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeAV1ProfileInfoKHR");
    out << "\t\t" << "VkVideoEncodeAV1ProfileInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeAV1QIndexKHR(std::ostream &out, const VkVideoEncodeAV1QIndexKHR* structInfo, Decoded_VkVideoEncodeAV1QIndexKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->intraQIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->predictiveQIndex << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bipredictiveQIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeAV1QIndexKHR");
    out << "\t\t" << "VkVideoEncodeAV1QIndexKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeAV1QualityLevelPropertiesKHR(std::ostream &out, const VkVideoEncodeAV1QualityLevelPropertiesKHR* structInfo, Decoded_VkVideoEncodeAV1QualityLevelPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string preferred_constant_q_index_info_var = GenerateStruct_VkVideoEncodeAV1QIndexKHR(out,
                                                                                               &structInfo->preferredConstantQIndex,
                                                                                               metaInfo->preferredConstantQIndex,
                                                                                               consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeAV1RateControlFlagsKHR(" << structInfo->preferredRateControlFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredGopFrameCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredKeyFramePeriod << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredConsecutiveBipredictiveFrameCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredTemporalLayerCount << "," << std::endl;
    struct_body << "\t\t\t" << preferred_constant_q_index_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredMaxSingleReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredSingleReferenceNameMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredMaxUnidirectionalCompoundReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredMaxUnidirectionalCompoundGroup1ReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredUnidirectionalCompoundReferenceNameMask << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredMaxBidirectionalCompoundReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredMaxBidirectionalCompoundGroup1ReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredMaxBidirectionalCompoundGroup2ReferenceCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->preferredBidirectionalCompoundReferenceNameMask << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeAV1QualityLevelPropertiesKHR");
    out << "\t\t" << "VkVideoEncodeAV1QualityLevelPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeAV1RateControlInfoKHR(std::ostream &out, const VkVideoEncodeAV1RateControlInfoKHR* structInfo, Decoded_VkVideoEncodeAV1RateControlInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeAV1RateControlFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->gopFrameCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->keyFramePeriod << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->consecutiveBipredictiveFrameCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->temporalLayerCount << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeAV1RateControlInfoKHR");
    out << "\t\t" << "VkVideoEncodeAV1RateControlInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeAV1RateControlLayerInfoKHR(std::ostream &out, const VkVideoEncodeAV1RateControlLayerInfoKHR* structInfo, Decoded_VkVideoEncodeAV1RateControlLayerInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string min_q_index_info_var = GenerateStruct_VkVideoEncodeAV1QIndexKHR(out,
                                                                                &structInfo->minQIndex,
                                                                                metaInfo->minQIndex,
                                                                                consumer);
    std::string max_q_index_info_var = GenerateStruct_VkVideoEncodeAV1QIndexKHR(out,
                                                                                &structInfo->maxQIndex,
                                                                                metaInfo->maxQIndex,
                                                                                consumer);
    std::string max_frame_size_info_var = GenerateStruct_VkVideoEncodeAV1FrameSizeKHR(out,
                                                                                      &structInfo->maxFrameSize,
                                                                                      metaInfo->maxFrameSize,
                                                                                      consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->useMinQIndex << "," << std::endl;
    struct_body << "\t\t\t" << min_q_index_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->useMaxQIndex << "," << std::endl;
    struct_body << "\t\t\t" << max_q_index_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->useMaxFrameSize << "," << std::endl;
    struct_body << "\t\t\t" << max_frame_size_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeAV1RateControlLayerInfoKHR");
    out << "\t\t" << "VkVideoEncodeAV1RateControlLayerInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeAV1SessionCreateInfoKHR(std::ostream &out, const VkVideoEncodeAV1SessionCreateInfoKHR* structInfo, Decoded_VkVideoEncodeAV1SessionCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->useMaxLevel << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoAV1Level(" << structInfo->maxLevel << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeAV1SessionCreateInfoKHR");
    out << "\t\t" << "VkVideoEncodeAV1SessionCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeAV1SessionParametersCreateInfoKHR(std::ostream &out, const VkVideoEncodeAV1SessionParametersCreateInfoKHR* structInfo, Decoded_VkVideoEncodeAV1SessionParametersCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pstd_sequence_header_struct = "NULL";
    if (structInfo->pStdSequenceHeader != NULL) {
        pstd_sequence_header_struct = GenerateStruct_StdVideoAV1SequenceHeader(out,
                                                                               structInfo->pStdSequenceHeader,
                                                                               metaInfo->pStdSequenceHeader->GetMetaStructPointer(),
                                                                               consumer);
        pstd_sequence_header_struct.insert(0, "&");
    }
    std::string pstd_decoder_model_info_struct = "NULL";
    if (structInfo->pStdDecoderModelInfo != NULL) {
        pstd_decoder_model_info_struct = GenerateStruct_StdVideoEncodeAV1DecoderModelInfo(out,
                                                                                          structInfo->pStdDecoderModelInfo,
                                                                                          metaInfo->pStdDecoderModelInfo->GetMetaStructPointer(),
                                                                                          consumer);
        pstd_decoder_model_info_struct.insert(0, "&");
    }
    std::string pstd_operating_points_array = "NULL";
    if (structInfo->pStdOperatingPoints != NULL) {
        pstd_operating_points_array = "pStdOperatingPoints_" + std::to_string(consumer.GetNextId());
        std::string pstd_operating_points_names;
        for (uint32_t idx = 0; idx < structInfo->stdOperatingPointCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pStdOperatingPoints + idx != NULL) {
                variable_name = GenerateStruct_StdVideoEncodeAV1OperatingPointInfo(out,
                                                                                   structInfo->pStdOperatingPoints + idx,
                                                                                   metaInfo->pStdOperatingPoints->GetMetaStructPointer() + idx,
                                                                                   consumer);
            }
            pstd_operating_points_names += variable_name + ", ";
        }
        out << "\t\t" << "StdVideoEncodeAV1OperatingPointInfo " << pstd_operating_points_array << "[] = {" << pstd_operating_points_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pstd_sequence_header_struct << "," << std::endl;
    struct_body << "\t\t\t" << pstd_decoder_model_info_struct << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stdOperatingPointCount << "," << std::endl;
    struct_body << "\t\t\t" << pstd_operating_points_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeAV1SessionParametersCreateInfoKHR");
    out << "\t\t" << "VkVideoEncodeAV1SessionParametersCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVideoDecodeVP9FeaturesKHR(std::ostream &out, const VkPhysicalDeviceVideoDecodeVP9FeaturesKHR* structInfo, Decoded_VkPhysicalDeviceVideoDecodeVP9FeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->videoDecodeVP9 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVideoDecodeVP9FeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceVideoDecodeVP9FeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeVP9CapabilitiesKHR(std::ostream &out, const VkVideoDecodeVP9CapabilitiesKHR* structInfo, Decoded_VkVideoDecodeVP9CapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoVP9Level(" << structInfo->maxLevel << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeVP9CapabilitiesKHR");
    out << "\t\t" << "VkVideoDecodeVP9CapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeVP9PictureInfoKHR(std::ostream &out, const VkVideoDecodeVP9PictureInfoKHR* structInfo, Decoded_VkVideoDecodeVP9PictureInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pstd_picture_info_struct = "NULL";
    if (structInfo->pStdPictureInfo != NULL) {
        pstd_picture_info_struct = GenerateStruct_StdVideoDecodeVP9PictureInfo(out,
                                                                               structInfo->pStdPictureInfo,
                                                                               metaInfo->pStdPictureInfo->GetMetaStructPointer(),
                                                                               consumer);
        pstd_picture_info_struct.insert(0, "&");
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << pstd_picture_info_struct << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const int32_t*>(&structInfo->referenceNameSlotIndices[0]), VK_MAX_VIDEO_VP9_REFERENCES_PER_FRAME_KHR) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->uncompressedHeaderOffset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->compressedHeaderOffset << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->tilesOffset << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeVP9PictureInfoKHR");
    out << "\t\t" << "VkVideoDecodeVP9PictureInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoDecodeVP9ProfileInfoKHR(std::ostream &out, const VkVideoDecodeVP9ProfileInfoKHR* structInfo, Decoded_VkVideoDecodeVP9ProfileInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "StdVideoVP9Profile(" << structInfo->stdProfile << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoDecodeVP9ProfileInfoKHR");
    out << "\t\t" << "VkVideoDecodeVP9ProfileInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVideoMaintenance1FeaturesKHR(std::ostream &out, const VkPhysicalDeviceVideoMaintenance1FeaturesKHR* structInfo, Decoded_VkPhysicalDeviceVideoMaintenance1FeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->videoMaintenance1 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVideoMaintenance1FeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceVideoMaintenance1FeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoInlineQueryInfoKHR(std::ostream &out, const VkVideoInlineQueryInfoKHR* structInfo, Decoded_VkVideoInlineQueryInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->queryPool) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->firstQuery << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->queryCount << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoInlineQueryInfoKHR");
    out << "\t\t" << "VkVideoInlineQueryInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkAttachmentFeedbackLoopInfoEXT(std::ostream &out, const VkAttachmentFeedbackLoopInfoEXT* structInfo, Decoded_VkAttachmentFeedbackLoopInfoEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->feedbackLoopEnable << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "attachmentFeedbackLoopInfoEXT");
    out << "\t\t" << "VkAttachmentFeedbackLoopInfoEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceUnifiedImageLayoutsFeaturesKHR(std::ostream &out, const VkPhysicalDeviceUnifiedImageLayoutsFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceUnifiedImageLayoutsFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->unifiedImageLayouts << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->unifiedImageLayoutsVideo << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceUnifiedImageLayoutsFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceUnifiedImageLayoutsFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCalibratedTimestampInfoKHR(std::ostream &out, const VkCalibratedTimestampInfoKHR* structInfo, Decoded_VkCalibratedTimestampInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkTimeDomainKHR(" << structInfo->timeDomain << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "calibratedTimestampInfoKHR");
    out << "\t\t" << "VkCalibratedTimestampInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkBindDescriptorBufferEmbeddedSamplersInfoEXT(std::ostream &out, const VkBindDescriptorBufferEmbeddedSamplersInfoEXT* structInfo, Decoded_VkBindDescriptorBufferEmbeddedSamplersInfoEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderStageFlags(" << structInfo->stageFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->layout) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->set << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "bindDescriptorBufferEmbeddedSamplersInfoEXT");
    out << "\t\t" << "VkBindDescriptorBufferEmbeddedSamplersInfoEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSetDescriptorBufferOffsetsInfoEXT(std::ostream &out, const VkSetDescriptorBufferOffsetsInfoEXT* structInfo, Decoded_VkSetDescriptorBufferOffsetsInfoEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pbuffer_indices_array = "NULL";
    if (structInfo->pBufferIndices != NULL) {
        pbuffer_indices_array = "pBufferIndices_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pbuffer_indices_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pBufferIndices, structInfo->setCount) << ";" << std::endl;
    }
    std::string poffsets_array = "poffsets_array_" + std::to_string(consumer.GetNextId());
    if (structInfo->setCount > 0) {
        std::string poffsets_values = toStringJoin(structInfo->pOffsets,
                                                   structInfo->pOffsets + structInfo->setCount,
                                                   [](VkDeviceSize current) { return std::to_string(current); },
                                                   ", ");
        if (structInfo->setCount == 1) {
            poffsets_array = "&" + poffsets_values;
        } else if (structInfo->setCount > 1) {
            out << "\t\t" << "VkDeviceSize " << poffsets_array << "[] = {" << poffsets_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkShaderStageFlags(" << structInfo->stageFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->layout) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->firstSet << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->setCount << "," << std::endl;
    struct_body << "\t\t\t" << pbuffer_indices_array << "," << std::endl;
    struct_body << "\t\t\t" << "{ *" << poffsets_array << " }" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "setDescriptorBufferOffsetsInfoEXT");
    out << "\t\t" << "VkSetDescriptorBufferOffsetsInfoEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCopyMemoryIndirectCommandKHR(std::ostream &out, const VkCopyMemoryIndirectCommandKHR* structInfo, Decoded_VkCopyMemoryIndirectCommandKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->srcAddress << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dstAddress << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "copyMemoryIndirectCommandKHR");
    out << "\t\t" << "VkCopyMemoryIndirectCommandKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCopyMemoryIndirectInfoKHR(std::ostream &out, const VkCopyMemoryIndirectInfoKHR* structInfo, Decoded_VkCopyMemoryIndirectInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string copy_address_range_info_var = GenerateStruct_VkStridedDeviceAddressRangeKHR(out,
                                                                                            &structInfo->copyAddressRange,
                                                                                            metaInfo->copyAddressRange,
                                                                                            consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkAddressCopyFlagsKHR(" << structInfo->srcCopyFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAddressCopyFlagsKHR(" << structInfo->dstCopyFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->copyCount << "," << std::endl;
    struct_body << "\t\t\t" << copy_address_range_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "copyMemoryIndirectInfoKHR");
    out << "\t\t" << "VkCopyMemoryIndirectInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCopyMemoryToImageIndirectCommandKHR(std::ostream &out, const VkCopyMemoryToImageIndirectCommandKHR* structInfo, Decoded_VkCopyMemoryToImageIndirectCommandKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string image_subresource_info_var = GenerateStruct_VkImageSubresourceLayers(out,
                                                                                     &structInfo->imageSubresource,
                                                                                     metaInfo->imageSubresource,
                                                                                     consumer);
    std::string image_offset_info_var = GenerateStruct_VkOffset3D(out,
                                                                  &structInfo->imageOffset,
                                                                  metaInfo->imageOffset,
                                                                  consumer);
    std::string image_extent_info_var = GenerateStruct_VkExtent3D(out,
                                                                  &structInfo->imageExtent,
                                                                  metaInfo->imageExtent,
                                                                  consumer);
    struct_body << "\t" << structInfo->srcAddress << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferRowLength << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->bufferImageHeight << "," << std::endl;
    struct_body << "\t\t\t" << image_subresource_info_var << "," << std::endl;
    struct_body << "\t\t\t" << image_offset_info_var << "," << std::endl;
    struct_body << "\t\t\t" << image_extent_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "copyMemoryToImageIndirectCommandKHR");
    out << "\t\t" << "VkCopyMemoryToImageIndirectCommandKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCopyMemoryToImageIndirectInfoKHR(std::ostream &out, const VkCopyMemoryToImageIndirectInfoKHR* structInfo, Decoded_VkCopyMemoryToImageIndirectInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string copy_address_range_info_var = GenerateStruct_VkStridedDeviceAddressRangeKHR(out,
                                                                                            &structInfo->copyAddressRange,
                                                                                            metaInfo->copyAddressRange,
                                                                                            consumer);
    std::string pimage_subresources_array = "NULL";
    if (structInfo->pImageSubresources != NULL) {
        pimage_subresources_array = "pImageSubresources_" + std::to_string(consumer.GetNextId());
        std::string pimage_subresources_names;
        for (uint32_t idx = 0; idx < structInfo->copyCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pImageSubresources + idx != NULL) {
                variable_name = GenerateStruct_VkImageSubresourceLayers(out,
                                                                        structInfo->pImageSubresources + idx,
                                                                        metaInfo->pImageSubresources->GetMetaStructPointer() + idx,
                                                                        consumer);
            }
            pimage_subresources_names += variable_name + ", ";
        }
        out << "\t\t" << "VkImageSubresourceLayers " << pimage_subresources_array << "[] = {" << pimage_subresources_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkAddressCopyFlagsKHR(" << structInfo->srcCopyFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->copyCount << "," << std::endl;
    struct_body << "\t\t\t" << copy_address_range_info_var << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->dstImage) << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageLayout(" << structInfo->dstImageLayout << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pimage_subresources_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "copyMemoryToImageIndirectInfoKHR");
    out << "\t\t" << "VkCopyMemoryToImageIndirectInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceCopyMemoryIndirectFeaturesKHR(std::ostream &out, const VkPhysicalDeviceCopyMemoryIndirectFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceCopyMemoryIndirectFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->indirectMemoryCopy << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->indirectMemoryToImageCopy << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceCopyMemoryIndirectFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceCopyMemoryIndirectFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceCopyMemoryIndirectPropertiesKHR(std::ostream &out, const VkPhysicalDeviceCopyMemoryIndirectPropertiesKHR* structInfo, Decoded_VkPhysicalDeviceCopyMemoryIndirectPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkQueueFlags(" << structInfo->supportedQueues << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceCopyMemoryIndirectPropertiesKHR");
    out << "\t\t" << "VkPhysicalDeviceCopyMemoryIndirectPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkStridedDeviceAddressRangeKHR(std::ostream &out, const VkStridedDeviceAddressRangeKHR* structInfo, Decoded_VkStridedDeviceAddressRangeKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->address << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->stride << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "stridedDeviceAddressRangeKHR");
    out << "\t\t" << "VkStridedDeviceAddressRangeKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVideoEncodeIntraRefreshFeaturesKHR(std::ostream &out, const VkPhysicalDeviceVideoEncodeIntraRefreshFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceVideoEncodeIntraRefreshFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->videoEncodeIntraRefresh << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVideoEncodeIntraRefreshFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceVideoEncodeIntraRefreshFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeIntraRefreshCapabilitiesKHR(std::ostream &out, const VkVideoEncodeIntraRefreshCapabilitiesKHR* structInfo, Decoded_VkVideoEncodeIntraRefreshCapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeIntraRefreshModeFlagsKHR(" << structInfo->intraRefreshModes << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxIntraRefreshCycleDuration << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxIntraRefreshActiveReferencePictures << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->partitionIndependentIntraRefreshRegions << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->nonRectangularIntraRefreshRegions << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeIntraRefreshCapabilitiesKHR");
    out << "\t\t" << "VkVideoEncodeIntraRefreshCapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeIntraRefreshInfoKHR(std::ostream &out, const VkVideoEncodeIntraRefreshInfoKHR* structInfo, Decoded_VkVideoEncodeIntraRefreshInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->intraRefreshCycleDuration << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->intraRefreshIndex << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeIntraRefreshInfoKHR");
    out << "\t\t" << "VkVideoEncodeIntraRefreshInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeSessionIntraRefreshCreateInfoKHR(std::ostream &out, const VkVideoEncodeSessionIntraRefreshCreateInfoKHR* structInfo, Decoded_VkVideoEncodeSessionIntraRefreshCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeIntraRefreshModeFlagBitsKHR(" << structInfo->intraRefreshMode << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeSessionIntraRefreshCreateInfoKHR");
    out << "\t\t" << "VkVideoEncodeSessionIntraRefreshCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoReferenceIntraRefreshInfoKHR(std::ostream &out, const VkVideoReferenceIntraRefreshInfoKHR* structInfo, Decoded_VkVideoReferenceIntraRefreshInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dirtyIntraRefreshRegions << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoReferenceIntraRefreshInfoKHR");
    out << "\t\t" << "VkVideoReferenceIntraRefreshInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceVideoEncodeQuantizationMapFeaturesKHR(std::ostream &out, const VkPhysicalDeviceVideoEncodeQuantizationMapFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceVideoEncodeQuantizationMapFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->videoEncodeQuantizationMap << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceVideoEncodeQuantizationMapFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceVideoEncodeQuantizationMapFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeAV1QuantizationMapCapabilitiesKHR(std::ostream &out, const VkVideoEncodeAV1QuantizationMapCapabilitiesKHR* structInfo, Decoded_VkVideoEncodeAV1QuantizationMapCapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minQIndexDelta << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxQIndexDelta << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeAV1QuantizationMapCapabilitiesKHR");
    out << "\t\t" << "VkVideoEncodeAV1QuantizationMapCapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH264QuantizationMapCapabilitiesKHR(std::ostream &out, const VkVideoEncodeH264QuantizationMapCapabilitiesKHR* structInfo, Decoded_VkVideoEncodeH264QuantizationMapCapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minQpDelta << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxQpDelta << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH264QuantizationMapCapabilitiesKHR");
    out << "\t\t" << "VkVideoEncodeH264QuantizationMapCapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeH265QuantizationMapCapabilitiesKHR(std::ostream &out, const VkVideoEncodeH265QuantizationMapCapabilitiesKHR* structInfo, Decoded_VkVideoEncodeH265QuantizationMapCapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minQpDelta << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxQpDelta << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeH265QuantizationMapCapabilitiesKHR");
    out << "\t\t" << "VkVideoEncodeH265QuantizationMapCapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeQuantizationMapCapabilitiesKHR(std::ostream &out, const VkVideoEncodeQuantizationMapCapabilitiesKHR* structInfo, Decoded_VkVideoEncodeQuantizationMapCapabilitiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string max_quantization_map_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                                 &structInfo->maxQuantizationMapExtent,
                                                                                 metaInfo->maxQuantizationMapExtent,
                                                                                 consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << max_quantization_map_extent_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeQuantizationMapCapabilitiesKHR");
    out << "\t\t" << "VkVideoEncodeQuantizationMapCapabilitiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeQuantizationMapInfoKHR(std::ostream &out, const VkVideoEncodeQuantizationMapInfoKHR* structInfo, Decoded_VkVideoEncodeQuantizationMapInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string quantization_map_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                             &structInfo->quantizationMapExtent,
                                                                             metaInfo->quantizationMapExtent,
                                                                             consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->quantizationMap) << "," << std::endl;
    struct_body << "\t\t\t" << quantization_map_extent_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeQuantizationMapInfoKHR");
    out << "\t\t" << "VkVideoEncodeQuantizationMapInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoEncodeQuantizationMapSessionParametersCreateInfoKHR(std::ostream &out, const VkVideoEncodeQuantizationMapSessionParametersCreateInfoKHR* structInfo, Decoded_VkVideoEncodeQuantizationMapSessionParametersCreateInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string quantization_map_texel_size_info_var = GenerateStruct_VkExtent2D(out,
                                                                                 &structInfo->quantizationMapTexelSize,
                                                                                 metaInfo->quantizationMapTexelSize,
                                                                                 consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << quantization_map_texel_size_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoEncodeQuantizationMapSessionParametersCreateInfoKHR");
    out << "\t\t" << "VkVideoEncodeQuantizationMapSessionParametersCreateInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoFormatAV1QuantizationMapPropertiesKHR(std::ostream &out, const VkVideoFormatAV1QuantizationMapPropertiesKHR* structInfo, Decoded_VkVideoFormatAV1QuantizationMapPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeAV1SuperblockSizeFlagsKHR(" << structInfo->compatibleSuperblockSizes << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoFormatAV1QuantizationMapPropertiesKHR");
    out << "\t\t" << "VkVideoFormatAV1QuantizationMapPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoFormatH265QuantizationMapPropertiesKHR(std::ostream &out, const VkVideoFormatH265QuantizationMapPropertiesKHR* structInfo, Decoded_VkVideoFormatH265QuantizationMapPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkVideoEncodeH265CtbSizeFlagsKHR(" << structInfo->compatibleCtbSizes << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoFormatH265QuantizationMapPropertiesKHR");
    out << "\t\t" << "VkVideoFormatH265QuantizationMapPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkVideoFormatQuantizationMapPropertiesKHR(std::ostream &out, const VkVideoFormatQuantizationMapPropertiesKHR* structInfo, Decoded_VkVideoFormatQuantizationMapPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string quantization_map_texel_size_info_var = GenerateStruct_VkExtent2D(out,
                                                                                 &structInfo->quantizationMapTexelSize,
                                                                                 metaInfo->quantizationMapTexelSize,
                                                                                 consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << quantization_map_texel_size_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "videoFormatQuantizationMapPropertiesKHR");
    out << "\t\t" << "VkVideoFormatQuantizationMapPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR(std::ostream &out, const VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderRelaxedExtendedInstruction << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceLayeredApiPropertiesKHR(std::ostream &out, const VkPhysicalDeviceLayeredApiPropertiesKHR* structInfo, Decoded_VkPhysicalDeviceLayeredApiPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->vendorID << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceID << "," << std::endl;
    struct_body << "\t\t\t" << "VkPhysicalDeviceLayeredApiKHR(" << structInfo->layeredAPI << ")" << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->deviceName) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceLayeredApiPropertiesKHR");
    out << "\t\t" << "VkPhysicalDeviceLayeredApiPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceLayeredApiPropertiesListKHR(std::ostream &out, const VkPhysicalDeviceLayeredApiPropertiesListKHR* structInfo, Decoded_VkPhysicalDeviceLayeredApiPropertiesListKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string playered_apis_array = "NULL";
    if (structInfo->pLayeredApis != NULL) {
        playered_apis_array = "pLayeredApis_" + std::to_string(consumer.GetNextId());
        std::string playered_apis_names;
        for (uint32_t idx = 0; idx < structInfo->layeredApiCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pLayeredApis + idx != NULL) {
                variable_name = GenerateStruct_VkPhysicalDeviceLayeredApiPropertiesKHR(out,
                                                                                       structInfo->pLayeredApis + idx,
                                                                                       metaInfo->pLayeredApis->GetMetaStructPointer() + idx,
                                                                                       consumer);
            }
            playered_apis_names += variable_name + ", ";
        }
        out << "\t\t" << "VkPhysicalDeviceLayeredApiPropertiesKHR " << playered_apis_array << "[] = {" << playered_apis_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->layeredApiCount << "," << std::endl;
    struct_body << "\t\t\t" << playered_apis_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceLayeredApiPropertiesListKHR");
    out << "\t\t" << "VkPhysicalDeviceLayeredApiPropertiesListKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceLayeredApiVulkanPropertiesKHR(std::ostream &out, const VkPhysicalDeviceLayeredApiVulkanPropertiesKHR* structInfo, Decoded_VkPhysicalDeviceLayeredApiVulkanPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string properties_info_var = GenerateStruct_VkPhysicalDeviceProperties2(out,
                                                                                 &structInfo->properties,
                                                                                 metaInfo->properties,
                                                                                 consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << properties_info_var << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceLayeredApiVulkanPropertiesKHR");
    out << "\t\t" << "VkPhysicalDeviceLayeredApiVulkanPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMaintenance7FeaturesKHR(std::ostream &out, const VkPhysicalDeviceMaintenance7FeaturesKHR* structInfo, Decoded_VkPhysicalDeviceMaintenance7FeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maintenance7 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMaintenance7FeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceMaintenance7FeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMaintenance7PropertiesKHR(std::ostream &out, const VkPhysicalDeviceMaintenance7PropertiesKHR* structInfo, Decoded_VkPhysicalDeviceMaintenance7PropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->robustFragmentShadingRateAttachmentAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->separateDepthStencilAttachmentAccess << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetTotalUniformBuffersDynamic << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetTotalStorageBuffersDynamic << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetTotalBuffersDynamic << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindTotalUniformBuffersDynamic << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindTotalStorageBuffersDynamic << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxDescriptorSetUpdateAfterBindTotalBuffersDynamic << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMaintenance7PropertiesKHR");
    out << "\t\t" << "VkPhysicalDeviceMaintenance7PropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMemoryBarrierAccessFlags3KHR(std::ostream &out, const VkMemoryBarrierAccessFlags3KHR* structInfo, Decoded_VkMemoryBarrierAccessFlags3KHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags3KHR(" << structInfo->srcAccessMask3 << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkAccessFlags3KHR(" << structInfo->dstAccessMask3 << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "memoryBarrierAccessFlags3KHR");
    out << "\t\t" << "VkMemoryBarrierAccessFlags3KHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMaintenance8FeaturesKHR(std::ostream &out, const VkPhysicalDeviceMaintenance8FeaturesKHR* structInfo, Decoded_VkPhysicalDeviceMaintenance8FeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maintenance8 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMaintenance8FeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceMaintenance8FeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceShaderFmaFeaturesKHR(std::ostream &out, const VkPhysicalDeviceShaderFmaFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceShaderFmaFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderFmaFloat16 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderFmaFloat32 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->shaderFmaFloat64 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceShaderFmaFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceShaderFmaFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMaintenance9FeaturesKHR(std::ostream &out, const VkPhysicalDeviceMaintenance9FeaturesKHR* structInfo, Decoded_VkPhysicalDeviceMaintenance9FeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maintenance9 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMaintenance9FeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceMaintenance9FeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMaintenance9PropertiesKHR(std::ostream &out, const VkPhysicalDeviceMaintenance9PropertiesKHR* structInfo, Decoded_VkPhysicalDeviceMaintenance9PropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->image2DViewOf3DSparse << "," << std::endl;
    struct_body << "\t\t\t" << "VkDefaultVertexAttributeValueKHR(" << structInfo->defaultVertexAttributeValue << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMaintenance9PropertiesKHR");
    out << "\t\t" << "VkPhysicalDeviceMaintenance9PropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkQueueFamilyOwnershipTransferPropertiesKHR(std::ostream &out, const VkQueueFamilyOwnershipTransferPropertiesKHR* structInfo, Decoded_VkQueueFamilyOwnershipTransferPropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->optimalImageTransferToQueueFamilies << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "queueFamilyOwnershipTransferPropertiesKHR");
    out << "\t\t" << "VkQueueFamilyOwnershipTransferPropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR(std::ostream &out, const VkPhysicalDeviceDepthClampZeroOneFeaturesKHR* structInfo, Decoded_VkPhysicalDeviceDepthClampZeroOneFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->depthClampZeroOne << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceDepthClampZeroOneFeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceDepthClampZeroOneFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceRobustness2FeaturesKHR(std::ostream &out, const VkPhysicalDeviceRobustness2FeaturesKHR* structInfo, Decoded_VkPhysicalDeviceRobustness2FeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->robustBufferAccess2 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->robustImageAccess2 << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->nullDescriptor << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceRobustness2FeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceRobustness2FeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceRobustness2PropertiesKHR(std::ostream &out, const VkPhysicalDeviceRobustness2PropertiesKHR* structInfo, Decoded_VkPhysicalDeviceRobustness2PropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->robustStorageBufferAccessSizeAlignment << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->robustUniformBufferAccessSizeAlignment << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceRobustness2PropertiesKHR");
    out << "\t\t" << "VkPhysicalDeviceRobustness2PropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDevicePresentModeFifoLatestReadyFeaturesKHR(std::ostream &out, const VkPhysicalDevicePresentModeFifoLatestReadyFeaturesKHR* structInfo, Decoded_VkPhysicalDevicePresentModeFifoLatestReadyFeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->presentModeFifoLatestReady << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDevicePresentModeFifoLatestReadyFeaturesKHR");
    out << "\t\t" << "VkPhysicalDevicePresentModeFifoLatestReadyFeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMaintenance10FeaturesKHR(std::ostream &out, const VkPhysicalDeviceMaintenance10FeaturesKHR* structInfo, Decoded_VkPhysicalDeviceMaintenance10FeaturesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maintenance10 << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMaintenance10FeaturesKHR");
    out << "\t\t" << "VkPhysicalDeviceMaintenance10FeaturesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMaintenance10PropertiesKHR(std::ostream &out, const VkPhysicalDeviceMaintenance10PropertiesKHR* structInfo, Decoded_VkPhysicalDeviceMaintenance10PropertiesKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->rgba4OpaqueBlackSwizzled << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->resolveSrgbFormatAppliesTransferFunction << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->resolveSrgbFormatSupportsTransferFunctionControl << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMaintenance10PropertiesKHR");
    out << "\t\t" << "VkPhysicalDeviceMaintenance10PropertiesKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRenderingAttachmentFlagsInfoKHR(std::ostream &out, const VkRenderingAttachmentFlagsInfoKHR* structInfo, Decoded_VkRenderingAttachmentFlagsInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkRenderingAttachmentFlagsKHR(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "renderingAttachmentFlagsInfoKHR");
    out << "\t\t" << "VkRenderingAttachmentFlagsInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRenderingEndInfoKHR(std::ostream &out, const VkRenderingEndInfoKHR* structInfo, Decoded_VkRenderingEndInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "renderingEndInfoKHR");
    out << "\t\t" << "VkRenderingEndInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkResolveImageModeInfoKHR(std::ostream &out, const VkResolveImageModeInfoKHR* structInfo, Decoded_VkResolveImageModeInfoKHR* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkResolveImageFlagsKHR(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkResolveModeFlagBits(" << structInfo->resolveMode << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkResolveModeFlagBits(" << structInfo->stencilResolveMode << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "resolveImageModeInfoKHR");
    out << "\t\t" << "VkResolveImageModeInfoKHR " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDebugReportCallbackCreateInfoEXT(std::ostream &out, const VkDebugReportCallbackCreateInfoEXT* structInfo, Decoded_VkDebugReportCallbackCreateInfoEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDebugReportFlagsEXT(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pfnCallback << "," << std::endl;
    out << "\t\t" << "// TODO: Support pUserData (non-struct output) argument." << std::endl;
    std::string variable_name = consumer.AddStruct(struct_body, "debugReportCallbackCreateInfoEXT");
    out << "\t\t" << "VkDebugReportCallbackCreateInfoEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineRasterizationStateRasterizationOrderAMD(std::ostream &out, const VkPipelineRasterizationStateRasterizationOrderAMD* structInfo, Decoded_VkPipelineRasterizationStateRasterizationOrderAMD* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkRasterizationOrderAMD(" << structInfo->rasterizationOrder << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineRasterizationStateRasterizationOrderAMD");
    out << "\t\t" << "VkPipelineRasterizationStateRasterizationOrderAMD " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDebugMarkerMarkerInfoEXT(std::ostream &out, const VkDebugMarkerMarkerInfoEXT* structInfo, Decoded_VkDebugMarkerMarkerInfoEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->pMarkerName) << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const float*>(&structInfo->color[0]), 4) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "debugMarkerMarkerInfoEXT");
    out << "\t\t" << "VkDebugMarkerMarkerInfoEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDebugMarkerObjectNameInfoEXT(std::ostream &out, const VkDebugMarkerObjectNameInfoEXT* structInfo, Decoded_VkDebugMarkerObjectNameInfoEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDebugReportObjectTypeEXT(" << structInfo->objectType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->object << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::ToEscape(structInfo->pObjectName) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "debugMarkerObjectNameInfoEXT");
    out << "\t\t" << "VkDebugMarkerObjectNameInfoEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDebugMarkerObjectTagInfoEXT(std::ostream &out, const VkDebugMarkerObjectTagInfoEXT* structInfo, Decoded_VkDebugMarkerObjectTagInfoEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string ptag_array = "NULL";
    if (structInfo->pTag != NULL) {
        std::string ptag_values;
        for (uint32_t idx0 = 0; idx0 < structInfo->tagSize; ++idx0) {
            ptag_values += std::to_string(reinterpret_cast<const uint8_t*>(structInfo->pTag)[idx0]) + ", ";
        }
        ptag_array = "pTag_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint8_t " << ptag_array << "[] = {" << ptag_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDebugReportObjectTypeEXT(" << structInfo->objectType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->object << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->tagName << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->tagSize << "," << std::endl;
    struct_body << "\t\t\t" << ptag_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "debugMarkerObjectTagInfoEXT");
    out << "\t\t" << "VkDebugMarkerObjectTagInfoEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDedicatedAllocationBufferCreateInfoNV(std::ostream &out, const VkDedicatedAllocationBufferCreateInfoNV* structInfo, Decoded_VkDedicatedAllocationBufferCreateInfoNV* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dedicatedAllocation << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "dedicatedAllocationBufferCreateInfoNV");
    out << "\t\t" << "VkDedicatedAllocationBufferCreateInfoNV " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDedicatedAllocationImageCreateInfoNV(std::ostream &out, const VkDedicatedAllocationImageCreateInfoNV* structInfo, Decoded_VkDedicatedAllocationImageCreateInfoNV* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dedicatedAllocation << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "dedicatedAllocationImageCreateInfoNV");
    out << "\t\t" << "VkDedicatedAllocationImageCreateInfoNV " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDedicatedAllocationMemoryAllocateInfoNV(std::ostream &out, const VkDedicatedAllocationMemoryAllocateInfoNV* structInfo, Decoded_VkDedicatedAllocationMemoryAllocateInfoNV* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->image) << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->buffer) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "dedicatedAllocationMemoryAllocateInfoNV");
    out << "\t\t" << "VkDedicatedAllocationMemoryAllocateInfoNV " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceTransformFeedbackFeaturesEXT(std::ostream &out, const VkPhysicalDeviceTransformFeedbackFeaturesEXT* structInfo, Decoded_VkPhysicalDeviceTransformFeedbackFeaturesEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->transformFeedback << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->geometryStreams << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceTransformFeedbackFeaturesEXT");
    out << "\t\t" << "VkPhysicalDeviceTransformFeedbackFeaturesEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceTransformFeedbackPropertiesEXT(std::ostream &out, const VkPhysicalDeviceTransformFeedbackPropertiesEXT* structInfo, Decoded_VkPhysicalDeviceTransformFeedbackPropertiesEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTransformFeedbackStreams << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTransformFeedbackBuffers << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTransformFeedbackBufferSize << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTransformFeedbackStreamDataSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTransformFeedbackBufferDataSize << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxTransformFeedbackBufferDataStride << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->transformFeedbackQueries << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->transformFeedbackStreamsLinesTriangles << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->transformFeedbackRasterizationStreamSelect << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->transformFeedbackDraw << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceTransformFeedbackPropertiesEXT");
    out << "\t\t" << "VkPhysicalDeviceTransformFeedbackPropertiesEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineRasterizationStateStreamCreateInfoEXT(std::ostream &out, const VkPipelineRasterizationStateStreamCreateInfoEXT* structInfo, Decoded_VkPipelineRasterizationStateStreamCreateInfoEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkPipelineRasterizationStateStreamCreateFlagsEXT(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->rasterizationStream << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineRasterizationStateStreamCreateInfoEXT");
    out << "\t\t" << "VkPipelineRasterizationStateStreamCreateInfoEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageViewAddressPropertiesNVX(std::ostream &out, const VkImageViewAddressPropertiesNVX* structInfo, Decoded_VkImageViewAddressPropertiesNVX* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->deviceAddress << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->size << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageViewAddressPropertiesNVX");
    out << "\t\t" << "VkImageViewAddressPropertiesNVX " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageViewHandleInfoNVX(std::ostream &out, const VkImageViewHandleInfoNVX* structInfo, Decoded_VkImageViewHandleInfoNVX* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->imageView) << "," << std::endl;
    struct_body << "\t\t\t" << "VkDescriptorType(" << structInfo->descriptorType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->sampler) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageViewHandleInfoNVX");
    out << "\t\t" << "VkImageViewHandleInfoNVX " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkTextureLODGatherFormatPropertiesAMD(std::ostream &out, const VkTextureLODGatherFormatPropertiesAMD* structInfo, Decoded_VkTextureLODGatherFormatPropertiesAMD* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->supportsTextureGatherLODBiasAMD << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "textureLODGatherFormatPropertiesAMD");
    out << "\t\t" << "VkTextureLODGatherFormatPropertiesAMD " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkShaderResourceUsageAMD(std::ostream &out, const VkShaderResourceUsageAMD* structInfo, Decoded_VkShaderResourceUsageAMD* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->numUsedVgprs << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->numUsedSgprs << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->ldsSizePerLocalWorkGroup << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->ldsUsageSizeInBytes << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->scratchMemUsageInBytes << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "shaderResourceUsageAMD");
    out << "\t\t" << "VkShaderResourceUsageAMD " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkShaderStatisticsInfoAMD(std::ostream &out, const VkShaderStatisticsInfoAMD* structInfo, Decoded_VkShaderStatisticsInfoAMD* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string resource_usage_info_var = GenerateStruct_VkShaderResourceUsageAMD(out,
                                                                                  &structInfo->resourceUsage,
                                                                                  metaInfo->resourceUsage,
                                                                                  consumer);
    struct_body << "\t" << "VkShaderStageFlags(" << structInfo->shaderStageMask << ")" << "," << std::endl;
    struct_body << "\t\t\t" << resource_usage_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->numPhysicalVgprs << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->numPhysicalSgprs << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->numAvailableVgprs << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->numAvailableSgprs << "," << std::endl;
    struct_body << "\t\t\t" << VulkanCppConsumerBase::BuildValue(reinterpret_cast<const uint32_t*>(&structInfo->computeWorkGroupSize[0]), 3) << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "shaderStatisticsInfoAMD");
    out << "\t\t" << "VkShaderStatisticsInfoAMD " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkStreamDescriptorSurfaceCreateInfoGGP(std::ostream &out, const VkStreamDescriptorSurfaceCreateInfoGGP* structInfo, Decoded_VkStreamDescriptorSurfaceCreateInfoGGP* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkStreamDescriptorSurfaceCreateFlagsGGP(" << structInfo->flags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->streamDescriptor << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "streamDescriptorSurfaceCreateInfoGGP");
    out << "\t\t" << "VkStreamDescriptorSurfaceCreateInfoGGP " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceCornerSampledImageFeaturesNV(std::ostream &out, const VkPhysicalDeviceCornerSampledImageFeaturesNV* structInfo, Decoded_VkPhysicalDeviceCornerSampledImageFeaturesNV* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->cornerSampledImage << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceCornerSampledImageFeaturesNV");
    out << "\t\t" << "VkPhysicalDeviceCornerSampledImageFeaturesNV " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExternalImageFormatPropertiesNV(std::ostream &out, const VkExternalImageFormatPropertiesNV* structInfo, Decoded_VkExternalImageFormatPropertiesNV* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string image_format_properties_info_var = GenerateStruct_VkImageFormatProperties(out,
                                                                                          &structInfo->imageFormatProperties,
                                                                                          metaInfo->imageFormatProperties,
                                                                                          consumer);
    struct_body << "\t" << image_format_properties_info_var << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryFeatureFlagsNV(" << structInfo->externalMemoryFeatures << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlagsNV(" << structInfo->exportFromImportedHandleTypes << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlagsNV(" << structInfo->compatibleHandleTypes << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "externalImageFormatPropertiesNV");
    out << "\t\t" << "VkExternalImageFormatPropertiesNV " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExportMemoryAllocateInfoNV(std::ostream &out, const VkExportMemoryAllocateInfoNV* structInfo, Decoded_VkExportMemoryAllocateInfoNV* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlagsNV(" << structInfo->handleTypes << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "exportMemoryAllocateInfoNV");
    out << "\t\t" << "VkExportMemoryAllocateInfoNV " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExternalMemoryImageCreateInfoNV(std::ostream &out, const VkExternalMemoryImageCreateInfoNV* structInfo, Decoded_VkExternalMemoryImageCreateInfoNV* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlagsNV(" << structInfo->handleTypes << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "externalMemoryImageCreateInfoNV");
    out << "\t\t" << "VkExternalMemoryImageCreateInfoNV " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkExportMemoryWin32HandleInfoNV(std::ostream &out, const VkExportMemoryWin32HandleInfoNV* structInfo, Decoded_VkExportMemoryWin32HandleInfoNV* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->pAttributes << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->dwAccess << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "exportMemoryWin32HandleInfoNV");
    out << "\t\t" << "VkExportMemoryWin32HandleInfoNV " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImportMemoryWin32HandleInfoNV(std::ostream &out, const VkImportMemoryWin32HandleInfoNV* structInfo, Decoded_VkImportMemoryWin32HandleInfoNV* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkExternalMemoryHandleTypeFlagsNV(" << structInfo->handleType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "reinterpret_cast<HANDLE>(" << structInfo->handle << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "importMemoryWin32HandleInfoNV");
    out << "\t\t" << "VkImportMemoryWin32HandleInfoNV " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkWin32KeyedMutexAcquireReleaseInfoNV(std::ostream &out, const VkWin32KeyedMutexAcquireReleaseInfoNV* structInfo, Decoded_VkWin32KeyedMutexAcquireReleaseInfoNV* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pacquire_syncs_array = "NULL";
    if (metaInfo->pAcquireSyncs.GetPointer() != NULL && structInfo->acquireCount > 0) {
        pacquire_syncs_array = "pacquire_syncs_array_" + std::to_string(consumer.GetNextId(VK_OBJECT_TYPE_DEVICE_MEMORY));
        std::string pacquire_syncs_values = toStringJoin(metaInfo->pAcquireSyncs.GetPointer(),
                                                         metaInfo->pAcquireSyncs.GetPointer() + structInfo->acquireCount,
                                                         [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                         ", ");
        if (structInfo->acquireCount == 1) {
            pacquire_syncs_array = "&" + pacquire_syncs_values;
        } else if (structInfo->acquireCount > 1) {
            out << "\t\t" << "VkDeviceMemory " << pacquire_syncs_array << "[] = {" << pacquire_syncs_values << "};" << std::endl;
        }
    }
    std::string pacquire_keys_array = "pacquire_keys_array_" + std::to_string(consumer.GetNextId());
    if (structInfo->acquireCount > 0) {
        std::string pacquire_keys_values = toStringJoin(structInfo->pAcquireKeys,
                                                        structInfo->pAcquireKeys + structInfo->acquireCount,
                                                        [](uint64_t current) { return std::to_string(current); },
                                                        ", ");
        if (structInfo->acquireCount == 1) {
            pacquire_keys_array = "&" + pacquire_keys_values;
        } else if (structInfo->acquireCount > 1) {
            out << "\t\t" << "uint64_t " << pacquire_keys_array << "[] = {" << pacquire_keys_values << "};" << std::endl;
        }
    }
    std::string pacquire_timeout_milliseconds_array = "NULL";
    if (structInfo->pAcquireTimeoutMilliseconds != NULL) {
        pacquire_timeout_milliseconds_array = "pAcquireTimeoutMilliseconds_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "uint32_t " << pacquire_timeout_milliseconds_array << "[] = " << VulkanCppConsumerBase::BuildValue(structInfo->pAcquireTimeoutMilliseconds, structInfo->acquireCount) << ";" << std::endl;
    }
    std::string prelease_syncs_array = "NULL";
    if (metaInfo->pReleaseSyncs.GetPointer() != NULL && structInfo->releaseCount > 0) {
        prelease_syncs_array = "prelease_syncs_array_" + std::to_string(consumer.GetNextId(VK_OBJECT_TYPE_DEVICE_MEMORY));
        std::string prelease_syncs_values = toStringJoin(metaInfo->pReleaseSyncs.GetPointer(),
                                                         metaInfo->pReleaseSyncs.GetPointer() + structInfo->releaseCount,
                                                         [&](const format::HandleId current) { return consumer.GetHandle(current); },
                                                         ", ");
        if (structInfo->releaseCount == 1) {
            prelease_syncs_array = "&" + prelease_syncs_values;
        } else if (structInfo->releaseCount > 1) {
            out << "\t\t" << "VkDeviceMemory " << prelease_syncs_array << "[] = {" << prelease_syncs_values << "};" << std::endl;
        }
    }
    std::string prelease_keys_array = "prelease_keys_array_" + std::to_string(consumer.GetNextId());
    if (structInfo->releaseCount > 0) {
        std::string prelease_keys_values = toStringJoin(structInfo->pReleaseKeys,
                                                        structInfo->pReleaseKeys + structInfo->releaseCount,
                                                        [](uint64_t current) { return std::to_string(current); },
                                                        ", ");
        if (structInfo->releaseCount == 1) {
            prelease_keys_array = "&" + prelease_keys_values;
        } else if (structInfo->releaseCount > 1) {
            out << "\t\t" << "uint64_t " << prelease_keys_array << "[] = {" << prelease_keys_values << "};" << std::endl;
        }
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->acquireCount << "," << std::endl;
    struct_body << "\t\t\t" << pacquire_syncs_array << "," << std::endl;
    struct_body << "\t\t\t" << "{ *" << pacquire_keys_array << " }" << "," << std::endl;
    struct_body << "\t\t\t" << pacquire_timeout_milliseconds_array << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->releaseCount << "," << std::endl;
    struct_body << "\t\t\t" << prelease_syncs_array << "," << std::endl;
    struct_body << "\t\t\t" << "{ *" << prelease_keys_array << " }" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "win32KeyedMutexAcquireReleaseInfoNV");
    out << "\t\t" << "VkWin32KeyedMutexAcquireReleaseInfoNV " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkValidationFlagsEXT(std::ostream &out, const VkValidationFlagsEXT* structInfo, Decoded_VkValidationFlagsEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pdisabled_validation_checks_values;
    std::string pdisabled_validation_checks_array = "NULL";
    if (structInfo->pDisabledValidationChecks != NULL) {
        for (uint32_t idx = 0; idx < structInfo->disabledValidationCheckCount; idx++) {
            pdisabled_validation_checks_values += util::ToString<VkValidationCheckEXT>(structInfo->pDisabledValidationChecks[idx]) + ", ";
        }
        pdisabled_validation_checks_array = "pDisabledValidationChecks_" + std::to_string(consumer.GetNextId());
        out << "\t\t" << "VkValidationCheckEXT " << pdisabled_validation_checks_array << "[] = {" << pdisabled_validation_checks_values << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->disabledValidationCheckCount << "," << std::endl;
    struct_body << "\t\t\t" << pdisabled_validation_checks_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "validationFlagsEXT");
    out << "\t\t" << "VkValidationFlagsEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkViSurfaceCreateInfoNN(std::ostream &out, const VkViSurfaceCreateInfoNN* structInfo, Decoded_VkViSurfaceCreateInfoNN* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkViSurfaceCreateFlagsNN(" << structInfo->flags << ")" << "," << std::endl;
    out << "\t\t" << "// TODO: Support window (non-struct output) argument." << std::endl;
    std::string variable_name = consumer.AddStruct(struct_body, "viSurfaceCreateInfoNN");
    out << "\t\t" << "VkViSurfaceCreateInfoNN " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkImageViewASTCDecodeModeEXT(std::ostream &out, const VkImageViewASTCDecodeModeEXT* structInfo, Decoded_VkImageViewASTCDecodeModeEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkFormat(" << structInfo->decodeMode << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "imageViewASTCDecodeModeEXT");
    out << "\t\t" << "VkImageViewASTCDecodeModeEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceASTCDecodeFeaturesEXT(std::ostream &out, const VkPhysicalDeviceASTCDecodeFeaturesEXT* structInfo, Decoded_VkPhysicalDeviceASTCDecodeFeaturesEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->decodeModeSharedExponent << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceASTCDecodeFeaturesEXT");
    out << "\t\t" << "VkPhysicalDeviceASTCDecodeFeaturesEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkCommandBufferInheritanceConditionalRenderingInfoEXT(std::ostream &out, const VkCommandBufferInheritanceConditionalRenderingInfoEXT* structInfo, Decoded_VkCommandBufferInheritanceConditionalRenderingInfoEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->conditionalRenderingEnable << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "commandBufferInheritanceConditionalRenderingInfoEXT");
    out << "\t\t" << "VkCommandBufferInheritanceConditionalRenderingInfoEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkConditionalRenderingBeginInfoEXT(std::ostream &out, const VkConditionalRenderingBeginInfoEXT* structInfo, Decoded_VkConditionalRenderingBeginInfoEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << consumer.GetHandle(metaInfo->buffer) << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->offset << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << "VkConditionalRenderingFlagsEXT(" << structInfo->flags << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "conditionalRenderingBeginInfoEXT");
    out << "\t\t" << "VkConditionalRenderingBeginInfoEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceConditionalRenderingFeaturesEXT(std::ostream &out, const VkPhysicalDeviceConditionalRenderingFeaturesEXT* structInfo, Decoded_VkPhysicalDeviceConditionalRenderingFeaturesEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->conditionalRendering << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->inheritedConditionalRendering << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceConditionalRenderingFeaturesEXT");
    out << "\t\t" << "VkPhysicalDeviceConditionalRenderingFeaturesEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPipelineViewportWScalingStateCreateInfoNV(std::ostream &out, const VkPipelineViewportWScalingStateCreateInfoNV* structInfo, Decoded_VkPipelineViewportWScalingStateCreateInfoNV* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string pviewport_w_scalings_array = "NULL";
    if (structInfo->pViewportWScalings != NULL) {
        pviewport_w_scalings_array = "pViewportWScalings_" + std::to_string(consumer.GetNextId());
        std::string pviewport_w_scalings_names;
        for (uint32_t idx = 0; idx < structInfo->viewportCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pViewportWScalings + idx != NULL) {
                variable_name = GenerateStruct_VkViewportWScalingNV(out,
                                                                    structInfo->pViewportWScalings + idx,
                                                                    metaInfo->pViewportWScalings->GetMetaStructPointer() + idx,
                                                                    consumer);
            }
            pviewport_w_scalings_names += variable_name + ", ";
        }
        out << "\t\t" << "VkViewportWScalingNV " << pviewport_w_scalings_array << "[] = {" << pviewport_w_scalings_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->viewportWScalingEnable << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->viewportCount << "," << std::endl;
    struct_body << "\t\t\t" << pviewport_w_scalings_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pipelineViewportWScalingStateCreateInfoNV");
    out << "\t\t" << "VkPipelineViewportWScalingStateCreateInfoNV " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkViewportWScalingNV(std::ostream &out, const VkViewportWScalingNV* structInfo, Decoded_VkViewportWScalingNV* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->xcoeff << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->ycoeff << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "viewportWScalingNV");
    out << "\t\t" << "VkViewportWScalingNV " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSurfaceCapabilities2EXT(std::ostream &out, const VkSurfaceCapabilities2EXT* structInfo, Decoded_VkSurfaceCapabilities2EXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string current_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                    &structInfo->currentExtent,
                                                                    metaInfo->currentExtent,
                                                                    consumer);
    std::string min_image_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                      &structInfo->minImageExtent,
                                                                      metaInfo->minImageExtent,
                                                                      consumer);
    std::string max_image_extent_info_var = GenerateStruct_VkExtent2D(out,
                                                                      &structInfo->maxImageExtent,
                                                                      metaInfo->maxImageExtent,
                                                                      consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->minImageCount << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxImageCount << "," << std::endl;
    struct_body << "\t\t\t" << current_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << min_image_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << max_image_extent_info_var << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->maxImageArrayLayers << "," << std::endl;
    struct_body << "\t\t\t" << "VkSurfaceTransformFlagsKHR(" << structInfo->supportedTransforms << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSurfaceTransformFlagBitsKHR(" << structInfo->currentTransform << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkCompositeAlphaFlagsKHR(" << structInfo->supportedCompositeAlpha << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkImageUsageFlags(" << structInfo->supportedUsageFlags << ")" << "," << std::endl;
    struct_body << "\t\t\t" << "VkSurfaceCounterFlagsEXT(" << structInfo->supportedSurfaceCounters << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "surfaceCapabilities2EXT");
    out << "\t\t" << "VkSurfaceCapabilities2EXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDeviceEventInfoEXT(std::ostream &out, const VkDeviceEventInfoEXT* structInfo, Decoded_VkDeviceEventInfoEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDeviceEventTypeEXT(" << structInfo->deviceEvent << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "deviceEventInfoEXT");
    out << "\t\t" << "VkDeviceEventInfoEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplayEventInfoEXT(std::ostream &out, const VkDisplayEventInfoEXT* structInfo, Decoded_VkDisplayEventInfoEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDisplayEventTypeEXT(" << structInfo->displayEvent << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displayEventInfoEXT");
    out << "\t\t" << "VkDisplayEventInfoEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkDisplayPowerInfoEXT(std::ostream &out, const VkDisplayPowerInfoEXT* structInfo, Decoded_VkDisplayPowerInfoEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkDisplayPowerStateEXT(" << structInfo->powerState << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "displayPowerInfoEXT");
    out << "\t\t" << "VkDisplayPowerInfoEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkSwapchainCounterCreateInfoEXT(std::ostream &out, const VkSwapchainCounterCreateInfoEXT* structInfo, Decoded_VkSwapchainCounterCreateInfoEXT* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << "VkSurfaceCounterFlagsEXT(" << structInfo->surfaceCounters << ")" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "swapchainCounterCreateInfoEXT");
    out << "\t\t" << "VkSwapchainCounterCreateInfoEXT " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPastPresentationTimingGOOGLE(std::ostream &out, const VkPastPresentationTimingGOOGLE* structInfo, Decoded_VkPastPresentationTimingGOOGLE* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->presentID << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->desiredPresentTime << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->actualPresentTime << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->earliestPresentTime << "UL" << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->presentMargin << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "pastPresentationTimingGOOGLE");
    out << "\t\t" << "VkPastPresentationTimingGOOGLE " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPresentTimeGOOGLE(std::ostream &out, const VkPresentTimeGOOGLE* structInfo, Decoded_VkPresentTimeGOOGLE* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->presentID << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->desiredPresentTime << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "presentTimeGOOGLE");
    out << "\t\t" << "VkPresentTimeGOOGLE " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPresentTimesInfoGOOGLE(std::ostream &out, const VkPresentTimesInfoGOOGLE* structInfo, Decoded_VkPresentTimesInfoGOOGLE* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    std::string ptimes_array = "NULL";
    if (structInfo->pTimes != NULL) {
        ptimes_array = "pTimes_" + std::to_string(consumer.GetNextId());
        std::string ptimes_names;
        for (uint32_t idx = 0; idx < structInfo->swapchainCount; idx++) {
            std::string variable_name = "NULL";
            if (structInfo->pTimes + idx != NULL) {
                variable_name = GenerateStruct_VkPresentTimeGOOGLE(out,
                                                                   structInfo->pTimes + idx,
                                                                   metaInfo->pTimes->GetMetaStructPointer() + idx,
                                                                   consumer);
            }
            ptimes_names += variable_name + ", ";
        }
        out << "\t\t" << "VkPresentTimeGOOGLE " << ptimes_array << "[] = {" << ptimes_names << "};" << std::endl;
    }
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->swapchainCount << "," << std::endl;
    struct_body << "\t\t\t" << ptimes_array << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "presentTimesInfoGOOGLE");
    out << "\t\t" << "VkPresentTimesInfoGOOGLE " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkRefreshCycleDurationGOOGLE(std::ostream &out, const VkRefreshCycleDurationGOOGLE* structInfo, Decoded_VkRefreshCycleDurationGOOGLE* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    struct_body << "\t" << structInfo->refreshDuration << "UL" << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "refreshCycleDurationGOOGLE");
    out << "\t\t" << "VkRefreshCycleDurationGOOGLE " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkMultiviewPerViewAttributesInfoNVX(std::ostream &out, const VkMultiviewPerViewAttributesInfoNVX* structInfo, Decoded_VkMultiviewPerViewAttributesInfoNVX* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->perViewAttributes << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->perViewAttributesPositionXOnly << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "multiviewPerViewAttributesInfoNVX");
    out << "\t\t" << "VkMultiviewPerViewAttributesInfoNVX " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;
    out << "\t\t" << "};" << std::endl;
    return variable_name;
}


std::string GenerateStruct_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX(std::ostream &out, const VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX* structInfo, Decoded_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX* metaInfo, VulkanCppConsumerBase &consumer){
    std::stringstream struct_body;
    std::string pnext_name = GenerateExtension(out, structInfo->pNext, metaInfo->pNext, consumer);
    struct_body << "\t" << "VkStructureType(" << structInfo->sType << ")" << "," << std::endl;
    struct_body << "\t\t\t" << pnext_name << "," << std::endl;
    struct_body << "\t\t\t" << structInfo->perViewPositionAllComponents << ",";
    std::string variable_name = consumer.AddStruct(struct_body, "physicalDeviceMultiviewPerViewAttributesPropertiesNVX");
    out << "\t\t" << "VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX " << variable_name << " {" << std::endl;
    out << "\t\t" << struct_body.str() << std::endl;