// Code generated by smithy-go-codegen DO NOT EDIT.

package endpoints

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/endpoints"
	"regexp"
)

// Options is the endpoint resolver configuration options
type Options struct {
	DisableHTTPS bool
}

// Resolver S3 endpoint resolver
type Resolver struct {
	partitions endpoints.Partitions
}

// ResolveEndpoint resolves the service endpoint for the given region and options
func (r *Resolver) ResolveEndpoint(region string, options Options) (endpoint aws.Endpoint, err error) {
	if len(region) == 0 {
		return endpoint, &aws.MissingRegionError{}
	}

	opt := endpoints.Options{
		DisableHTTPS: options.DisableHTTPS,
	}
	return r.partitions.ResolveEndpoint(region, opt)
}

// New returns a new Resolver
func New() *Resolver {
	return &Resolver{
		partitions: defaultPartitions,
	}
}

var defaultPartitions = endpoints.Partitions{
	{
		ID: "aws",
		Defaults: endpoints.Endpoint{
			Hostname:          "s3.{region}.amazonaws.com",
			Protocols:         []string{"http", "https"},
			SignatureVersions: []string{"s3v4"},
		},
		RegionRegex:    regexp.MustCompile("^(us|eu|ap|sa|ca|me|af)\\-\\w+\\-\\d+$"),
		IsRegionalized: true,
		Endpoints: endpoints.Endpoints{
			"af-south-1": endpoints.Endpoint{},
			"ap-east-1":  endpoints.Endpoint{},
			"ap-northeast-1": endpoints.Endpoint{
				Hostname:          "s3.ap-northeast-1.amazonaws.com",
				SignatureVersions: []string{"s3", "s3v4"},
			},
			"ap-northeast-2": endpoints.Endpoint{},
			"ap-south-1":     endpoints.Endpoint{},
			"ap-southeast-1": endpoints.Endpoint{
				Hostname:          "s3.ap-southeast-1.amazonaws.com",
				SignatureVersions: []string{"s3", "s3v4"},
			},
			"ap-southeast-2": endpoints.Endpoint{
				Hostname:          "s3.ap-southeast-2.amazonaws.com",
				SignatureVersions: []string{"s3", "s3v4"},
			},
			"aws-global": endpoints.Endpoint{
				Hostname:          "s3.amazonaws.com",
				SignatureVersions: []string{"s3", "s3v4"},
				CredentialScope: endpoints.CredentialScope{
					Region: "us-east-1",
				},
			},
			"ca-central-1": endpoints.Endpoint{},
			"eu-central-1": endpoints.Endpoint{},
			"eu-north-1":   endpoints.Endpoint{},
			"eu-south-1":   endpoints.Endpoint{},
			"eu-west-1": endpoints.Endpoint{
				Hostname:          "s3.eu-west-1.amazonaws.com",
				SignatureVersions: []string{"s3", "s3v4"},
			},
			"eu-west-2":  endpoints.Endpoint{},
			"eu-west-3":  endpoints.Endpoint{},
			"me-south-1": endpoints.Endpoint{},
			"s3-external-1": endpoints.Endpoint{
				Hostname:          "s3-external-1.amazonaws.com",
				SignatureVersions: []string{"s3", "s3v4"},
				CredentialScope: endpoints.CredentialScope{
					Region: "us-east-1",
				},
			},
			"sa-east-1": endpoints.Endpoint{
				Hostname:          "s3.sa-east-1.amazonaws.com",
				SignatureVersions: []string{"s3", "s3v4"},
			},
			"us-east-1": endpoints.Endpoint{
				Hostname:          "s3.us-east-1.amazonaws.com",
				SignatureVersions: []string{"s3", "s3v4"},
			},
			"us-east-2": endpoints.Endpoint{},
			"us-west-1": endpoints.Endpoint{
				Hostname:          "s3.us-west-1.amazonaws.com",
				SignatureVersions: []string{"s3", "s3v4"},
			},
			"us-west-2": endpoints.Endpoint{
				Hostname:          "s3.us-west-2.amazonaws.com",
				SignatureVersions: []string{"s3", "s3v4"},
			},
		},
	},
	{
		ID: "aws-cn",
		Defaults: endpoints.Endpoint{
			Hostname:          "s3.{region}.amazonaws.com.cn",
			Protocols:         []string{"http", "https"},
			SignatureVersions: []string{"s3v4"},
		},
		RegionRegex:    regexp.MustCompile("^cn\\-\\w+\\-\\d+$"),
		IsRegionalized: true,
		Endpoints: endpoints.Endpoints{
			"cn-north-1":     endpoints.Endpoint{},
			"cn-northwest-1": endpoints.Endpoint{},
		},
	},
	{
		ID: "aws-iso",
		Defaults: endpoints.Endpoint{
			Hostname:          "s3.{region}.c2s.ic.gov",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"s3v4"},
		},
		RegionRegex:    regexp.MustCompile("^us\\-iso\\-\\w+\\-\\d+$"),
		IsRegionalized: true,
		Endpoints: endpoints.Endpoints{
			"us-iso-east-1": endpoints.Endpoint{
				Protocols:         []string{"http", "https"},
				SignatureVersions: []string{"s3v4"},
			},
		},
	},
	{
		ID: "aws-iso-b",
		Defaults: endpoints.Endpoint{
			Hostname:          "s3.{region}.sc2s.sgov.gov",
			Protocols:         []string{"http", "https"},
			SignatureVersions: []string{"s3v4"},
		},
		RegionRegex:    regexp.MustCompile("^us\\-isob\\-\\w+\\-\\d+$"),
		IsRegionalized: true,
		Endpoints: endpoints.Endpoints{
			"us-isob-east-1": endpoints.Endpoint{},
		},
	},
	{
		ID: "aws-us-gov",
		Defaults: endpoints.Endpoint{
			Hostname:          "s3.{region}.amazonaws.com",
			Protocols:         []string{"https"},
			SignatureVersions: []string{"s3", "s3v4"},
		},
		RegionRegex:    regexp.MustCompile("^us\\-gov\\-\\w+\\-\\d+$"),
		IsRegionalized: true,
		Endpoints: endpoints.Endpoints{
			"fips-us-gov-west-1": endpoints.Endpoint{
				Hostname: "s3-fips.us-gov-west-1.amazonaws.com",
				CredentialScope: endpoints.CredentialScope{
					Region: "us-gov-west-1",
				},
			},
			"us-gov-east-1": endpoints.Endpoint{
				Hostname:  "s3.us-gov-east-1.amazonaws.com",
				Protocols: []string{"http", "https"},
			},
			"us-gov-west-1": endpoints.Endpoint{
				Hostname:  "s3.us-gov-west-1.amazonaws.com",
				Protocols: []string{"http", "https"},
			},
		},
	},
}
