/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxIncludeRawNode;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeReferenceDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRawNode;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTableCore;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u00062\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00010\u0010H\u0016JV\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00010\u00102\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u00162\u001a\u0010\u0017\u001a\u0016\u0012\b\u0012\u00060\u0003j\u0002`\u0018\u0012\b\u0012\u00060\u0003j\u0002`\u00190\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00010\u0010H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxIncludeRawNode;", "Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxRawNode;", "ruleId", "", "parent", "include", "", "<init>", "(ILorg/jetbrains/plugins/textmate/language/syntax/SyntaxRawNode;Ljava/lang/String;)V", "getRuleId", "()I", "getParent", "()Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxRawNode;", "findInRepository", "scopeName", "topLevelRules", "", "", "compile", "Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptor;", "topLevelNodes", "compiledNodes", "", "ruleIdToReferenceRuleId", "Lorg/jetbrains/plugins/textmate/language/syntax/RuleId;", "Lorg/jetbrains/plugins/textmate/language/syntax/ReferenceRuleId;", "syntaxTable", "Lorg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableCore;", "resolveInclude", "intellij.textmate.core"})
final class SyntaxIncludeRawNode
implements SyntaxRawNode {
    private final int ruleId;
    @NotNull
    private final SyntaxRawNode parent;
    @NotNull
    private final String include;

    public SyntaxIncludeRawNode(int ruleId, @NotNull SyntaxRawNode parent, @NotNull String include) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)include, (String)"include");
        this.ruleId = ruleId;
        this.parent = parent;
        this.include = include;
    }

    @Override
    public int getRuleId() {
        return this.ruleId;
    }

    @Override
    @NotNull
    public SyntaxRawNode getParent() {
        return this.parent;
    }

    @Override
    @Nullable
    public SyntaxRawNode findInRepository(@NotNull String scopeName, @NotNull Map<CharSequence, ? extends SyntaxRawNode> topLevelRules) {
        Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
        Intrinsics.checkNotNullParameter(topLevelRules, (String)"topLevelRules");
        SyntaxRawNode syntaxRawNode = this.resolveInclude(topLevelRules);
        return syntaxRawNode != null ? syntaxRawNode.findInRepository(scopeName, topLevelRules) : null;
    }

    @Override
    @Nullable
    public SyntaxNodeDescriptor compile(@NotNull Map<CharSequence, ? extends SyntaxRawNode> topLevelNodes, @NotNull Map<Integer, SyntaxNodeDescriptor> compiledNodes, @NotNull Map<Integer, Integer> ruleIdToReferenceRuleId, @NotNull TextMateSyntaxTableCore syntaxTable) {
        SyntaxNodeDescriptor syntaxNodeDescriptor;
        SyntaxRawNode resolvedNode;
        Intrinsics.checkNotNullParameter(topLevelNodes, (String)"topLevelNodes");
        Intrinsics.checkNotNullParameter(compiledNodes, (String)"compiledNodes");
        Intrinsics.checkNotNullParameter(ruleIdToReferenceRuleId, (String)"ruleIdToReferenceRuleId");
        Intrinsics.checkNotNullParameter((Object)syntaxTable, (String)"syntaxTable");
        SyntaxRawNode syntaxRawNode = resolvedNode = this.resolveInclude(topLevelNodes);
        if (syntaxRawNode != null) {
            SyntaxRawNode resolvedNode2 = syntaxRawNode;
            boolean bl = false;
            SyntaxNodeDescriptor compiledNode = compiledNodes.get(resolvedNode2.getRuleId());
            Integer referenceRuleId = ruleIdToReferenceRuleId.get(resolvedNode2.getRuleId());
            if (compiledNode != null) {
                syntaxNodeDescriptor = compiledNode;
            } else if (referenceRuleId != null) {
                syntaxNodeDescriptor = new SyntaxNodeReferenceDescriptor(referenceRuleId, syntaxTable);
            } else {
                int referenceRuleId2 = ruleIdToReferenceRuleId.size();
                Integer n = referenceRuleId2;
                ruleIdToReferenceRuleId.put(resolvedNode2.getRuleId(), n);
                syntaxNodeDescriptor = new SyntaxNodeReferenceDescriptor(referenceRuleId2, syntaxTable);
            }
        } else {
            syntaxNodeDescriptor = null;
        }
        return syntaxNodeDescriptor;
    }

    private final SyntaxRawNode resolveInclude(Map<CharSequence, ? extends SyntaxRawNode> topLevelNodes) {
        SyntaxRawNode syntaxRawNode;
        if (StringsKt.startsWith$default((CharSequence)this.include, (char)'#', (boolean)false, (int)2, null)) {
            SyntaxRawNode syntaxRawNode2 = this.getParent();
            String string = this.include.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            syntaxRawNode = syntaxRawNode2.findInRepository(string, topLevelNodes);
        } else if (StringsKt.equals((String)"$self", (String)this.include, (boolean)true) || StringsKt.equals((String)"$base", (String)this.include, (boolean)true)) {
            syntaxRawNode = (SyntaxRawNode)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)this.getParent(), (Function1)((Function1)resolveInclude.1.INSTANCE)));
        } else {
            String scopeName;
            String topLevelScope;
            int i = StringsKt.indexOf$default((CharSequence)this.include, (char)'#', (int)0, (boolean)false, (int)6, null);
            if (i >= 0) {
                String string = this.include.substring(0, i);
                v4 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            } else {
                v4 = topLevelScope = this.include;
            }
            if (i >= 0) {
                String string = this.include.substring(i + 1);
                v6 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            } else {
                v6 = scopeName = "";
            }
            if (((CharSequence)scopeName).length() > 0) {
                SyntaxRawNode syntaxRawNode3 = topLevelNodes.get(topLevelScope);
                syntaxRawNode = syntaxRawNode3 != null ? syntaxRawNode3.findInRepository(scopeName, topLevelNodes) : null;
            } else {
                syntaxRawNode = topLevelNodes.get(topLevelScope);
            }
        }
        return syntaxRawNode;
    }
}

