/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.TextMateCapture;
import org.jetbrains.plugins.textmate.language.syntax.lexer.SyntaxMatchUtils;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerState;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateSyntaxMatcher;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextmateToken;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexUtilKt;
import org.jetbrains.plugins.textmate.regex.TextMateRange;
import org.jetbrains.plugins.textmate.regex.TextMateString;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 62\u00020\u0001:\u00016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0016\u001a\u00020\u0007J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0007J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJT\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010!\u001a\u00020\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J^\u0010'\u001a\u00020\t2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010!\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J(\u00101\u001a\u00020\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\b\u00102\u001a\u0004\u0018\u00010\u000e2\u0006\u00103\u001a\u00020\u0007H\u0002J\u001e\u00104\u001a\u00020\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u00103\u001a\u00020\u0007H\u0002J\u001e\u00105\u001a\u00020\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u00103\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateLexerCore;", "", "languageDescriptor", "Lorg/jetbrains/plugins/textmate/language/TextMateLanguageDescriptor;", "mySyntaxMatcher", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateSyntaxMatcher;", "myLineLimit", "", "myStripWhitespaces", "", "<init>", "(Lorg/jetbrains/plugins/textmate/language/TextMateLanguageDescriptor;Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateSyntaxMatcher;IZ)V", "myCurrentOffset", "myText", "", "myCurrentScope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "myNestedScope", "Lkotlin/collections/ArrayDeque;", "myStates", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateLexerState;", "getCurrentOffset", "init", "", "text", "startOffset", "advanceLine", "", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextmateToken;", "checkCancelledCallback", "Ljava/lang/Runnable;", "parseLine", "line", "output", "states", "lineStartOffset", "linePosition", "lineByteOffset", "parseCaptures", "captureKey", "Lorg/jetbrains/plugins/textmate/Constants$CaptureKey;", "rule", "Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptor;", "matchData", "Lorg/jetbrains/plugins/textmate/regex/MatchData;", "string", "Lorg/jetbrains/plugins/textmate/regex/TextMateString;", "startLineOffset", "openScopeSelector", "name", "position", "closeScopeSelector", "addToken", "Companion", "intellij.textmate.core"})
@SourceDebugExtension(value={"SMAP\nTextMateLexerCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateLexerCore.kt\norg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateLexerCore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,425:1\n1#2:426\n*E\n"})
public final class TextMateLexerCore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextMateLanguageDescriptor languageDescriptor;
    @NotNull
    private final TextMateSyntaxMatcher mySyntaxMatcher;
    private final int myLineLimit;
    private final boolean myStripWhitespaces;
    private int myCurrentOffset;
    @NotNull
    private CharSequence myText;
    @NotNull
    private TextMateScope myCurrentScope;
    @NotNull
    private ArrayDeque<Integer> myNestedScope;
    @NotNull
    private PersistentList<TextMateLexerState> myStates;
    private static final int MAX_LOOPS_COUNT = 10;

    public TextMateLexerCore(@NotNull TextMateLanguageDescriptor languageDescriptor, @NotNull TextMateSyntaxMatcher mySyntaxMatcher, int myLineLimit, boolean myStripWhitespaces) {
        Intrinsics.checkNotNullParameter((Object)languageDescriptor, (String)"languageDescriptor");
        Intrinsics.checkNotNullParameter((Object)mySyntaxMatcher, (String)"mySyntaxMatcher");
        this.languageDescriptor = languageDescriptor;
        this.mySyntaxMatcher = mySyntaxMatcher;
        this.myLineLimit = myLineLimit;
        this.myStripWhitespaces = myStripWhitespaces;
        this.myText = "";
        this.myCurrentScope = TextMateScope.EMPTY;
        this.myNestedScope = new ArrayDeque();
        this.myStates = ExtensionsKt.persistentListOf();
    }

    public final int getCurrentOffset() {
        return this.myCurrentOffset;
    }

    /*
     * WARNING - void declaration
     */
    public final void init(@NotNull CharSequence text, int startOffset) {
        void it;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.myText = text;
        this.myCurrentOffset = startOffset;
        TextMateLexerState[] textMateLexerStateArray = new TextMateLexerState[]{TextMateLexerState.Companion.notMatched(this.languageDescriptor.getRootSyntaxNode())};
        this.myStates = ExtensionsKt.persistentListOf((Object[])textMateLexerStateArray);
        this.myCurrentScope = new TextMateScope(this.languageDescriptor.getScopeName(), null);
        TextMateLexerState[] textMateLexerStateArray2 = textMateLexerStateArray = new ArrayDeque();
        TextMateLexerCore textMateLexerCore = this;
        boolean bl = false;
        it.addLast((Object)1);
        textMateLexerCore.myNestedScope = textMateLexerStateArray;
    }

    @NotNull
    public final List<TextmateToken> advanceLine(@Nullable Runnable checkCancelledCallback) {
        List list;
        int startLineOffset = this.myCurrentOffset;
        int it = StringsKt.indexOf$default((CharSequence)this.myText, (char)'\n', (int)startLineOffset, (boolean)false, (int)4, null);
        boolean bl = false;
        int endLineOffset = it == -1 ? this.myText.length() : it + 1;
        CharSequence lineCharSequence = this.myText.subSequence(startLineOffset, endLineOffset);
        if (this.myLineLimit >= 0 && lineCharSequence.length() > this.myLineLimit) {
            List output = new ArrayList();
            this.myStates = this.parseLine(lineCharSequence.subSequence(0, this.myLineLimit), output, this.myStates, startLineOffset, 0, 0, checkCancelledCallback);
            this.addToken(output, endLineOffset);
            list = output;
        } else {
            List output = new ArrayList();
            this.myStates = this.parseLine(lineCharSequence, output, this.myStates, startLineOffset, 0, 0, checkCancelledCallback);
            list = output;
        }
        return list;
    }

    private final PersistentList<TextMateLexerState> parseLine(CharSequence line, List<TextmateToken> output, PersistentList<TextMateLexerState> states, int lineStartOffset, int linePosition, int lineByteOffset, Runnable checkCancelledCallback) {
        PersistentList states2 = states;
        int linePosition2 = linePosition;
        int lineByteOffset2 = lineByteOffset;
        PersistentList lastSuccessState = states2;
        int lastSuccessStateOccursCount = 0;
        int lastMovedOffset = lineStartOffset;
        boolean matchBeginString = lineStartOffset == 0 && linePosition2 == 0;
        int anchorByteOffset = -1;
        TextMateString string = this.mySyntaxMatcher.createStringToMatch(line);
        PersistentList whileStates = states2;
        while (!whileStates.isEmpty()) {
            TextMateLexerState whileState = (TextMateLexerState)CollectionsKt.last((List)((List)whileStates));
            whileStates = whileStates.removeAt(whileStates.size() - 1);
            if (whileState.getSyntaxRule().getStringAttribute(Constants.StringKey.WHILE) == null) continue;
            MatchData matchWhile = this.mySyntaxMatcher.matchStringRegex(Constants.StringKey.WHILE, string, lineByteOffset2, anchorByteOffset == lineByteOffset2, matchBeginString, whileState, checkCancelledCallback);
            if (matchWhile.getMatched()) {
                if (anchorByteOffset != -1) continue;
                anchorByteOffset = MatchData.byteOffset$default(matchWhile, 0, 1, null).getEnd();
                continue;
            }
            this.closeScopeSelector(output, linePosition2 + lineStartOffset);
            this.closeScopeSelector(output, linePosition2 + lineStartOffset);
            states2 = whileStates;
            anchorByteOffset = -1;
        }
        Set localStates = new LinkedHashSet();
        while (true) {
            TextMateLexerState lastState = (TextMateLexerState)CollectionsKt.last((List)((List)states2));
            SyntaxNodeDescriptor lastRule = lastState.getSyntaxRule();
            TextMateLexerState currentState = this.mySyntaxMatcher.matchRule(lastRule, string, lineByteOffset2, anchorByteOffset == lineByteOffset2, matchBeginString, TextMateWeigh.Priority.NORMAL, this.myCurrentScope, checkCancelledCallback);
            SyntaxNodeDescriptor currentRule = currentState.getSyntaxRule();
            MatchData currentMatch = currentState.getMatchData();
            int endPosition = 0;
            MatchData endMatch = this.mySyntaxMatcher.matchStringRegex(Constants.StringKey.END, string, lineByteOffset2, anchorByteOffset == lineByteOffset2, matchBeginString, lastState, checkCancelledCallback);
            if (endMatch.getMatched() && (!currentMatch.getMatched() || MatchData.byteOffset$default(currentMatch, 0, 1, null).getStart() >= MatchData.byteOffset$default(endMatch, 0, 1, null).getStart() || Intrinsics.areEqual((Object)lastState, (Object)currentState))) {
                TextMateLexerState poppedState = (TextMateLexerState)CollectionsKt.last((List)((List)states2));
                if (poppedState.getMatchData().getMatched() && !poppedState.getMatchedEOL()) {
                    anchorByteOffset = MatchData.byteOffset$default(poppedState.getMatchData(), 0, 1, null).getEnd();
                }
                states2 = states2.removeAt(states2.size() - 1);
                TextMateRange endRange = MatchData.charRange$default(endMatch, string, 0, 2, null);
                int startPosition = endPosition = endRange.getStart();
                this.closeScopeSelector(output, startPosition + lineStartOffset);
                if (lastRule.getCaptureRules(Constants.CaptureKey.END_CAPTURES) == null && lastRule.getCaptureRules(Constants.CaptureKey.CAPTURES) == null || this.parseCaptures(output, Constants.CaptureKey.END_CAPTURES, lastRule, endMatch, string, line, lineStartOffset, (PersistentList<TextMateLexerState>)states2, checkCancelledCallback) || this.parseCaptures(output, Constants.CaptureKey.CAPTURES, lastRule, endMatch, string, line, lineStartOffset, (PersistentList<TextMateLexerState>)states2, checkCancelledCallback)) {
                    endPosition = endRange.getEnd();
                }
                this.closeScopeSelector(output, endPosition + lineStartOffset);
                if (linePosition2 == endPosition && TextMateLexerCore.Companion.containsLexerState(localStates, poppedState) && poppedState.getEnterByteOffset() == lineByteOffset2) {
                    this.addToken(output, line.length() + lineStartOffset);
                    break;
                }
                v0 = localStates.remove(poppedState);
            } else if (currentMatch.getMatched()) {
                anchorByteOffset = MatchData.byteOffset$default(currentMatch, 0, 1, null).getEnd();
                TextMateRange currentRange = MatchData.charRange$default(currentMatch, string, 0, 2, null);
                int startPosition = currentRange.getStart();
                endPosition = currentRange.getEnd();
                if (currentRule.getStringAttribute(Constants.StringKey.BEGIN) != null) {
                    states2 = states2.add((Object)currentState);
                    CharSequence name = TextMateLexerCore.Companion.getStringAttribute(Constants.StringKey.NAME, currentRule, string, currentMatch);
                    this.openScopeSelector(output, name, startPosition + lineStartOffset);
                    this.parseCaptures(output, Constants.CaptureKey.BEGIN_CAPTURES, currentRule, currentMatch, string, line, lineStartOffset, (PersistentList<TextMateLexerState>)states2, checkCancelledCallback);
                    this.parseCaptures(output, Constants.CaptureKey.CAPTURES, currentRule, currentMatch, string, line, lineStartOffset, (PersistentList<TextMateLexerState>)states2, checkCancelledCallback);
                    CharSequence contentName = TextMateLexerCore.Companion.getStringAttribute(Constants.StringKey.CONTENT_NAME, currentRule, string, currentMatch);
                    this.openScopeSelector(output, contentName, endPosition + lineStartOffset);
                } else if (currentRule.getStringAttribute(Constants.StringKey.MATCH) != null) {
                    CharSequence name = TextMateLexerCore.Companion.getStringAttribute(Constants.StringKey.NAME, currentRule, string, currentMatch);
                    this.openScopeSelector(output, name, startPosition + lineStartOffset);
                    this.parseCaptures(output, Constants.CaptureKey.CAPTURES, currentRule, currentMatch, string, line, lineStartOffset, (PersistentList<TextMateLexerState>)states2, checkCancelledCallback);
                    this.closeScopeSelector(output, endPosition + lineStartOffset);
                }
                if (linePosition2 == endPosition && TextMateLexerCore.Companion.containsLexerState(localStates, currentState)) {
                    this.addToken(output, line.length() + lineStartOffset);
                    break;
                }
                v0 = localStates.add(currentState);
            } else {
                this.addToken(output, line.length() + lineStartOffset);
                break;
            }
            if (lastMovedOffset < this.myCurrentOffset) {
                lastSuccessState = states2;
                lastSuccessStateOccursCount = 0;
                lastMovedOffset = this.myCurrentOffset;
            } else if (Intrinsics.areEqual((Object)lastSuccessState, (Object)states2)) {
                if (lastSuccessStateOccursCount > 10) {
                    this.addToken(output, line.length() + lineStartOffset);
                    break;
                }
                ++lastSuccessStateOccursCount;
            }
            if (linePosition2 != endPosition) {
                lineByteOffset2 += RegexUtilKt.byteOffsetByCharOffset(line, linePosition2, endPosition);
                linePosition2 = endPosition;
            }
            Runnable runnable = checkCancelledCallback;
            if (runnable == null) continue;
            runnable.run();
        }
        return states2;
    }

    private final boolean parseCaptures(List<TextmateToken> output, Constants.CaptureKey captureKey, SyntaxNodeDescriptor rule, MatchData matchData, TextMateString string, CharSequence line, int startLineOffset, PersistentList<TextMateLexerState> states, Runnable checkCancelledCallback) {
        TextMateCapture[] captures = rule.getCaptureRules(captureKey);
        if (captures == null) {
            return false;
        }
        ArrayDeque activeCaptureRanges = new ArrayDeque();
        int n = matchData.count();
        for (int group = 0; group < n; ++group) {
            TextMateRange byteRange;
            TextMateCapture capture;
            TextMateCapture textMateCapture = capture = group < captures.length ? captures[group] : null;
            if (capture == null || (byteRange = matchData.byteOffset(group)).isEmpty()) continue;
            TextMateRange captureRange = matchData.charRange(string, group);
            while (!activeCaptureRanges.isEmpty() && ((TextMateRange)activeCaptureRanges.last()).getEnd() <= captureRange.getStart()) {
                this.closeScopeSelector(output, startLineOffset + ((TextMateRange)activeCaptureRanges.removeLast()).getEnd());
            }
            if (capture instanceof TextMateCapture.Name) {
                int selectorStartOffset;
                CharSequence captureName = ((TextMateCapture.Name)capture).getName();
                CharSequence scopeName = rule.hasBackReference(captureKey, group) ? SyntaxMatchUtils.INSTANCE.replaceGroupsWithMatchDataInCaptures(captureName, string, matchData) : captureName;
                int indexOfSpace = StringsKt.indexOf((CharSequence)scopeName, (char)' ', (int)(selectorStartOffset = 0), (boolean)false);
                if (indexOfSpace == -1) {
                    this.openScopeSelector(output, scopeName, startLineOffset + captureRange.getStart());
                    activeCaptureRanges.addLast((Object)captureRange);
                    continue;
                }
                while (indexOfSpace >= 0) {
                    this.openScopeSelector(output, scopeName.subSequence(selectorStartOffset, indexOfSpace), startLineOffset + captureRange.getStart());
                    selectorStartOffset = indexOfSpace + 1;
                    indexOfSpace = StringsKt.indexOf((CharSequence)scopeName, (char)' ', (int)selectorStartOffset, (boolean)false);
                    activeCaptureRanges.addLast((Object)captureRange);
                }
                this.openScopeSelector(output, scopeName.subSequence(selectorStartOffset, scopeName.length()), startLineOffset + captureRange.getStart());
                activeCaptureRanges.addLast((Object)captureRange);
                continue;
            }
            if (capture instanceof TextMateCapture.Rule) {
                CharSequence capturedString = line.subSequence(0, captureRange.getEnd());
                TextMateString capturedTextMateString = this.mySyntaxMatcher.createStringToMatch(capturedString);
                TextMateLexerState captureState = new TextMateLexerState(((TextMateCapture.Rule)capture).getNode(), matchData, TextMateWeigh.Priority.NORMAL, byteRange.getStart(), capturedTextMateString);
                this.parseLine(capturedString, output, (PersistentList<TextMateLexerState>)states.add((Object)captureState), startLineOffset, captureRange.getStart(), byteRange.getStart(), checkCancelledCallback);
                continue;
            }
            throw new IllegalStateException(("unknown capture type: " + capture).toString());
        }
        while (!activeCaptureRanges.isEmpty()) {
            this.closeScopeSelector(output, startLineOffset + ((TextMateRange)activeCaptureRanges.removeLast()).getEnd());
        }
        return true;
    }

    private final void openScopeSelector(List<TextmateToken> output, CharSequence name, int position) {
        this.addToken(output, position);
        int count = 0;
        int prevIndexOfSpace = 0;
        if (name != null) {
            int indexOfSpace = StringsKt.indexOf((CharSequence)name, (char)' ', (int)0, (boolean)false);
            while (indexOfSpace >= 0) {
                this.myCurrentScope = this.myCurrentScope.add(name.subSequence(prevIndexOfSpace, indexOfSpace));
                prevIndexOfSpace = indexOfSpace + 1;
                indexOfSpace = StringsKt.indexOf((CharSequence)name, (char)' ', (int)prevIndexOfSpace, (boolean)false);
                ++count;
            }
        }
        CharSequence charSequence = name;
        this.myCurrentScope = this.myCurrentScope.add(charSequence != null ? charSequence.subSequence(prevIndexOfSpace, name.length()) : null);
        this.myNestedScope.addLast((Object)(count + 1));
    }

    private final void closeScopeSelector(List<TextmateToken> output, int position) {
        block3: {
            CharSequence lastOpenedName = this.myCurrentScope.getScopeName();
            if (lastOpenedName != null && !(lastOpenedName.length() == 0)) {
                this.addToken(output, position);
            }
            Integer n = (Integer)this.myNestedScope.removeLastOrNull();
            if (n == null) break block3;
            int nestingLevel = ((Number)n).intValue();
            boolean bl = false;
            for (int i = 0; i < nestingLevel; ++i) {
                int it = i;
                boolean bl2 = false;
                TextMateScope textMateScope = this.myCurrentScope.getParent();
                if (textMateScope == null) {
                    textMateScope = this.myCurrentScope;
                }
                this.myCurrentScope = textMateScope;
            }
        }
    }

    private final void addToken(List<TextmateToken> output, int position) {
        int position2 = Math.min(position, this.myText.length());
        if (position2 > this.myCurrentOffset) {
            int wsEnd;
            boolean restartable = this.myCurrentScope.getParent() == null;
            int wsStart = this.myCurrentOffset;
            while (this.myStripWhitespaces && position2 > this.myCurrentOffset && CharsKt.isWhitespace((char)this.myText.charAt(this.myCurrentOffset))) {
                int n = this.myCurrentOffset;
                this.myCurrentOffset = n + 1;
            }
            if (wsStart < this.myCurrentOffset) {
                output.add(new TextmateToken(TextMateScope.WHITESPACE, wsStart, this.myCurrentOffset, restartable));
                restartable = false;
            }
            for (wsEnd = position2; this.myStripWhitespaces && wsEnd > this.myCurrentOffset && CharsKt.isWhitespace((char)this.myText.charAt(wsEnd - 1)); --wsEnd) {
            }
            if (this.myCurrentOffset < wsEnd) {
                output.add(new TextmateToken(this.myCurrentScope, this.myCurrentOffset, wsEnd, restartable));
            }
            if (wsEnd < position2) {
                output.add(new TextmateToken(TextMateScope.WHITESPACE, wsEnd, position2, restartable));
            }
            this.myCurrentOffset = position2;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0002J*\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateLexerCore$Companion;", "", "<init>", "()V", "MAX_LOOPS_COUNT", "", "containsLexerState", "", "states", "", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateLexerState;", "state", "getStringAttribute", "", "keyName", "Lorg/jetbrains/plugins/textmate/Constants$StringKey;", "syntaxRule", "Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptor;", "string", "Lorg/jetbrains/plugins/textmate/regex/TextMateString;", "matchData", "Lorg/jetbrains/plugins/textmate/regex/MatchData;", "intellij.textmate.core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean containsLexerState(Set<TextMateLexerState> states, TextMateLexerState state) {
            for (TextMateLexerState s : states) {
                if (s.getEnterByteOffset() != state.getEnterByteOffset() || !Intrinsics.areEqual((Object)s.getSyntaxRule(), (Object)state.getSyntaxRule())) continue;
                return true;
            }
            return false;
        }

        private final CharSequence getStringAttribute(Constants.StringKey keyName, SyntaxNodeDescriptor syntaxRule, TextMateString string, MatchData matchData) {
            CharSequence stringAttribute = syntaxRule.getStringAttribute(keyName);
            return stringAttribute == null ? null : (syntaxRule.hasBackReference(keyName) ? SyntaxMatchUtils.INSTANCE.replaceGroupsWithMatchDataInCaptures(stringAttribute, string, matchData) : stringAttribute);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

