/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.MsBaseJdbcHelper;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MsJdbcHelper
extends MsBaseJdbcHelper {
    public MsJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("MSSQL", version, connection);
    }

    public MsJdbcHelper(@NotNull String dbmsName, @Nullable String version, @Nullable Connection connection) {
        if (dbmsName == null) {
            MsJdbcHelper.$$$reportNull$$$0(0);
        }
        super(dbmsName, version, connection);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection) {
        return new MsJdbcHelper(version, connection);
    }

    public MsJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return MsJdbcHelper.extractVersion(version);
    }

    @NotNull
    static MsJdbcHelper create(@NotNull String dbmsName, @Nullable Connection delegate, @Nullable String productVer) {
        if (dbmsName == null) {
            MsJdbcHelper.$$$reportNull$$$0(1);
        }
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new MsJdbcHelper(dbmsName, MsJdbcHelper.extractVersion(productVer), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dbmsName";
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MsJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

