/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.util;

import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.execution.rmi.ssl.SslEntityReader;
import com.intellij.util.ArrayUtilRt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.X509TrustedCertificateBlock;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.jetbrains.annotations.NotNull;

public class BCSslEntityReader
extends SslEntityReader {
    private static final BouncyCastleProvider provider = new BouncyCastleProvider();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<? extends SslEntityReader.Entity> read(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            BCSslEntityReader.$$$reportNull$$$0(0);
        }
        PushbackInputStream pStream = new PushbackInputStream(stream);
        int peeked = pStream.read();
        pStream.unread(peeked);
        if (peeked == 48) {
            List<? extends SslEntityReader.Entity> list = BCSslEntityReader.readDer(pStream);
            List<? extends SslEntityReader.Entity> list2 = list;
            if (list2 == null) {
                BCSslEntityReader.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<? extends SslEntityReader.Entity> list = BCSslEntityReader.readPem(pStream);
        List<? extends SslEntityReader.Entity> list3 = list;
        if (list3 == null) {
            BCSslEntityReader.$$$reportNull$$$0(2);
        }
        return list3;
        finally {
            pStream.close();
        }
    }

    @NotNull
    private static List<? extends SslEntityReader.Entity> readPem(@NotNull InputStream stream) throws IOException {
        Object obj;
        if (stream == null) {
            BCSslEntityReader.$$$reportNull$$$0(3);
        }
        PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
        ArrayList<Object> res = new ArrayList<Object>();
        while ((obj = pemParser.readObject()) != null) {
            if (obj instanceof X509CertificateHolder) {
                res.add(new BCCertificateEntry((X509CertificateHolder)obj));
                continue;
            }
            if (obj instanceof X509TrustedCertificateBlock) {
                res.add(new BCCertificateEntry(((X509TrustedCertificateBlock)obj).getCertificateHolder()));
                continue;
            }
            if (obj instanceof PrivateKeyInfo) {
                res.add(new BCUnencryptedPrivateKeyEntity((PrivateKeyInfo)obj));
                continue;
            }
            if (obj instanceof PEMKeyPair) {
                res.add(new BCUnencryptedPrivateKeyEntity(((PEMKeyPair)obj).getPrivateKeyInfo()));
                continue;
            }
            if (obj instanceof PKCS8EncryptedPrivateKeyInfo) {
                res.add(new BCEncryptedPrivateKeyEntity((PKCS8EncryptedPrivateKeyInfo)obj));
                continue;
            }
            if (obj instanceof PEMEncryptedKeyPair) {
                res.add(new BCEncryptedPairPrivateKeyEntity((PEMEncryptedKeyPair)obj));
                continue;
            }
            JdbcNativeUtil.logWarn("Unknown entity: " + obj, null);
        }
        ArrayList<Object> arrayList = res;
        ArrayList<Object> arrayList2 = arrayList;
        if (arrayList2 == null) {
            BCSslEntityReader.$$$reportNull$$$0(4);
        }
        return arrayList2;
        finally {
            pemParser.close();
        }
    }

    @NotNull
    private static List<? extends SslEntityReader.Entity> readDer(@NotNull InputStream stream) throws IOException {
        block8: {
            SslEntityReader.Entity entity;
            if (stream == null) {
                BCSslEntityReader.$$$reportNull$$$0(5);
            }
            ASN1InputStream asnStream = new ASN1InputStream(stream);
            ASN1Primitive obj = asnStream.readObject();
            SslEntityReader.Entity entity2 = entity = obj == null ? null : BCSslEntityReader.parseDerEntity(obj);
            if (entity == null) break block8;
            List<SslEntityReader.Entity> list = Collections.singletonList(entity);
            List<SslEntityReader.Entity> list2 = list;
            if (list2 == null) {
                BCSslEntityReader.$$$reportNull$$$0(6);
            }
            return list2;
            finally {
                asnStream.close();
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            BCSslEntityReader.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static SslEntityReader.Entity parseDerEntity(ASN1Primitive obj) {
        try {
            Certificate certificate = Certificate.getInstance((Object)obj);
            BCCertificateEntry cert = new BCCertificateEntry(new X509CertificateHolder(certificate));
            cert.get();
            return cert;
        }
        catch (Throwable certificate) {
            try {
                BCUnencryptedPrivateKeyEntity pk = new BCUnencryptedPrivateKeyEntity(PrivateKeyInfo.getInstance((Object)obj));
                pk.get();
                return pk;
            }
            catch (Throwable throwable) {
                try {
                    return new BCEncryptedPrivateKeyEntity(new PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo.getInstance((Object)obj)));
                }
                catch (Throwable throwable2) {
                    return null;
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/util/BCSslEntityReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/util/BCSslEntityReader";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readPem";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readDer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readPem";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readDer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BCCertificateEntry
    implements SslEntityReader.CertificateEntity {
        private final X509CertificateHolder myCertificate;

        private BCCertificateEntry(@NotNull X509CertificateHolder certificate) {
            if (certificate == null) {
                BCCertificateEntry.$$$reportNull$$$0(0);
            }
            this.myCertificate = certificate;
        }

        public X509Certificate get() throws IOException {
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(this.myCertificate.getEncoded()));
            }
            catch (CertificateException e) {
                throw new IOException("Failed to read certificate", e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certificate", "com/intellij/database/remote/util/BCSslEntityReader$BCCertificateEntry", "<init>"));
        }
    }

    private static class BCUnencryptedPrivateKeyEntity
    implements SslEntityReader.UnencryptedPrivateKeyEntity {
        private final PrivateKeyInfo myPrivateKey;

        private BCUnencryptedPrivateKeyEntity(@NotNull PrivateKeyInfo privateKey) {
            if (privateKey == null) {
                BCUnencryptedPrivateKeyEntity.$$$reportNull$$$0(0);
            }
            this.myPrivateKey = privateKey;
        }

        public PrivateKey get() throws IOException {
            return BCUnencryptedPrivateKeyEntity.convert(this.myPrivateKey);
        }

        private static PrivateKey convert(@NotNull PrivateKeyInfo key) throws IOException {
            if (key == null) {
                BCUnencryptedPrivateKeyEntity.$$$reportNull$$$0(1);
            }
            return new JcaPEMKeyConverter().getPrivateKey(key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "privateKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/util/BCSslEntityReader$BCUnencryptedPrivateKeyEntity";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "convert";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BCEncryptedPrivateKeyEntity
    implements SslEntityReader.EncryptedPrivateKeyEntity {
        private final PKCS8EncryptedPrivateKeyInfo myPrivateKey;

        private BCEncryptedPrivateKeyEntity(@NotNull PKCS8EncryptedPrivateKeyInfo privateKey) {
            if (privateKey == null) {
                BCEncryptedPrivateKeyEntity.$$$reportNull$$$0(0);
            }
            this.myPrivateKey = privateKey;
        }

        public PrivateKey get(char[] password) throws IOException {
            try {
                InputDecryptorProvider decryptProvider = BCEncryptedPrivateKeyEntity.getDecryptProvider(password == null ? ArrayUtilRt.EMPTY_CHAR_ARRAY : password);
                PrivateKeyInfo decrypted = this.myPrivateKey.decryptPrivateKeyInfo(decryptProvider);
                return BCUnencryptedPrivateKeyEntity.convert(decrypted);
            }
            catch (PKCSException e) {
                throw new IOException("Failed to decrypt private key", e);
            }
        }

        private static InputDecryptorProvider getDecryptProvider(char[] password) throws IOException {
            try {
                return new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider((Provider)provider).build(password);
            }
            catch (OperatorCreationException e) {
                throw new IOException("Failed to create decrypt provider", e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "privateKey", "com/intellij/database/remote/util/BCSslEntityReader$BCEncryptedPrivateKeyEntity", "<init>"));
        }
    }

    private static class BCEncryptedPairPrivateKeyEntity
    implements SslEntityReader.EncryptedPrivateKeyEntity {
        private final PEMEncryptedKeyPair myPair;

        private BCEncryptedPairPrivateKeyEntity(PEMEncryptedKeyPair pair) {
            this.myPair = pair;
        }

        public PrivateKey get(char[] password) throws IOException {
            PEMDecryptorProvider decryptProvider = BCEncryptedPairPrivateKeyEntity.getDecryptProvider(password == null ? ArrayUtilRt.EMPTY_CHAR_ARRAY : password);
            PEMKeyPair decrypted = this.myPair.decryptKeyPair(decryptProvider);
            return BCUnencryptedPrivateKeyEntity.convert(decrypted.getPrivateKeyInfo());
        }

        private static PEMDecryptorProvider getDecryptProvider(char[] password) {
            return new JcePEMDecryptorProviderBuilder().setProvider((Provider)provider).build(password);
        }
    }
}

