/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.java;

import com.fasterxml.jackson.core.type.TypeReference;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.openapi.module.impl.scopes.LibraryScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.packageChecker.java.JavaPackageUtilKt;
import com.intellij.packageChecker.model.CommonPathHolder;
import com.intellij.packageChecker.model.LibraryDependency;
import com.intellij.packageChecker.model.PreProcessedVulnerablePath;
import com.intellij.packageChecker.util.SerializationUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.PsiShortNamesCacheImpl;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.PackageType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/packageChecker/java/JavaLibraryDependency;", "Lcom/intellij/packageChecker/model/LibraryDependency;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "<init>", "(Lcom/intellij/openapi/roots/libraries/Library;)V", "getLibrary", "()Lcom/intellij/openapi/roots/libraries/Library;", "getVulnerableElementQualifiedNames", "", "", "project", "Lcom/intellij/openapi/project/Project;", "path", "Lcom/intellij/packageChecker/model/PreProcessedVulnerablePath;", "createPackage", "Lorg/jetbrains/security/package/Package;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.packageChecker.java"})
@SourceDebugExtension(value={"SMAP\nJavaLibraryDependency.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaLibraryDependency.kt\ncom/intellij/packageChecker/java/JavaLibraryDependency\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n19#2:61\n11158#3:62\n11493#3,3:63\n13402#3,2:68\n295#4,2:66\n*S KotlinDebug\n*F\n+ 1 JavaLibraryDependency.kt\ncom/intellij/packageChecker/java/JavaLibraryDependency\n*L\n20#1:61\n35#1:62\n35#1:63,3\n44#1:68,2\n39#1:66,2\n*E\n"})
public final class JavaLibraryDependency
implements LibraryDependency {
    @NotNull
    private final Library library;

    public JavaLibraryDependency(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.library = library;
    }

    @NotNull
    public final Library getLibrary() {
        return this.library;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getVulnerableElementQualifiedNames(@NotNull Project project, @NotNull PreProcessedVulnerablePath path) {
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                if (project.isDisposed()) break block11;
                Library $this$asSafely$iv = this.library;
                boolean $i$f$asSafely = false;
                Library library = $this$asSafely$iv;
                if (!(library instanceof LibraryEx)) {
                    library = null;
                }
                LibraryEx libraryEx = (LibraryEx)library;
                boolean bl = libraryEx != null ? libraryEx.isDisposed() : false;
                if (!bl) break block12;
            }
            return SetsKt.emptySet();
        }
        if (path.getPackageManager() != PackageType.maven || StringsKt.isBlank((CharSequence)path.getPathsHolders())) {
            return SetsKt.emptySet();
        }
        List vulnerablePaths2 = (List)SerializationUtils.INSTANCE.getOm().readValue(path.getPathsHolders(), (TypeReference)new TypeReference<List<? extends CommonPathHolder>>(){});
        Set qualifiedNames = new LinkedHashSet();
        for (CommonPathHolder pathHolder : vulnerablePaths2) {
            Pair classPair;
            Object v3;
            block10: {
                void $this$mapTo$iv$iv;
                PsiClass[] matchedClassNames;
                String className = StringsKt.substringAfterLast$default((String)pathHolder.getParent(), (char)'.', null, (int)2, null);
                Intrinsics.checkNotNullExpressionValue((Object)PsiShortNamesCacheImpl.getInstance((Project)project).getClassesByName(className, (GlobalSearchScope)new LibraryScope(project, this.library)), (String)"getClassesByName(...)");
                PsiClass[] $this$map$iv = matchedClassNames;
                boolean $i$f$map = false;
                PsiClass[] psiClassArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void psiClass;
                    void item$iv$iv;
                    void var18_29 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to((Object)QualifiedNameProviderUtil.getQualifiedName((PsiElement)((PsiElement)psiClass)), (Object)psiClass));
                }
                List matchedQualifiedNames = (List)destination$iv$iv;
                Iterable $this$firstOrNull$iv = matchedQualifiedNames;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)pathHolder.getParent())) continue;
                    v3 = element$iv;
                    break block10;
                }
                v3 = null;
            }
            if ((Pair)v3 == null) continue;
            Object object = classPair.getSecond();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-second>(...)");
            PsiClass clazz = (PsiClass)object;
            for (String vulnerableMethod : pathHolder.getVulnerableMethods()) {
                PsiMethod[] methods;
                Intrinsics.checkNotNullExpressionValue((Object)clazz.findMethodsByName(vulnerableMethod, false), (String)"findMethodsByName(...)");
                PsiMethod[] $this$forEach$iv = methods;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    PsiMethod element$iv;
                    PsiMethod method = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    String methodName = QualifiedNameProviderUtil.getQualifiedName((PsiElement)((PsiElement)method));
                    if (methodName == null) continue;
                    qualifiedNames.add(methodName);
                }
            }
        }
        return qualifiedNames;
    }

    @Override
    @Nullable
    public Package createPackage() {
        Library library = this.library;
        LibraryEx libraryEx = library instanceof LibraryEx ? (LibraryEx)library : null;
        boolean bl = libraryEx != null ? libraryEx.isDisposed() : false;
        if (bl) {
            return null;
        }
        return JavaPackageUtilKt.createPackage(this.library);
    }

    @NotNull
    public final Library component1() {
        return this.library;
    }

    @NotNull
    public final JavaLibraryDependency copy(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return new JavaLibraryDependency(library);
    }

    public static /* synthetic */ JavaLibraryDependency copy$default(JavaLibraryDependency javaLibraryDependency, Library library, int n, Object object) {
        if ((n & 1) != 0) {
            library = javaLibraryDependency.library;
        }
        return javaLibraryDependency.copy(library);
    }

    @NotNull
    public String toString() {
        return "JavaLibraryDependency(library=" + this.library + ")";
    }

    public int hashCode() {
        return this.library.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaLibraryDependency)) {
            return false;
        }
        JavaLibraryDependency javaLibraryDependency = (JavaLibraryDependency)other;
        return Intrinsics.areEqual((Object)this.library, (Object)javaLibraryDependency.library);
    }
}

