/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.packageChecker.model.GeneralRepositoryServer;
import com.intellij.packageChecker.model.GeneralRepositoryServerKt;
import com.intellij.packageChecker.model.HttpClientApi;
import com.intellij.packageChecker.model.HttpClientHeadersService;
import com.intellij.packageChecker.model.ResourceUrl;
import com.intellij.packageChecker.util.GzipUtils;
import com.intellij.packageChecker.util.SerializationUtils;
import com.intellij.util.LineSeparator;
import java.io.IOException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.ClientData;
import org.jetbrains.security.dto.HashesDto;
import org.jetbrains.security.dto.RequestDto;
import org.jetbrains.security.exceptions.AnalysisException;
import org.jetbrains.security.exceptions.AnalysisExceptionScope;
import org.jetbrains.security.package.Package;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJj\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010 \"\u0004\b\u0001\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0\u001f0&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u0002H 0(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u0002H 0(H\u0084@\u00a2\u0006\u0002\u0010*J\u0016\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020$0\u001fH\u0002J>\u0010.\u001a\b\u0012\u0004\u0012\u0002H!0\u001f\"\u0004\b\u0000\u0010!2\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020,2\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0\u001f0&H\u0082@\u00a2\u0006\u0002\u00101R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001b\u001a\u00020\u00168DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001a\u001a\u0004\b\u001c\u0010\u0018\u00a8\u00062"}, d2={"Lcom/intellij/packageChecker/model/GeneralRepositoryServer;", "", "clientData", "Lorg/jetbrains/security/ClientData;", "packagesUrlString", "", "dbBaseUrl", "Lcom/intellij/packageChecker/model/ResourceUrl;", "attemptsToCheck", "", "requestTimeout", "Ljava/time/Duration;", "<init>", "(Lorg/jetbrains/security/ClientData;Ljava/lang/String;Lcom/intellij/packageChecker/model/ResourceUrl;ILjava/time/Duration;)V", "chunkSize", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "httpClient", "Lcom/intellij/packageChecker/model/HttpClientApi;", "getHttpClient", "()Lcom/intellij/packageChecker/model/HttpClientApi;", "httpClient$delegate", "Lkotlin/Lazy;", "gzipHttpClient", "getGzipHttpClient", "gzipHttpClient$delegate", "getStatusForPackages", "", "T", "DTO", "pkgs", "", "Lorg/jetbrains/security/package/Package;", "bodyHandler", "Ljava/net/http/HttpResponse$BodyHandler;", "transform", "Lkotlin/Function1;", "allAttemptsFailed", "(Ljava/lang/Iterable;Ljava/net/http/HttpResponse$BodyHandler;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createRequestDto", "Lorg/jetbrains/security/dto/RequestDto;", "packageChunk", "getPackagesFromServer", "url", "requestData", "(Ljava/lang/String;Lorg/jetbrains/security/dto/RequestDto;Ljava/net/http/HttpResponse$BodyHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nGeneralRepositoryServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneralRepositoryServer.kt\ncom/intellij/packageChecker/model/GeneralRepositoryServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,110:1\n1368#2:111\n1454#2,2:112\n1557#2:115\n1628#2,3:116\n1557#2:119\n1628#2,3:120\n1456#2,3:123\n1557#2:126\n1628#2,3:127\n326#3:114\n*S KotlinDebug\n*F\n+ 1 GeneralRepositoryServer.kt\ncom/intellij/packageChecker/model/GeneralRepositoryServer\n*L\n55#1:111\n55#1:112,2\n64#1:115\n64#1:116,3\n87#1:119\n87#1:120,3\n55#1:123,3\n92#1:126\n92#1:127,3\n56#1:114\n*E\n"})
public class GeneralRepositoryServer {
    @NotNull
    private final ClientData clientData;
    @NotNull
    private final String packagesUrlString;
    @NotNull
    private final ResourceUrl dbBaseUrl;
    private final int attemptsToCheck;
    @NotNull
    private final Duration requestTimeout;
    private final int chunkSize;
    private final ObjectMapper objectMapper;
    @NotNull
    private final Lazy httpClient$delegate;
    @NotNull
    private final Lazy gzipHttpClient$delegate;

    public GeneralRepositoryServer(@NotNull ClientData clientData, @NotNull String packagesUrlString, @NotNull ResourceUrl dbBaseUrl, int attemptsToCheck, @NotNull Duration requestTimeout) {
        Intrinsics.checkNotNullParameter((Object)clientData, (String)"clientData");
        Intrinsics.checkNotNullParameter((Object)packagesUrlString, (String)"packagesUrlString");
        Intrinsics.checkNotNullParameter((Object)dbBaseUrl, (String)"dbBaseUrl");
        Intrinsics.checkNotNullParameter((Object)requestTimeout, (String)"requestTimeout");
        this.clientData = clientData;
        this.packagesUrlString = packagesUrlString;
        this.dbBaseUrl = dbBaseUrl;
        this.attemptsToCheck = attemptsToCheck;
        this.requestTimeout = requestTimeout;
        this.chunkSize = 4096;
        this.objectMapper = SerializationUtils.INSTANCE.getOm();
        this.httpClient$delegate = LazyKt.lazy(() -> GeneralRepositoryServer.httpClient_delegate$lambda$0(this));
        this.gzipHttpClient$delegate = LazyKt.lazy(() -> GeneralRepositoryServer.gzipHttpClient_delegate$lambda$1(this));
    }

    public /* synthetic */ GeneralRepositoryServer(ClientData clientData, String string, ResourceUrl resourceUrl, int n, Duration duration, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 3;
        }
        if ((n2 & 0x10) != 0) {
            duration = Duration.ofMinutes(5L);
        }
        this(clientData, string, resourceUrl, n, duration);
    }

    protected final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    protected final HttpClientApi getHttpClient() {
        Lazy lazy = this.httpClient$delegate;
        return (HttpClientApi)lazy.getValue();
    }

    @NotNull
    protected final HttpClientApi getGzipHttpClient() {
        Lazy lazy = this.gzipHttpClient$delegate;
        return (HttpClientApi)lazy.getValue();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected final <T, DTO> Object getStatusForPackages(@NotNull Iterable<Package> var1_1, @NotNull HttpResponse.BodyHandler<List<DTO>> var2_2, @NotNull Function1<? super DTO, ? extends T> var3_3, @NotNull Function1<? super Package, ? extends T> var4_4, @NotNull Continuation<? super List<? extends T>> $completion) {
        block23: {
            block22: {
                if (!($completion instanceof getStatusForPackages.1)) ** GOTO lbl-1000
                var29_6 = $completion;
                if ((var29_6.label & -2147483648) != 0) {
                    var29_6.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        Object L$5;
                        Object L$6;
                        Object L$7;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ GeneralRepositoryServer this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.getStatusForPackages(null, null, null, null, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var30_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block2 : switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!(this.attemptsToCheck > 0)) {
                            var7_9 = "Failed requirement.";
                            throw new IllegalArgumentException(var7_9.toString());
                        }
                        $this$flatMap$iv = CollectionsKt.chunked((Iterable)pkgs, (int)this.chunkSize);
                        $i$f$flatMap = false;
                        var8_12 = $this$flatMap$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$flatMapTo = false;
                        var11_15 = $this$flatMapTo$iv$iv.iterator();
lbl21:
                        // 2 sources

                        while (var11_15.hasNext()) {
                            element$iv$iv = var11_15.next();
                            pkgChunk = (List)element$iv$iv;
                            $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2 = false;
                            $i$f$currentCoroutineContext = false;
                            JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                            attempt = 0;
                            exception = null;
lbl30:
                            // 3 sources

                            while (attempt < this.attemptsToCheck) {
                                ++attempt;
                                if (pkgChunk.isEmpty()) {
                                    v0 = CollectionsKt.emptyList();
                                    break block22;
                                }
                                $continuation.L$0 = this;
                                $continuation.L$1 = bodyHandler;
                                $continuation.L$2 = transform;
                                $continuation.L$3 = allAttemptsFailed;
                                $continuation.L$4 = destination$iv$iv;
                                $continuation.L$5 = var11_15;
                                $continuation.L$6 = pkgChunk;
                                $continuation.L$7 = exception;
                                $continuation.I$0 = attempt;
                                $continuation.label = 1;
                                v1 = this.getPackagesFromServer(this.dbBaseUrl.url + this.packagesUrlString, this.createRequestDto(pkgChunk), bodyHandler, (Continuation<? super List<? extends DTO>>)$continuation);
                                ** if (v1 != var30_8) goto lbl50
lbl49:
                                // 1 sources

                                return var30_8;
lbl50:
                                // 1 sources

                                ** GOTO lbl70
                            }
                            break block2;
                        }
                        break block23;
                    }
                    case 1: {
                        $i$f$flatMap = false;
                        $i$f$flatMapTo = false;
                        $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2 = false;
                        attempt = $continuation.I$0;
                        exception = (AnalysisException)$continuation.L$7;
                        pkgChunk = (List)$continuation.L$6;
                        var11_15 = (Iterator<T>)$continuation.L$5;
                        destination$iv$iv = (Collection)$continuation.L$4;
                        allAttemptsFailed = (Function1)$continuation.L$3;
                        transform = (Function1)$continuation.L$2;
                        bodyHandler = (HttpResponse.BodyHandler)$continuation.L$1;
                        this = (GeneralRepositoryServer)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl70:
                            // 2 sources

                            $this$map$iv = (Iterable)v1;
                            $i$f$map = false;
                            var19_27 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            var22_30 = $this$mapTo$iv$iv.iterator();
                            while (var22_30.hasNext()) {
                                item$iv$iv = var22_30.next();
                                destination$iv$iv.add(transform.invoke(item$iv$iv));
                            }
                            v0 = (List)destination$iv$iv;
                            break block22;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            message = "Failed to check dependencies on server: " + this.dbBaseUrl.url;
                            $this$mapTo$iv$iv = e;
                            if ($this$mapTo$iv$iv instanceof IOException || $this$mapTo$iv$iv instanceof IllegalArgumentException || $this$mapTo$iv$iv instanceof AnalysisException) {
                                GeneralRepositoryServerKt.access$getLogger$p().warn(message);
                                GeneralRepositoryServerKt.access$getLogger$p().debug((Throwable)e);
                                if (e instanceof AnalysisException) {
                                    v2 = (AnalysisException)e;
                                } else {
                                    v3 = e.getMessage();
                                    if (v3 == null) {
                                        v3 = e.getClass().getSimpleName();
                                    }
                                    destination$iv$iv = v3;
                                    Intrinsics.checkNotNull((Object)destination$iv$iv);
                                    v2 = new AnalysisException(message, AnalysisExceptionScope.USER, (String)destination$iv$iv);
                                }
                                exception = v2;
                            }
                            $continuation.L$0 = this;
                            $continuation.L$1 = bodyHandler;
                            $continuation.L$2 = transform;
                            $continuation.L$3 = allAttemptsFailed;
                            $continuation.L$4 = destination$iv$iv;
                            $continuation.L$5 = var11_15;
                            $continuation.L$6 = pkgChunk;
                            $continuation.L$7 = exception;
                            $continuation.I$0 = attempt;
                            $continuation.label = 2;
                            v4 = DelayKt.delay((long)(attempt * 200), $continuation);
                            if (v4 != var30_8) ** GOTO lbl30
                            return var30_8;
                        }
                    }
                    case 2: {
                        $i$f$flatMap = false;
                        $i$f$flatMapTo = false;
                        $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2 = false;
                        attempt = $continuation.I$0;
                        exception = (AnalysisException)$continuation.L$7;
                        pkgChunk = (List)$continuation.L$6;
                        var11_15 = (Iterator)$continuation.L$5;
                        destination$iv$iv = (Collection)$continuation.L$4;
                        allAttemptsFailed = (Function1)$continuation.L$3;
                        transform = (Function1)$continuation.L$2;
                        bodyHandler = (HttpResponse.BodyHandler)$continuation.L$1;
                        this = (GeneralRepositoryServer)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        ** GOTO lbl30
                    }
                }
                if (exception != null) {
                    v5 = GeneralRepositoryServerKt.access$getLogger$p();
                    e = exception.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)e, (String)"getStackTrace(...)");
                    v6 = e;
                    v7 = LineSeparator.getSystemLineSeparator().getSeparatorString();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getSeparatorString(...)");
                    v5.warn(ArraysKt.joinToString$default((Object[])v6, (CharSequence)v7, null, null, (int)0, null, null, (int)62, null));
                }
                $this$map$iv = pkgChunk;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var22_30 = $this$mapTo$iv$iv.iterator();
                while (var22_30.hasNext()) {
                    item$iv$iv = var22_30.next();
                    var24_32 = (Package)item$iv$iv;
                    var25_33 = destination$iv$iv;
                    $i$a$-map-GeneralRepositoryServer$getStatusForPackages$2$1 = false;
                    var25_33.add(allAttemptsFailed.invoke((Object)it));
                }
                v0 = (List)destination$iv$iv;
            }
            list$iv$iv = v0;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            ** GOTO lbl21
        }
        return (List)destination$iv$iv;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final RequestDto createRequestDto(List<Package> packageChunk) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = packageChunk;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Package package_ = (Package)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSearchKey());
        }
        List packageDTOs = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        return new HashesDto(packageDTOs, this.clientData.getAnonymousToken(), this.clientData.getApplicationMode());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final <DTO> Object getPackagesFromServer(String var1_1, RequestDto var2_2, HttpResponse.BodyHandler<List<DTO>> var3_3, Continuation<? super List<? extends DTO>> $completion) {
        if (!($completion instanceof getPackagesFromServer.1)) ** GOTO lbl-1000
        var9_5 = $completion;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GeneralRepositoryServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GeneralRepositoryServer.access$getPackagesFromServer(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                requestDataJson = this.objectMapper.writeValueAsBytes((Object)requestData);
                v0 = this.getGzipHttpClient();
                Intrinsics.checkNotNull((Object)requestDataJson);
                var7_10 = HttpRequest.BodyPublishers.ofByteArray(GzipUtils.INSTANCE.compressToGzip(requestDataJson));
                Intrinsics.checkNotNullExpressionValue((Object)var7_10, (String)"ofByteArray(...)");
                $continuation.L$0 = url;
                $continuation.label = 1;
                v1 = v0.post(url, var7_10, bodyHandler, $continuation);
                ** if (v1 != var10_7) goto lbl24
lbl23:
                // 1 sources

                return var10_7;
lbl24:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                url = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl31:
                    // 2 sources

                    var5_11 /* !! */  = ((HttpResponse)v1).body();
                    Intrinsics.checkNotNull(var5_11 /* !! */ );
                    var5_11 /* !! */  = (List)var5_11 /* !! */ ;
                }
                catch (Exception var6_9) {
                    throw new AnalysisException("Failed to check dependencies on server: " + url, AnalysisExceptionScope.USER, null, 4, null);
                }
                return var5_11 /* !! */ ;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final HttpClientApi httpClient_delegate$lambda$0(GeneralRepositoryServer this$0) {
        return new HttpClientApi(HttpClientHeadersService.Companion.getInstance().getHeaderParams(), this$0.requestTimeout);
    }

    private static final HttpClientApi gzipHttpClient_delegate$lambda$1(GeneralRepositoryServer this$0) {
        return new HttpClientApi(HttpClientHeadersService.Companion.getInstance().getGzipHeadersParam(), this$0.requestTimeout);
    }

    public static final /* synthetic */ Object access$getPackagesFromServer(GeneralRepositoryServer $this, String url, RequestDto requestData, HttpResponse.BodyHandler bodyHandler2, Continuation $completion) {
        return $this.getPackagesFromServer(url, requestData, bodyHandler2, $completion);
    }
}

