/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editors.patchItemHandlers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.jetbrains.rd.ide.editor.CaretRestoreHelper;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.editor.EditorVersionsKt;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.RdAbstractEditorVersion;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretId;
import com.jetbrains.rd.ide.model.RdCaretModelChange;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdInitialCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdPatchExtension;
import com.jetbrains.rd.ide.model.RdPatchInitialCaretStateHintExtension;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdPatchItemVersion;
import com.jetbrains.rd.ide.model.RdSelection;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.editors.patchItemHandlers.FrontendSelectionChangeHandlerKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandler;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler;", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchItemHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchItemVersion;", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "<init>", "()V", "apply", "", "item", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "rollback", "step", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "redo", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendSelectionChangeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendSelectionChangeHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 FrontendRdPatchHandlerContext.kt\ncom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n69#2,4:95\n69#2,4:106\n69#2,4:110\n69#2,4:114\n40#3:99\n41#3,3:101\n44#3:105\n1863#4:100\n1864#4:104\n*S KotlinDebug\n*F\n+ 1 FrontendSelectionChangeHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler\n*L\n18#1:95,4\n49#1:106,4\n54#1:110,4\n61#1:114,4\n48#1:99\n48#1:101,3\n48#1:105\n48#1:100\n48#1:104\n*E\n"})
public final class FrontendSelectionChangeHandler
implements FrontendRdPatchItemHandler<RdPatchItemVersion, RdSelectionChangeBase> {
    @Override
    public void apply(@NotNull RdSelectionChangeBase item, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PatchItemOperationType operation = context.getOperation();
        Logger $this$trace$iv = FrontendSelectionChangeHandlerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Applying selection change step: " + item.getEditorId() + " with operation type " + operation);
        }
        PatchItemOperationType patchItemOperationType = operation;
        if (patchItemOperationType instanceof PatchItemOperationType.Rollback) {
            this.rollback(item, context, ((PatchItemOperationType.Rollback)operation).getRebaseSession());
        } else if (patchItemOperationType instanceof PatchItemOperationType.Redo) {
            this.redo(item, ((PatchItemOperationType.Redo)operation).getRebaseSession());
        } else {
            Editor editor = FrontendTextControlHostKt.toEditorOrNull(item.getEditorId());
            if (editor == null) {
                FrontendSelectionChangeHandler $this$apply_u24lambda_u241 = this;
                boolean bl = false;
                FrontendSelectionChangeHandlerKt.access$getLogger$p().warn("There is no editor for " + item.getEditorId());
                return;
            }
            Editor editor2 = editor;
            if (operation instanceof PatchItemOperationType.SoftRollback) {
                return;
            }
            EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor2);
            Intrinsics.checkNotNull((Object)editorSynchronizer);
            EditorSynchronizer synchronizer = editorSynchronizer;
            if (operation instanceof PatchItemOperationType.SoftPerform || operation instanceof PatchItemOperationType.SoftRedo) {
                RdAbstractEditorVersion rdAbstractEditorVersion = synchronizer.getVersion();
                Intrinsics.checkNotNull((Object)rdAbstractEditorVersion, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdEditorVersion");
                RdEditorVersion version = (RdEditorVersion)rdAbstractEditorVersion;
                synchronizer.resetVersion((RdAbstractEditorVersion)EditorVersionsKt.increment((RdEditorVersion)version));
            } else {
                synchronizer.receiveSelection((RdCaretModelChange)item);
            }
        }
    }

    private final void rollback(RdSelectionChangeBase step, FrontendRdPatchHandlerContext context, FrontendRebaseSession rebaseSession) {
        RdInitialCaretStateSnapshot rdInitialCaretStateSnapshot;
        block8: {
            FrontendRdPatchHandlerContext this_$iv = context;
            boolean $i$f$getExtension = false;
            Iterable $this$forEach$iv$iv = this_$iv.getPatch().getExtensions();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                RdPatchExtension it$iv = (RdPatchExtension)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof RdPatchInitialCaretStateHintExtension)) continue;
                RdPatchInitialCaretStateHintExtension it = (RdPatchInitialCaretStateHintExtension)it$iv;
                boolean bl2 = false;
                rdInitialCaretStateSnapshot = it.getInitialCaretStateHint();
                break block8;
            }
            rdInitialCaretStateSnapshot = null;
        }
        if (Intrinsics.areEqual((Object)(rdInitialCaretStateSnapshot != null ? rdInitialCaretStateSnapshot.getEditorId() : null), (Object)step.getEditorId())) {
            Logger $this$trace$iv = FrontendSelectionChangeHandlerKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Do not rollback initial caret state hint: " + step.getEditorId() + " - RdPatchInitialCaretStateHintExtension for " + step.getEditorId() + " is not present");
            }
            return;
        }
        Editor editor = FrontendTextControlHostKt.toEditorOrNull(step.getEditorId());
        if (editor == null) {
            Logger $this$trace$iv = FrontendSelectionChangeHandlerKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Do not rollback caret state change: " + step.getEditorId() + " with operation type " + context.getOperation() + " because editor does not exist");
            }
            return;
        }
        CaretRestoreHelper caretRestoreHelper = CaretRestoreHelper.Companion.getInstance();
        if (caretRestoreHelper.getLastCaretBeforeRollbackLeansForward() == null) {
            caretRestoreHelper.setLastCaretBeforeRollbackLeansForward(Boolean.valueOf(editor.getCaretModel().getPrimaryCaret().getLogicalPosition().leansForward));
        }
        Logger $this$trace$iv = FrontendSelectionChangeHandlerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Rollback caret state change: " + step.getEditorId() + " with operation type " + context.getOperation());
        }
        EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor);
        if (editorSynchronizer == null) {
            throw new IllegalStateException("editor synchronizer is null".toString());
        }
        editorSynchronizer.receiveSelection((RdCaretModelChange)UtilKt.reverse((RdSelectionChangeBase)step));
        rebaseSession.record((RdPatchItem)step);
    }

    private final void redo(RdSelectionChangeBase item, FrontendRebaseSession rebaseSession) {
        Editor editor = FrontendTextControlHostKt.toEditorOrNull(item.getEditorId());
        if (editor == null) {
            FrontendSelectionChangeHandler $this$redo_u24lambda_u246 = this;
            boolean bl = false;
            FrontendSelectionChangeHandlerKt.access$getLogger$p().warn("There is no editor for " + item.getEditorId());
            return;
        }
        Editor editor2 = editor;
        RdCaretState actualState = UtilKt.getActualState((RdSelectionChangeBase)rebaseSession.replay(item));
        for (RdCaret rdCaret : actualState.getCarets()) {
            RdSelection selection;
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            Caret caret = UtilKt.getCaretById((CaretModel)caretModel, (RdCaretId)rdCaret.getId());
            if (caret == null) {
                LogicalPosition newLogicalPosition;
                boolean isPrimary = Intrinsics.areEqual((Object)rdCaret.getId(), (Object)actualState.getPrimaryCaretId());
                Intrinsics.checkNotNullExpressionValue((Object)editor2.offsetToLogicalPosition(rdCaret.getOffset().getOffset()), (String)"offsetToLogicalPosition(...)");
                Caret caret2 = caret = editor2.getCaretModel().addCaret(newLogicalPosition, isPrimary);
                if (caret2 != null) {
                    UtilKt.setId((Caret)caret2, (RdCaretId)rdCaret.getId());
                }
            }
            if (rdCaret.getOffset().getOffset() != -1) {
                Caret caret3 = caret;
                if (caret3 != null) {
                    caret3.moveToOffset(rdCaret.getOffset().getOffset());
                }
            }
            if ((selection = rdCaret.getSelection()).getStart().getOffset() == -1 || selection.getEnd().getOffset() == -1 || selection.getStart().getOffset() >= selection.getEnd().getOffset()) continue;
            Caret caret4 = caret;
            if (caret4 == null) continue;
            caret4.setSelection(selection.getStart().getOffset(), selection.getEnd().getOffset());
        }
    }
}

