/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.document.DocumentLogRangeShifterKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListener;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListeners;
import com.jetbrains.rd.ide.model.DocOffsetAndVirtualModel;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdEditorChange;
import com.jetbrains.rd.ide.model.RdInitialCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdSelection;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.util.string.IPrintableKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000eJ\u0018\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0018\u0010\r\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizerListener;", "<init>", "()V", "history", "", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "pointers", "", "", "", "change", "", "replay", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "Lcom/jetbrains/rd/ide/model/RdCaretState;", "anchor", "Lcom/jetbrains/rd/ide/model/RdPatchItem;", "state", "Lcom/jetbrains/rd/ide/model/DocOffsetAndVirtualModel;", "offsetAndVirtualModel", "offset", "record", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendRebaseSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendRebaseSession.kt\ncom/jetbrains/rdclient/requests/FrontendRebaseSession\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,131:1\n15#2:132\n*S KotlinDebug\n*F\n+ 1 FrontendRebaseSession.kt\ncom/jetbrains/rdclient/requests/FrontendRebaseSession\n*L\n19#1:132\n*E\n"})
public final class FrontendRebaseSession
implements DocumentSynchronizerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<RdDocumentChange> history = new ArrayList();
    @NotNull
    private final Map<Object, Integer> pointers = new LinkedHashMap();
    @NotNull
    private static final Logger logger;

    private FrontendRebaseSession() {
    }

    public void change(@NotNull RdDocumentChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        this.history.add(change);
    }

    @NotNull
    public final RdSelectionChangeBase replay(@NotNull RdSelectionChangeBase change) {
        RdSelectionChangeBase rdSelectionChangeBase;
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        RdSelectionChangeBase rdSelectionChangeBase2 = change;
        if (rdSelectionChangeBase2 instanceof RdCaretStateChange) {
            rdSelectionChangeBase = (RdSelectionChangeBase)new RdCaretStateChange(this.replay((RdPatchItem)change, ((RdCaretStateChange)change).getOldState()), this.replay((RdPatchItem)change, ((RdCaretStateChange)change).getNewState()), change.getEditorId());
        } else if (rdSelectionChangeBase2 instanceof RdCaretStateSnapshot) {
            rdSelectionChangeBase = (RdSelectionChangeBase)new RdCaretStateSnapshot(this.replay((RdPatchItem)change, ((RdCaretStateSnapshot)change).getState()), change.getEditorId());
        } else if (rdSelectionChangeBase2 instanceof RdInitialCaretStateSnapshot) {
            rdSelectionChangeBase = (RdSelectionChangeBase)new RdInitialCaretStateSnapshot(this.replay((RdPatchItem)change, ((RdInitialCaretStateSnapshot)change).getState()), change.getEditorId());
        } else {
            throw new IllegalStateException(("Unsupported selection change: " + this).toString());
        }
        return rdSelectionChangeBase;
    }

    private final RdCaretState replay(RdPatchItem anchor, RdCaretState state2) {
        List shiftCarets = new ArrayList();
        for (RdCaret caret : state2.getCarets()) {
            RdCaret shiftCaret = new RdCaret(caret.getId(), this.replay(anchor, caret.getOffset()), new RdSelection(this.replay(anchor, caret.getSelection().getStart()), this.replay(anchor, caret.getSelection().getEnd())));
            shiftCarets.add(shiftCaret);
        }
        return new RdCaretState(state2.getPrimaryCaretId(), shiftCarets);
    }

    private final DocOffsetAndVirtualModel replay(RdPatchItem anchor, DocOffsetAndVirtualModel offsetAndVirtualModel) {
        int shiftOffset = this.replay(anchor, offsetAndVirtualModel.getOffset());
        return new DocOffsetAndVirtualModel(shiftOffset, offsetAndVirtualModel.getVirtualDelta(), offsetAndVirtualModel.getLogicalLeansForward());
    }

    @NotNull
    public final RdDocumentChange replay(@NotNull RdDocumentChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        if (Intrinsics.areEqual((Object)change.isWholeTextReplaced(), (Object)true)) {
            return change;
        }
        int shiftOffset = this.replay((RdPatchItem)change, change.getOffset());
        int shiftMoveOffset = this.replay((RdPatchItem)change, change.getMoveOffset());
        int shiftOldDocumentLength = this.replay((RdPatchItem)change, change.getOldDocumentLength());
        return new RdDocumentChange(shiftOffset, shiftMoveOffset, change.getNewText(), change.getOldText(), change.getModificationKind(), shiftOldDocumentLength, change.getText(), change.isWholeTextReplaced(), change.getDocumentId());
    }

    private final int replay(RdPatchItem anchor, int offset) {
        RdDocumentId rdDocumentId;
        Integer index = this.pointers.get(anchor);
        if (index == null) {
            logger.error("Can not find anchor patch item in the history: " + IPrintableKt.printToString((Object)anchor));
            return offset;
        }
        RdPatchItem rdPatchItem = anchor;
        if (rdPatchItem instanceof RdDocumentChangeBase) {
            rdDocumentId = ((RdDocumentChangeBase)anchor).getDocumentId();
        } else if (rdPatchItem instanceof RdEditorChange) {
            rdDocumentId = ((RdEditorChange)anchor).getEditorId().getDocumentId();
        } else {
            throw new IllegalStateException(("Unknown anchor: " + IPrintableKt.printToString((Object)anchor)).toString());
        }
        RdDocumentId documentId = rdDocumentId;
        List changes = new ArrayList();
        Iterator iterator2 = ((Iterable)this.history).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            RdDocumentChange change = (RdDocumentChange)iterator2.next();
            if (i <= index || !Intrinsics.areEqual((Object)change.getDocumentId(), (Object)documentId)) continue;
            changes.add(change);
        }
        int newOffset = DocumentLogRangeShifterKt.shiftOnePoint$default((List)changes, (int)offset, (boolean)false, (int)4, null);
        if (newOffset == offset) {
            return offset;
        }
        logger.trace("Offset was rebased: " + offset + " -> " + newOffset + " for change " + anchor.getClass().getSimpleName());
        return newOffset;
    }

    public final void record(@NotNull RdPatchItem anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        this.pointers.put(anchor, this.history.size() - 1);
    }

    public /* synthetic */ FrontendRebaseSession(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendRebaseSession.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendRebaseSession.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000bH\u0086\b\u00f8\u0001\u0000J\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendRebaseSession$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "using", "", "clientAppSession", "Lcom/intellij/openapi/client/ClientAppSession;", "action", "Lkotlin/Function1;", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "createEmpty", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void using(@NotNull ClientAppSession clientAppSession, @NotNull Function1<? super FrontendRebaseSession, Unit> action) {
            Intrinsics.checkNotNullParameter((Object)clientAppSession, (String)"clientAppSession");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            boolean $i$f$using = false;
            FrontendRebaseSession rebaseSession = this.createEmpty();
            try {
                DocumentSynchronizerListeners.Companion.getInstance(clientAppSession).addListener((DocumentSynchronizerListener)rebaseSession);
                action.invoke((Object)rebaseSession);
            }
            finally {
                InlineMarker.finallyStart((int)1);
                DocumentSynchronizerListeners.Companion.getInstance(clientAppSession).removeListener((DocumentSynchronizerListener)rebaseSession);
                InlineMarker.finallyEnd((int)1);
            }
        }

        @NotNull
        public final FrontendRebaseSession createEmpty() {
            return new FrontendRebaseSession(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

