/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.RemoteSdkPropertiesHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsManager;
import com.jetbrains.nodejs.remote.NodeJSRemoteInterpreterManager;
import com.jetbrains.plugins.remotesdk.RemoteCredentialsProducer;
import java.util.function.Consumer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeJSRemoteSdkAdditionalData
extends RemoteSdkPropertiesHolder
implements RemoteSdkAdditionalData {
    public static final String HELPERS_DIR = ".webstorm_nodejs_helpers";
    private static final String VERSION = "VERSION";
    private static final String OUTDATED_ID = "OUTDATED_ID";
    private final RemoteConnectionCredentialsWrapper myCredentialsWrapper;
    private String myVersionString;
    private String myOutdatedSdkId;

    public NodeJSRemoteSdkAdditionalData(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            NodeJSRemoteSdkAdditionalData.$$$reportNull$$$0(0);
        }
        super(HELPERS_DIR);
        this.myCredentialsWrapper = new RemoteConnectionCredentialsWrapper();
        this.setInterpreterPath(interpreterPath);
    }

    private RemoteCredentialsProducer getProducer() {
        return new RemoteCredentialsProducer(this.myCredentialsWrapper);
    }

    public void setSdkId(String sdkId) {
        throw new IllegalStateException("sdkId in this class is constructed based on fields, so it can't be set");
    }

    public String getSdkId() {
        return FileUtil.toSystemIndependentName((String)(this.myCredentialsWrapper.getId() + this.getInterpreterPath()));
    }

    @Nullable
    public String getOutdatedSdkId() {
        return this.myOutdatedSdkId;
    }

    @NotNull
    public RemoteConnectionCredentialsWrapper connectionCredentials() {
        RemoteConnectionCredentialsWrapper remoteConnectionCredentialsWrapper = this.myCredentialsWrapper;
        if (remoteConnectionCredentialsWrapper == null) {
            NodeJSRemoteSdkAdditionalData.$$$reportNull$$$0(1);
        }
        return remoteConnectionCredentialsWrapper;
    }

    public RemoteCredentials getRemoteCredentials(@Nullable Project project, boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        return this.getProducer().getRemoteCredentials(project, allowSynchronousInteraction);
    }

    public void produceRemoteCredentials(@Nullable Project project, boolean allowSynchronousInteraction, @NotNull Consumer<RemoteCredentials> consumer) {
        if (consumer == null) {
            NodeJSRemoteSdkAdditionalData.$$$reportNull$$$0(2);
        }
        this.getProducer().produceRemoteCredentials(project, allowSynchronousInteraction, consumer);
    }

    public Object getRemoteSdkDataKey() {
        return this.myCredentialsWrapper.getConnectionKey();
    }

    public void save(Element rootElement) {
        super.save(rootElement);
        rootElement.setAttribute(VERSION, StringUtil.notNullize((String)this.getVersionString()));
        rootElement.setAttribute(OUTDATED_ID, StringUtil.notNullize((String)this.getOutdatedSdkId()));
        this.myCredentialsWrapper.save(rootElement);
    }

    @NotNull
    public static NodeJSRemoteSdkAdditionalData load(@Nullable Element element, @NotNull String interpreterPath) {
        if (interpreterPath == null) {
            NodeJSRemoteSdkAdditionalData.$$$reportNull$$$0(3);
        }
        NodeJSRemoteSdkAdditionalData data = new NodeJSRemoteSdkAdditionalData(RemoteSdkProperties.getInterpreterPathFromFullPath((String)interpreterPath));
        if (element != null) {
            CredentialsManager.getInstance().loadCredentials(interpreterPath, element, (RemoteSdkAdditionalData)data);
            data.myOutdatedSdkId = StringUtil.nullize((String)element.getAttributeValue(OUTDATED_ID));
            if (data.myOutdatedSdkId == null) {
                data.myOutdatedSdkId = data.getSdkId();
                CredentialsManager.updateOutdatedSdk((RemoteSdkAdditionalData)data, null);
                NodeJSRemoteInterpreterManager.getInstance().loadFullyCredentials(data);
                if (data.getSdkId().equals(data.myOutdatedSdkId)) {
                    data.myOutdatedSdkId = null;
                }
            }
            data.load(element);
            data.setVersionString(StringUtil.notNullize((String)element.getAttributeValue(VERSION)));
        }
        NodeJSRemoteSdkAdditionalData nodeJSRemoteSdkAdditionalData = data;
        if (nodeJSRemoteSdkAdditionalData == null) {
            NodeJSRemoteSdkAdditionalData.$$$reportNull$$$0(4);
        }
        return nodeJSRemoteSdkAdditionalData;
    }

    public <C> void setCredentials(Key<C> key, C credentials) {
        this.myCredentialsWrapper.setCredentials(key, credentials);
    }

    public CredentialsType<?> getRemoteConnectionType() {
        return this.myCredentialsWrapper.getRemoteConnectionType();
    }

    public void switchOnConnectionType(CredentialsCase ... cases) {
        this.myCredentialsWrapper.switchType(cases);
    }

    public String getVersionString() {
        return this.myVersionString;
    }

    public void setVersionString(String versionString) {
        this.myVersionString = versionString;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/remote/NodeJSRemoteSdkAdditionalData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/remote/NodeJSRemoteSdkAdditionalData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "connectionCredentials";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "produceRemoteCredentials";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

