/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote.docker;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.configuration.DockerContainerCliSettingsEditor;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.execution.AbstractNodeTargetRunProfile;
import com.intellij.javascript.nodejs.execution.runConfiguration.AbstractNodeRunConfigurationExtension;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkAdditionalData;
import com.jetbrains.nodejs.remote.NodeRemoteInterpreterUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J%\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00072\u0006\u0010\u0006\u001a\u0002H\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/nodejs/remote/docker/NodeDockerRunConfigurationExtension;", "Lcom/intellij/javascript/nodejs/execution/runConfiguration/AbstractNodeRunConfigurationExtension;", "<init>", "()V", "isApplicableFor", "", "configuration", "Lcom/intellij/javascript/nodejs/execution/AbstractNodeTargetRunProfile;", "shouldExtendMainEditor", "getSerializationId", "", "readExternal", "", "runConfiguration", "element", "Lorg/jdom/Element;", "writeExternal", "createEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "P", "(Lcom/intellij/javascript/nodejs/execution/AbstractNodeTargetRunProfile;)Lcom/intellij/openapi/options/SettingsEditor;", "getDockerCredentials", "Lcom/intellij/docker/remote/DockerCredentialsHolder;", "tryGetServer", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "getEditorTitle", "intellij.nodeJS.remoteInterpreter"})
public final class NodeDockerRunConfigurationExtension
extends AbstractNodeRunConfigurationExtension {
    public boolean isApplicableFor(@NotNull AbstractNodeTargetRunProfile configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return this.getDockerCredentials(configuration) != null;
    }

    public boolean shouldExtendMainEditor() {
        return true;
    }

    @NotNull
    protected String getSerializationId() {
        return "NodeDockerRunConfigurationExtension";
    }

    protected void readExternal(@NotNull AbstractNodeTargetRunProfile runConfiguration, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = XmlSerializer.deserialize((Element)element, DockerContainerSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deserialize(...)");
        DockerContainerSettings value = (DockerContainerSettings)object;
        DockerContainerSettings.upgradeSettings((Project)runConfiguration.getProject(), (DockerContainerSettings)value, (int)2);
        runConfiguration.putCopyableUserData(DockerContainerSettings.KEY, (Object)value);
    }

    protected void writeExternal(@NotNull AbstractNodeTargetRunProfile runConfiguration, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DockerContainerSettings data = (DockerContainerSettings)runConfiguration.getCopyableUserData(DockerContainerSettings.KEY);
        if (data != null) {
            XmlSerializer.serializeInto((Object)data, (Element)element);
        }
    }

    @NotNull
    public <P extends AbstractNodeTargetRunProfile> SettingsEditor<P> createEditor(@NotNull P configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        return (SettingsEditor)new DockerContainerCliSettingsEditor(configuration.getProject(), arg_0 -> NodeDockerRunConfigurationExtension.createEditor$lambda$0(this, configuration, arg_0));
    }

    private final DockerCredentialsHolder getDockerCredentials(AbstractNodeTargetRunProfile configuration) {
        NodeJSRemoteSdkAdditionalData data;
        NodeJSRemoteSdkAdditionalData nodeJSRemoteSdkAdditionalData;
        try {
            Project project = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            nodeJSRemoteSdkAdditionalData = NodeRemoteInterpreterUtil.findRemoteSdkAdditionalData(project, configuration.getInterpreter());
        }
        catch (ExecutionException e) {
            nodeJSRemoteSdkAdditionalData = null;
        }
        NodeJSRemoteSdkAdditionalData nodeJSRemoteSdkAdditionalData2 = data = nodeJSRemoteSdkAdditionalData;
        return nodeJSRemoteSdkAdditionalData2 != null ? DockerCredentialsHolder.tryGetDockerCredentials((RemoteSdkAdditionalData)nodeJSRemoteSdkAdditionalData2) : null;
    }

    private final RemoteServer<?> tryGetServer(AbstractNodeTargetRunProfile configuration) {
        String accountName;
        DockerCredentialsHolder credentials = this.getDockerCredentials(configuration);
        if (credentials != null && StringUtil.isNotEmpty((String)(accountName = credentials.getAccountName()))) {
            return RemoteServersManager.getInstance().findByName(accountName, (ServerType)DockerCloudType.getInstance());
        }
        return null;
    }

    @Nullable
    public String getEditorTitle() {
        return null;
    }

    private static final RemoteServer createEditor$lambda$0(NodeDockerRunConfigurationExtension this$0, AbstractNodeTargetRunProfile $configuration, AbstractNodeTargetRunProfile it) {
        return this$0.tryGetServer($configuration);
    }
}

