/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.build;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.intellij.docker.agent.build.DockerIgnoreMatcherKt;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u00122\u00020\u0001:\b\u000b\f\r\u000e\u000f\u0010\u0011\u0012B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H$J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\n\u0082\u0001\u0006\u0013\u0014\u0015\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/docker/agent/build/DockerIgnoreMatcher;", "", "<init>", "()V", "doMatch", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$MatchResult;", "path", "", "match", "isExclusion", "", "MatchResult", "BySuffix", "ByRegEx", "ByPrefix", "ByEquals", "DummyMatcher", "Exclusion", "Companion", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$ByEquals;", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$ByPrefix;", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$ByRegEx;", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$BySuffix;", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$DummyMatcher;", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$Exclusion;", "intellij.clouds.docker.agent"})
public abstract class DockerIgnoreMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final LoadingCache<String, Pattern> PATTERN_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(1000L).build(CacheLoader.from(Pattern::compile));

    private DockerIgnoreMatcher() {
    }

    @NotNull
    protected abstract MatchResult doMatch(@NotNull String var1);

    @NotNull
    public final MatchResult match(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = FilenameUtils.normalize((String)path, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalize(...)");
        return this.doMatch(string);
    }

    public final boolean isExclusion() {
        return this instanceof Exclusion;
    }

    public /* synthetic */ DockerIgnoreMatcher(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$ByEquals;", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher;", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "doMatch", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$MatchResult;", "path", "intellij.clouds.docker.agent"})
    private static final class ByEquals
    extends DockerIgnoreMatcher {
        @NotNull
        private final String value;

        public ByEquals(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @Override
        @NotNull
        protected MatchResult doMatch(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return DockerIgnoreMatcherKt.access$testMatchingBy(path, this.value, ByEquals::doMatch$lambda$0) ? MatchResult.MATCHED : MatchResult.NOT_MATCHED;
        }

        private static final boolean doMatch$lambda$0(String s1, String s2) {
            Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
            return Intrinsics.areEqual((Object)s1, (Object)s2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$ByPrefix;", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher;", "prefix", "", "<init>", "(Ljava/lang/String;)V", "doMatch", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$MatchResult;", "path", "intellij.clouds.docker.agent"})
    private static final class ByPrefix
    extends DockerIgnoreMatcher {
        @NotNull
        private final String prefix;

        public ByPrefix(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            super(null);
            this.prefix = prefix;
        }

        @Override
        @NotNull
        protected MatchResult doMatch(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return StringsKt.startsWith$default((String)path, (String)this.prefix, (boolean)false, (int)2, null) ? MatchResult.MATCHED : MatchResult.NOT_MATCHED;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0014R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$ByRegEx;", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher;", "pattern", "", "<init>", "(Ljava/lang/String;)V", "myPatten", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "doMatch", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$MatchResult;", "path", "intellij.clouds.docker.agent"})
    private static final class ByRegEx
    extends DockerIgnoreMatcher {
        private final Pattern myPatten;

        public ByRegEx(@NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            super(null);
            this.myPatten = (Pattern)PATTERN_CACHE.get((Object)pattern);
        }

        @Override
        @NotNull
        protected MatchResult doMatch(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.myPatten.matcher(path).matches() ? MatchResult.MATCHED : MatchResult.NOT_MATCHED;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$BySuffix;", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher;", "suffix", "", "<init>", "(Ljava/lang/String;)V", "doMatch", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$MatchResult;", "path", "intellij.clouds.docker.agent"})
    private static final class BySuffix
    extends DockerIgnoreMatcher {
        @NotNull
        private final String suffix;

        public BySuffix(@NotNull String suffix) {
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            super(null);
            this.suffix = suffix;
        }

        @Override
        @NotNull
        protected MatchResult doMatch(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return DockerIgnoreMatcherKt.access$testMatchingBy(path, this.suffix, BySuffix::doMatch$lambda$0) ? MatchResult.MATCHED : MatchResult.NOT_MATCHED;
        }

        private static final boolean doMatch$lambda$0(String s1, String s2) {
            Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
            return StringsKt.endsWith$default((String)s1, (String)s2, (boolean)false, (int)2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006RP\u0010\u0004\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$Companion;", "", "<init>", "()V", "PATTERN_CACHE", "Lcom/google/common/cache/LoadingCache;", "", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "Lcom/google/common/cache/LoadingCache;", "compile", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher;", "ignorePattern", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final DockerIgnoreMatcher compile(@NotNull String ignorePattern) {
            Intrinsics.checkNotNullParameter((Object)ignorePattern, (String)"ignorePattern");
            normalizedPattern = StringsKt.trim((CharSequence)ignorePattern).toString();
            if (StringsKt.startsWith$default((String)normalizedPattern, (String)"#", (boolean)false, (int)2, null)) {
                return DummyMatcher.INSTANCE;
            }
            isExclusion = StringsKt.startsWith$default((String)normalizedPattern, (String)"!", (boolean)false, (int)2, null);
            if (isExclusion) {
                normalizedPattern = StringsKt.trim((CharSequence)StringsKt.removePrefix((String)normalizedPattern, (CharSequence)"!")).toString();
            }
            normalizedPattern = StringsKt.replace$default((String)normalizedPattern, (String)"\\", (String)"/", (boolean)false, (int)4, null);
            normalizedPattern = StringsKt.removePrefix((String)normalizedPattern, (CharSequence)"./");
            sep = '/';
            queue = new LinkedList<E>(StringsKt.toList((CharSequence)normalizedPattern));
            matcher = Reflection.getOrCreateKotlinClass(ByEquals.class);
            regStr = "^[/]?";
            index = 0;
            while (((Collection)queue).isEmpty() == false) {
                block24: {
                    block25: {
                        block23: {
                            v0 = ch = (Character)queue.poll();
                            var10_10 = '*';
                            if (v0 == null || v0.charValue() != var10_10) break block23;
                            v1 = (Character)queue.peek();
                            var10_10 = '*';
                            if (v1 != null && v1.charValue() == var10_10) {
                                queue.poll();
                                v2 = (Character)queue.peek();
                                var10_10 = sep;
                                if (v2 != null && v2.charValue() == var10_10) {
                                    queue.poll();
                                }
                                if (queue.isEmpty()) {
                                    if (Intrinsics.areEqual((Object)matcher, (Object)Reflection.getOrCreateKotlinClass(ByEquals.class))) {
                                        matcher = Reflection.getOrCreateKotlinClass(ByPrefix.class);
                                    } else {
                                        regStr = (String)regStr + ".*";
                                        matcher = Reflection.getOrCreateKotlinClass(ByRegEx.class);
                                    }
                                } else {
                                    matcher = Reflection.getOrCreateKotlinClass(ByRegEx.class);
                                    regStr = (String)regStr + "(.*" + sep + ")?";
                                }
                                if (index == 0) {
                                    matcher = Reflection.getOrCreateKotlinClass(BySuffix.class);
                                }
                            } else {
                                regStr = (String)regStr + "[^/]*";
                                matcher = Reflection.getOrCreateKotlinClass(ByRegEx.class);
                            }
                            break block24;
                        }
                        v3 = ch;
                        var10_10 = '?';
                        if (v3 == null || v3.charValue() != var10_10) break block25;
                        regStr = (String)regStr + "[^" + sep + "]";
                        matcher = Reflection.getOrCreateKotlinClass(ByRegEx.class);
                        break block24;
                    }
                    v4 = ch;
                    var10_10 = '[';
                    if (v4 != null && v4.charValue() == var10_10) ** GOTO lbl-1000
                    v5 = ch;
                    var10_10 = ']';
                    if (v5 != null && v5.charValue() == var10_10) lbl-1000:
                    // 2 sources

                    {
                        regStr = (String)regStr + DockerIgnoreMatcherKt.access$escapeChar(ch.charValue());
                        matcher = Reflection.getOrCreateKotlinClass(ByRegEx.class);
                    } else {
                        v6 = ch;
                        var10_10 = '/';
                        if (v6 != null && v6.charValue() == var10_10) {
                            if (index == 0) continue;
                            regStr = (String)regStr + ch;
                        } else {
                            Intrinsics.checkNotNull((Object)ch);
                            regStr = DockerIgnoreMatcherKt.access$isShouldBeEscaped(ch.charValue()) != false ? (String)regStr + DockerIgnoreMatcherKt.access$escapeChar(ch.charValue()) : (String)regStr + ch;
                        }
                    }
                }
                ++index;
            }
            regStr = (String)regStr + "$";
            var10_11 = matcher;
            if (Intrinsics.areEqual((Object)var10_11, (Object)Reflection.getOrCreateKotlinClass(ByRegEx.class))) {
                v7 = new ByRegEx((String)regStr);
            } else if (Intrinsics.areEqual((Object)var10_11, (Object)Reflection.getOrCreateKotlinClass(BySuffix.class))) {
                v7 = new BySuffix(StringsKt.removePrefix((String)normalizedPattern, (CharSequence)"**"));
            } else if (Intrinsics.areEqual((Object)var10_11, (Object)Reflection.getOrCreateKotlinClass(ByPrefix.class))) {
                v7 = new ByPrefix(StringsKt.removeSuffix((String)normalizedPattern, (CharSequence)"**"));
            } else if (Intrinsics.areEqual((Object)var10_11, (Object)Reflection.getOrCreateKotlinClass(ByEquals.class))) {
                v7 = new ByEquals(normalizedPattern);
            } else {
                throw new IllegalStateException();
            }
            matcherInstance = v7;
            return isExclusion != false ? (DockerIgnoreMatcher)new Exclusion(matcherInstance) : matcherInstance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$DummyMatcher;", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher;", "<init>", "()V", "doMatch", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$MatchResult;", "path", "", "intellij.clouds.docker.agent"})
    private static final class DummyMatcher
    extends DockerIgnoreMatcher {
        @NotNull
        public static final DummyMatcher INSTANCE = new DummyMatcher();

        private DummyMatcher() {
            super(null);
        }

        @Override
        @NotNull
        protected MatchResult doMatch(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return MatchResult.NOT_MATCHED;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$Exclusion;", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher;", "delegate", "<init>", "(Lcom/intellij/docker/agent/build/DockerIgnoreMatcher;)V", "doMatch", "Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$MatchResult;", "path", "", "intellij.clouds.docker.agent"})
    private static final class Exclusion
    extends DockerIgnoreMatcher {
        @NotNull
        private final DockerIgnoreMatcher delegate;

        public Exclusion(@NotNull DockerIgnoreMatcher delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(null);
            this.delegate = delegate;
        }

        @Override
        @NotNull
        protected MatchResult doMatch(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return DockerIgnoreMatcherKt.isMatched(this.delegate.match(path)) ? MatchResult.EXCLUDED : MatchResult.NOT_MATCHED;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/agent/build/DockerIgnoreMatcher$MatchResult;", "", "<init>", "(Ljava/lang/String;I)V", "MATCHED", "NOT_MATCHED", "EXCLUDED", "intellij.clouds.docker.agent"})
    public static final class MatchResult
    extends Enum<MatchResult> {
        public static final /* enum */ MatchResult MATCHED = new MatchResult();
        public static final /* enum */ MatchResult NOT_MATCHED = new MatchResult();
        public static final /* enum */ MatchResult EXCLUDED = new MatchResult();
        private static final /* synthetic */ MatchResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MatchResult[] values() {
            return (MatchResult[])$VALUES.clone();
        }

        public static MatchResult valueOf(String value) {
            return Enum.valueOf(MatchResult.class, value);
        }

        @NotNull
        public static EnumEntries<MatchResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = matchResultArray = new MatchResult[]{MatchResult.MATCHED, MatchResult.NOT_MATCHED, MatchResult.EXCLUDED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

