/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile.actions;

import com.intellij.docker.compose.ComposeFilesSynchronizedWithServiceView;
import com.intellij.docker.composeFile.ComposeFileUtil;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/composeFile/actions/SyncComposeFileWithServiceView;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/TooltipDescriptionProvider;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getYAMLFile", "Lorg/jetbrains/yaml/psi/YAMLFile;", "intellij.clouds.docker.compose"})
public final class SyncComposeFileWithServiceView
extends DumbAwareAction
implements TooltipDescriptionProvider {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ComposeFilesSynchronizedWithServiceView $this$actionPerformed_u24lambda_u240 = ComposeFilesSynchronizedWithServiceView.Companion.getInstance();
        boolean bl = false;
        YAMLFile yAMLFile = this.getYAMLFile(e);
        if (yAMLFile == null || (yAMLFile = yAMLFile.getVirtualFile()) == null) {
            return;
        }
        YAMLFile file = yAMLFile;
        if ($this$actionPerformed_u24lambda_u240.getFiles().contains(file)) {
            String string = file.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            $this$actionPerformed_u24lambda_u240.removeFile(string);
        } else {
            String string = file.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            $this$actionPerformed_u24lambda_u240.addFile(string);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        YAMLFile yamlFile = this.getYAMLFile(e);
        if (yamlFile != null && ComposeFileUtil.isDockerComposeYamlFile(yamlFile)) {
            List<VirtualFile> files = ComposeFilesSynchronizedWithServiceView.Companion.getInstance().getFiles();
            e.getPresentation().setVisible(true);
            if (files.contains(yamlFile.getVirtualFile())) {
                e.getPresentation().setIcon(AllIcons.Actions.StopRefresh);
                e.getPresentation().setText(DockerComposeBundle.message("SyncComposeFileWithServiceView.disable.sync.text", new Object[0]));
                e.getPresentation().setDescription("");
            } else {
                e.getPresentation().setIcon(AllIcons.Actions.Refresh);
                e.getPresentation().setText(DockerComposeBundle.message("SyncComposeFileWithServiceView.enable.sync.text", new Object[0]));
                e.getPresentation().setDescription(DockerComposeBundle.message("SyncComposeFileWithServiceView.enable.sync.description", new Object[0]));
            }
        } else {
            e.getPresentation().setVisible(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final YAMLFile getYAMLFile(AnActionEvent $this$getYAMLFile) {
        Object object = $this$getYAMLFile.getData(CommonDataKeys.PSI_FILE);
        return object instanceof YAMLFile ? (YAMLFile)object : null;
    }
}

