/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.remoteServer.util.Column;
import com.intellij.remoteServer.util.JTableWrapper;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class TableWithCardEditor<T, C extends Column<T>> {
    private final JBTable myTable = new JBTable(){

        @NotNull
        public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column2) {
            if (renderer == null) {
                1.$$$reportNull$$$0(0);
            }
            if (renderer instanceof DefaultTableCellRenderer) {
                ((DefaultTableCellRenderer)renderer).setForeground(TableWithCardEditor.this.isEditable(row) ? UIUtil.getActiveTextColor() : NamedColorUtil.getInactiveTextColor());
            }
            Component component2 = super.prepareRenderer(renderer, row, column2);
            if (component2 == null) {
                1.$$$reportNull$$$0(1);
            }
            return component2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/settings/TableWithCardEditor$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/settings/TableWithCardEditor$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareRenderer";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    private final JTableWrapper<T, C> myTableWrapper;
    protected final JPanel panel;
    private List<T> myItems;

    public TableWithCardEditor(C[] columns) {
        this.myTableWrapper = new JTableWrapper(this.myTable, columns);
        AnActionButtonUpdater editActionUpdater = e -> {
            int[] rows;
            for (int row : rows = this.myTable.getSelectedRows()) {
                if (this.isEditable(row)) continue;
                return false;
            }
            return true;
        };
        this.panel = ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(button -> this.addItem()).setEditAction(button -> this.editItem()).setRemoveAction(button -> this.removeItem()).setEditActionUpdater(editActionUpdater).setRemoveActionUpdater(editActionUpdater).createPanel();
        this.panel.setPreferredSize(new Dimension(-1, 200));
    }

    protected boolean isEditable(int row) {
        return true;
    }

    protected void setShowGrid(boolean v) {
        this.myTable.setShowGrid(v);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void addItem() {
        T newItem = this.createItem();
        if (!this.showDialogAndGetResult(newItem)) {
            return;
        }
        this.myItems.add(newItem);
        this.update(this.myItems.size() - 1);
    }

    private void editItem() {
        int selectedIndex = this.myTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        T selectedItem = this.myItems.get(selectedIndex);
        T editedItem = this.cloneItem(selectedItem);
        if (!this.showDialogAndGetResult(editedItem)) {
            return;
        }
        this.myItems.set(selectedIndex, editedItem);
        this.update(selectedIndex);
    }

    private void removeItem() {
        int selectedIndex = this.myTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        this.myItems.remove(selectedIndex);
        this.update();
    }

    private void update() {
        this.myTableWrapper.setInputRows(this.myItems);
    }

    private void update(int selectedIndex) {
        this.update();
        this.myTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
    }

    public void setEnabled(boolean enabled) {
        this.myTable.setEnabled(enabled);
    }

    public void setItems(List<T> items) {
        this.myItems = new ArrayList<T>(items);
        this.update();
    }

    public List<T> getItems() {
        return this.myItems;
    }

    protected abstract T createItem();

    protected abstract T cloneItem(T var1);

    protected abstract boolean showDialogAndGetResult(T var1);
}

