/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.vfs;

import com.intellij.docker.agent.fs.LsEntry;
import com.intellij.docker.agent.fs.LsParsingKt;
import com.intellij.docker.agent.util.TarCompressionUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.utils.RemoteDockerRuntimeUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThrowableConsumer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerFileSystem
extends NewVirtualFileSystem
implements NonPhysicalFileSystem,
Disposable {
    private static final String PROTOCOL = "docker";
    private static final Logger LOG = Logger.getInstance(DockerFileSystem.class);
    private static final Map<String, Map<String, Ref<Entry>>> ourEntries = new ConcurrentHashMap<String, Map<String, Ref<Entry>>>();
    private final DockerApplicationRuntime myRuntime;
    private volatile boolean disposed;

    public DockerFileSystem(@NotNull DockerApplicationRuntime runtime) {
        if (runtime == null) {
            DockerFileSystem.$$$reportNull$$$0(0);
        }
        this.myRuntime = runtime;
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(1);
        }
        return this.disposed ? null : VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        if (normalizedPath == null) {
            DockerFileSystem.$$$reportNull$$$0(2);
        }
        return DockerFileSystem.extractRootPathImpl(normalizedPath);
    }

    @NotNull
    private static String extractRootPathImpl(@NotNull String normalizedPath) {
        int index;
        if (normalizedPath == null) {
            DockerFileSystem.$$$reportNull$$$0(3);
        }
        String string = (index = normalizedPath.indexOf(47)) < 0 ? normalizedPath : normalizedPath.substring(0, index);
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(4);
        }
        return string;
    }

    public int getRank() {
        return 1;
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(5);
        }
        if (newParent == null) {
            DockerFileSystem.$$$reportNull$$$0(6);
        }
        if (copyName == null) {
            DockerFileSystem.$$$reportNull$$$0(7);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file);
    }

    @NotNull
    private static IOException createModificationNotSupportedError(@NotNull VirtualFile file) {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(8);
        }
        return new IOException(DockerBundle.message("DockerFileSystem.error.modification.not.supported", file.getUrl()));
    }

    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        byte[] byArray;
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(9);
        }
        if (this.disposed || !this.myRuntime.isRunning() || file.isDirectory() || file.is(VFileProperty.SYMLINK)) {
            throw DockerFileSystem.createGettingContentsError(file);
        }
        try {
            Ref contents = Ref.create();
            RemoteDockerRuntimeUtil.download(this.myRuntime.getAgentContainer(), this.getPathInsideContainer(file), null, (ThrowableConsumer<? super File, ? extends IOException>)((ThrowableConsumer)tarFile2 -> {
                try (TarArchiveInputStream tarInputStream = new TarArchiveInputStream(TarCompressionUtil.decompressStream(new BufferedInputStream(new FileInputStream((File)tarFile2))));){
                    TarArchiveEntry tarEntry = tarInputStream.getNextTarEntry();
                    if (tarEntry != null && tarEntry.getName().equals(file.getName()) && tarEntry.isFile()) {
                        contents.set((Object)FileUtil.loadBytes((InputStream)tarInputStream));
                    }
                }
            }));
            if (contents.isNull()) {
                throw DockerFileSystem.createGettingContentsError(file);
            }
            byArray = (byte[])contents.get();
        }
        catch (ServerRuntimeException e) {
            throw DockerFileSystem.createGettingContentsError(file, e);
        }
        if (byArray == null) {
            DockerFileSystem.$$$reportNull$$$0(10);
        }
        return byArray;
    }

    @NotNull
    private static IOException createGettingContentsError(@NotNull VirtualFile file) {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(11);
        }
        return DockerFileSystem.createGettingContentsError(file, null);
    }

    @NotNull
    private static IOException createGettingContentsError(@NotNull VirtualFile file, @Nullable Throwable cause) {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(12);
        }
        return new IOException(DockerBundle.message("DockerFileSystem.error.can.not.get.contents", file.getUrl()), cause);
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(13);
        }
        throw new IOException("Not implemented yet");
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file, Object requestor, long modStamp, long l) throws IOException {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(14);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file);
    }

    public long getLength(@NotNull VirtualFile file) {
        FileAttributes attributes;
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(15);
        }
        return (attributes = this.getAttributes(file)) != null ? attributes.length : 0L;
    }

    public boolean exists(@NotNull VirtualFile file) {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(16);
        }
        return this.getAttributes(file) != null;
    }

    public String @NotNull [] list(@NotNull VirtualFile file) {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(17);
        }
        if (this.disposed) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                DockerFileSystem.$$$reportNull$$$0(18);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String path = this.getPathInsideContainer(file);
        String joinedEntries = this.execLs('A', path);
        if (joinedEntries == null) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                DockerFileSystem.$$$reportNull$$$0(19);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        Object pathWithSlash = "/".equals(path) ? path : path + "/";
        Map<String, Ref<Entry>> entries = DockerFileSystem.getRootEntries(file);
        ArrayList<String> names = new ArrayList<String>();
        for (String entry : StringUtil.splitByLinesDontTrim((String)joinedEntries)) {
            Pair<String, Entry> parsedEntry = DockerFileSystem.parseLsEntry(entry);
            if (parsedEntry == null) continue;
            names.add((String)parsedEntry.first);
            entries.put((String)pathWithSlash + (String)parsedEntry.first, (Ref<Entry>)Ref.create((Object)((Entry)parsedEntry.second)));
        }
        String[] stringArray = ArrayUtilRt.toStringArray(names);
        if (stringArray == null) {
            DockerFileSystem.$$$reportNull$$$0(20);
        }
        return stringArray;
    }

    @Nullable
    private String execLs(char flag2, @NotNull String pathInsideContainer) {
        if (pathInsideContainer == null) {
            DockerFileSystem.$$$reportNull$$$0(21);
        }
        if (!this.myRuntime.isRunning()) {
            return null;
        }
        try {
            CompletableFuture<byte[]> outputFuture = this.myRuntime.captureExecOutput(new String[]{"ls", "-" + flag2 + "ln", "--full-time", "--", pathInsideContainer}, false);
            byte[] output2 = outputFuture.get();
            if (output2 == null) {
                return null;
            }
            return new String(output2, StandardCharsets.UTF_8);
        }
        catch (Throwable t) {
            LOG.warn(t);
            return null;
        }
    }

    @Nullable
    static Pair<String, Entry> parseLsEntry(@NotNull String entry) {
        LsEntry result2;
        if (entry == null) {
            DockerFileSystem.$$$reportNull$$$0(22);
        }
        if ((result2 = LsParsingKt.parseLsEntry(entry)) == null) {
            return null;
        }
        return Pair.create((Object)result2.getName(), (Object)new Entry(new FileAttributes(result2.isDirectory(), false, result2.isSymlink(), false, result2.getLength(), result2.getLastModified(), false, FileAttributes.CaseSensitivity.SENSITIVE), result2.getTarget()));
    }

    @NotNull
    private static Map<String, Ref<Entry>> getRootEntries(@NotNull VirtualFile file) {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(23);
        }
        Map map2 = ourEntries.computeIfAbsent(DockerFileSystem.extractRootPath(file), rootPath -> new ConcurrentHashMap());
        if (map2 == null) {
            DockerFileSystem.$$$reportNull$$$0(24);
        }
        return map2;
    }

    @NotNull
    private static String extractRootPath(@NotNull VirtualFile file) {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(25);
        }
        return DockerFileSystem.extractRootPathImpl(file.getPath());
    }

    public boolean isDirectory(@NotNull VirtualFile file) {
        FileAttributes attributes;
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(26);
        }
        return (attributes = this.getAttributes(file)) != null && attributes.isDirectory();
    }

    public long getTimeStamp(@NotNull VirtualFile file) {
        FileAttributes attributes;
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(27);
        }
        return (attributes = this.getAttributes(file)) != null ? attributes.lastModified : 0L;
    }

    public void setTimeStamp(@NotNull VirtualFile file, long timeStamp) throws IOException {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(28);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file);
    }

    public boolean isWritable(@NotNull VirtualFile file) {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(29);
        }
        return false;
    }

    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) throws IOException {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(30);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            DockerFileSystem.$$$reportNull$$$0(31);
        }
        if (dir == null) {
            DockerFileSystem.$$$reportNull$$$0(32);
        }
        throw DockerFileSystem.createModificationNotSupportedError(parent);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file) throws IOException {
        if (parent == null) {
            DockerFileSystem.$$$reportNull$$$0(33);
        }
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(34);
        }
        throw DockerFileSystem.createModificationNotSupportedError(parent);
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(35);
        }
        return this.disposed ? null : VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(36);
        }
        String string = path;
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(37);
        }
        return string;
    }

    public void refresh(boolean asynchronous) {
        this.refresh(asynchronous, null);
    }

    public void refresh(boolean asynchronous, @Nullable Runnable finishRunnable) {
        if (this.disposed) {
            return;
        }
        ourEntries.remove(this.getRootPath());
        this.processRoots(roots -> {
            RefreshQueue.getInstance().refresh(asynchronous, true, finishRunnable, roots);
            VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])roots);
        });
    }

    @NotNull
    private String getRootPath() {
        String string = FileUtil.sanitizeFileName((String)Objects.requireNonNull(this.myRuntime.getServer()).getName(), (boolean)false) + ":" + this.myRuntime.getId() + ":/";
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(38);
        }
        return string;
    }

    private void processRoots(@NotNull Consumer<VirtualFile[]> rootsProcessor) {
        VirtualFile[] roots;
        if (rootsProcessor == null) {
            DockerFileSystem.$$$reportNull$$$0(39);
        }
        if ((roots = ManagingFS.getInstance().getRoots((NewVirtualFileSystem)this)).length > 0) {
            rootsProcessor.accept(roots);
        }
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(40);
        }
        return this.disposed ? null : VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file) throws IOException {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(41);
        }
        if (requestor != this) {
            throw DockerFileSystem.createModificationNotSupportedError(file);
        }
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) throws IOException {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(42);
        }
        if (newParent == null) {
            DockerFileSystem.$$$reportNull$$$0(43);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file);
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file, @NotNull String newName) throws IOException {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(44);
        }
        if (newName == null) {
            DockerFileSystem.$$$reportNull$$$0(45);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file);
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(46);
        }
        Entry entry = this.disposed ? null : this.getEntry(file);
        return entry != null ? entry.attributes : null;
    }

    @Nullable
    private Entry getEntry(@NotNull VirtualFile file) {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(47);
        }
        return (Entry)DockerFileSystem.getRootEntries(file).computeIfAbsent(this.getPathInsideContainer(file), path -> {
            Pair<String, Entry> parsedEntry;
            String entry = this.execLs('d', (String)path);
            if (entry != null && (parsedEntry = DockerFileSystem.parseLsEntry(entry)) != null) {
                return Ref.create((Object)((Entry)parsedEntry.second));
            }
            return Ref.create();
        }).get();
    }

    public boolean isSymLink(@NotNull VirtualFile file) {
        FileAttributes attributes;
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(48);
        }
        return (attributes = this.getAttributes(file)) != null && attributes.isSymLink();
    }

    public String resolveSymLink(@NotNull VirtualFile file) {
        String target2;
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(49);
        }
        if (this.disposed) {
            return null;
        }
        Entry entry = this.getEntry(file);
        String string = target2 = entry != null ? entry.target : null;
        if (target2 == null || target2.contains(":")) {
            return null;
        }
        if (target2.startsWith("/")) {
            return DockerFileSystem.extractRootPath(file) + target2;
        }
        List pathComponents = StringUtil.split((String)this.getPathInsideContainer(file), (String)"/");
        ArrayList<String> resolvedComponents = pathComponents.size() < 2 ? new ArrayList<String>() : new ArrayList(pathComponents.subList(0, pathComponents.size() - 1));
        for (String targetComponent : StringUtil.split((String)target2, (String)"/")) {
            if ("..".equals(targetComponent)) {
                if (resolvedComponents.isEmpty()) {
                    return null;
                }
                resolvedComponents.remove(resolvedComponents.size() - 1);
                continue;
            }
            if (".".equals(targetComponent)) continue;
            resolvedComponents.add(targetComponent);
        }
        return DockerFileSystem.extractRootPath(file) + "/" + StringUtil.join(resolvedComponents, (String)"/");
    }

    public void dispose() {
        this.disposed = true;
        ApplicationManager.getApplication().invokeLater(() -> this.processRoots(roots -> ApplicationManager.getApplication().runWriteAction(() -> {
            for (VirtualFile root : roots) {
                try {
                    root.delete((Object)this);
                }
                catch (Throwable t) {
                    LOG.warn(t);
                }
            }
        })), ModalityState.defaultModalityState());
    }

    @Nullable
    public VirtualFile getRoot() {
        VirtualFile root = this.findFileByPath(this.getRootPath());
        if (root != null) {
            VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{root});
        }
        return root;
    }

    @NotNull
    public String getPathInsideContainer(@NotNull VirtualFile file) {
        if (file == null) {
            DockerFileSystem.$$$reportNull$$$0(50);
        }
        return DockerFileSystem.getPathInsideContainer(file.getPath());
    }

    @NotNull
    private static String getPathInsideContainer(@NotNull String path) {
        int index;
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(51);
        }
        String pathInsideContainer = (index = path.indexOf(47)) < 0 ? "" : path.substring(index);
        String string = pathInsideContainer.isEmpty() ? "/" : pathInsideContainer;
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getSanitizedContainerName() {
        String containerName = this.myRuntime.getContainerName();
        if (containerName == null) {
            return "";
        }
        String string = FileUtil.sanitizeFileName((String)StringUtil.trimStart((String)containerName, (String)"/"), (boolean)false);
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(53);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 10, 18, 19, 20, 24, 37, 38, 52, 53 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 1: 
            case 35: 
            case 36: 
            case 40: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedPath";
                break;
            }
            case 4: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 37: 
            case 38: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/vfs/DockerFileSystem";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 41: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInsideContainer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsProcessor";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/vfs/DockerFileSystem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRootPathImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootEntries";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPath";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathInsideContainer";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getSanitizedContainerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 2: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPathImpl";
                break;
            }
            case 4: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 37: 
            case 38: 
            case 52: 
            case 53: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createModificationNotSupportedError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createGettingContentsError";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "execLs";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseLsEntry";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRootEntries";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processRoots";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getEntry";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getPathInsideContainer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 10, 18, 19, 20, 24, 37, 38, 52, 53 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static final class Entry {
        @NotNull
        public final FileAttributes attributes;
        @Nullable
        public final String target;

        public Entry(@NotNull FileAttributes attributes, @Nullable String target2) {
            if (attributes == null) {
                Entry.$$$reportNull$$$0(0);
            }
            this.attributes = attributes;
            this.target = target2;
        }

        public int hashCode() {
            return Objects.hash(this.attributes, this.target);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)obj;
            return this.attributes.equals((Object)entry.attributes) && Objects.equals(this.target, entry.target);
        }

        public String toString() {
            return "Entry(attributes: " + String.valueOf(this.attributes) + ", target: " + this.target + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/docker/vfs/DockerFileSystem$Entry", "<init>"));
        }
    }
}

