/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

@Internal
public class AuthSupport {
    public static void extractFromAuthority(String scheme, URIAuthority authority, CredentialsStore credentialsStore) {
        Args.notNull(credentialsStore, "Credentials store");
        if (authority == null) {
            return;
        }
        String userInfo = authority.getUserInfo();
        if (userInfo == null) {
            return;
        }
        int atColon = userInfo.indexOf(58);
        String userName = atColon >= 0 ? userInfo.substring(0, atColon) : userInfo;
        char[] password = atColon >= 0 ? userInfo.substring(atColon + 1).toCharArray() : null;
        credentialsStore.setCredentials(new AuthScope(scheme, authority.getHostName(), authority.getPort(), null, "Basic"), new UsernamePasswordCredentials(userName, password));
    }

    public static HttpHost resolveAuthTarget(HttpRequest request2, HttpRoute route) {
        HttpHost target2;
        Args.notNull(request2, "Request");
        Args.notNull(route, "Route");
        URIAuthority authority = request2.getAuthority();
        String scheme = request2.getScheme();
        HttpHost httpHost = target2 = authority != null ? new HttpHost(scheme, authority) : route.getTargetHost();
        if (target2.getPort() < 0) {
            return new HttpHost(target2.getSchemeName(), target2.getHostName(), route.getTargetHost().getPort());
        }
        return target2;
    }
}

