/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.AsyncLog;
import com.intellij.openapi.diagnostic.LogEvent;
import com.intellij.openapi.diagnostic.LogLevel;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\b\u0010\u0006\u001a\u00020\u0001H\u0007\u001a\b\u0010\u0007\u001a\u00020\u0001H\u0000\"\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"log", "", "Lcom/intellij/openapi/diagnostic/LogEvent;", "logNow", "asyncLog", "Lcom/intellij/openapi/diagnostic/AsyncLog;", "awaitLogQueueProcessed", "shutdownLogProcessing", "intellij.platform.util"})
public final class AsyncLogKt {
    @Nullable
    private static final AsyncLog asyncLog;

    public static final void log(@NotNull LogEvent $this$log) {
        Intrinsics.checkNotNullParameter($this$log, "<this>");
        if (asyncLog != null) {
            asyncLog.log($this$log);
        } else {
            AsyncLogKt.logNow($this$log);
        }
    }

    private static final void logNow(LogEvent $this$logNow) {
        Logger julLogger = $this$logNow.component1();
        LogLevel level = $this$logNow.component2();
        String message = $this$logNow.component3();
        Throwable throwable = $this$logNow.component4();
        if (throwable != null) {
            julLogger.log(level.getLevel(), message, throwable);
        } else {
            julLogger.log(level.getLevel(), message);
        }
    }

    @TestOnly
    @ApiStatus.Internal
    public static final void awaitLogQueueProcessed() {
        block0: {
            AsyncLog asyncLog = AsyncLogKt.asyncLog;
            if (asyncLog == null) break block0;
            asyncLog.awaitQueueProcessed();
        }
    }

    public static final void shutdownLogProcessing() {
        block0: {
            AsyncLog asyncLog = AsyncLogKt.asyncLog;
            if (asyncLog == null) break block0;
            asyncLog.shutdown();
        }
    }

    public static final /* synthetic */ void access$logNow(LogEvent $receiver) {
        AsyncLogKt.logNow($receiver);
    }

    static {
        AsyncLog asyncLog;
        boolean bl = false;
        if (Boolean.getBoolean("intellij.platform.log.sync")) {
            asyncLog = null;
        } else {
            AsyncLog asyncLog2;
            try {
                asyncLog2 = new AsyncLog();
            }
            catch (Throwable throwable) {
                asyncLog2 = null;
            }
            asyncLog = asyncLog2;
        }
        AsyncLogKt.asyncLog = asyncLog;
    }
}

