/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointPriorityListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.Java11Shim;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.UnmodifiableView;

public class KeyedExtensionCollector<T, KeyT>
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance(KeyedExtensionCollector.class);
    @NonNls
    protected final String lock;
    private Map<String, PersistentList<T>> explicitExtensions;
    private volatile @UnmodifiableView Map<String, List<T>> cache;
    private final String epName;
    private final SimpleModificationTracker tracker;
    protected final AtomicBoolean myEpListenerAdded;

    public KeyedExtensionCollector(@NotNull ExtensionPointName<? extends KeyedLazyInstance<T>> epName) {
        if (epName == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(0);
        }
        this(epName.getName());
    }

    public KeyedExtensionCollector(@NotNull String epName) {
        if (epName == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(1);
        }
        this.explicitExtensions = Java11Shim.Companion.getINSTANCE().mapOf();
        this.cache = Java11Shim.Companion.getINSTANCE().mapOf();
        this.tracker = new SimpleModificationTracker();
        this.myEpListenerAdded = new AtomicBoolean();
        this.epName = epName;
        this.lock = "lock for KeyedExtensionCollector " + epName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        String string = this.lock;
        synchronized (string) {
            this.cache = Collections.emptyMap();
            this.tracker.incModificationCount();
        }
    }

    private void addExtensionPointListener(@NotNull @NotNull ExtensionPoint<@NotNull KeyedLazyInstance<T>> point) {
        if (point == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(2);
        }
        if (this.myEpListenerAdded.compareAndSet(false, true)) {
            point.addExtensionPointListener((ExtensionPointListener)new MyExtensionPointListener(), false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateCacheForExtension(@NotNull String key) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(3);
        }
        if (!this.cache.containsKey(key)) {
            return;
        }
        String string = this.lock;
        synchronized (string) {
            this.cache = UtilKt.without(this.cache, key);
            this.tracker.incModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(4);
        }
        if (t == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(5);
        }
        String stringKey = this.keyToString(key);
        String string = this.lock;
        synchronized (string) {
            PersistentList<T> value = this.explicitExtensions.get(stringKey);
            this.explicitExtensions = UtilKt.with(this.explicitExtensions, stringKey, value == null ? ExtensionsKt.persistentListOf((Object[])new Object[]{t}) : value.add(t));
            this.invalidateCacheForExtension(stringKey);
        }
    }

    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t, @NotNull Disposable parentDisposable) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(6);
        }
        if (t == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(8);
        }
        this.addExplicitExtension(key, t);
        Disposer.register(parentDisposable, () -> this.removeExplicitExtension(key, t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(9);
        }
        if (t == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(10);
        }
        String stringKey = this.keyToString(key);
        String string = this.lock;
        synchronized (string) {
            PersistentList list = this.explicitExtensions.get(stringKey);
            if (list != null) {
                this.explicitExtensions = (list = list.remove(t)).isEmpty() ? UtilKt.without(this.explicitExtensions, stringKey) : UtilKt.with(this.explicitExtensions, stringKey, list);
            }
            this.invalidateCacheForExtension(stringKey);
        }
    }

    @NotNull
    protected String keyToString(@NotNull KeyT key) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(11);
        }
        String string = key.toString();
        if (string == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(12);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<T> forKey(@NotNull KeyT key) {
        String stringKey;
        List<T> cached;
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(13);
        }
        if ((cached = this.cache.get(stringKey = this.keyToString(key))) != null) {
            List<T> list = cached;
            if (list != null) return list;
            KeyedExtensionCollector.$$$reportNull$$$0(14);
            return list;
        }
        cached = this.buildExtensions(stringKey, key);
        String string = this.lock;
        // MONITORENTER : string
        List<T> recent = this.cache.get(stringKey);
        if (recent != null) {
            List<T> list = recent;
            // MONITOREXIT : string
            if (list != null) return list;
            KeyedExtensionCollector.$$$reportNull$$$0(15);
            return list;
        }
        this.cache = UtilKt.with(this.cache, stringKey, cached);
        List<T> list = cached;
        // MONITOREXIT : string
        if (list != null) return list;
        KeyedExtensionCollector.$$$reportNull$$$0(16);
        return list;
    }

    public final @UnknownNullability T findSingle(@NotNull KeyT key) {
        List<T> list;
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(17);
        }
        return (list = this.forKey(key)).isEmpty() ? null : (T)list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull KeyT key) {
        if (stringKey == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(18);
        }
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(19);
        }
        List<KeyedLazyInstance<T>> extensions = this.getExtensions();
        String string = this.lock;
        // MONITORENTER : string
        PersistentList<T> explicit = this.explicitExtensions.get(stringKey);
        PersistentList result2 = this.buildExtensionsFromExtensionPoint(bean -> stringKey.equals(bean.getKey()), extensions);
        PersistentList persistentList = explicit == null ? result2 : explicit.addAll(result2);
        // MONITOREXIT : string
        if (persistentList != null) return persistentList;
        KeyedExtensionCollector.$$$reportNull$$$0(20);
        return persistentList;
    }

    @NotNull
    protected final List<KeyedLazyInstance<T>> getExtensions() {
        ExtensionPoint<@NotNull KeyedLazyInstance<T>> point = this.getPoint();
        if (point == null) {
            List<KeyedLazyInstance<T>> list = Java11Shim.Companion.getINSTANCE().listOf();
            if (list == null) {
                KeyedExtensionCollector.$$$reportNull$$$0(21);
            }
            return list;
        }
        this.addExtensionPointListener(point);
        List list = point.getExtensionList();
        if (list == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    final List<T> buildExtensionsFromExtensionPoint(@NotNull Predicate<? super KeyedLazyInstance<T>> isMyBean, @NotNull List<? extends KeyedLazyInstance<T>> extensions) {
        if (isMyBean == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(23);
        }
        if (extensions == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(24);
        }
        ArrayList<T> result2 = null;
        Object r1 = null;
        Object r2 = null;
        for (KeyedLazyInstance<T> bean : extensions) {
            T instance;
            if (!isMyBean.test(bean) || (instance = KeyedExtensionCollector.instantiate(bean)) == null) continue;
            if (result2 != null) {
                result2.add(instance);
                continue;
            }
            if (r1 == null) {
                r1 = instance;
                continue;
            }
            if (r2 == null) {
                r2 = instance;
                continue;
            }
            result2 = new ArrayList<T>();
            result2.add(r1);
            result2.add(r2);
            result2.add(instance);
        }
        if (result2 != null) {
            ArrayList<T> arrayList = result2;
            if (arrayList == null) {
                KeyedExtensionCollector.$$$reportNull$$$0(25);
            }
            return arrayList;
        }
        if (r2 != null) {
            List<Object> list = Java11Shim.Companion.getINSTANCE().listOf(r1, r2);
            if (list == null) {
                KeyedExtensionCollector.$$$reportNull$$$0(26);
            }
            return list;
        }
        if (r1 != null) {
            List<Object> list = Java11Shim.Companion.getINSTANCE().listOf(r1);
            if (list == null) {
                KeyedExtensionCollector.$$$reportNull$$$0(27);
            }
            return list;
        }
        List list = Java11Shim.Companion.getINSTANCE().listOf();
        if (list == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(28);
        }
        return list;
    }

    @Nullable
    public static <T> T instantiate(@NotNull KeyedLazyInstance<T> bean) {
        if (bean == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(29);
        }
        try {
            return (T)bean.getInstance();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (ExtensionNotApplicableException ignore) {
            return null;
        }
        catch (Exception | LinkageError e) {
            LOG.error(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected final List<T> buildExtensions(@NotNull Set<String> keys2) {
        if (keys2 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(30);
        }
        List<KeyedLazyInstance<T>> extensions = this.getExtensions();
        String string = this.lock;
        // MONITORENTER : string
        List<T> explicit = this.buildExtensionsFromExplicitRegistration(keys2::contains);
        List<T> result2 = this.buildExtensionsFromExtensionPoint(bean -> {
            String key;
            try {
                key = bean.getKey();
            }
            catch (IllegalStateException e) {
                LOG.error(e);
                return false;
            }
            return keys2.contains(key);
        }, extensions);
        PersistentList persistentList = ExtensionsKt.toPersistentList(explicit).addAll(result2);
        // MONITOREXIT : string
        if (persistentList != null) return persistentList;
        KeyedExtensionCollector.$$$reportNull$$$0(31);
        return persistentList;
    }

    @NotNull
    protected final List<T> buildExtensionsFromExplicitRegistration(@NotNull Predicate<? super String> isMyBean) {
        if (isMyBean == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(32);
        }
        PersistentList result2 = ExtensionsKt.persistentListOf();
        for (Map.Entry<String, PersistentList<T>> entry : this.explicitExtensions.entrySet()) {
            String key = entry.getKey();
            if (!isMyBean.test(key)) continue;
            result2 = result2.addAll((Collection)entry.getValue());
        }
        PersistentList persistentList = result2;
        if (persistentList == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(33);
        }
        return persistentList;
    }

    @ApiStatus.Internal
    public final @Nullable ExtensionPoint<@NotNull KeyedLazyInstance<T>> getPoint() {
        return Extensions.getRootArea().getExtensionPointIfRegistered(this.epName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyExtensions() {
        String string = this.lock;
        synchronized (string) {
            if (!this.explicitExtensions.isEmpty()) {
                return true;
            }
        }
        ExtensionPoint<@NotNull KeyedLazyInstance<T>> point = this.getPoint();
        return point != null && point.size() != 0;
    }

    @NotNull
    public String getName() {
        String string = this.epName;
        if (string == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(34);
        }
        return string;
    }

    @Override
    public long getModificationCount() {
        return this.tracker.getModificationCount();
    }

    protected void ensureValuesLoaded() {
        ExtensionPoint<@NotNull KeyedLazyInstance<T>> point = this.getPoint();
        if (point != null) {
            for (KeyedLazyInstance bean : point.getExtensionList()) {
                bean.getInstance();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/KeyedExtensionCollector";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringKey";
                break;
            }
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isMyBean";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionCollector";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "keyToString";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "forKey";
                break;
            }
            case 20: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensions";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensionsFromExtensionPoint";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensionsFromExplicitRegistration";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPointListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invalidateCacheForExtension";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeExplicitExtension";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "keyToString";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "forKey";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findSingle";
                break;
            }
            case 18: 
            case 19: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensions";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensionsFromExtensionPoint";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensionsFromExplicitRegistration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyExtensionPointListener
    implements ExtensionPointAndAreaListener<KeyedLazyInstance<T>>,
    ExtensionPointPriorityListener {
        private MyExtensionPointListener() {
        }

        public void extensionAdded(@NotNull KeyedLazyInstance<T> bean, @NotNull PluginDescriptor pluginDescriptor) {
            if (bean == null) {
                MyExtensionPointListener.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                MyExtensionPointListener.$$$reportNull$$$0(1);
            }
            if (bean.getKey() == null) {
                throw new PluginException("No key specified for extension of class " + bean.getInstance().getClass(), pluginDescriptor.getPluginId());
            }
            KeyedExtensionCollector.this.invalidateCacheForExtension(bean.getKey());
        }

        public void extensionRemoved(@NotNull KeyedLazyInstance<T> bean, @NotNull PluginDescriptor pluginDescriptor) {
            if (bean == null) {
                MyExtensionPointListener.$$$reportNull$$$0(2);
            }
            if (pluginDescriptor == null) {
                MyExtensionPointListener.$$$reportNull$$$0(3);
            }
            KeyedExtensionCollector.this.invalidateCacheForExtension(bean.getKey());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void areaReplaced(@NotNull ExtensionsArea area) {
            if (area == null) {
                MyExtensionPointListener.$$$reportNull$$$0(4);
            }
            String string = KeyedExtensionCollector.this.lock;
            synchronized (string) {
                KeyedExtensionCollector.this.cache = Java11Shim.Companion.getINSTANCE().mapOf();
                KeyedExtensionCollector.this.tracker.incModificationCount();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionCollector$MyExtensionPointListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionRemoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "areaReplaced";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

