/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageQueue;
import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u001a\u0010\u0015\u001a\u00020\u00132\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/messages/impl/RootBus;", "Lcom/intellij/util/messages/impl/CompositeMessageBus;", "owner", "Lcom/intellij/util/messages/MessageBusOwner;", "<init>", "(Lcom/intellij/util/messages/MessageBusOwner;)V", "compactionFutureRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/CompletableFuture;", "compactionRequest", "Ljava/util/concurrent/atomic/AtomicInteger;", "emptyConnectionCounter", "queueThreadLocal", "Ljava/lang/ThreadLocal;", "Lcom/intellij/util/messages/impl/MessageQueue;", "queue", "getQueue$intellij_platform_core", "()Lcom/intellij/util/messages/impl/MessageQueue;", "scheduleEmptyConnectionRemoving", "", "dispose", "removeDisposedHandlers", "topic", "Lcom/intellij/util/messages/Topic;", "handler", "", "intellij.platform.core"})
@ApiStatus.Internal
@VisibleForTesting
public final class RootBus
extends CompositeMessageBus {
    @NotNull
    private final AtomicReference<CompletableFuture<?>> compactionFutureRef;
    @NotNull
    private final AtomicInteger compactionRequest;
    @NotNull
    private final AtomicInteger emptyConnectionCounter;
    @NotNull
    private final ThreadLocal<MessageQueue> queueThreadLocal;

    public RootBus(@NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        super(owner);
        this.compactionFutureRef = new AtomicReference();
        this.compactionRequest = new AtomicInteger();
        this.emptyConnectionCounter = new AtomicInteger();
        ThreadLocal<MessageQueue> threadLocal = ThreadLocal.withInitial(RootBus::queueThreadLocal$lambda$0);
        Intrinsics.checkNotNullExpressionValue(threadLocal, "withInitial(...)");
        this.queueThreadLocal = threadLocal;
    }

    @NotNull
    public final MessageQueue getQueue$intellij_platform_core() {
        MessageQueue messageQueue = this.queueThreadLocal.get();
        Intrinsics.checkNotNullExpressionValue(messageQueue, "get(...)");
        return messageQueue;
    }

    public final void scheduleEmptyConnectionRemoving() {
        int counter = this.emptyConnectionCounter.incrementAndGet();
        if (counter < 128 || !this.emptyConnectionCounter.compareAndSet(counter, 0)) {
            return;
        }
        if (this.compactionRequest.incrementAndGet() == 1) {
            this.compactionFutureRef.set(CompletableFuture.runAsync(() -> RootBus.scheduleEmptyConnectionRemoving$lambda$1(this), AppExecutorUtil.getAppExecutorService()));
        }
    }

    @Override
    public void dispose() {
        CompletableFuture compactionFuture;
        CompletableFuture completableFuture = compactionFuture = (CompletableFuture)this.compactionFutureRef.getAndSet(null);
        if (completableFuture != null) {
            completableFuture.cancel(false);
        }
        this.compactionRequest.set(0);
        super.dispose();
    }

    public final void removeDisposedHandlers(@NotNull Topic<?> topic, @NotNull Object handler) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(handler, "handler");
        ArrayDeque<Message> queue = this.getQueue$intellij_platform_core().queue;
        if (queue.isEmpty()) {
            return;
        }
        queue.removeIf(arg_0 -> RootBus.removeDisposedHandlers$lambda$3(arg_0 -> RootBus.removeDisposedHandlers$lambda$2(topic, handler, arg_0), arg_0));
    }

    private static final MessageQueue queueThreadLocal$lambda$0() {
        return new MessageQueue();
    }

    private static final void scheduleEmptyConnectionRemoving$lambda$1(RootBus this$0) {
        int request = 0;
        do {
            request = this$0.compactionRequest.get();
            this$0.removeEmptyConnectionsRecursively();
        } while (!this$0.compactionRequest.compareAndSet(request, 0));
    }

    private static final boolean removeDisposedHandlers$lambda$2(Topic $topic, Object $handler, Message message) {
        int n = message.handlers.length;
        for (int messageIndex = 0; messageIndex < n; ++messageIndex) {
            Object messageHandler;
            if (message.handlers[messageIndex] == null) {
                return false;
            }
            if (message.topic != $topic || messageHandler != $handler) continue;
            message.handlers[messageIndex] = null;
            return message.handlers.length == 1;
        }
        return false;
    }

    private static final boolean removeDisposedHandlers$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

