/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.connector;

import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.connector.Lsp4jServerConnector;
import com.intellij.platform.lsp.impl.connector.LspServerProcessListener;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0013H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0013H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/lsp/impl/connector/Lsp4jServerConnectorStdio;", "Lcom/intellij/platform/lsp/impl/connector/Lsp4jServerConnector;", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "Lsp4jServerConnectorStdio", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;)V", "processHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "processListener", "Lcom/intellij/platform/lsp/impl/connector/LspServerProcessListener;", "ideToServerStream", "Ljava/io/OutputStream;", "getIdeToServerStream", "()Ljava/io/OutputStream;", "serverToIdeStream", "Ljava/io/InputStream;", "getServerToIdeStream", "()Ljava/io/InputStream;", "prepareConnect", "", "startNotify", "isConnectionAlive", "", "disconnect", "intellij.platform.lsp.impl"})
public final class Lsp4jServerConnectorStdio
extends Lsp4jServerConnector {
    @NotNull
    private final LspServerImpl lspServer;
    @NotNull
    private final OSProcessHandler processHandler;
    @NotNull
    private final LspServerProcessListener processListener;
    @NotNull
    private final OutputStream ideToServerStream;
    @NotNull
    private final InputStream serverToIdeStream;

    public Lsp4jServerConnectorStdio(@NotNull LspServerImpl lspServer) {
        LspServerProcessListener lspServerProcessListener;
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        super(lspServer);
        this.lspServer = lspServer;
        this.processHandler = this.lspServer.getDescriptor().startServerProcess();
        LspServerProcessListener lspServerProcessListener2 = lspServerProcessListener = new LspServerProcessListener(this.lspServer);
        Lsp4jServerConnectorStdio lsp4jServerConnectorStdio = this;
        boolean bl = false;
        this.processHandler.addProcessListener((ProcessListener)lspServerProcessListener2);
        lsp4jServerConnectorStdio.processListener = lspServerProcessListener;
        OutputStream outputStream = this.processHandler.getProcessInput();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getProcessInput(...)");
        this.ideToServerStream = outputStream;
        this.serverToIdeStream = this.processListener.getPipedInputStream();
    }

    @Override
    @NotNull
    protected OutputStream getIdeToServerStream() {
        return this.ideToServerStream;
    }

    @Override
    @NotNull
    protected InputStream getServerToIdeStream() {
        return this.serverToIdeStream;
    }

    @Override
    protected void prepareConnect() {
    }

    @Override
    protected void startNotify() {
        this.processHandler.startNotify();
    }

    @Override
    protected boolean isConnectionAlive() {
        return this.processHandler.isStartNotified() && !this.processHandler.isProcessTerminated();
    }

    @Override
    protected void disconnect() {
        if (!this.processHandler.isProcessTerminated()) {
            this.lspServer.logInfo$intellij_platform_lsp_impl("Stopping LSP server process: " + this.processHandler.getCommandLineForLog());
            ExecutionManagerImpl.Companion.stopProcess((ProcessHandler)this.processHandler);
        }
    }
}

