/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Getter;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableCellState;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DbExpertOptionsEditor<Target> {
    private final TableView<DbOptionsValues.OptionValue<Target, ?>> myTable;
    private final ListTableModel<DbOptionsValues.OptionValue<Target, ?>> myModel;
    private final DbOptionsValues<Target> myAllValues;
    private final DataContext myDataContext;
    private final Splitter myPanel;
    private final JEditorPane myDescription;
    private final Supplier<Target> myTempTarget;

    public DbExpertOptionsEditor(Class<Target> targetClass, Supplier<Target> tempTarget, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            DbExpertOptionsEditor.$$$reportNull$$$0(0);
        }
        this.myTempTarget = tempTarget;
        this.myAllValues = new DbOptionsValues<Target>(targetClass, t -> t.getLocation() == DbOptionProvider.UiLocation.EXPERT);
        this.myDataContext = dataContext;
        this.myModel = new ListTableModel(new ColumnInfo[]{new NameColumnInfo(), new ValueColumnInfo()});
        this.myTable = new TableView(this.myModel);
        this.myTable.getColumnModel().getColumn(1).setPreferredWidth(JBUI.scale((int)120));
        this.myTable.getEmptyText().setText(DatabaseBundle.message("status.text.not.expert.options.available", new Object[0]));
        this.myPanel = new Splitter(true, 0.7f);
        this.myPanel.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane(this.myTable, (boolean)true));
        this.myDescription = new JEditorPane("text/html", "");
        this.myDescription.setEditorKit(HTMLEditorKitBuilder.simple());
        this.myDescription.setEditable(false);
        this.myDescription.setPreferredSize((Dimension)JBUI.size((int)100, (int)100));
        this.myPanel.setSecondComponent((JComponent)this.myDescription);
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
        this.updateDescription();
        this.myTable.getSelectionModel().addListSelectionListener(e -> this.updateDescription());
    }

    private void updateDescription() {
        DbOptionsValues.OptionValue v = (DbOptionsValues.OptionValue)this.myTable.getSelectedObject();
        this.myDescription.setText(v == null ? DatabaseBundle.message("select.option.to.see.description", new Object[0]) : v.provider.getDescription());
    }

    public void updateList(Target target2) {
        this.myModel.setItems(new ArrayList(this.myAllValues.getFiltered(target2)));
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    public void apply(Target target2) {
        this.myAllValues.apply(target2);
    }

    public void reset(Target target2) {
        this.myAllValues.reset(target2);
        this.updateList(target2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dataSource/ui/DbExpertOptionsEditor", "<init>"));
    }

    public static class DbOptionsValues<Target> {
        private final List<OptionValue<Target, ?>> myAllValues;

        public DbOptionsValues(Class<Target> targetClass, Condition<DbOptionProvider<Target, ?>> initialCondition) {
            this.myAllValues = ContainerUtil.newArrayList((Iterable)DbOptionProvider.getProviders(targetClass).filter(initialCondition).map(p2 -> OptionValue.create(p2, null)));
            this.myAllValues.sort(Comparator.comparing(o -> o.provider.getDisplayName()));
        }

        public void apply(Target target2) {
            for (OptionValue<Target, ?> value : this.myAllValues) {
                value.apply(target2);
            }
        }

        public void reset(Target target2) {
            for (OptionValue<Target, ?> value : this.myAllValues) {
                value.reset(target2);
            }
        }

        @NotNull
        public @Unmodifiable List<OptionValue<Target, ?>> getFiltered(Target target2) {
            List list = ContainerUtil.filter(this.myAllValues, v -> v.provider.isApplicable(target2));
            if (list == null) {
                DbOptionsValues.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/ui/DbExpertOptionsEditor$DbOptionsValues", "getFiltered"));
        }

        public static final class OptionValue<Target, T> {
            public final DbOptionProvider<Target, T> provider;
            public T value;

            public void assign(OptionValue<Target, ?> v) {
                if (v.provider == this.provider) {
                    this.value = v.value;
                }
            }

            public void apply(Target target2) {
                this.provider.store(target2, this.value);
            }

            public void reset(Target target2) {
                this.value = this.provider.load(target2);
            }

            private static <Target, T> OptionValue<Target, T> create(DbOptionProvider<Target, T> provider, Target target2) {
                return new OptionValue<Target, T>(provider, provider.load(target2));
            }

            private OptionValue(DbOptionProvider<Target, T> provider, T value) {
                this.provider = provider;
                this.value = value;
            }

            public DbOptionProvider.EditorDesc<OptionValue<Target, T>> getComponent(Target target2, @NotNull DataContext dataContext) {
                DbOptionProvider.EditorDesc<T> editor2;
                if (dataContext == null) {
                    OptionValue.$$$reportNull$$$0(0);
                }
                if ((editor2 = this.provider.getEditor(target2, dataContext)) == null) {
                    return null;
                }
                editor2.setter.set(this.value);
                return new DbOptionProvider.EditorDesc<OptionValue<Target, T>>(editor2.component, v -> editor2.setter.set(v.value), () -> new OptionValue<Target, Object>(this.provider, editor2.getter.get()), editor2.changed);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dataSource/ui/DbExpertOptionsEditor$DbOptionsValues$OptionValue", "getComponent"));
            }
        }
    }

    private class NameColumnInfo
    extends ColumnInfo<DbOptionsValues.OptionValue<Target, ?>, DbOptionsValues.OptionValue<Target, ?>> {
        private NameColumnInfo() {
            super(DatabaseBundle.message("expert.properties.column.name.name", new Object[0]));
        }

        @Nullable
        public DbOptionsValues.OptionValue<Target, ?> valueOf(DbOptionsValues.OptionValue<Target, ?> value) {
            return value;
        }

        @Nullable
        public TableCellRenderer getRenderer(DbOptionsValues.OptionValue<Target, ?> value) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column2) {
                    DbOptionsValues.OptionValue ov;
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DbOptionsValues.OptionValue optionValue = ov = value instanceof DbOptionsValues.OptionValue ? (DbOptionsValues.OptionValue)value : null;
                    if (ov != null) {
                        Object defVal = ov.provider.load(null);
                        SimpleTextAttributes attributes = Objects.equals(defVal, ov.value) ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                        this.append(UIUtil.removeMnemonic((String)ov.provider.getDisplayName()), attributes);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dataSource/ui/DbExpertOptionsEditor$NameColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }
    }

    private class ValueColumnInfo
    extends ColumnInfo<DbOptionsValues.OptionValue<Target, ?>, DbOptionsValues.OptionValue<Target, ?>> {
        private final AbstractTableCellEditor myEditor;
        private final TableCellRenderer myRenderer;

        private ValueColumnInfo() {
            super(DatabaseBundle.message("expert.properties.column.name.value", new Object[0]));
            this.myEditor = new AbstractTableCellEditor(){
                private Getter<DbOptionsValues.OptionValue<Target, Object>> myGetter;

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column2) {
                    DbOptionProvider.EditorDesc component = ValueColumnInfo.this.getEditor(table, value, true, true);
                    this.myGetter = component == null ? null : component.getter;
                    return component == null ? new JBLabel(AllIcons.General.Error) : component.component;
                }

                public Object getCellEditorValue() {
                    return this.myGetter == null ? null : this.myGetter.get();
                }
            };
            this.myRenderer = new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column2) {
                    DbOptionProvider.EditorDesc editor2 = ValueColumnInfo.this.getEditor(table, value, isSelected, hasFocus);
                    return editor2 == null ? new JBLabel(AllIcons.General.Error) : editor2.component;
                }
            };
        }

        private DbOptionProvider.EditorDesc<DbOptionsValues.OptionValue<Target, Object>> getEditor(JTable table, Object value, boolean isSelected, boolean hasFocus) {
            if (!(value instanceof DbOptionsValues.OptionValue)) {
                return null;
            }
            DbOptionsValues.OptionValue editedValue = (DbOptionsValues.OptionValue)value;
            DbOptionProvider.EditorDesc editor2 = editedValue.getComponent(DbExpertOptionsEditor.this.myTempTarget.get(), DbExpertOptionsEditor.this.myDataContext);
            TableCellState state = new TableCellState();
            state.collectState(table, isSelected, hasFocus, 0, 0);
            if (editor2 != null) {
                state.updateRenderer(editor2.component);
                editor2.changed.set(() -> this.setValue(editedValue, (DbOptionsValues.OptionValue)editor2.getter.get()));
            }
            return editor2;
        }

        @Nullable
        public DbOptionsValues.OptionValue<Target, ?> valueOf(DbOptionsValues.OptionValue<Target, ?> value) {
            return value;
        }

        public void setValue(DbOptionsValues.OptionValue<Target, ?> value, DbOptionsValues.OptionValue<Target, ?> value2) {
            value.assign(value2);
        }

        public TableCellRenderer getRenderer(DbOptionsValues.OptionValue<Target, ?> value) {
            return this.myRenderer;
        }

        public TableCellEditor getEditor(DbOptionsValues.OptionValue<Target, ?> value) {
            return this.myEditor;
        }

        public boolean isCellEditable(DbOptionsValues.OptionValue<Target, ?> value) {
            return true;
        }
    }
}

