/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.diagnostic.DiagnosticMonitor;
import com.intellij.database.dialects.SqlAffectAnalyzer;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.introspection.AffectedObjectScriptedMention;
import com.intellij.database.introspection.BelongingAreaKind;
import com.intellij.database.introspection.Impactees;
import com.intellij.database.introspection.ObjectEffectType;
import com.intellij.database.introspection.ScriptedName;
import com.intellij.database.introspection.ScriptedNameFun;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.common.NumberFun;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCallStatement;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlDropStatementImpl;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u001e\u0010\u000f\u001a\u00060\u0010R\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0017\u001a\u00020\u0014H\u0014\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "Lcom/intellij/database/dialects/SqlAffectAnalyzer;", "<init>", "()V", "determineAffectedObjects", "Lcom/intellij/database/introspection/Impactees;", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "script", "", "Lcom/intellij/psi/PsiElement;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "describeScript", "", "prepareDeterminer", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "dbms", "Lcom/intellij/database/Dbms;", "refineObjectKind", "Lcom/intellij/database/model/ObjectKind;", "statement", "Lcom/intellij/sql/psi/SqlDdlStatement;", "objectKind", "determineBelongingKind", "Lcom/intellij/database/introspection/BelongingAreaKind;", "Determiner", "SingleDatabaseDeterminer", "MultiDatabaseDeterminer", "Companion", "intellij.database.dialects.base"})
public class BaseAffectAnalyzer
implements SqlAffectAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Impactees determineAffectedObjects(@NotNull DasDataSource dataSource, @NotNull List<? extends PsiElement> script2, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter(script2, (String)"script");
        if (script2.isEmpty()) {
            return Impactees.EMPTY;
        }
        Dbms dbms = dataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Determiner determiner = this.prepareDeterminer(dbms, searchPath);
        for (PsiElement psiElement : script2) {
            determiner.analyze(psiElement);
        }
        Impactees impactees = determiner.getImpactees();
        String string = dataSource.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        DiagnosticMonitor.record$default(DiagnosticMonitor.INSTANCE, string, false, () -> BaseAffectAnalyzer.determineAffectedObjects$lambda$0(this, script2, impactees), 2, null);
        return impactees;
    }

    private final String describeScript(List<? extends PsiElement> script2) {
        return NumberFun.toStringWithUnits(script2.size(), "statement") + ":" + CollectionsKt.joinToString$default((Iterable)script2, (CharSequence)"", null, null, (int)0, null, BaseAffectAnalyzer::describeScript$lambda$1, (int)30, null);
    }

    @NotNull
    protected Determiner prepareDeterminer(@NotNull Dbms dbms, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return ModelFun.isMultiDatabase(dbms) ? (Determiner)new MultiDatabaseDeterminer(searchPath) : (Determiner)new SingleDatabaseDeterminer(searchPath);
    }

    @NotNull
    protected ObjectKind refineObjectKind(@NotNull SqlDdlStatement statement2, @NotNull ObjectKind objectKind) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        return objectKind;
    }

    @Nullable
    protected BelongingAreaKind determineBelongingKind(@NotNull ObjectKind objectKind) {
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        return null;
    }

    private static final CharSequence determineAffectedObjects$lambda$0(BaseAffectAnalyzer this$0, List $script, Impactees $impactees) {
        String scriptDescription = this$0.describeScript($script);
        String impactDescription = $impactees.toString();
        return StringsKt.trimMargin$default((String)("|Analysing script: " + StringsKt.replace$default((String)scriptDescription, (String)"\n", (String)"\n\t", (boolean)false, (int)4, null) + "\n         |Determined impact: " + StringsKt.replace$default((String)impactDescription, (String)"\n", (String)"\n\t", (boolean)false, (int)4, null) + "\n      "), null, (int)1, null);
    }

    private static final CharSequence describeScript$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\n\t- " + it.getClass().getSimpleName();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u0006*\u00020\u0006H\u0086\b\u00a2\u0006\u0002\u0010\u0007J0\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Companion;", "", "<init>", "()V", "child", "P", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "parseQualifiedIdentifier", "", "Lcom/intellij/database/introspection/ScriptedName;", "str", "", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "project", "Lcom/intellij/openapi/project/Project;", "skip", "", "intellij.database.dialects.base"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <P extends PsiElement> P child(PsiElement $this$child) {
            Intrinsics.checkNotNullParameter((Object)$this$child, (String)"<this>");
            boolean $i$f$child = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"P");
            return (P)PsiTreeUtil.findChildOfType((PsiElement)$this$child, PsiElement.class, (boolean)false);
        }

        @Nullable
        public final List<ScriptedName> parseQualifiedIdentifier(@NotNull String str, @NotNull SqlLanguageDialect dialect, @NotNull Project project, int skip) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List<ScriptedName> parsedNames = com.intellij.database.dialects.base.BaseAffectAnalyzer$Companion.parseQualifiedIdentifier$lexQualifiedIdentifier(dialect, project, str);
            if (parsedNames.size() <= skip) {
                return null;
            }
            List<ScriptedName> adjustedNames = skip <= 0 ? parsedNames : parsedNames.subList(0, parsedNames.size() - skip);
            return CollectionsKt.asReversed(adjustedNames);
        }

        public static /* synthetic */ List parseQualifiedIdentifier$default(Companion companion, String string, SqlLanguageDialect sqlLanguageDialect, Project project, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = 0;
            }
            return companion.parseQualifiedIdentifier(string, sqlLanguageDialect, project, n);
        }

        private static final boolean parseQualifiedIdentifier$lexQualifiedIdentifier$lambda$0$isIdent(IElementType type) {
            return Intrinsics.areEqual((Object)type, (Object)SqlTokens.SQL_IDENT) || Intrinsics.areEqual((Object)type, (Object)SqlTokens.SQL_IDENT_DELIMITED) || type instanceof SqlIdentifierKeywordTokenType || type instanceof SqlKeywordTokenType;
        }

        private static final List<ScriptedName> parseQualifiedIdentifier$lexQualifiedIdentifier(SqlLanguageDialect $dialect, Project $project, String $str) {
            List list;
            List $this$parseQualifiedIdentifier_u24lexQualifiedIdentifier_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            Dbms dbms = $dialect.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            NamingService ns = NamingServices.getNamingService$default(dbms2, null, null, 6, null);
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(dbms2);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
            SqlLanguageDialect language = sqlLanguageDialect;
            Lexer lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language)).createLexer($project);
            Intrinsics.checkNotNullExpressionValue((Object)lexer, (String)"createLexer(...)");
            Lexer lexer2 = lexer;
            lexer2.start((CharSequence)$str);
            boolean afterDot = false;
            while (lexer2.getTokenType() != null) {
                IElementType type = lexer2.getTokenType();
                if (com.intellij.database.dialects.base.BaseAffectAnalyzer$Companion.parseQualifiedIdentifier$lexQualifiedIdentifier$lambda$0$isIdent(type)) {
                    String text2;
                    Intrinsics.checkNotNullExpressionValue((Object)lexer2.getTokenText(), (String)"getTokenText(...)");
                    $this$parseQualifiedIdentifier_u24lexQualifiedIdentifier_u24lambda_u240.add(new ScriptedName(ns.unquoteIdentifier(text2), ns.isQuoted(text2)));
                }
                if (Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_PERIOD) && afterDot) {
                    $this$parseQualifiedIdentifier_u24lexQualifiedIdentifier_u24lambda_u240.add(ScriptedName.Companion.getUnspecified());
                }
                afterDot = Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_PERIOD);
                lexer2.advance();
            }
            return CollectionsKt.build((List)list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0017H\u0014J8\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010!\u001a\u00020\"H\u0004J&\u0010#\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0004J0\u0010#\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010(\u001a\u0004\u0018\u00010 2\b\u0010&\u001a\u0004\u0018\u00010'H\u0004J\u0012\u0010)\u001a\u00020\u00052\b\u0010*\u001a\u0004\u0018\u00010+H$J\b\u0010,\u001a\u00020-H&\u00a8\u0006."}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "", "<init>", "(Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;)V", "analyze", "", "statement", "Lcom/intellij/psi/PsiElement;", "analyzeBatchBlock", "block", "Lcom/intellij/sql/psi/SqlBatchBlock;", "analyzeStatement", "Lcom/intellij/sql/psi/SqlStatement;", "analyzeDdlStatement", "Lcom/intellij/sql/psi/SqlDdlStatement;", "analyzeCreateStatement", "Lcom/intellij/sql/psi/SqlCreateStatement;", "analyzeGenericCreateStatement", "analyzeAlterStatement", "Lcom/intellij/sql/psi/SqlAlterStatement;", "analyzeCallStatement", "Lcom/intellij/sql/psi/SqlCallStatement;", "analyzeDropStatement", "Lcom/intellij/sql/psi/impl/SqlDropStatementImpl;", "handleIdentifier", "actionType", "Lcom/intellij/database/introspection/ObjectEffectType;", "belongingAreaKind", "Lcom/intellij/database/introspection/BelongingAreaKind;", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "identifierElement", "Lcom/intellij/sql/psi/SqlNameElement;", "skipNames", "", "handleRename", "oldReference", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "newIdentifierElement", "Lcom/intellij/sql/psi/SqlElement;", "oldIdentifierElement", "acceptObject", "mention", "Lcom/intellij/database/introspection/AffectedObjectScriptedMention;", "getImpactees", "Lcom/intellij/database/introspection/Impactees;", "intellij.database.dialects.base"})
    protected abstract class Determiner {
        public void analyze(@NotNull PsiElement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            PsiElement psiElement = statement2;
            if (psiElement instanceof SqlBatchBlock) {
                this.analyzeBatchBlock((SqlBatchBlock)statement2);
            } else if (psiElement instanceof SqlStatement) {
                this.analyzeStatement((SqlStatement)statement2);
            }
        }

        protected void analyzeBatchBlock(@NotNull SqlBatchBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            for (PsiElement innerElement : block.getChildren()) {
                this.analyze(innerElement);
            }
        }

        protected void analyzeStatement(@NotNull SqlStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            SqlStatement sqlStatement = statement2;
            if (sqlStatement instanceof SqlDdlStatement) {
                this.analyzeDdlStatement((SqlDdlStatement)statement2);
            } else if (sqlStatement instanceof SqlCallStatement) {
                this.analyzeCallStatement((SqlCallStatement)statement2);
            }
        }

        protected void analyzeDdlStatement(@NotNull SqlDdlStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            SqlDdlStatement sqlDdlStatement = statement2;
            if (sqlDdlStatement instanceof SqlCreateStatement) {
                this.analyzeCreateStatement((SqlCreateStatement)statement2);
            } else if (sqlDdlStatement instanceof SqlAlterStatement) {
                this.analyzeAlterStatement((SqlAlterStatement)statement2);
            } else if (sqlDdlStatement instanceof SqlDropStatementImpl) {
                this.analyzeDropStatement((SqlDropStatementImpl)statement2);
            }
        }

        protected void analyzeCreateStatement(@NotNull SqlCreateStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            SqlCreateStatement sqlCreateStatement = statement2;
            if (sqlCreateStatement instanceof SqlCreateIndexStatement) {
                Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_ALTERED, BelongingAreaKind.A_SCHEMA, ObjectKind.TABLE, (SqlNameElement)((SqlCreateIndexStatement)statement2).getTargetReference(), 0, 16, null);
            } else if (sqlCreateStatement instanceof SqlCreateTriggerStatement) {
                Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_ALTERED, BelongingAreaKind.A_SCHEMA, ObjectKind.TABLE, (SqlNameElement)((SqlCreateTriggerStatement)statement2).getTargetContextExpression(), 0, 16, null);
            } else {
                this.analyzeGenericCreateStatement(statement2);
            }
        }

        private final void analyzeGenericCreateStatement(SqlCreateStatement statement2) {
            SqlDdlStatement sqlDdlStatement = (SqlDdlStatement)statement2;
            ObjectKind objectKind = statement2.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
            ObjectKind kind = BaseAffectAnalyzer.this.refineObjectKind(sqlDdlStatement, objectKind);
            BelongingAreaKind belongingAreaKind = BaseAffectAnalyzer.this.determineBelongingKind(kind);
            Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_CREATED, belongingAreaKind, kind, statement2.getNameElement(), 0, 16, null);
        }

        protected void analyzeAlterStatement(@NotNull SqlAlterStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            SqlReferenceExpression sqlReferenceExpression = statement2.getAlterTargetReference();
            if (sqlReferenceExpression == null) {
                return;
            }
            SqlReferenceExpression objectRef = sqlReferenceExpression;
            ObjectKind objectKind = objectRef.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
            ObjectKind kind = objectKind;
            kind = BaseAffectAnalyzer.this.refineObjectKind((SqlDdlStatement)statement2, kind);
            BelongingAreaKind belongingAreaKind = BaseAffectAnalyzer.this.determineBelongingKind(kind);
            Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_ALTERED, belongingAreaKind, kind, (SqlNameElement)objectRef, 0, 16, null);
        }

        protected void analyzeCallStatement(@NotNull SqlCallStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        }

        protected void analyzeDropStatement(@NotNull SqlDropStatementImpl statement2) {
            Intrinsics.checkNotNullParameter((Object)((Object)statement2), (String)"statement");
            ObjectKind objectKind = statement2.getTargetType();
            if (objectKind == null) {
                ObjectKind objectKind2 = ObjectKind.UNKNOWN_OBJECT;
                objectKind = objectKind2;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"UNKNOWN_OBJECT");
            }
            ObjectKind kind = objectKind;
            kind = BaseAffectAnalyzer.this.refineObjectKind((SqlDdlStatement)statement2, kind);
            BelongingAreaKind belongingAreaKind = BaseAffectAnalyzer.this.determineBelongingKind(kind);
            SqlReferenceExpression identifierElement = statement2.getTargetExpression();
            Determiner.handleIdentifier$default(this, ObjectEffectType.WAS_DROPPED, belongingAreaKind, kind, (SqlNameElement)identifierElement, 0, 16, null);
        }

        protected final void handleIdentifier(@NotNull ObjectEffectType actionType, @Nullable BelongingAreaKind belongingAreaKind, @Nullable ObjectKind objectKind, @Nullable SqlNameElement identifierElement, int skipNames) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            if (identifierElement == null) {
                return;
            }
            String identifierText = identifierElement.getText();
            Language language = identifierElement.getLanguage();
            SqlLanguageDialect sqlLanguageDialect = language instanceof SqlLanguageDialect ? (SqlLanguageDialect)language : null;
            if (sqlLanguageDialect == null) {
                SqlLanguageDialect sqlLanguageDialect2 = SqlLanguageDialect.getIsoDialect();
                sqlLanguageDialect = sqlLanguageDialect2;
                Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect2, (String)"getIsoDialect(...)");
            }
            SqlLanguageDialect dialect = sqlLanguageDialect;
            Project project = identifierElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            Intrinsics.checkNotNull((Object)identifierText);
            List<ScriptedName> qi = Companion.parseQualifiedIdentifier(identifierText, dialect, project2, skipNames);
            if (qi != null) {
                ObjectKind objectKind2 = objectKind;
                if (objectKind2 == null) {
                    objectKind2 = ObjectKind.UNKNOWN_OBJECT;
                }
                ObjectKind objectKind3 = objectKind2;
                Intrinsics.checkNotNull((Object)objectKind3);
                AffectedObjectScriptedMention mention = AffectedObjectScriptedMention.Companion.wasAffected(qi, objectKind3, belongingAreaKind, actionType);
                this.acceptObject(mention);
            }
        }

        public static /* synthetic */ void handleIdentifier$default(Determiner determiner, ObjectEffectType objectEffectType, BelongingAreaKind belongingAreaKind, ObjectKind objectKind, SqlNameElement sqlNameElement, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleIdentifier");
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            determiner.handleIdentifier(objectEffectType, belongingAreaKind, objectKind, sqlNameElement, n);
        }

        protected final void handleRename(@Nullable BelongingAreaKind belongingAreaKind, @Nullable SqlReferenceExpression oldReference, @Nullable SqlElement newIdentifierElement) {
            if (oldReference == null) {
                return;
            }
            ObjectKind objectKind = BaseIntrospectionFunctions.nullize(oldReference.getKind(), SqlDbElementType.ANY);
            this.handleRename(belongingAreaKind, objectKind, (SqlNameElement)oldReference, newIdentifierElement);
        }

        protected final void handleRename(@Nullable BelongingAreaKind belongingAreaKind, @Nullable ObjectKind objectKind, @Nullable SqlNameElement oldIdentifierElement, @Nullable SqlElement newIdentifierElement) {
            if (oldIdentifierElement == null || newIdentifierElement == null) {
                return;
            }
            Project project = oldIdentifierElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            Language language = oldIdentifierElement.getLanguage();
            SqlLanguageDialect sqlLanguageDialect = language instanceof SqlLanguageDialect ? (SqlLanguageDialect)language : null;
            if (sqlLanguageDialect == null) {
                SqlLanguageDialect sqlLanguageDialect2 = SqlLanguageDialect.getIsoDialect();
                sqlLanguageDialect = sqlLanguageDialect2;
                Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect2, (String)"getIsoDialect(...)");
            }
            SqlLanguageDialect dialect = sqlLanguageDialect;
            ObjectKind objectKind2 = objectKind;
            if (objectKind2 == null) {
                objectKind2 = ObjectKind.SCHEMA_OBJECT;
            }
            ObjectKind theKind = objectKind2;
            String string = oldIdentifierElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            List oqi = com.intellij.database.dialects.base.BaseAffectAnalyzer$Companion.parseQualifiedIdentifier$default(Companion, string, dialect, project2, 0, 8, null);
            String string2 = newIdentifierElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            List nqi = com.intellij.database.dialects.base.BaseAffectAnalyzer$Companion.parseQualifiedIdentifier$default(Companion, string2, dialect, project2, 0, 8, null);
            if (oqi == null || nqi == null || nqi.isEmpty()) {
                return;
            }
            ScriptedName scriptedName = (ScriptedName)nqi.get(0);
            Intrinsics.checkNotNull((Object)theKind);
            AffectedObjectScriptedMention mention = AffectedObjectScriptedMention.Companion.wasRenamed(oqi, scriptedName, theKind, belongingAreaKind);
            this.acceptObject(mention);
        }

        protected abstract void acceptObject(@Nullable AffectedObjectScriptedMention var1);

        @NotNull
        public abstract Impactees getImpactees();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0094\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0013\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$MultiDatabaseDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "<init>", "(Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;Lcom/intellij/database/util/SearchPath;)V", "currDatabase", "Lcom/intellij/database/introspection/ScriptedName;", "getCurrDatabase", "()Lcom/intellij/database/introspection/ScriptedName;", "currSchema", "getCurrSchema", "mentions", "Ljava/util/TreeSet;", "Lcom/intellij/database/introspection/AffectedObjectScriptedMention;", "getMentions", "()Ljava/util/TreeSet;", "acceptObject", "", "mention", "getImpactees", "Lcom/intellij/database/introspection/Impactees;", "intellij.database.dialects.base"})
    protected class MultiDatabaseDeterminer
    extends Determiner {
        @NotNull
        private final ScriptedName currDatabase;
        @NotNull
        private final ScriptedName currSchema;
        @NotNull
        private final TreeSet<AffectedObjectScriptedMention> mentions = new TreeSet();

        @NotNull
        protected final ScriptedName getCurrDatabase() {
            return this.currDatabase;
        }

        @NotNull
        protected final ScriptedName getCurrSchema() {
            return this.currSchema;
        }

        @NotNull
        protected final TreeSet<AffectedObjectScriptedMention> getMentions() {
            return this.mentions;
        }

        public MultiDatabaseDeterminer(SearchPath searchPath) {
            ObjectPath currPath;
            Object object = searchPath;
            ObjectPath objectPath = currPath = object != null && (object = ((SearchPath)object).elements) != null ? (ObjectPath)CollectionsKt.firstOrNull((List)object) : null;
            this.currDatabase = ScriptedNameFun.toScriptedName(objectPath != null ? objectPath.findParent(ObjectKind.DATABASE, false) : null);
            ObjectPath objectPath2 = currPath;
            this.currSchema = ScriptedNameFun.toScriptedName(objectPath2 != null ? objectPath2.findParent(ObjectKind.SCHEMA, false) : null);
        }

        @Override
        protected void acceptObject(@Nullable AffectedObjectScriptedMention mention) {
            if (mention == null) {
                return;
            }
            AffectedObjectScriptedMention m = mention;
            ScriptedName d = mention.databaseName;
            ScriptedName s = mention.schemaName;
            boolean databaseIsSpecified = d.isSpecified();
            boolean schemaIsSpecified = s.isSpecified();
            if (!databaseIsSpecified || !schemaIsSpecified || m.belongingAreaKind == null) {
                d = d.orDefault(this.currDatabase);
                s = s.orDefault(databaseIsSpecified ? ScriptedName.Companion.getCurrent() : this.currSchema);
                BelongingAreaKind belongingAreaKind = m.belongingAreaKind;
                if (belongingAreaKind == null) {
                    belongingAreaKind = schemaIsSpecified ? BelongingAreaKind.A_SCHEMA : null;
                }
                BelongingAreaKind theBelongingAreaKind = belongingAreaKind;
                m = AffectedObjectScriptedMention.copy$default(m, d, s, null, null, null, theBelongingAreaKind, null, 92, null);
            }
            this.mentions.add(m);
        }

        @Override
        @NotNull
        public Impactees getImpactees() {
            return Impactees.Companion.of((Set<AffectedObjectScriptedMention>)this.mentions);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0094\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$SingleDatabaseDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "<init>", "(Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;Lcom/intellij/database/util/SearchPath;)V", "currSchema", "Lcom/intellij/database/introspection/ScriptedName;", "getCurrSchema", "()Lcom/intellij/database/introspection/ScriptedName;", "mentions", "Ljava/util/TreeSet;", "Lcom/intellij/database/introspection/AffectedObjectScriptedMention;", "getMentions", "()Ljava/util/TreeSet;", "acceptObject", "", "mention", "getImpactees", "Lcom/intellij/database/introspection/Impactees;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseAffectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$SingleDatabaseDeterminer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n1#2:277\n*E\n"})
    protected class SingleDatabaseDeterminer
    extends Determiner {
        @NotNull
        private final ScriptedName currSchema;
        @NotNull
        private final TreeSet<AffectedObjectScriptedMention> mentions;

        public SingleDatabaseDeterminer(SearchPath searchPath) {
            ObjectPath objectPath;
            SingleDatabaseDeterminer singleDatabaseDeterminer = this;
            Object object = searchPath;
            if (object != null && (object = ((SearchPath)object).elements) != null) {
                Object v2;
                SingleDatabaseDeterminer singleDatabaseDeterminer2;
                block3: {
                    Iterable iterable = (Iterable)object;
                    singleDatabaseDeterminer2 = singleDatabaseDeterminer;
                    Iterable iterable2 = iterable;
                    for (Object t : iterable2) {
                        ObjectPath it = (ObjectPath)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.kind, (Object)ObjectKind.SCHEMA)) continue;
                        v2 = t;
                        break block3;
                    }
                    v2 = null;
                }
                singleDatabaseDeterminer = singleDatabaseDeterminer2;
                objectPath = v2;
            } else {
                objectPath = null;
            }
            singleDatabaseDeterminer.currSchema = ScriptedNameFun.toScriptedName(objectPath);
            this.mentions = new TreeSet();
        }

        @NotNull
        protected final ScriptedName getCurrSchema() {
            return this.currSchema;
        }

        @NotNull
        protected final TreeSet<AffectedObjectScriptedMention> getMentions() {
            return this.mentions;
        }

        @Override
        protected void acceptObject(@Nullable AffectedObjectScriptedMention mention) {
            if (mention == null) {
                return;
            }
            ScriptedName s = mention.schemaName.orDefault(this.currSchema);
            BelongingAreaKind belongingAreaKind = mention.belongingAreaKind;
            if (belongingAreaKind == null) {
                belongingAreaKind = mention.schemaName.isSpecified() ? BelongingAreaKind.A_SCHEMA : null;
            }
            BelongingAreaKind theAffectAreaKind = belongingAreaKind;
            AffectedObjectScriptedMention m = AffectedObjectScriptedMention.copy$default(mention, ScriptedName.Companion.getCurrent(), s, null, null, null, theAffectAreaKind, null, 92, null);
            this.mentions.add(m);
        }

        @Override
        @NotNull
        public Impactees getImpactees() {
            return Impactees.Companion.of((Set<AffectedObjectScriptedMention>)this.mentions);
        }
    }
}

