/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.producers;

import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.AlterProducerBase;
import com.intellij.database.dialects.base.generator.producers.Flags;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModSequence;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016J!\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0013H\u0014\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u000bH\u0014J\b\u0010\u0016\u001a\u00020\u000bH\u0004J\b\u0010\u0017\u001a\u00020\u000bH\u0014J\u0012\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0014J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0018\u0010 \u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0014J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0014J\b\u0010\"\u001a\u00020\u000bH\u0014J\b\u0010#\u001a\u00020\u000bH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0014\u00a8\u0006'"}, d2={"Lcom/intellij/database/dialects/base/generator/producers/AlterSequence;", "T", "Lcom/intellij/database/model/basic/BasicSequence;", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducerBase;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/model/ElementAlteration;)V", "produceFlag", "", "id", "Lcom/intellij/database/model/meta/BasicMetaId;", "produced", "", "computeAlterProperty", "", "prop", "Lcom/intellij/database/model/meta/BasicMetaProperty;", "(Lcom/intellij/database/model/meta/BasicMetaProperty;)Ljava/lang/Boolean;", "produceAlterSequenceIdentity", "produceIdentityOptions", "produceAlterStartValueClause", "doProduceAlterStartValueClause", "startValue", "Ljava/math/BigInteger;", "produceAlterNextValueClause", "s1", "Lcom/intellij/database/model/SequenceIdentity;", "s2", "produceAlterIncrementByClause", "produceAlterMinValueClause", "produceAlterMaxValueClause", "produceAlterCacheSize", "produceAlterCycled", "no", "", "s", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nSequenceProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SequenceProducers.kt\ncom/intellij/database/dialects/base/generator/producers/AlterSequence\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public class AlterSequence<T extends BasicSequence>
extends AlterProducerBase<T> {
    public AlterSequence(@NotNull ScriptingContext context, @NotNull ElementAlteration<? extends T> elements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        super(context, elements);
    }

    @Override
    public void produceFlag(@NotNull BasicMetaId id, @NotNull Set<BasicMetaId> produced) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(produced, (String)"produced");
        BasicMetaId basicMetaId = id;
        if (Intrinsics.areEqual((Object)basicMetaId, BasicModSequence.START_VALUE) || Intrinsics.areEqual((Object)basicMetaId, BasicModSequence.SEQUENCE_IDENTITY)) {
            ((Collection)produced).add(BasicModSequence.START_VALUE);
            ((Collection)produced).add(BasicModSequence.SEQUENCE_IDENTITY);
            this.produceAlterSequenceIdentity();
        } else if (Intrinsics.areEqual((Object)basicMetaId, BasicModSequence.CACHE_SIZE)) {
            this.produceAlterCacheSize();
        } else if (Intrinsics.areEqual((Object)basicMetaId, BasicModSequence.CYCLED)) {
            this.produceAlterCycled();
        } else {
            super.produceFlag(id, produced);
        }
    }

    @Override
    @Nullable
    protected Boolean computeAlterProperty(@NotNull BasicMetaProperty<T, ?> prop) {
        Intrinsics.checkNotNullParameter(prop, (String)"prop");
        BasicMetaPropertyId basicMetaPropertyId = prop.id;
        return Intrinsics.areEqual(basicMetaPropertyId, BasicModSequence.START_VALUE) ? Boolean.valueOf(((BasicSequence)this.getTo()).getStartValue() != null && !Intrinsics.areEqual((Object)((BasicSequence)this.getElement()).getStartValue(), (Object)((BasicSequence)this.getTo()).getStartValue())) : (Intrinsics.areEqual(basicMetaPropertyId, BasicModSequence.SEQUENCE_IDENTITY) ? Boolean.valueOf(this.checkAlterValue(((BasicSequence)this.getElement()).getSequenceIdentity(), ((BasicSequence)this.getTo()).getSequenceIdentity())) : super.computeAlterProperty(prop));
    }

    protected void produceAlterSequenceIdentity() {
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> AlterSequence.produceAlterSequenceIdentity$lambda$0(this, arg_0)));
    }

    protected final void produceIdentityOptions() {
        this.sqlClause((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> AlterSequence.produceIdentityOptions$lambda$1(this, arg_0)));
    }

    protected void produceAlterStartValueClause() {
        Flags flags = this.getFlags();
        BasicMetaPropertyId<BigInteger> basicMetaPropertyId = BasicModSequence.START_VALUE;
        Intrinsics.checkNotNullExpressionValue(basicMetaPropertyId, (String)"START_VALUE");
        if (flags.get(basicMetaPropertyId)) {
            this.doProduceAlterStartValueClause(((BasicSequence)this.getTo()).getStartValue());
        }
    }

    protected void doProduceAlterStartValueClause(@Nullable BigInteger startValue) {
        block0: {
            BigInteger bigInteger = startValue;
            if (bigInteger == null) break block0;
            BigInteger it = bigInteger;
            boolean bl = false;
            this.sqlClause((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> AlterSequence.doProduceAlterStartValueClause$lambda$3$lambda$2(it, arg_0)));
        }
    }

    protected void produceAlterNextValueClause(@NotNull SequenceIdentity s1, @NotNull SequenceIdentity s2) {
        block1: {
            BigInteger bigInteger;
            Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
            BigInteger bigInteger2 = s2.next;
            if (bigInteger2 == null) break block1;
            BigInteger it = bigInteger = bigInteger2;
            boolean bl = false;
            bigInteger2 = !Intrinsics.areEqual((Object)it, (Object)s1.next) ? bigInteger : null;
            if (bigInteger2 != null) {
                it = bigInteger2;
                boolean bl2 = false;
                this.sqlClause((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> AlterSequence.produceAlterNextValueClause$lambda$7$lambda$6(it, this, arg_0)));
            }
        }
    }

    private final void produceAlterIncrementByClause(SequenceIdentity s1, SequenceIdentity s2) {
        if (!Intrinsics.areEqual((Object)s1.increment, (Object)s2.increment)) {
            this.sqlClause((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> AlterSequence.produceAlterIncrementByClause$lambda$8(s2, arg_0)));
        }
    }

    protected void produceAlterMinValueClause(@NotNull SequenceIdentity s1, @NotNull SequenceIdentity s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        if (!Intrinsics.areEqual((Object)s1.min, (Object)s2.min)) {
            this.sqlClause((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> AlterSequence.produceAlterMinValueClause$lambda$10(s2, this, arg_0)));
        }
    }

    protected void produceAlterMaxValueClause(@NotNull SequenceIdentity s1, @NotNull SequenceIdentity s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        if (!Intrinsics.areEqual((Object)s1.max, (Object)s2.max)) {
            this.sqlClause((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> AlterSequence.produceAlterMaxValueClause$lambda$12(s2, this, arg_0)));
        }
    }

    protected void produceAlterCacheSize() {
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> AlterSequence.produceAlterCacheSize$lambda$15(this, arg_0)));
    }

    private final void produceAlterCycled() {
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> AlterSequence.produceAlterCycled$lambda$16(this, arg_0)));
    }

    @NotNull
    protected String no(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return "no " + s;
    }

    private static final Unit produceAlterSequenceIdentity$lambda$0(AlterSequence this$0, ScriptingContext.NewCodingAdapter $this$newCoding) {
        Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
        $this$newCoding.plus($this$newCoding.unaryPlus("alter sequence"), this$0.fqToName());
        this$0.produceIdentityOptions();
        return Unit.INSTANCE;
    }

    private static final Unit produceIdentityOptions$lambda$1(AlterSequence this$0, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
        SequenceIdentity sequenceIdentity = ((BasicSequence)this$0.getElement()).getSequenceIdentity();
        Intrinsics.checkNotNullExpressionValue((Object)sequenceIdentity, (String)"getSequenceIdentity(...)");
        SequenceIdentity s1 = sequenceIdentity;
        SequenceIdentity sequenceIdentity2 = ((BasicSequence)this$0.getTo()).getSequenceIdentity();
        Intrinsics.checkNotNullExpressionValue((Object)sequenceIdentity2, (String)"getSequenceIdentity(...)");
        SequenceIdentity s2 = sequenceIdentity2;
        this$0.produceAlterStartValueClause();
        if (this$0.getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE).booleanValue()) {
            this$0.produceAlterNextValueClause(s1, s2);
        }
        this$0.produceAlterIncrementByClause(s1, s2);
        this$0.produceAlterMinValueClause(s1, s2);
        this$0.produceAlterMaxValueClause(s1, s2);
        return Unit.INSTANCE;
    }

    private static final Unit doProduceAlterStartValueClause$lambda$3$lambda$2(BigInteger $it, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
        $this$sqlClause.plus($this$sqlClause, "start with " + $it);
        return Unit.INSTANCE;
    }

    private static final Unit produceAlterNextValueClause$lambda$7$lambda$6(BigInteger $it, AlterSequence this$0, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
        String string = "with " + $it;
        ScriptingContext.NewCodingAdapter newCodingAdapter = $this$sqlClause.plus($this$sqlClause, "restart");
        ScriptingContext.NewCodingAdapter newCodingAdapter2 = $this$sqlClause;
        boolean bl = false;
        boolean bl2 = !Intrinsics.areEqual((Object)$it, (Object)((BasicSequence)this$0.getTo()).getStartValue());
        newCodingAdapter2.plus(newCodingAdapter, (CharSequence)((Object)(bl2 ? string : null)));
        return Unit.INSTANCE;
    }

    private static final Unit produceAlterIncrementByClause$lambda$8(SequenceIdentity $s2, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
        $this$sqlClause.plus($this$sqlClause, "increment by " + $s2.increment);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit produceAlterMinValueClause$lambda$10(SequenceIdentity $s2, AlterSequence this$0, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        Object object;
        ScriptingContext.NewCodingAdapter newCodingAdapter;
        ScriptingContext.NewCodingAdapter newCodingAdapter2;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
                newCodingAdapter2 = $this$sqlClause;
                newCodingAdapter = $this$sqlClause;
                object = $s2.min;
                if (object == null) break block2;
                BigInteger bigInteger = object;
                ScriptingContext.NewCodingAdapter newCodingAdapter3 = newCodingAdapter;
                ScriptingContext.NewCodingAdapter newCodingAdapter4 = newCodingAdapter2;
                boolean bl = false;
                String string = "minvalue " + (BigInteger)it;
                newCodingAdapter2 = newCodingAdapter4;
                newCodingAdapter = newCodingAdapter3;
                String string2 = string;
                object = string2;
                if (string2 != null) break block3;
            }
            object = this$0.no("minvalue");
        }
        newCodingAdapter2.plus(newCodingAdapter, (CharSequence)object);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit produceAlterMaxValueClause$lambda$12(SequenceIdentity $s2, AlterSequence this$0, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        Object object;
        ScriptingContext.NewCodingAdapter newCodingAdapter;
        ScriptingContext.NewCodingAdapter newCodingAdapter2;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
                newCodingAdapter2 = $this$sqlClause;
                newCodingAdapter = $this$sqlClause;
                object = $s2.max;
                if (object == null) break block2;
                BigInteger bigInteger = object;
                ScriptingContext.NewCodingAdapter newCodingAdapter3 = newCodingAdapter;
                ScriptingContext.NewCodingAdapter newCodingAdapter4 = newCodingAdapter2;
                boolean bl = false;
                String string = "maxvalue " + (BigInteger)it;
                newCodingAdapter2 = newCodingAdapter4;
                newCodingAdapter = newCodingAdapter3;
                String string2 = string;
                object = string2;
                if (string2 != null) break block3;
            }
            object = this$0.no("maxvalue");
        }
        newCodingAdapter2.plus(newCodingAdapter, (CharSequence)object);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit produceAlterCacheSize$lambda$15(AlterSequence this$0, ScriptingContext.NewCodingAdapter $this$newCoding) {
        Object object;
        ScriptingContext.NewCodingAdapter newCodingAdapter;
        ScriptingContext.NewCodingAdapter newCodingAdapter2;
        block3: {
            block2: {
                void it;
                void it2;
                Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
                Long l = ((BasicSequence)this$0.getTo()).getCacheSize();
                long l2 = ((Number)l).longValue();
                ScriptingContext.NewCodingAdapter newCodingAdapter3 = $this$newCoding.plus($this$newCoding.unaryPlus("alter sequence"), this$0.fqToName());
                ScriptingContext.NewCodingAdapter newCodingAdapter4 = $this$newCoding;
                boolean bl = false;
                boolean bl2 = it2 > 1L;
                newCodingAdapter2 = newCodingAdapter4;
                newCodingAdapter = newCodingAdapter3;
                object = bl2 ? l : null;
                if (object == null) break block2;
                long l3 = ((Number)object).longValue();
                newCodingAdapter3 = newCodingAdapter;
                newCodingAdapter4 = newCodingAdapter2;
                boolean bl3 = false;
                String string = "cache " + (long)it;
                newCodingAdapter2 = newCodingAdapter4;
                newCodingAdapter = newCodingAdapter3;
                String string2 = string;
                object = string2;
                if (string2 != null) break block3;
            }
            object = this$0.no("cache");
        }
        newCodingAdapter2.plus(newCodingAdapter, (CharSequence)object);
        return Unit.INSTANCE;
    }

    private static final Unit produceAlterCycled$lambda$16(AlterSequence this$0, ScriptingContext.NewCodingAdapter $this$newCoding) {
        Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
        $this$newCoding.plus($this$newCoding.plus($this$newCoding.unaryPlus("alter sequence"), this$0.fqToName()), ((BasicSequence)this$0.getTo()).isCycled() ? "cycle" : this$0.no("cycle"));
        return Unit.INSTANCE;
    }
}

