/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.data.types.GeoHelper;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.util.ObjectUtils;
import java.io.ByteArrayOutputStream;
import java.text.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.ByteOrderValues;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

public final class MysqlBaseGeoHelper
extends GeoHelper {
    @Override
    public boolean isGeoType(@NotNull String type) {
        if (type == null) {
            MysqlBaseGeoHelper.$$$reportNull$$$0(0);
        }
        return type.equalsIgnoreCase("geometry") || type.equalsIgnoreCase("geography") || type.equalsIgnoreCase("point") || type.equalsIgnoreCase("linestring") || type.equalsIgnoreCase("polygon") || type.equalsIgnoreCase("multipoint") || type.equalsIgnoreCase("multilinestring") || type.equalsIgnoreCase("multipolygon") || type.equalsIgnoreCase("geometrycollection");
    }

    @Override
    public String extractGeometryAsWkt(Object data, @Nullable GridColumn column2) {
        byte[] bytes2 = (byte[])ObjectUtils.tryCast((Object)data, byte[].class);
        if (bytes2 == null) {
            return null;
        }
        ByteArrayInStream stream = new ByteArrayInStream(bytes2);
        byte[] buf = new byte[4];
        stream.read(buf);
        int srid = ByteOrderValues.getInt(buf, 2);
        Geometry geometry = MysqlBaseGeoHelper.wkb2Geom(stream);
        if (geometry == null) {
            return null;
        }
        geometry.setSRID(srid);
        return new WKTWriter().write(GeoHelper.CrsHelper.toSrid4326(geometry));
    }

    @Override
    @NotNull
    public byte[] extractBinaryFromWkt(@NotNull String data, int position) throws ParseException {
        byte[] byArray;
        if (data == null) {
            MysqlBaseGeoHelper.$$$reportNull$$$0(1);
        }
        try {
            Geometry geometry = new WKTReader().read(data);
            int dimension = geometry.getBoundaryDimension();
            WKBWriter wkbWriter = new WKBWriter(Integer.max(dimension, 2), 2, false);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            byte[] bin = wkbWriter.write(geometry);
            stream.writeBytes(new byte[4]);
            stream.writeBytes(bin);
            byArray = stream.toByteArray();
        }
        catch (Throwable e) {
            throw new ParseException(e.getMessage(), position);
        }
        if (byArray == null) {
            MysqlBaseGeoHelper.$$$reportNull$$$0(2);
        }
        return byArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysqlbase/MysqlBaseGeoHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlBaseGeoHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractBinaryFromWkt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isGeoType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractBinaryFromWkt";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

