/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DbConversionPoints;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BitDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.UnknownDomain;
import com.intellij.database.data.types.domain.ZonedDomain;
import com.intellij.database.dialects.postgresbase.PgBaseDomains;

public class PgGPlumBaseDomains
extends PgBaseDomains {
    private static final int MAX_BIT = 0x5000000;
    private static final int MONEY_SCALE = 2;
    private static final int MAX_PRECISION = 1000;
    private static final int MAX_CHAR = 0xA00000;

    public PgGPlumBaseDomains() {
        super(1000, 1000, 0xA00000, 0xA00000);
        this.add(new ZonedDomain(new FractionDomain("time with time zone", DbConversionPoints.TIME_WITH_TIMEZONE, 6, 6, true), "time").withAliases("timetz"));
        this.add(new ZonedDomain(new FractionDomain("timestamp with time zone", DbConversionPoints.TIMESTAMP_WITH_TIMEZONE, 6, 6, true), "timestamp").withAliases("timestamptz"));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, 6, 6, true));
        this.add(new Number2Domain("money", ConversionPoint.MONEY, 1000, 2, false).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new IntegerDomain("serial", ConversionPoint.SERIAL_NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("bigserial", ConversionPoint.SERIAL_NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new PgBaseDomains.MyTextLikeDomain("point", ConversionPoint.POINT).withOperationSupport(OperationSupport.SUPPORTS_EQUALS));
        this.add(new PgBaseDomains.MyTextLikeDomain("interval", ConversionPoint.INTERVAL).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new FractionDomain("time", ConversionPoint.TIME, 6, 6, true));
        this.add(new BinaryDomain("bytea", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add(new BitDomain("bit", ConversionPoint.BIT_STRING, 0x5000000L, -1L, true, false).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new BitDomain("bit varying", ConversionPoint.BIT_STRING, 0x5000000L, -1L, true, true).withAliases("varbit").withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new TextDomain("xml", ConversionPoint.XML, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new TextDomain("tid", ConversionPoint.TEXT_ID, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new SimpleDomain("uuid", ConversionPoint.UUID_TEXT));
        this.add(new SimpleDomain("tsvector", ConversionPoint.TSVECTOR).withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add(new UnknownDomain("xid").withOperationSupport(OperationSupport.SUPPORTS_EQUALS));
        this.add(new UnknownDomain("cid").withOperationSupport(OperationSupport.SUPPORTS_EQUALS));
        this.add(new UnknownDomain("box"));
        this.add(new UnknownDomain("gtsvector"));
        this.add(new UnknownDomain("line"));
        this.add(new UnknownDomain("lseg"));
        this.add(new UnknownDomain("regconfig"));
        this.add(new UnknownDomain("regdictionary"));
        this.add(new UnknownDomain("tsquery"));
        this.add(new UnknownDomain("txid_snapshot"));
        this.add(new UnknownDomain("name"));
        this.add(new UnknownDomain("pg_lsn"));
        this.add(new UnknownDomain("macaddr8"));
        this.add(new UnknownDomain("pg_node_tree"));
    }
}

