/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.run.ConsoleDataRequestUi;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseEditorNotifications {
    private static final Key<ErrorNotificationPanel> NOTIFICATION_KEY = Key.create((String)"ErrorNotificationPanel");

    public static void registerListeners(final @NotNull Project project) {
        if (project == null) {
            DatabaseEditorNotifications.$$$reportNull$$$0(0);
        }
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){
            private final FileDocumentManager fdm = FileDocumentManager.getInstance();

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                DatabaseEditorNotifications.hideErrorInEditor(project, this.fdm.getFile(event.getDocument()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/editor/DatabaseEditorNotifications$1", "documentChanged"));
            }
        }, (Disposable)project.getMessageBus());
    }

    private static DataContext newDataContextForErrorFix(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DatabaseEditorNotifications.$$$reportNull$$$0(1);
        }
        return SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project).add(CommonDataKeys.VIRTUAL_FILE, (Object)file).build();
    }

    public static boolean showErrorInEditor(@NotNull Project project, @NotNull ErrorHandler handler2, @Nullable VirtualFile file) {
        if (project == null) {
            DatabaseEditorNotifications.$$$reportNull$$$0(2);
        }
        if (handler2 == null) {
            DatabaseEditorNotifications.$$$reportNull$$$0(3);
        }
        DatabaseEditorNotifications.hideErrorInEditor(project, file);
        if (!DbImplUtil.isDatabaseVirtualFile(file)) {
            return false;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        FileEditor fileEditor = editorManager.getSelectedEditor(file);
        if (fileEditor == null || editorManager.getSelectedEditor() != fileEditor) {
            return false;
        }
        ErrorNotificationPanel.Builder builder = ErrorNotificationPanel.create((String)handler2.getSummary(), null, (JComponent)fileEditor.getComponent());
        ConsoleDataRequestUi.appendFixes(builder, DatabaseEditorNotifications.newDataContextForErrorFix(project, file), handler2.getFixes());
        builder.addCloseButton(() -> DatabaseEditorNotifications.hideErrorInEditor(project, fileEditor));
        ErrorNotificationPanel panel2 = builder.build();
        NOTIFICATION_KEY.set((UserDataHolder)fileEditor, (Object)panel2);
        editorManager.addBottomComponent(fileEditor, (JComponent)panel2);
        return true;
    }

    private static void hideErrorInEditor(@NotNull Project project, @Nullable VirtualFile file) {
        FileEditor[] editors2;
        if (project == null) {
            DatabaseEditorNotifications.$$$reportNull$$$0(4);
        }
        if (!DbImplUtil.isDatabaseVirtualFile(file)) {
            return;
        }
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        for (FileEditor editor2 : editors2 = manager.getEditors(file)) {
            DatabaseEditorNotifications.hideErrorInEditor(project, editor2);
        }
    }

    private static void hideErrorInEditor(@NotNull Project project, @NotNull FileEditor fileEditor) {
        ErrorNotificationPanel notificationPanel;
        if (project == null) {
            DatabaseEditorNotifications.$$$reportNull$$$0(5);
        }
        if (fileEditor == null) {
            DatabaseEditorNotifications.$$$reportNull$$$0(6);
        }
        if ((notificationPanel = (ErrorNotificationPanel)NOTIFICATION_KEY.get((UserDataHolder)fileEditor)) == null) {
            return;
        }
        FileEditorManager.getInstance((Project)project).removeBottomComponent(fileEditor, (JComponent)notificationPanel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/editor/DatabaseEditorNotifications";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerListeners";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "newDataContextForErrorFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorInEditor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hideErrorInEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

