/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.state;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbStructureObjectModelApplier;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureNodeState;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbStructureObjectModelState<E extends BasicElement>
extends DbEditorModelBase.StateBase
implements DbStructureNodeState {
    private final DbModelRef<E, DbObjectModelState<E>> myObjectRef;
    private final List<DbModelRef<E, DbStructureFamilyModelState<?>>> myFamilies;

    public DbStructureObjectModelState(@NotNull DbModelRef<E, DbObjectModelState<E>> objectRef, @NotNull List<DbModelRef<E, DbStructureFamilyModelState<?>>> families) {
        if (objectRef == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(0);
        }
        if (families == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(1);
        }
        this.myObjectRef = objectRef;
        this.myFamilies = families;
    }

    public <U extends BasicElement> DbStructureObjectModelState<U> tryCast(@NotNull BasicMetaObject<U> meta) {
        if (meta == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(2);
        }
        return this.myObjectRef.getIdentity().getMetaObject() == meta ? this : null;
    }

    @NotNull
    public List<DbModelRef<E, DbStructureFamilyModelState<?>>> getFamilies() {
        List<DbModelRef<E, DbStructureFamilyModelState<?>>> list = this.myFamilies;
        if (list == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public DbModelRef<E, DbObjectModelState<E>> getObjectRef() {
        DbModelRef<E, DbObjectModelState<E>> dbModelRef = this.myObjectRef;
        if (dbModelRef == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(4);
        }
        return dbModelRef;
    }

    @NotNull
    public List<DbModelRef<E, DbStructureFamilyModelState<?>>> getStructureChildren() {
        List<DbModelRef<E, DbStructureFamilyModelState<?>>> list = this.myFamilies;
        if (list == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(5);
        }
        return list;
    }

    public <C extends BasicElement> void removeChild(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<C> id) {
        DbModelRef<E, DbStructureFamilyModelState<C>> family;
        if (controller == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(6);
        }
        if (id == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(7);
        }
        if ((family = this.getFamily(id.getMetaObject())) != null) {
            family.getState().removeChild(controller, (DbModelRef<C, S> c2) -> c2.getIdentity() == id);
        }
    }

    public <C extends BasicElement> void addChild(@NotNull DbEditorModel<C, DbStructureObjectModelState<C>> model) {
        DbModelRef<E, DbStructureFamilyModelState<C>> family;
        if (model == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(8);
        }
        if ((family = this.getFamily(model.getIdentity().getMetaObject())) != null) {
            family.getState().addChild(model);
        }
    }

    @Nullable
    public <C extends BasicElement> DbModelRef<E, DbStructureFamilyModelState<C>> getFamily(@NotNull BasicMetaObject<C> meta) {
        if (meta == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(9);
        }
        for (DbModelRef<E, DbStructureFamilyModelState<?>> family : this.myFamilies) {
            DbStructureFamilyModelState<C> s = family.getState().tryCast(meta);
            if (s == null) continue;
            return family.castState(s);
        }
        return null;
    }

    @Nullable
    public DbModelRef<E, DbStructureFamilyModelState<?>> getFamily(@NotNull ObjectKind kind) {
        if (kind == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(10);
        }
        for (DbModelRef<E, DbStructureFamilyModelState<?>> family : this.myFamilies) {
            if (family.getState().getMetaObject().kind != kind) continue;
            return family;
        }
        return null;
    }

    @Override
    public boolean register(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(11);
        }
        if (!super.register(model)) {
            return false;
        }
        this.getObjectRef().register(model.getController());
        for (DbModelRef<E, DbStructureFamilyModelState<?>> ref2 : this.getFamilies()) {
            ref2.register(model.getController());
        }
        return true;
    }

    @Override
    public boolean unregister(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(12);
        }
        if (!super.unregister(model)) {
            return false;
        }
        this.getObjectRef().unregister(model.getController());
        for (DbModelRef<E, DbStructureFamilyModelState<?>> ref2 : this.getFamilies()) {
            ref2.unregister(model.getController());
        }
        return true;
    }

    @Nullable
    public static <E extends BasicElement> DbStructureObjectModelState<E> resolve(@NotNull DbEditorModelController controller, @Nullable ElementIdentity<E> id) {
        if (controller == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(13);
        }
        return id == null ? null : controller.resolveState(id, DbStructureObjectModelApplier.ID, DbStructureObjectModelState.class);
    }

    @Nullable
    public static <E extends BasicElement> DbStructureFamilyModelState<E> resolve(@NotNull DbEditorModelController controller, @Nullable ElementIdentity<?> id, @NotNull BasicMetaObject<E> meta) {
        DbStructureObjectModelState<?> parent;
        if (controller == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(14);
        }
        if (meta == null) {
            DbStructureObjectModelState.$$$reportNull$$$0(15);
        }
        DbModelRef<?, DbStructureFamilyModelState<?>> ref2 = (parent = DbStructureObjectModelState.resolve(controller, id)) == null ? null : parent.getFamily(meta);
        return ref2 == null ? null : ref2.getState();
    }

    @Contract(value="null->null;!null->!null")
    public static <E extends BasicElement> DbModelRef<E, DbStructureObjectModelState<E>> fix(@Nullable DbModelRef<?, DbStructureObjectModelState<?>> ref2) {
        return ref2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectRef";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "families";
                break;
            }
            case 2: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/state/DbStructureObjectModelState";
                break;
            }
            case 6: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/state/DbStructureObjectModelState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectRef";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryCast";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFamily";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

