/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.bigquery.refactoring;

import com.intellij.database.util.DdlBuilder;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/dialects/bigquery/refactoring/BigQueryExtractFunctionHelper;", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper;", "<init>", "()V", "supportsTableFunctions", "", "getSupportsTableFunctions", "()Z", "getRoutineKeyword", "", "functionInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "generateTableType", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "sqlType", "Lcom/intellij/sql/psi/SqlTableType;", "generateBodyStatement", "intellij.database.dialects.bigquery"})
public final class BigQueryExtractFunctionHelper
extends SqlExtractFunctionHelper {
    @NotNull
    public static final BigQueryExtractFunctionHelper INSTANCE = new BigQueryExtractFunctionHelper();

    private BigQueryExtractFunctionHelper() {
    }

    @Override
    public boolean getSupportsTableFunctions() {
        return true;
    }

    @Override
    @NotNull
    public String getRoutineKeyword(@NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        return functionInfo.getCodeInfo().isTableFunction() ? "table function" : "function";
    }

    @Override
    public void generateTableType(@NotNull DdlBuilder builder, @NotNull SqlTableType sqlType) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        builder.keyword("table");
        builder.symbol("<");
        this.generateTableTypeColumns(builder, sqlType);
        builder.symbol(">");
    }

    @Override
    protected void generateBodyStatement(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        this.generateReturnExpression(builder, functionInfo);
    }
}

