/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlReturnsClause;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlObjectAttributeDefinitionImpl;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlUnusedVariableInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlUnusedVariableInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlUnusedVariableInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlUnusedVariableInspection.$$$reportNull$$$0(2);
        }
        final Dbms dbms = dialect.getDbms();
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlVariableDefinition(SqlVariableDefinition o) {
                if (o instanceof SqlReturnsClause || o instanceof SqlObjectAttributeDefinitionImpl) {
                    return;
                }
                if (dbms.isExasol() && DasUtil.getKind(o.getDasParent()) == ObjectKind.SCRIPT) {
                    return;
                }
                if (dbms.isPostgres() && o instanceof DasArgument && ((DasArgument)o).getArgumentDirection() == ArgumentDirection.OUT) {
                    return;
                }
                if (dbms.isOracle() && SqlImplUtil.sqlParents((PsiElement)o).filter(e -> e instanceof SqlDefinition && ((SqlDefinition)e).getKind() == ObjectKind.PACKAGE).isNotEmpty()) {
                    return;
                }
                PsiElement scope2 = PsiTreeUtil.getParentOfType((PsiElement)o, (Class[])new Class[]{PsiFile.class, SqlCreateStatement.class, SqlProcedureDefinitionImpl.class, SqlBlockStatementImpl.class});
                if (scope2 == null) {
                    return;
                }
                if (scope2 instanceof SqlProcedureDefinitionImpl) {
                    PsiElement body2 = (PsiElement)((SqlProcedureDefinitionImpl)scope2).getBody().first();
                    if (body2 == null) {
                        body2 = (PsiElement)SqlImplUtil.sqlChildren(scope2).filter(q -> SqlImplUtil.isBodyLazyBlock(q)).first();
                    }
                    if (body2 == null || SqlImplUtil.isBodyLazyBlock(body2) && SqlImplUtil.sqlChildren(body2).filter(q -> SqlImplUtil.isBodyLazyBlock(q)).isEmpty()) {
                        return;
                    }
                }
                if (o.getNode().getElementType() == SqlCompositeElementTypes.SQL_PARAMETER_DEFINITION && !(scope2 instanceof SqlCreateStatement) && !(scope2 instanceof SqlProcedureDefinitionImpl)) {
                    return;
                }
                if (SqlUnusedVariableInspection.foundAnyRefs((PsiElement)o, (Condition<? super SqlElement>)((Condition)e -> o == e || o.getNameElement() == e), o.getUseScope())) {
                    return;
                }
                PsiElement element = (PsiElement)ObjectUtils.chooseNotNull((Object)o.getNameElement(), (Object)o);
                this.addDescriptor(this.myManager.createProblemDescriptor(element, SqlBundle.message((String)"inspection.message.never.used", (Object[])new Object[]{StringUtil.capitalize((String)DbPresentationCore.getPresentableName(o.getKind(), dbms)), o.getName()}), true, ProblemHighlightType.LIKE_UNUSED_SYMBOL, onTheFly, new LocalQuickFix[0]));
            }
        };
    }

    static boolean foundAnyRefs(PsiElement o, Condition<? super SqlElement> skip, SearchScope searchScope) {
        Ref found = Ref.create((Object)false);
        ReferencesSearch.search((PsiElement)o, (SearchScope)searchScope).forEach(ref2 -> {
            PsiElement element = ref2.getElement();
            if (element instanceof SqlElement && skip.value((Object)((SqlElement)element))) {
                return true;
            }
            found.set((Object)true);
            return false;
        });
        return (Boolean)found.get() != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlUnusedVariableInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

