/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.versioning;

import java.util.StringTokenizer;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class DefaultArtifactVersion
implements ArtifactVersion {
    private Integer majorVersion;
    private Integer minorVersion;
    private Integer incrementalVersion;
    private Integer buildNumber;
    private String qualifier;
    private ComparableVersion comparable;

    public DefaultArtifactVersion(String version) {
        this.parseVersion(version);
    }

    public int hashCode() {
        return 11 + this.comparable.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArtifactVersion)) {
            return false;
        }
        return this.compareTo((ArtifactVersion)other) == 0;
    }

    @Override
    public int compareTo(ArtifactVersion otherVersion) {
        if (otherVersion instanceof DefaultArtifactVersion) {
            return this.comparable.compareTo(((DefaultArtifactVersion)otherVersion).comparable);
        }
        return this.compareTo(new DefaultArtifactVersion(otherVersion.toString()));
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion != null ? this.majorVersion : 0;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion != null ? this.minorVersion : 0;
    }

    @Override
    public int getIncrementalVersion() {
        return this.incrementalVersion != null ? this.incrementalVersion : 0;
    }

    @Override
    public int getBuildNumber() {
        return this.buildNumber != null ? this.buildNumber : 0;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public final void parseVersion(String version) {
        String part1;
        this.comparable = new ComparableVersion(version);
        int index = version.indexOf(45);
        String part2 = null;
        if (index < 0) {
            part1 = version;
        } else {
            part1 = version.substring(0, index);
            part2 = version.substring(index + 1);
        }
        if (part2 != null) {
            if (part2.length() == 1 || !part2.startsWith("0")) {
                this.buildNumber = DefaultArtifactVersion.tryParseInt(part2);
                if (this.buildNumber == null) {
                    this.qualifier = part2;
                }
            } else {
                this.qualifier = part2;
            }
        }
        if (!part1.contains(".") && !part1.startsWith("0")) {
            this.majorVersion = DefaultArtifactVersion.tryParseInt(part1);
            if (this.majorVersion == null) {
                this.qualifier = version;
                this.buildNumber = null;
            }
        } else {
            boolean fallback = false;
            StringTokenizer tok2 = new StringTokenizer(part1, ".");
            if (tok2.hasMoreTokens()) {
                this.majorVersion = DefaultArtifactVersion.getNextIntegerToken(tok2);
                if (this.majorVersion == null) {
                    fallback = true;
                }
            } else {
                fallback = true;
            }
            if (tok2.hasMoreTokens()) {
                this.minorVersion = DefaultArtifactVersion.getNextIntegerToken(tok2);
                if (this.minorVersion == null) {
                    fallback = true;
                }
            }
            if (tok2.hasMoreTokens()) {
                this.incrementalVersion = DefaultArtifactVersion.getNextIntegerToken(tok2);
                if (this.incrementalVersion == null) {
                    fallback = true;
                }
            }
            if (tok2.hasMoreTokens()) {
                this.qualifier = tok2.nextToken();
                fallback = DefaultArtifactVersion.isDigits(this.qualifier);
            }
            if (part1.contains("..") || part1.startsWith(".") || part1.endsWith(".")) {
                fallback = true;
            }
            if (fallback) {
                this.qualifier = version;
                this.majorVersion = null;
                this.minorVersion = null;
                this.incrementalVersion = null;
                this.buildNumber = null;
            }
        }
    }

    private static Integer getNextIntegerToken(StringTokenizer tok2) {
        String s = tok2.nextToken();
        if (s.length() > 1 && s.startsWith("0")) {
            return null;
        }
        return DefaultArtifactVersion.tryParseInt(s);
    }

    private static boolean isDigits(String str) {
        if (str == null || str.trim().isEmpty()) {
            return false;
        }
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char c2 = str.charAt(i2);
            if (c2 >= '0' && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    private static Integer tryParseInt(String s) {
        if (!DefaultArtifactVersion.isDigits(s)) {
            return null;
        }
        try {
            long longValue = Long.parseLong(s);
            if (longValue > Integer.MAX_VALUE) {
                return null;
            }
            return (int)longValue;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String toString() {
        return this.comparable.toString();
    }
}

