/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.management.PluginManagementInjector;
import org.apache.maven.model.merge.MavenModelMerger;

@Named
@Singleton
public class DefaultPluginManagementInjector
implements PluginManagementInjector {
    private ManagementModelMerger merger = new ManagementModelMerger();

    @Override
    public void injectManagement(Model model, ModelBuildingRequest request2, ModelProblemCollector problems) {
        this.merger.mergeManagedBuildPlugins(model);
    }

    protected static class ManagementModelMerger
    extends MavenModelMerger {
        protected ManagementModelMerger() {
        }

        public void mergeManagedBuildPlugins(Model model) {
            PluginManagement pluginManagement;
            Build build = model.getBuild();
            if (build != null && (pluginManagement = build.getPluginManagement()) != null) {
                this.mergePluginContainerPlugins(build, pluginManagement);
            }
        }

        private void mergePluginContainerPlugins(PluginContainer target2, PluginContainer source) {
            List<Plugin> src = source.getPlugins();
            if (!src.isEmpty()) {
                Object key2;
                List<Plugin> tgt = target2.getPlugins();
                LinkedHashMap<Object, Plugin> managedPlugins = new LinkedHashMap<Object, Plugin>(src.size() * 2);
                Map<Object, Object> context = Collections.emptyMap();
                for (Plugin element : src) {
                    key2 = this.getPluginKey(element);
                    managedPlugins.put(key2, element);
                }
                for (Plugin element : tgt) {
                    key2 = this.getPluginKey(element);
                    Plugin managedPlugin = (Plugin)managedPlugins.get(key2);
                    if (managedPlugin == null) continue;
                    this.mergePlugin(element, managedPlugin, false, context);
                }
            }
        }

        @Override
        protected void mergePlugin_Executions(Plugin target2, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
            List<PluginExecution> src = source.getExecutions();
            if (!src.isEmpty()) {
                Object key2;
                List<PluginExecution> tgt = target2.getExecutions();
                LinkedHashMap<Object, PluginExecution> merged = new LinkedHashMap<Object, PluginExecution>((src.size() + tgt.size()) * 2);
                for (PluginExecution element : src) {
                    key2 = this.getPluginExecutionKey(element);
                    merged.put(key2, element.clone());
                }
                for (PluginExecution element : tgt) {
                    key2 = this.getPluginExecutionKey(element);
                    PluginExecution existing2 = (PluginExecution)merged.get(key2);
                    if (existing2 != null) {
                        this.mergePluginExecution(element, existing2, sourceDominant, context);
                    }
                    merged.put(key2, element);
                }
                target2.setExecutions(new ArrayList<PluginExecution>(merged.values()));
            }
        }
    }
}

