/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jettison;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.Convention;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class Node {
    JSONObject object;
    Map attributes;
    Map namespaces;
    Iterator keys;
    QName name;
    JSONArray array;
    int arrayIndex;
    String currentKey;
    Node parent;

    public Node(Node parent, String name2, JSONObject object, Convention con) throws JSONException, XMLStreamException {
        this.parent = parent;
        this.object = object;
        this.namespaces = new LinkedHashMap();
        this.attributes = new LinkedHashMap();
        con.processAttributesAndNamespaces(this, object);
        this.keys = object.keys();
        this.name = con.createQName(name2, this);
    }

    public Node(String name2, Convention con) throws XMLStreamException {
        this.name = con.createQName(name2, this);
        this.namespaces = new HashMap();
        this.attributes = new HashMap();
    }

    public Node(JSONObject object) {
        this.object = object;
        this.namespaces = new HashMap();
        this.attributes = new HashMap();
    }

    public int getNamespaceCount() {
        return this.namespaces.size();
    }

    public String getNamespaceURI(String prefix) {
        String result2 = (String)this.namespaces.get(prefix);
        if (result2 == null && this.parent != null) {
            result2 = this.parent.getNamespaceURI(prefix);
        }
        return result2;
    }

    public String getNamespaceURI(int index) {
        if (index < 0 || index >= this.getNamespaceCount()) {
            throw new IllegalArgumentException("Illegal index: element has " + this.getNamespaceCount() + " namespace declarations");
        }
        Iterator itr = this.namespaces.values().iterator();
        while (--index >= 0) {
            itr.next();
        }
        Object ns = itr.next();
        return ns == null ? "" : ns.toString();
    }

    public String getNamespacePrefix(String URI2) {
        String result2 = null;
        for (Map.Entry e : this.namespaces.entrySet()) {
            if (!e.getValue().equals(URI2)) continue;
            result2 = (String)e.getKey();
        }
        if (result2 == null && this.parent != null) {
            result2 = this.parent.getNamespacePrefix(URI2);
        }
        return result2;
    }

    public String getNamespacePrefix(int index) {
        if (index < 0 || index >= this.getNamespaceCount()) {
            throw new IllegalArgumentException("Illegal index: element has " + this.getNamespaceCount() + " namespace declarations");
        }
        Iterator itr = this.namespaces.keySet().iterator();
        while (--index >= 0) {
            itr.next();
        }
        return itr.next().toString();
    }

    public void setNamespaces(Map namespaces2) {
        this.namespaces = namespaces2;
    }

    public void setNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setAttribute(QName name2, String value) {
        this.attributes.put(name2, value);
    }

    public Iterator getKeys() {
        return this.keys;
    }

    public QName getName() {
        return this.name;
    }

    public JSONObject getObject() {
        return this.object;
    }

    public void setObject(JSONObject object) {
        this.object = object;
    }

    public JSONArray getArray() {
        return this.array;
    }

    public void setArray(JSONArray array) {
        this.array = array;
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public void setArrayIndex(int arrayIndex) {
        this.arrayIndex = arrayIndex;
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    public void setCurrentKey(String currentKey) {
        this.currentKey = currentKey;
    }

    public String toString() {
        if (this.name != null) {
            return this.name.toString();
        }
        return super.toString();
    }
}

