/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

import java.util.UUID;
import org.eclipse.aether.repository.ArtifactRepository;

public final class WorkspaceRepository
implements ArtifactRepository {
    private final String type;
    private final Object key;

    public WorkspaceRepository() {
        this("workspace");
    }

    public WorkspaceRepository(String type) {
        this(type, null);
    }

    public WorkspaceRepository(String type, Object key2) {
        this.type = type != null ? type : "";
        this.key = key2 != null ? key2 : UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public String getContentType() {
        return this.type;
    }

    @Override
    public String getId() {
        return "workspace";
    }

    public Object getKey() {
        return this.key;
    }

    public String toString() {
        return "(" + this.getContentType() + ")";
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null || !this.getClass().equals(obj2.getClass())) {
            return false;
        }
        WorkspaceRepository that = (WorkspaceRepository)obj2;
        return this.getContentType().equals(that.getContentType()) && this.getKey().equals(that.getKey());
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.getKey().hashCode();
        hash = hash * 31 + this.getContentType().hashCode();
        return hash;
    }
}

