/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.util.Complex;
import org.locationtech.proj4j.util.ProjectionMath;

public class NewZealandMapGridProjection
extends Projection {
    private static final Complex[] bf = new Complex[]{new Complex(0.7557853228, 0.0), new Complex(0.249204646, 0.003371507), new Complex(-0.001541739, 0.04105856), new Complex(-0.10162907, 0.01727609), new Complex(-0.26623489, -0.36249218), new Complex(-0.6870983, -1.1651967)};
    private static final double[] tphi = new double[]{1.5627014243, 0.5185406398, -0.03333098, -0.1052906, -0.0368594, 0.007317, 0.0122, 0.00394, -0.0013};
    private static final double[] tpsi = new double[]{0.6399175073, -0.1358797613, 0.063294409, -0.02526853, 0.0117879, -0.0055161, 0.0026906, -0.001333, 6.7E-4, -3.4E-4};
    private static final double SECS_TO_RAD = 0.484813681109536;
    private static final double RAD_TO_SECS = 2.0626480624709638;

    public NewZealandMapGridProjection() {
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        Complex p2 = new Complex(0.0, 0.0);
        lpphi = (lpphi - this.projectionLatitude) * 2.0626480624709638;
        for (int i2 = tpsi.length - 1; i2 >= 0; --i2) {
            p2.r = tpsi[i2] + lpphi * p2.r;
        }
        p2.r *= lpphi;
        p2.i = lplam;
        p2 = ProjectionMath.zpoly1(p2, bf);
        out.x = p2.i;
        out.y = p2.r;
        return out;
    }

    @Override
    protected ProjCoordinate projectInverse(double x, double y, ProjCoordinate dst) {
        int nn;
        Complex p2 = new Complex(y, x);
        Complex fp = new Complex(0.0, 0.0);
        Complex dp = new Complex(0.0, 0.0);
        for (nn = 20; nn > 0; --nn) {
            Complex f = ProjectionMath.zpoly1d(p2, bf, fp);
            f.r -= y;
            f.i -= x;
            double den = fp.r * fp.r + fp.i * fp.i;
            dp.r = -(f.r * fp.r + f.i * fp.i) / den;
            p2.r += dp.r;
            dp.i = -(f.i * fp.r - f.r * fp.i) / den;
            p2.i += dp.i;
            if (Math.abs(dp.r) + Math.abs(dp.i) <= 1.0E-10) break;
        }
        if (nn > 0) {
            dst.x = p2.i;
            dst.y = tphi[tphi.length - 1];
            for (int i2 = tphi.length - 1; i2 > 0; --i2) {
                dst.y = tphi[i2 - 1] + p2.r * dst.y;
            }
            dst.y = this.projectionLatitude + p2.r * dst.y * 0.484813681109536;
        } else {
            dst.x = Double.NaN;
            dst.y = Double.NaN;
        }
        return dst;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.a = 6378388.0;
        this.projectionLongitude = 3.01941960595019;
        this.projectionLatitude = -0.7155849933176751;
        this.falseEasting = 2510000.0;
        this.falseNorthing = 6023150.0;
    }

    @Override
    public String toString() {
        return "New Zealand Map Grid";
    }
}

