/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JSDebuggerEditorsProvider;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.LambdaInLineVisitor;
import com.intellij.javascript.debugger.PsiVisitorKt;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.debugger.RemoteUrlMappingHelper;
import com.intellij.javascript.debugger.breakpoints.JavaScriptLineBreakpointProperties;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.SourceInfo;

public class JavaScriptBreakpointType
extends XLineBreakpointType<JavaScriptLineBreakpointProperties> {
    private final XDebuggerEditorsProvider myEditorsProvider = new JSDebuggerEditorsProvider();

    public JavaScriptBreakpointType() {
        super("javascript", JSDebuggerBundle.message("javascript.breakpoint.title", new Object[0]));
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<JavaScriptLineBreakpointProperties> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            JavaScriptBreakpointType.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JavaScriptBreakpointType.$$$reportNull$$$0(1);
        }
        return this.myEditorsProvider;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Document document;
        boolean canContainsJavaScript;
        if (file == null) {
            JavaScriptBreakpointType.$$$reportNull$$$0(2);
        }
        if (project == null) {
            JavaScriptBreakpointType.$$$reportNull$$$0(3);
        }
        FileType fileType = file.getFileType();
        if (ScratchUtil.isScratch((VirtualFile)file)) {
            FileType substitutedFileType = LanguageUtil.getLanguageFileType((Language)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file, (FileType)fileType));
            fileType = (FileType)ObjectUtils.notNull((Object)substitutedFileType, (Object)fileType);
        }
        boolean bl = canContainsJavaScript = DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType) || JsFileUtil.isHtmlOrTemplateFile(file);
        if ((canContainsJavaScript || JavaScriptDebugAware.isBreakpointAware(fileType)) && (document = FileDocumentManager.getInstance().getDocument(file)) != null) {
            return JsFileUtil.containsDebuggableElement(line, project, document, canContainsJavaScript);
        }
        return false;
    }

    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XLineBreakpoint<JavaScriptLineBreakpointProperties> breakpoint, @Nullable XDebugSession currentSession) {
        XDebugProcess debugProcess;
        if (breakpoint == null) {
            JavaScriptBreakpointType.$$$reportNull$$$0(4);
        }
        XSourcePosition position = breakpoint.getSourcePosition();
        if (currentSession != null && position != null && (debugProcess = currentSession.getDebugProcess()) instanceof JavaScriptDebugProcess) {
            JavaScriptDebugProcess jsDebugProcess = (JavaScriptDebugProcess)debugProcess;
            DebuggableFileFinder fileFinder = jsDebugProcess.getFinder().getDelegate();
            VirtualFile file = position.getFile();
            if (fileFinder instanceof RemoteDebuggingFileFinder && !((RemoteDebuggingFileFinder)fileFinder).isDebuggable(file, currentSession.getProject()) && fileFinder.canSetRemoteUrl(file, currentSession.getProject())) {
                return Collections.singletonList(new SpecifyRemoteUrlAction(jsDebugProcess, file));
            }
        }
        return super.getAdditionalPopupMenuActions(breakpoint, currentSession);
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<JavaScriptLineBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    @Nullable
    public JavaScriptLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            JavaScriptBreakpointType.$$$reportNull$$$0(5);
        }
        return new JavaScriptLineBreakpointProperties();
    }

    public String getBreakpointsDialogHelpTopic() {
        return "reference.dialogs.breakpoints";
    }

    @NotNull
    public List<? extends XLineBreakpointType.XLineBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            JavaScriptBreakpointType.$$$reportNull$$$0(6);
        }
        if (position == null) {
            JavaScriptBreakpointType.$$$reportNull$$$0(7);
        }
        List list = PsiVisitorKt.computeInNBRA(() -> {
            SmartList result = new SmartList();
            result.add(new MyExactBreakpointVariant(position));
            PsiVisitors.visit((XSourcePosition)position, (Project)project, null, (PsiVisitors.Visitor)new LambdaInLineVisitor((List)result){
                final /* synthetic */ List val$result;
                {
                    this.val$result = list;
                }

                @Override
                protected void process(@NotNull JSFunction element, @NotNull PsiElement firstBreakable) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (firstBreakable == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    SourceInfo lambdaPosition = this.createSourcePosition(firstBreakable);
                    this.val$result.add(new MyExactBreakpointVariant((XSourcePosition)lambdaPosition, (PsiElement)element, this.lambdaOrdinal++));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "firstBreakable";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (result.size() > 1) {
                result.add(0, new XLineBreakpointType.XLineBreakpointAllVariant((XLineBreakpointType)this, position));
            }
            return result;
        });
        if (list == null) {
            JavaScriptBreakpointType.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<JavaScriptLineBreakpointProperties> breakpoint) {
        Integer myOrdinal;
        XSourcePosition position = breakpoint.getSourcePosition();
        if (position == null) {
            return null;
        }
        JavaScriptLineBreakpointProperties properties = (JavaScriptLineBreakpointProperties)breakpoint.getProperties();
        if (properties != null && (myOrdinal = properties.lambdaOrdinal) != null && myOrdinal >= 0) {
            return PsiVisitorKt.computeInNBRA(() -> {
                final Ref result = Ref.create();
                PsiVisitors.visit((XSourcePosition)position, (Project)((XBreakpointBase)breakpoint).getProject(), null, (PsiVisitors.Visitor)new LambdaInLineVisitor(){

                    @Override
                    protected void process(@NotNull JSFunction element, @NotNull PsiElement firstBreakable) {
                        if (element == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (firstBreakable == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (myOrdinal == this.lambdaOrdinal) {
                            result.set((Object)element.getTextRange());
                            this.isStopped = true;
                        }
                        ++this.lambdaOrdinal;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "firstBreakable";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType$2";
                        objectArray[2] = "process";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                return (TextRange)result.get();
            });
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalPopupMenuActions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeVariants";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private static final class SpecifyRemoteUrlAction
    extends AnAction {
        private final JavaScriptDebugProcess<?> myDebugProcess;
        private final VirtualFile myFile;

        private SpecifyRemoteUrlAction(@NotNull JavaScriptDebugProcess debugProcess, @NotNull VirtualFile file) {
            if (debugProcess == null) {
                SpecifyRemoteUrlAction.$$$reportNull$$$0(0);
            }
            if (file == null) {
                SpecifyRemoteUrlAction.$$$reportNull$$$0(1);
            }
            super(JSDebuggerBundle.message("action.name.specify.remote.url.for.0", file.getName()));
            this.myDebugProcess = debugProcess;
            this.myFile = file;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SpecifyRemoteUrlAction.$$$reportNull$$$0(2);
            }
            RemoteUrlMappingHelper.showSetRemoteUrlDialog(this.myDebugProcess, this.myFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugProcess";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType$SpecifyRemoteUrlAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class MyExactBreakpointVariant
    extends XLineBreakpointType.XLineBreakpointAllVariant {
        private final int lambdaOrdinal;
        private final PsiElement myElement;

        public MyExactBreakpointVariant(XSourcePosition lambdaPosition) {
            super((XLineBreakpointType)JavaScriptBreakpointType.this, lambdaPosition);
            this.lambdaOrdinal = -1;
            this.myElement = null;
        }

        public MyExactBreakpointVariant(@NotNull XSourcePosition lambdaPosition, PsiElement element, int lambdaOrdinal) {
            if (element == null) {
                MyExactBreakpointVariant.$$$reportNull$$$0(0);
            }
            super((XLineBreakpointType)JavaScriptBreakpointType.this, lambdaPosition);
            this.myElement = element;
            this.lambdaOrdinal = lambdaOrdinal;
        }

        @Nullable
        public JavaScriptLineBreakpointProperties createProperties() {
            JavaScriptLineBreakpointProperties properties = (JavaScriptLineBreakpointProperties)super.createProperties();
            assert (properties != null);
            properties.lambdaOrdinal = this.lambdaOrdinal;
            return properties;
        }

        public TextRange getHighlightRange() {
            return this.myElement != null ? this.myElement.getTextRange() : null;
        }

        @NotNull
        public String getText() {
            String string = this.myElement != null ? StringUtil.shortenTextWithEllipsis((String)this.myElement.getText(), (int)100, (int)0) : JSDebuggerBundle.message("javascript.breakpoint.type.line", new Object[0]);
            if (string == null) {
                MyExactBreakpointVariant.$$$reportNull$$$0(1);
            }
            return string;
        }

        public Icon getIcon() {
            return this.myElement != null ? this.myElement.getIcon(0) : AllIcons.Debugger.Db_set_breakpoint;
        }

        public boolean isMultiVariant() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType$MyExactBreakpointVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType$MyExactBreakpointVariant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

