/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.locationResolving;

import com.intellij.javascript.debugger.JSCachingFileFinderKt;
import com.intellij.javascript.debugger.locationResolving.FileUrlMapping;
import com.intellij.javascript.debugger.locationResolving.SearchAccuracy;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Url;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\tJ\u0018\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u0010\u001c\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/debugger/locationResolving/FileUrlMappingsStorage;", "", "<init>", "()V", "urlToScriptHashCode", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "Lcom/intellij/util/Url;", "urlToFileMap", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/javascript/debugger/locationResolving/FileUrlMapping;", "fileToUrlMap", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptFound", "", "url", "script", "Lorg/jetbrains/debugger/Script;", "removeOutdatedResults", "sourceContent", "", "removeMapping", "mapping", "addMapping", "findSuitableMapping", "accuracy", "Lcom/intellij/javascript/debugger/locationResolving/SearchAccuracy;", "findUrls", "", "file", "intellij.javascript.debugger"})
final class FileUrlMappingsStorage {
    @NotNull
    private final Object2IntOpenHashMap<Url> urlToScriptHashCode = new Object2IntOpenHashMap();
    @NotNull
    private final MultiMap<Url, FileUrlMapping> urlToFileMap;
    @NotNull
    private final MultiMap<VirtualFile, FileUrlMapping> fileToUrlMap;

    public FileUrlMappingsStorage() {
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
        this.urlToFileMap = multiMap;
        MultiMap multiMap2 = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"create(...)");
        this.fileToUrlMap = multiMap2;
    }

    public final synchronized void scriptFound(@NotNull Url url, @NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (this.urlToScriptHashCode.containsKey((Object)url)) {
            int scriptHashCode = this.urlToScriptHashCode.getInt((Object)url);
            if (scriptHashCode == script.hashCode()) {
                return;
            }
            this.urlToScriptHashCode.put((Object)url, script.hashCode());
            ArrayList outdatedMappings = new ArrayList(this.urlToFileMap.get((Object)url));
            Iterator iterator = outdatedMappings.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                FileUrlMapping outdatedMapping = (FileUrlMapping)iterator2.next();
                Intrinsics.checkNotNull((Object)outdatedMapping);
                this.removeMapping(outdatedMapping);
            }
        } else {
            this.urlToScriptHashCode.put((Object)url, script.hashCode());
            ArrayList mappingsToCheck = new ArrayList(this.urlToFileMap.get((Object)url));
            ArrayList<FileUrlMapping> mappingsToAdd = new ArrayList<FileUrlMapping>();
            Iterator iterator = mappingsToCheck.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator3 = iterator;
            while (iterator3.hasNext()) {
                FileUrlMapping mappingToCheck = (FileUrlMapping)iterator3.next();
                if (mappingToCheck.getFile() == null || JSCachingFileFinderKt.isFileMatchingScript(mappingToCheck.getFile(), script)) continue;
                mappingsToAdd.add(mappingToCheck.copyWithNoFile());
                Intrinsics.checkNotNull((Object)mappingToCheck);
                this.removeMapping(mappingToCheck);
            }
            Iterator iterator4 = mappingsToAdd.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
            iterator3 = iterator4;
            while (iterator3.hasNext()) {
                Object e = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                FileUrlMapping mappingToAdd = (FileUrlMapping)e;
                this.addMapping(mappingToAdd);
            }
        }
    }

    public final synchronized void removeOutdatedResults(@NotNull Url url, @Nullable String sourceContent) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ArrayList mappingsToCheck = new ArrayList(this.urlToFileMap.get((Object)url));
        Iterator iterator = mappingsToCheck.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            FileUrlMapping mapping = (FileUrlMapping)iterator2.next();
            boolean fileContentIsUpToDate = mapping.getFile() != null ? mapping.getFile().getModificationStamp() == mapping.getFileOrFsModificationStamp() && !FileDocumentManager.getInstance().isFileModified(mapping.getFile()) : VirtualFileManager.getInstance().getStructureModificationCount() == mapping.getFileOrFsModificationStamp() && (sourceContent == null || sourceContent.hashCode() == mapping.getContentHashCode());
            if (fileContentIsUpToDate) continue;
            Intrinsics.checkNotNull((Object)mapping);
            this.removeMapping(mapping);
        }
    }

    private final void removeMapping(FileUrlMapping mapping) {
        this.urlToFileMap.remove((Object)mapping.getUrl(), (Object)mapping);
        if (mapping.getFile() != null) {
            this.fileToUrlMap.remove((Object)mapping.getFile(), (Object)mapping);
        }
    }

    public final synchronized void addMapping(@NotNull FileUrlMapping mapping) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        ArrayList candidateUrlMappings = new ArrayList(this.urlToFileMap.get((Object)mapping.getUrl()));
        Iterator iterator = candidateUrlMappings.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            FileUrlMapping candidateMapping = (FileUrlMapping)iterator2.next();
            if (!mapping.dominates(candidateMapping.getFile() != null, candidateMapping.getAccuracy())) continue;
            Intrinsics.checkNotNull((Object)candidateMapping);
            this.removeMapping(candidateMapping);
        }
        this.urlToFileMap.putValue((Object)mapping.getUrl(), (Object)mapping);
        if (mapping.getFile() != null) {
            ArrayList candidateFileMappings = new ArrayList(this.fileToUrlMap.get((Object)mapping.getFile()));
            Iterator iterator3 = candidateFileMappings.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
            Iterator iterator4 = iterator3;
            while (iterator4.hasNext()) {
                FileUrlMapping candidateMapping = (FileUrlMapping)iterator4.next();
                if (!mapping.dominates(candidateMapping.getFile() != null, candidateMapping.getAccuracy())) continue;
                Intrinsics.checkNotNull((Object)candidateMapping);
                this.removeMapping(candidateMapping);
            }
            this.fileToUrlMap.putValue((Object)mapping.getFile(), (Object)mapping);
        }
    }

    @Nullable
    public final synchronized FileUrlMapping findSuitableMapping(@NotNull Url url, @NotNull SearchAccuracy accuracy) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)accuracy), (String)"accuracy");
        for (FileUrlMapping mapping : this.urlToFileMap.get((Object)url)) {
            if (!mapping.dominates(true, accuracy) || !mapping.dominates(false, accuracy)) continue;
            return mapping;
        }
        return null;
    }

    @NotNull
    public final synchronized List<Url> findUrls(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List result = new ArrayList();
        SearchAccuracy bestMatch = SearchAccuracy.BY_NAME;
        for (FileUrlMapping mapping : this.fileToUrlMap.get((Object)file)) {
            if (mapping.getAccuracy().compareTo((Enum)bestMatch) < 0) {
                result = new ArrayList();
                bestMatch = mapping.getAccuracy();
            }
            if (mapping.getAccuracy() != bestMatch) continue;
            result.add(mapping.getUrl());
        }
        return result;
    }
}

