/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.jetbrains.gateway.GatewayBundle;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B)\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/gateway/plugins/DownloadAndInstallConnectionPluginTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "title", "", "canBeCancelled", "", "pluginProviderName", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "<init>", "(Ljava/lang/String;ZLjava/lang/String;Lcom/intellij/openapi/extensions/PluginId;)V", "errorMessage", "Lorg/jetbrains/annotations/Nls;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onFinished", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nDownloadAndInstallConnectionPluginTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadAndInstallConnectionPluginTask.kt\ncom/jetbrains/gateway/plugins/DownloadAndInstallConnectionPluginTask\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n4344#2,2:82\n774#3:84\n865#3,2:85\n1628#3,3:87\n*S KotlinDebug\n*F\n+ 1 DownloadAndInstallConnectionPluginTask.kt\ncom/jetbrains/gateway/plugins/DownloadAndInstallConnectionPluginTask\n*L\n23#1:82,2\n27#1:84\n27#1:85,2\n28#1:87,3\n*E\n"})
public final class DownloadAndInstallConnectionPluginTask
extends Task.Modal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pluginProviderName;
    @NotNull
    private final PluginId pluginId;
    @Nullable
    private String errorMessage;
    @NotNull
    private static final Logger log;

    public DownloadAndInstallConnectionPluginTask(@Nls @NotNull String title, boolean canBeCancelled, @NotNull String pluginProviderName, @NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)pluginProviderName, (String)"pluginProviderName");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        super(null, title, canBeCancelled);
        this.pluginProviderName = pluginProviderName;
        this.pluginId = pluginId;
    }

    /*
     * WARNING - void declaration
     */
    public void run(@NotNull ProgressIndicator indicator) {
        Iterator<Object> $this$filterTo$iv$iv;
        Object it;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Set pluginIds = SetsKt.setOf((Object)this.pluginId);
        Set plugins = new LinkedHashSet();
        List descriptors = new ArrayList(MarketplaceRequests.Companion.loadLastCompatiblePluginDescriptors$default((MarketplaceRequests.Companion)MarketplaceRequests.Companion, (Set)pluginIds, null, (boolean)false, (int)6, null));
        IdeaPluginDescriptor[] objectArray = PluginManagerCore.getPlugins();
        boolean $i$f$filterTo = false;
        for (IdeaPluginDescriptor element$iv : objectArray) {
            it = element$iv;
            boolean bl = false;
            if (!(!it.isEnabled() && PluginManagerCore.isCompatible((IdeaPluginDescriptor)it) && PluginManagementPolicy.Companion.getInstance().canInstallPlugin((IdeaPluginDescriptor)it))) continue;
            ((Collection)descriptors).add(element$iv);
        }
        Iterable iterable = descriptors;
        boolean $i$f$filter = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo222 = false;
        it = $this$filterTo$iv$iv.iterator();
        while (it.hasNext()) {
            Object element$iv$iv = it.next();
            IdeaPluginDescriptor it2 = (IdeaPluginDescriptor)element$iv$iv;
            boolean bl = false;
            if (!pluginIds.contains(it2.getPluginId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable3 = (List)destination$iv$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv : iterable3) {
            void it3;
            IdeaPluginDescriptor $i$f$filterTo222 = (IdeaPluginDescriptor)item$iv;
            Collection collection = plugins;
            boolean bl = false;
            collection.add(PluginDownloader.createDownloader((IdeaPluginDescriptor)it3));
        }
        if (!((Collection)plugins).isEmpty()) {
            List list = new ArrayList();
            List nodes = new ArrayList();
            for (PluginDownloader downloader : plugins) {
                IdeaPluginDescriptor plugin;
                Intrinsics.checkNotNullExpressionValue((Object)downloader.getDescriptor(), (String)"getDescriptor(...)");
                list.add(plugin);
                if (!plugin.isEnabled()) continue;
                PluginNode pluginNode = downloader.toPluginNode();
                Intrinsics.checkNotNullExpressionValue((Object)pluginNode, (String)"toPluginNode(...)");
                nodes.add(pluginNode);
            }
            PluginManagerMain.suggestToEnableInstalledDependantPlugins((PluginEnabler)((PluginEnabler)PluginEnabler.HEADLESS), (List)nodes);
            PluginEnabler.HEADLESS.enable((Collection)list);
            if (!((Collection)nodes).isEmpty()) {
                List customPlugins = CollectionsKt.emptyList();
                PluginInstallOperation operation = new PluginInstallOperation(nodes, (Collection)customPlugins, (PluginEnabler)PluginEnabler.HEADLESS, indicator);
                operation.setAllowInstallWithoutRestart(true);
                operation.run();
                if (operation.isSuccess()) {
                    ActionsKt.invokeLater((ModalityState)ModalityState.defaultModalityState(), () -> DownloadAndInstallConnectionPluginTask.run$lambda$3(operation));
                } else {
                    Object[] objectArray2 = new Object[]{this.pluginProviderName};
                    this.errorMessage = GatewayBundle.INSTANCE.message("protocol.connection.provider.installation.failed", objectArray2);
                    log.warn("Couldn't install the following plugins:\n" + CollectionsKt.joinToString$default((Iterable)plugins, null, null, null, (int)0, null, DownloadAndInstallConnectionPluginTask::run$lambda$4, (int)31, null));
                }
            }
        } else {
            Object[] objectArray3 = new Object[]{this.pluginProviderName};
            this.errorMessage = GatewayBundle.INSTANCE.message("protocol.connection.provider.not.compatible", objectArray3);
        }
    }

    public void onFinished() {
        block0: {
            super.onFinished();
            String string = this.errorMessage;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            Messages.showWarningDialog((String)it, (String)GatewayBundle.INSTANCE.message("protocol.connection.provider.installation.problem.title", new Object[0]));
        }
    }

    private static final Unit run$lambda$3(PluginInstallOperation $operation) {
        for (PendingDynamicPluginInstall pendingDynamicPluginInstall : $operation.getPendingDynamicPluginInstalls()) {
            Path file = pendingDynamicPluginInstall.component1();
            IdeaPluginDescriptorImpl pluginDescriptor = pendingDynamicPluginInstall.component2();
            PluginInstaller.installAndLoadDynamicPlugin((Path)file, (IdeaPluginDescriptorImpl)pluginDescriptor);
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence run$lambda$4(PluginDownloader it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPluginName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPluginName(...)");
        return string;
    }

    static {
        Logger logger = Logger.getInstance(DownloadAndInstallConnectionPluginTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/plugins/DownloadAndInstallConnectionPluginTask$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

