/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt.projectView;

import com.intellij.dbt.DbtIcons;
import com.intellij.dbt.DbtModuleEntity;
import com.intellij.dbt.DbtUtils;
import com.intellij.ide.IconProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/dbt/projectView/DbtIconProvider;", "Lcom/intellij/ide/IconProvider;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "element", "Lcom/intellij/psi/PsiElement;", "flags", "", "intellij.dbt"})
public final class DbtIconProvider
extends IconProvider {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiDirectory) {
            VirtualFile virtualFile = ((PsiDirectory)element).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            if (DbtUtils.Companion.containsDbtProjectFile(virtualFile)) {
                VirtualFileUrl virtualFileUrl;
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (module == null) {
                    return null;
                }
                Module module2 = module;
                DbtModuleEntity dbtModuleEntity = DbtUtils.Companion.getDbtSettings(module2);
                if (dbtModuleEntity == null) {
                    return null;
                }
                DbtModuleEntity dbtSettings = dbtModuleEntity;
                if (Intrinsics.areEqual((Object)((PsiDirectory)element).getVirtualFile().getPath(), (virtualFileUrl = dbtSettings.getDbtProjectPath()) != null && (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) != null ? virtualFileUrl.getPath() : null)) {
                    return DbtIcons.Dbt;
                }
            }
        }
        return null;
    }
}

