/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.LayeredFileName;
import org.apache.commons.vfs2.provider.LayeredFileNameParser;

public abstract class AbstractLayeredFileProvider
extends AbstractFileProvider {
    public AbstractLayeredFileProvider() {
        this.setFileNameParser(LayeredFileNameParser.getInstance());
    }

    @Override
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LayeredFileName name = (LayeredFileName)this.parseUri(baseFile != null ? baseFile.getName() : null, uri);
        FileName fileName = name.getOuterName();
        FileObject file = this.getContext().resolveFile(baseFile, fileName.getURI(), fileSystemOptions);
        FileObject rootFile = this.createFileSystem(name.getScheme(), file, fileSystemOptions);
        return rootFile.resolveFile(name.getPath());
    }

    @Override
    public FileObject createFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName rootName = file.getName();
        FileSystem fs = this.findFileSystem(rootName, null);
        if (fs == null) {
            fs = this.doCreateFileSystem(scheme, file, fileSystemOptions);
            fs = this.addFileSystem(rootName, fs);
        }
        return fs.getRoot();
    }

    protected abstract FileSystem doCreateFileSystem(String var1, FileObject var2, FileSystemOptions var3);

    @Override
    public FileSystem findOrCreateFileSystem(String uri, FileSystemOptions fileSystemOptions, boolean onlyCached) throws FileSystemException {
        LayeredFileName name = (LayeredFileName)this.parseUri(null, uri);
        FileName fileName = name.getOuterName();
        FileObject file = this.getContext().resolveFile(null, fileName.getURI(), fileSystemOptions);
        FileName rootName = file.getName();
        FileSystem fs = this.findFileSystem(rootName, null);
        if (fs == null && !onlyCached) {
            fs = this.doCreateFileSystem(name.getScheme(), file, fileSystemOptions);
            fs = this.addFileSystem(rootName, fs);
        }
        return fs;
    }
}

