/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.download.NodeDownloadableInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreterType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class NodeJsInterpreterRefList {
    private final List<NodeJsInterpreterRef> myAliasRefs;
    private final List<NodeJsInterpreterRef> myConstantRefs;

    private NodeJsInterpreterRefList(@NotNull List<NodeJsInterpreterRef> interpreterRefs, @NotNull List<NodeJsInterpreter> interpreters) {
        if (interpreterRefs == null) {
            NodeJsInterpreterRefList.$$$reportNull$$$0(0);
        }
        if (interpreters == null) {
            NodeJsInterpreterRefList.$$$reportNull$$$0(1);
        }
        this.myAliasRefs = new ArrayList<NodeJsInterpreterRef>(interpreterRefs);
        this.myConstantRefs = new ArrayList<NodeJsInterpreterRef>(ContainerUtil.map(interpreters, NodeJsInterpreter::toRef));
    }

    List<NodeJsInterpreterRef> getAllAvailableAsRefs(boolean withProjectRef) {
        ArrayList<NodeJsInterpreterRef> interpreterRefs = new ArrayList<NodeJsInterpreterRef>();
        if (withProjectRef) {
            interpreterRefs.add(NodeJsInterpreterRef.createProjectRef());
        }
        interpreterRefs.addAll(this.myAliasRefs);
        interpreterRefs.addAll(this.myConstantRefs);
        return interpreterRefs;
    }

    public void addIfMissing(@NotNull NodeJsInterpreterRef interpreterRef) {
        if (interpreterRef == null) {
            NodeJsInterpreterRefList.$$$reportNull$$$0(2);
        }
        if (interpreterRef.isProjectRef()) {
            return;
        }
        if (interpreterRef.isConstantRef()) {
            if (!this.myConstantRefs.contains(interpreterRef)) {
                this.myConstantRefs.add(0, interpreterRef);
            }
        } else if (!this.myAliasRefs.contains(interpreterRef)) {
            this.myAliasRefs.add(interpreterRef);
        }
    }

    @NotNull
    static NodeJsInterpreterRefList create(@NotNull List<NodeJsInterpreterType<?>> types) {
        if (types == null) {
            NodeJsInterpreterRefList.$$$reportNull$$$0(3);
        }
        ArrayList<NodeJsInterpreterRef> interpreterRefs = new ArrayList<NodeJsInterpreterRef>();
        ArrayList<NodeJsInterpreter> interpreters = new ArrayList<NodeJsInterpreter>();
        for (NodeJsInterpreterType<?> type2 : types) {
            interpreterRefs.addAll(type2.getInterpreterRefs());
            interpreters.addAll(type2.getInterpreters());
        }
        return new NodeJsInterpreterRefList(interpreterRefs, interpreters);
    }

    @NotNull
    static List<NodeJsInterpreterType<?>> getTypes(boolean placeLocalInTheEnd, boolean withRemote, boolean withDownload) {
        ArrayList<NodeJsInterpreterType> enabledTypes = new ArrayList<NodeJsInterpreterType>();
        if (!placeLocalInTheEnd) {
            enabledTypes.add(NodeJsLocalInterpreterType.getInstance());
        }
        if (withRemote) {
            enabledTypes.add(NodeJsRemoteInterpreterType.getInstance());
        }
        if (withDownload) {
            enabledTypes.add(NodeDownloadableInterpreterType.getInstance());
        }
        if (WslNodeInterpreterType.getInstance().isAvailable()) {
            enabledTypes.add(WslNodeInterpreterType.getInstance());
        }
        if (placeLocalInTheEnd) {
            enabledTypes.add(NodeJsLocalInterpreterType.getInstance());
        }
        List<NodeJsInterpreterType<?>> list = List.copyOf(enabledTypes);
        if (list == null) {
            NodeJsInterpreterRefList.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRefs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRefList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRefList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addIfMissing";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

