/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpDependency;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpFile;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManagerState;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspace;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspaceList;
import com.intellij.javascript.nodejs.library.yarn.pnp.workspaceModel.YarnPnpEntityHelperKt;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="YarnPnpManager", storages={@Storage(value="$CACHE_FILE$")})
@Service(value={Service.Level.PROJECT})
public final class YarnPnpManager
implements PersistentStateComponent<YarnPnpManagerState>,
Disposable {
    public static final String PNP_JS = ".pnp.js";
    public static final String PNP_CJS = ".pnp.cjs";
    private static final Logger LOG = Logger.getInstance(YarnPnpManager.class);
    private static final ExecutorService ourExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)(YarnPnpManager.class.getSimpleName() + " Pool"), (int)2);
    private final Project myProject;
    private final ConcurrentMap<VirtualFile, YarnPnpFile> myFileMap;
    private final boolean myJsAwareProject;
    private volatile List<YarnPnpFile> myPnpFilesSnapshot;
    private volatile Map<VirtualFile, YarnPnpFile> myRootToFileMap;
    private JSLibraryManager myLibraryManager;
    private final SimpleModificationTracker myYarnChangeTracker;
    private final AtomicBoolean myInterpreterChangeListenerAdded;
    private boolean myRefreshLibrariesAfterLoadingState;
    private final List<Deferred<Unit>> myWorkspaceModelUpdates;

    public YarnPnpManager(@NotNull Project project) {
        if (project == null) {
            YarnPnpManager.$$$reportNull$$$0(0);
        }
        this.myFileMap = new ConcurrentHashMap<VirtualFile, YarnPnpFile>();
        this.myYarnChangeTracker = new SimpleModificationTracker();
        this.myInterpreterChangeListenerAdded = new AtomicBoolean(false);
        this.myRefreshLibrariesAfterLoadingState = true;
        this.myWorkspaceModelUpdates = new CopyOnWriteArrayList<Deferred<Unit>>();
        this.myProject = project;
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new YarnPnpFileListener(), (Disposable)this);
        this.myJsAwareProject = !NodeModulesDirectoryManager.isIdeaProject(project);
    }

    public void dispose() {
    }

    @Nullable
    public YarnPnpDependency findDependencyByFileOrDirectory(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            YarnPnpManager.$$$reportNull$$$0(1);
        }
        for (YarnPnpFile pnpFile : this.getPnpFiles()) {
            YarnPnpDependency dependency;
            YarnPnpWorkspaceList list = pnpFile.getWorkspaceList();
            if (list == null || (dependency = list.findDependencyByFile(fileOrDirectory)) == null) continue;
            return dependency;
        }
        return null;
    }

    @Nullable
    public YarnPnpFile findPnpFile(@Nullable VirtualFile pnpJsFile) {
        return (YarnPnpFile)this.myFileMap.get(pnpJsFile);
    }

    @NotNull
    public static YarnPnpManager getInstance(@NotNull Project project) {
        if (project == null) {
            YarnPnpManager.$$$reportNull$$$0(2);
        }
        YarnPnpManager yarnPnpManager = (YarnPnpManager)project.getService(YarnPnpManager.class);
        if (yarnPnpManager == null) {
            YarnPnpManager.$$$reportNull$$$0(3);
        }
        return yarnPnpManager;
    }

    @NotNull
    public YarnPnpManagerState getState() {
        YarnPnpManagerState yarnPnpManagerState = YarnPnpManagerState.convertFileListToState(this.myFileMap.values());
        if (yarnPnpManagerState == null) {
            YarnPnpManager.$$$reportNull$$$0(4);
        }
        return yarnPnpManagerState;
    }

    public void loadState(@NotNull YarnPnpManagerState state) {
        if (state == null) {
            YarnPnpManager.$$$reportNull$$$0(5);
        }
        Map map2 = ContainerUtil.map2Map(state.convertStateToFileList(this.myProject), file -> Pair.create((Object)file.getPnpFile(), (Object)file));
        this.myFileMap.clear();
        this.myFileMap.putAll(map2);
        this.resetSnapshot();
        if (this.myRefreshLibrariesAfterLoadingState) {
            this.refreshLibrariesAsync(this.myFileMap.values(), true);
        }
    }

    @TestOnly
    public void setRefreshLibrariesAfterLoadingState(boolean refreshLibrariesAfterLoadingState) {
        this.myRefreshLibrariesAfterLoadingState = refreshLibrariesAfterLoadingState;
    }

    private void refreshLibrariesAsync(@NotNull Collection<YarnPnpFile> files, boolean deleteIfNotAccepted) {
        if (files == null) {
            YarnPnpManager.$$$reportNull$$$0(6);
        }
        if (files.isEmpty()) {
            return;
        }
        ourExecutorService.execute(() -> {
            boolean reloadLibrariesNeeded = false;
            for (YarnPnpFile file : files) {
                boolean accepted;
                if (deleteIfNotAccepted && !(accepted = ((Boolean)ReadAction.compute(() -> this.acceptPnpJsFile(file.getPnpFile()))).booleanValue())) {
                    this.handleFileDeleted(file.getPnpFile(), false);
                    reloadLibrariesNeeded = true;
                    continue;
                }
                reloadLibrariesNeeded |= file.refresh();
            }
            LOG.info(reloadLibrariesNeeded ? "Libraries roots changed, reloading" : "No libraries roots changed");
            if (reloadLibrariesNeeded) {
                this.reloadLibrariesLater();
            }
            this.scheduleUpdateOnNodeInterpreterChange();
        });
    }

    @TestOnly
    public void registerWorkspaceModelUpdate(final @NotNull CompletableDeferred<Unit> entityUpdate) {
        if (entityUpdate == null) {
            YarnPnpManager.$$$reportNull$$$0(7);
        }
        this.myWorkspaceModelUpdates.add((Deferred<Unit>)entityUpdate);
        entityUpdate.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(){

            public Unit invoke(Throwable throwable) {
                YarnPnpManager.this.myWorkspaceModelUpdates.remove(entityUpdate);
                return Unit.INSTANCE;
            }
        });
    }

    @TestOnly
    public boolean isWorkspaceModelUpdated() {
        return ((BoundedTaskExecutor)ourExecutorService).isEmpty() && this.myWorkspaceModelUpdates.isEmpty();
    }

    private void scheduleUpdateOnNodeInterpreterChange() {
        if (this.myInterpreterChangeListenerAdded.compareAndSet(false, true)) {
            ReadAction.run(() -> {
                if (!this.myProject.isDisposed()) {
                    NodeJsInterpreterManager.getInstance(this.myProject).addChangeListener(new NodeJsInterpreterChangeListener(){

                        @Override
                        public void interpreterChanged(@Nullable NodeJsInterpreter newInterpreter) {
                            YarnPnpManager.this.refreshLibrariesAsync(YarnPnpManager.this.myFileMap.values(), false);
                        }
                    }, this);
                }
            });
        }
    }

    public void addPnpJsFile(@NotNull VirtualFile pnpJsFile) {
        YarnPnpFile file;
        if (pnpJsFile == null) {
            YarnPnpManager.$$$reportNull$$$0(8);
        }
        if (this.myFileMap.get(pnpJsFile) == null && this.acceptPnpJsFile(pnpJsFile) && this.myFileMap.putIfAbsent(pnpJsFile, file = new YarnPnpFile(pnpJsFile, this.myProject)) == null) {
            YarnPnpEntityHelperKt.addPnpEntity(this.myProject, file);
            this.resetSnapshot();
            this.refreshLibrariesAsync(Collections.singletonList(file), false);
        }
    }

    private boolean acceptPnpJsFile(@NotNull VirtualFile pnpJsFile) {
        if (pnpJsFile == null) {
            YarnPnpManager.$$$reportNull$$$0(9);
        }
        if (!pnpJsFile.isValid() || !YarnPnpManager.isPnpJsFile(pnpJsFile)) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        VirtualFile contentRoot = fileIndex.getContentRootForFile(pnpJsFile, false);
        return contentRoot != null && !JSLibraryUtil.hasDirectoryInPath(pnpJsFile, "node_modules", contentRoot) && !fileIndex.isInLibrary(pnpJsFile) && this.myJsAwareProject;
    }

    private void resetSnapshot() {
        this.myPnpFilesSnapshot = null;
        this.myRootToFileMap = null;
    }

    @NotNull
    public List<YarnPnpFile> getPnpFiles() {
        List<YarnPnpFile> files = this.myPnpFilesSnapshot;
        if (files == null) {
            this.myPnpFilesSnapshot = files = List.copyOf(this.myFileMap.values());
        }
        List<YarnPnpFile> list = files;
        if (list == null) {
            YarnPnpManager.$$$reportNull$$$0(10);
        }
        return list;
    }

    public boolean hasPnpFiles() {
        return !this.getPnpFiles().isEmpty();
    }

    public boolean isUnderPnp(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            YarnPnpManager.$$$reportNull$$$0(11);
        }
        return this.findContainingPnpFile(fileOrDirectory) != null;
    }

    @NotNull
    public ModificationTracker getYarnChangeTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myYarnChangeTracker;
        if (simpleModificationTracker == null) {
            YarnPnpManager.$$$reportNull$$$0(12);
        }
        return simpleModificationTracker;
    }

    @NotNull
    private Map<VirtualFile, YarnPnpFile> getPnpRootToFileMap() {
        Map<Object, YarnPnpFile> rootToFileMap = this.myRootToFileMap;
        if (rootToFileMap == null) {
            this.myRootToFileMap = rootToFileMap = Map.copyOf(ContainerUtil.map2MapNotNull(this.myFileMap.values(), pnpFile -> {
                VirtualFile parent = pnpFile.getPnpFile().getParent();
                if (parent == null) {
                    LOG.error("No parent for " + String.valueOf(pnpFile.getPnpFile()));
                    return null;
                }
                return Pair.create((Object)parent, (Object)pnpFile);
            }));
        }
        Map<VirtualFile, YarnPnpFile> map2 = rootToFileMap;
        if (map2 == null) {
            YarnPnpManager.$$$reportNull$$$0(13);
        }
        return map2;
    }

    private void reloadLibrariesLater() {
        this.myYarnChangeTracker.incModificationCount();
        JSLibraryManager libraryManager = this.getLibraryManager();
        if (libraryManager != null) {
            libraryManager.scheduleCommitChanges(null);
        }
    }

    @Nullable
    private JSLibraryManager getLibraryManager() {
        JSLibraryManager libraryManager = this.myLibraryManager;
        if (libraryManager == null) {
            this.myLibraryManager = libraryManager = (JSLibraryManager)((Object)ReadAction.compute(() -> this.myProject.isDisposed() ? null : JSLibraryManager.getInstance(this.myProject)));
        }
        return libraryManager;
    }

    private void handleFileDeleted(@NotNull VirtualFile pnpJsFile, boolean reloadLibraries) {
        YarnPnpFile pnpFile;
        if (pnpJsFile == null) {
            YarnPnpManager.$$$reportNull$$$0(14);
        }
        if ((pnpFile = (YarnPnpFile)this.myFileMap.remove(pnpJsFile)) != null) {
            pnpFile.setWorkspaceList(null);
            this.resetSnapshot();
            if (reloadLibraries) {
                this.reloadLibrariesLater();
            }
        }
    }

    private void handleFileContentChanged(@NotNull VirtualFile pnpJsFile) {
        YarnPnpFile pnpFile;
        if (pnpJsFile == null) {
            YarnPnpManager.$$$reportNull$$$0(15);
        }
        if ((pnpFile = (YarnPnpFile)this.myFileMap.get(pnpJsFile)) != null) {
            YarnPnpEntityHelperKt.removePnpEntity(this.myProject, pnpFile);
            this.refreshLibrariesAsync(Collections.singletonList(pnpFile), false);
        }
    }

    @Nullable
    public YarnPnpDependency findDependency(@NotNull VirtualFile packageJson, @NotNull String dependencyName) {
        YarnPnpWorkspace workspace;
        if (packageJson == null) {
            YarnPnpManager.$$$reportNull$$$0(16);
        }
        if (dependencyName == null) {
            YarnPnpManager.$$$reportNull$$$0(17);
        }
        return (workspace = this.findWorkspaceByFile(packageJson)) != null ? workspace.findDependencyByName(dependencyName) : null;
    }

    public boolean hasDirectOrIndirectDependency(@NotNull VirtualFile packageJson, @NotNull String dependencyName) {
        YarnPnpWorkspace workspace;
        if (packageJson == null) {
            YarnPnpManager.$$$reportNull$$$0(18);
        }
        if (dependencyName == null) {
            YarnPnpManager.$$$reportNull$$$0(19);
        }
        return (workspace = this.findWorkspaceByFile(packageJson)) != null && workspace.hasDirectOrIndirectDependency(dependencyName);
    }

    @Nullable
    public VirtualFile findInstalledPackageDir(@NotNull VirtualFile packageJson, @NotNull String dependencyName) {
        YarnPnpDependency dependency;
        if (packageJson == null) {
            YarnPnpManager.$$$reportNull$$$0(20);
        }
        if (dependencyName == null) {
            YarnPnpManager.$$$reportNull$$$0(21);
        }
        if ((dependency = this.findDependency(packageJson, dependencyName)) != null) {
            return dependency.resolveLocation();
        }
        return null;
    }

    @Nullable
    public String getDependencyRequireableLocation(@NotNull VirtualFile packageJson, @NotNull String dependencyName) {
        YarnPnpDependency dependency;
        if (packageJson == null) {
            YarnPnpManager.$$$reportNull$$$0(22);
        }
        if (dependencyName == null) {
            YarnPnpManager.$$$reportNull$$$0(23);
        }
        if ((dependency = this.findDependency(packageJson, dependencyName)) != null) {
            return dependency.getRequireableLocation();
        }
        return null;
    }

    @Nullable
    private YarnPnpWorkspace findWorkspaceByFile(@NotNull VirtualFile packageJson) {
        YarnPnpWorkspaceList workspaceList;
        if (packageJson == null) {
            YarnPnpManager.$$$reportNull$$$0(24);
        }
        if ((workspaceList = this.findWorkspaceList(packageJson)) != null) {
            return workspaceList.findWorkspaceByFile(packageJson);
        }
        return null;
    }

    @Nullable
    private YarnPnpWorkspaceList findWorkspaceList(@NotNull VirtualFile packageJson) {
        YarnPnpFile pnpFile;
        if (packageJson == null) {
            YarnPnpManager.$$$reportNull$$$0(25);
        }
        return (pnpFile = this.findContainingPnpFile(packageJson)) != null ? pnpFile.getWorkspaceList() : null;
    }

    @Nullable
    private YarnPnpFile findContainingPnpFile(@NotNull VirtualFile file) {
        Map<VirtualFile, YarnPnpFile> pnpRootToFileMap;
        if (file == null) {
            YarnPnpManager.$$$reportNull$$$0(26);
        }
        if ((pnpRootToFileMap = this.getPnpRootToFileMap()).isEmpty()) {
            return null;
        }
        return JSProjectUtil.traverseUpAndFindFirst(file, f -> (YarnPnpFile)pnpRootToFileMap.get(f));
    }

    @Contract(value="null -> false")
    public static boolean isPnpJsFile(@Nullable VirtualFile file) {
        return file != null && !file.isDirectory() && YarnPnpManager.isPnpJsFileName(file.getNameSequence());
    }

    @Contract(value="null -> false")
    public static boolean isPnpJsFileName(@Nullable CharSequence fileName) {
        return StringUtil.equals((CharSequence)fileName, (CharSequence)PNP_JS) || StringUtil.equals((CharSequence)fileName, (CharSequence)PNP_CJS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 10, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityUpdate";
                break;
            }
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pnpJsFile";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPnpFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getYarnChangeTracker";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPnpRootToFileMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyByFileOrDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refreshLibrariesAsync";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerWorkspaceModelUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addPnpJsFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptPnpJsFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUnderPnp";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "handleFileDeleted";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleFileContentChanged";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findDependency";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasDirectOrIndirectDependency";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findInstalledPackageDir";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyRequireableLocation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findWorkspaceByFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findWorkspaceList";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findContainingPnpFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 10, 12, 13 -> new IllegalStateException(string);
        };
    }

    private class YarnPnpFileListener
    implements AsyncFileListener {
        private YarnPnpFileListener() {
        }

        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            List relevantEvents;
            if (events == null) {
                YarnPnpFileListener.$$$reportNull$$$0(0);
            }
            return (relevantEvents = ContainerUtil.filter(events, YarnPnpFileListener::isRelevantEvent)).isEmpty() ? null : new AsyncFileListener.ChangeApplier(){

                public void afterVfsChange() {
                    for (VFileEvent event : relevantEvents) {
                        if (event instanceof VFileDeleteEvent) {
                            YarnPnpFileListener.this.tryDelete(event.getFile());
                            continue;
                        }
                        if (event instanceof VFileContentChangeEvent) {
                            YarnPnpFileListener.this.tryHandleFileContentChanged(event.getFile());
                            continue;
                        }
                        if (event instanceof VFilePropertyChangeEvent) {
                            VFilePropertyChangeEvent renameEvent = (VFilePropertyChangeEvent)event;
                            if (!renameEvent.isRename() || Objects.equals(renameEvent.getOldValue(), renameEvent.getNewValue())) continue;
                            YarnPnpFileListener.this.tryDelete(renameEvent.getFile());
                            YarnPnpFileListener.this.tryAdd(renameEvent.getFile());
                            continue;
                        }
                        if (event instanceof VFileMoveEvent) {
                            YarnPnpFileListener.this.tryDelete(event.getFile());
                            YarnPnpFileListener.this.tryAdd(event.getFile());
                            continue;
                        }
                        if (event instanceof VFileCreateEvent) {
                            YarnPnpFileListener.this.tryAdd(event.getFile());
                            continue;
                        }
                        if (!(event instanceof VFileCopyEvent)) continue;
                        YarnPnpFileListener.this.tryAdd(event.getFile());
                    }
                }
            };
        }

        private void tryAdd(@Nullable VirtualFile pnpJsFile) {
            if (pnpJsFile != null) {
                YarnPnpManager.this.addPnpJsFile(pnpJsFile);
            }
        }

        private void tryDelete(@Nullable VirtualFile pnpJsFile) {
            if (pnpJsFile != null) {
                YarnPnpManager.this.handleFileDeleted(pnpJsFile, true);
            }
        }

        private void tryHandleFileContentChanged(@Nullable VirtualFile pnpJsFile) {
            if (pnpJsFile != null) {
                YarnPnpManager.this.handleFileContentChanged(pnpJsFile);
            }
        }

        private static boolean isRelevantEvent(@NotNull VFileEvent event) {
            if (event == null) {
                YarnPnpFileListener.$$$reportNull$$$0(1);
            }
            if (event instanceof VFileCreateEvent) {
                return !((VFileCreateEvent)event).isDirectory() && YarnPnpManager.isPnpJsFileName(((VFileCreateEvent)event).getChildName());
            }
            if (event instanceof VFilePropertyChangeEvent) {
                VFilePropertyChangeEvent e = (VFilePropertyChangeEvent)event;
                if (e.isRename()) {
                    CharSequence oldName = (CharSequence)ObjectUtils.tryCast((Object)e.getOldValue(), CharSequence.class);
                    CharSequence newName = (CharSequence)ObjectUtils.tryCast((Object)e.getNewValue(), CharSequence.class);
                    return YarnPnpManager.isPnpJsFileName(oldName) || YarnPnpManager.isPnpJsFileName(newName);
                }
                return false;
            }
            return YarnPnpManager.isPnpJsFile(event.getFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpManager$YarnPnpFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isRelevantEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

